/*
 * S2BIN converts a Motorola S-record file to binary format.
 * Tested exclusively on various Maui(tm) operating systems.
 * Compiled with Microsoft(R) QuickC 2.0 using small model.
 * Output files are named according to their begin address.
 * (Will anybody tell me what S4, S5 and S6 records do? :-)
 *
 * Usage: s2bin < s-file
 *
 * Copyright (c) 1994 by L.Georgiev, Bulgaria <lucho@midi.tu-varna.bg>
 *
 * Disclaimer:  The author assumes no responsibility for any damage
 * arising out of use of this program.  You may use it at your own risk.
 *
 * You may freely distribute this source providing that the above
 * copyright notice is left intact.  You may not, however, charge
 * any money except a small fee for the physical act of copying.
 *
 * Acknowledgements:  Maui is a trade mark of Turtle Beach Systems, Inc.
 *                    Motorola is a trade mark of Motorola Inc.
 * QuickC and Microsoft are trade marks of Microsoft Corporation
 */

#ifndef MSDOS
    #error Don\'t expect this to compile without some modification.
#endif
#ifndef _QC
    #pragma message ("This is tested only under QuickC.  Be careful!\n")
#endif
#ifdef NO_EXT_KEYS
    #error This uses Microsoft(R) extensions to ANSI C.  Compile with /Ze
#endif

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>
#include <fcntl.h>
#include <io.h>

#define MAXLEN  0x204  /* s-string length limit */
#define MAXLINES 5000  /* s-record number limit */

#define isdata(s) ((s)[0] == 'S' && (s)[1] >= '1' && (s)[1] <= '3')

typedef unsigned char u_char;
typedef unsigned long u_long;

typedef struct s_hdr {
    u_long addr;
    unsigned count;
    u_char far *data;
} * s_rec;


void far2near(char *t, char far *s, size_t n)
{
    while (n--)
	*t++ = *s++;
}


void done(int code)
{
    fputs("\nDone.\n", stdout);
    exit(code);
}


void error(char *str, int code)
{
    fputs( strcat("\n", str), stdout );
    exit(code);
}


void *alloc(size_t size)
{
    void *p;

    if ((p = malloc(size)) == NULL)
	error("Not enough memory\n", -1);
    return p;
}


void far *falloc(size_t size)
{
    void far *p;

    if ((p = _fmalloc(size)) == NULL)
	error("Not enough memory\n", -1);
    return p;
}


int acmp(s_rec *s, s_rec *t)
{
    char buf[10];

    /* Arguments are pointers to the elements of the array being sorted.
     * Each element is a pointer to a structure of type s_hdr.
     */
    if ((*s)->addr < (*t)->addr)
	return -1;
    if ((*s)->addr > (*t)->addr)
	return 1;
    error( strcat("Two or more S-records beginning with the same address:\n",
	ultoa( (*s)->addr, buf, 16 )), -2);
}


u_long gethex(char *s, size_t n)
{
    u_long val;
    char buf[MAXLEN], *end;

    n *= 2;
    strncpy(buf, s, n);
    buf[n] = '\0';
    val = strtoul(buf, &end, 16);
    if (*end)
	error( strcat("Non-hex characters:\n", end), -3);
    return val;
}


s_rec new_s(char *s)
{
    char *str = s;
    u_char sum;
    int adr_len, i;
    s_rec hdr;

    hdr = (s_rec) alloc( sizeof (struct s_hdr) );
    adr_len = 2 + *++s - '1';
    sum = (u_char) gethex(++s, 1);
    hdr->count = sum - adr_len - 1;
    if ((signed)hdr->count < 1)
	error( strcat("Bad length for the following S-record:\n", str), -4 );
    s += 2;
    hdr->addr = gethex(s, adr_len);
    s += 2*adr_len;
    for (i = 0; i < adr_len; i++)
	sum += (u_char) (hdr->addr >> 8 * i);
    hdr->data = (u_char far *) falloc( hdr->count );
    for (i = 0; i < hdr->count; i++, s += 2)
	if (!s[0] || !s[1])
	    error( strcat("The following S-record is too short:\n", str), -5);
	else
	    sum += hdr->data[i] = (u_char) gethex(s, 1);
    if ((u_char)~sum != (u_char)gethex(s, 1))
	error( strcat("Bad checksum in the following S-record:\n", str), -6 );
    return hdr;
}


void main()
{
    char buf[MAXLEN], name[80];
    unsigned i, n, out;
    s_rec *s;

    s = (s_rec *) alloc( MAXLINES * (size_t) sizeof (s_rec) );
    while (!feof(stdin)) {
	do
	    if (fgets(buf, MAXLEN, stdin) == NULL)
		done(0);
	while (!isdata(buf));
	fputs("\nReading...", stdout);
	for (n = 0; !feof(stdin) && isdata(buf); n++) {
	    s[n] = new_s(buf);
	    fgets(buf, MAXLEN, stdin);
	}
	fputs("\rSorting...", stdout);
	qsort( (void *)s, n, sizeof (s_rec), acmp );
	ultoa(s[0]->addr, name, 16);
	strcat(name, ".bin");
	if ((out = open( name, O_BINARY | O_WRONLY | O_CREAT | O_EXCL)) == -1)
	    error( strcat( name,
	       " exists: rename, move or erase it; then run me again.\n"), -7);
	fputs("\rWriting ", stdout);
	fputs(name, stdout);
	for (i = 0; i < n; i++) {
	    lseek(out, s[i]->addr - s[0]->addr, SEEK_SET);
	    far2near(buf, s[i]->data, s[i]->count);
	    write(out, buf, s[i]->count);
	    _ffree(s[i]->data);
	    free(s[i]);
	}
	close(out);
    }
    done(0);
}
