;۲۲۲۲۲۲۲۲۲۲۲۲
;۲۲              QView Module             ޱ۲۲۲
;۲۲        (c) Copyright  1995-2006       ް۲۲۲
;۲۲           AGCProduct ۲         ޱ۲۲۲
;۲۲۲                   by                  ޲۲۲
;۲۲             Alexandr Gazko            ۲۲۲
;۲۲            ver. 2.91  beta            ޲۲۲۲
;۲۲۲۲۲۲۲۲۲۲۲۲

.CODE
;*************************************************************************
; Procedure Delay
;*************************************************************************
Delay       proc    far
            push    ax
            push    cx
            push    dx
            mov     ah,86h
            xor     cx,cx
            mov     dx,65000
            int     15h
            pop     dx
            pop     cx
            pop     ax
            retf
Delay       endp
;*************************************************************************
; Procedure HideCursor
; Parameters:  not used
;*************************************************************************
HideCursor  proc    far
            push    ax
            push    bx
            push    dx
            mov     bh,0
            mov     dh,ScrHigh
            inc     dh
            mov     dl,0
            mov     wCursorXY,dx
            mov     ah,2
            int     10h
            pop     dx
            pop     bx
            pop     ax
            retf
HideCursor  endp
;*************************************************************************
; Procedure CursorOff
; Parameters:  not used
;*************************************************************************
CursorOff   proc    far
            push    ax
            push    bx
            push    dx
            mov     dx,wCursorXY
            mov     wCurOnOffXY,dx
            mov     bh,0
            mov     dh,ScrHigh
            inc     dh
            mov     dl,0
            mov     ah,2
            int     10h
            pop     dx
            pop     bx
            pop     ax
            retf
CursorOff   endp
;*************************************************************************
; Procedure MoveCursor
; Parameters:
;            bx - coordinates (Bh-Y,Bl-X)
;*************************************************************************
MoveCursor  proc    far
            push    dx
            push    bx
            push    ax
            mov     wCursorXY,bx
            mov     dx,bx
            mov     bh,0
            mov     ah,2
            int     10h
            pop     ax
            pop     bx
            pop     dx
            retf
MoveCursor  endp
;*************************************************************************
; Procedure CursorOn
; Parameters:
;*************************************************************************
CursorOn    proc    far
            push    dx
            push    bx
            push    ax
            mov     dx,wCurOnOffXY
            mov     bh,0
            mov     ah,2
            int     10h
            pop     ax
            pop     bx
            pop     dx
            retf
CursorOn    endp
;*************************************************************************
; Procedure OutChar
; Parameters:
;            al - char for output
;            ah - attributes for output char
;            bh - Y coordinat
;            bl - X coordinat
;*************************************************************************
OutChar     proc    far
            push    es
            push    bx
            push    ax
            mov     ax,VideoSeg                     ; 1
            mov     es,ax                           ; 3
            mov     al,bh                           ; 1
            mov     bh,byte ptr ScrWidth            ; 1
            inc     bh                              ; 1
            mul     bh                              ; 13
            shl     ax,1                            ; 3
            xor     bh,bh                           ; 1
            shl     bx,1                            ; 3
            add     bx,ax                           ; 1
            pop     ax
            mov     es:[bx],ax                      ; 1
            pop     bx
            pop     es
            retf
OutCHar     endp
;*************************************************************************
; Procedure OutVBChr
; Parameters:
;            al - char for output
;            ah - attributes for output char
;            bh - Y coordinat
;            bl - X coordinat
;*************************************************************************
OutVBChr    proc    far
            cmp     bVideoBuf,1
            jne     OutChar
            push    es
            push    bx
            push    ax
            mov     ax,VideoBufSeg                  ; 1
            mov     es,ax                           ; 3
            mov     al,bh                           ; 1
            mov     bh,byte ptr ScrWidth            ; 1
            inc     bh                              ; 1
            mul     bh                              ; 13
            shl     ax,1                            ; 3
            xor     bh,bh                           ; 1
            shl     bx,1                            ; 3
            add     bx,ax                           ; 1
            pop     ax
            mov     es:[bx],ax                      ; 1
            pop     bx
            pop     es
            retf
OutVBChr    endp
;*************************************************************************
; Procedure VBuf2Scr
;*************************************************************************
VBuf2Scr    proc    far
            cmp     bVideoBuf,1
            jne     vb2crExit
            push    ds
            push    es
            push    esi
            push    edi
            push    ecx
            mov     ax,VideoSeg                     ; 1
            mov     es,ax                           ; 3
            xor     ecx,ecx
            mov     cx,wOutWinSize
            shr     cx,2
            mov     si,word ptr ScrWidth
            inc     si
            add     si,si
            mov     di,si
            mov     ax,VideoBufSeg                  ; 1
            mov     ds,ax                           ; 3
            rep     movsd
            pop     ecx
            pop     edi
            pop     esi
            pop     es
            pop     ds
vb2crExit:  retf
VBuf2Scr    endp
;*************************************************************************
; Procedure GetChar
; Parameters:
;            bh - Y coordinat
;            bl - X coordinat
; Return:
;            al - char for output
;            ah - attributes for output char
;*************************************************************************
GetChar     proc    far
            push    es
            push    bx
            mov     ax,VideoSeg
            mov     es,ax
            mov     al,bh
            mov     bh,byte ptr ScrWidth
            inc     bh
            mul     bh
            shl     ax,1
            xor     bh,bh
            shl     bx,1
            add     bx,ax
            mov     ax,es:[bx]
            pop     bx
            pop     es
            retf
GetChar     endp
;*************************************************************************
; Procedure Sleep
; Return:
;*************************************************************************
Sleep       proc    far
            push    ax
            cmp     bIdleSupport,0
            jne     sleepExit
            mov     ax,1680h
            int     2Fh
sleepExit:  pop     ax
            retf
Sleep       endp
;*************************************************************************
; Procedure ReadKey
; Return: ax - readed keys
;*************************************************************************
ReadKey     proc    far
rekeLoop:   Call    Sleep
            Call    MouseRead
            cmp    wMousePress,1
            jne    rekeTstKbd
            mov    ax,0FE00h
            retf

rekeTstKbd: mov     ah,1
            int     16h
            jz      rekeLoop
            xor     ah,ah
            int     16h
            retf
ReadKey     endp
;*************************************************************************
; Procedure OutAttr
; Parameters:
;            ah - attributes for output
;            bh - Y coordinat
;            bl - X coordinat
;*************************************************************************
OutAttr     proc    far
            push    es
            push    bx
            push    ax
            mov     ax,VideoSeg
            mov     es,ax
            mov     al,bh
            mov     bh,byte ptr ScrWidth
            inc     bh
            mul     bh
            shl     ax,1
            xor     bh,bh
            shl     bx,1
            add     bx,ax
            pop     ax
            mov     es:[bx+1],ah
            pop     bx
            pop     es
            retf
OutAttr     endp
;*************************************************************************
; Procedure RectWindow
; Parameters:
;            ah - attributes for output char
;            bh - Top Left Y coordinat Window
;            bl - Top Left X coordinat Window
;            dh - Bottom Right Y coordinat Window
;            dl - Bottom Right X coordinat Window
;
;*************************************************************************
RectWindow  proc    far
            push    bx
            push    cx
            push    dx
            push    ax
            push    si
            push    di

            cmp     bZoomWinFlg,1
            jne     rewiEnd

            mov     si,bx
            mov     di,dx
            mov     ch,dh
            sub     ch,bh
            mov     cl,dl
            sub     cl,bl
            sub     cx,0202h
            shr     cl,1
            shr     ch,1
            add     bx,cx
            mov     dx,bx
;            sub     bx,0101h
;            add     dx,0101h

rewiLoop:   push    ax
            mov     ax,si
            cmp     bh,ah
            ja      rewiCont3
            mov     bh,ah
            jmp     short rewiCont4
rewiCont3:  dec     bh
rewiCont4:  cmp     bl,al
            ja      rewiCont5
            mov     bl,al
            jmp     short rewiCont6
rewiCont5:  dec     bl

rewiCont6:  mov     ax,di
            cmp     dh,ah
            jb      rewiCont7
            mov     dh,ah
            jmp     short rewiCont8
rewiCont7:  inc     dh
rewiCont8:  cmp     dl,al
            jb      rewiCont9
            mov     dl,al
            jmp     short rewiCont10
rewiCont9:  inc     dl
rewiCont10: pop     ax
            cmp     bx,si
            ja      rewiCont1
            cmp     dx,di
            jae     rewiEnd
rewiCont1:  Call    RectStdWin
            push    ax
            push    cx
            push    dx
            mov     ah,86h
            xor     cx,cx
            mov     dx,2500
            int     15h
            pop     dx
            pop     cx
            pop     ax
            jmp     short rewiLoop

rewiEnd:    Call    RectStdWin
            pop     di
            pop     si
            pop     ax
            pop     dx
            pop     cx
            pop     bx
            retf
RectWindow  endp
;*************************************************************************
; Procedure RectStdWin
; Parameters:
;            ah - attributes for output char
;            bh - Top Left Y coordinat Window
;            bl - Top Left X coordinat Window
;            dh - Bottom Right Y coordinat Window
;            dl - Bottom Right X coordinat Window
;
;*************************************************************************
RectStdWin  proc    far
            push    di
            push    bx
            push    cx
            push    ax

            lea     di,WinChars
            cmp     bWinCharSet,1
            je      rwBegin
            add     di,6
rwBegin:    push    bx
            mov     al,20h
            xor     ch,ch
            mov     cl,dh
            sub     cl,bh

rwcont5:    push    cx
            xor     ch,ch
            mov     cl,dl
            sub     cl,bl
            push    bx

rwcont6:    Call    OutChar
            inc     bl
            loop    rwcont6

            pop     bx
            inc     bh
            pop     cx
            loop    rwcont5

            pop     bx
            mov     al,[di]        ; ''
            xor     ch,ch
            mov     cl,dl
            sub     cl,bl
            push    bx
rwcont1:    Call    OutChar
            inc     bl
            loop    rwcont1
            pop     bx

            push    bx
            mov     bh,dh
            xor     ch,ch
            mov     cl,dl
            sub     cl,bl
rwcont2:    Call    OutChar
            inc     bl
            loop    rwcont2
            pop     bx

            push    bx
            push    ax
            mov     bh,dh
            inc     bh
            xor     ch,ch
            mov     cl,dl
            sub     cl,bl
            inc     cl
            add     bl,2
            mov     ah,08h
rwcont7:    Call    OutAttr
            inc     bl
            loop    rwcont7
            pop     ax
            pop     bx

            mov     al,[di+1]             ; ''
            xor     ch,ch
            mov     cl,dh
            sub     cl,bh
            push    bx
rwcont3:    Call    OutChar
            inc     bh
            loop    rwcont3
            pop     bx

            push    bx
            mov     bl,dl
            xor     ch,ch
            mov     cl,dh
            sub     cl,bh
rwcont4:    Call    OutChar
            inc     bh
            loop    rwcont4
            pop     bx

            push    bx
            push    ax
            xor     ch,ch
            mov     cl,dh
            sub     cl,bh
            inc     bh
            mov     ah,08h
rwcont8:    mov     bl,dl
            inc     bl
            Call    OutAttr
            inc     bl
            Call    OutAttr
            inc     bh
            loop    rwcont8
            pop     ax
            pop     bx

            mov     al,[di+2]
            Call    OutChar
            inc     bl
            mov     al,'['
            Call    OutChar
            inc     bl
            mov     al,']'
            Call    OutChar
            sub     bl,2
            push    bx
            mov     bx,dx
            mov     al,[di+3]
            Call    OutChar
            pop     bx
            push    bx
            mov     bl,dl
            mov     al,[di+4]
            Call    OutChar
            pop     bx
            mov     bh,dh
            mov     al,[di+5]
            Call    OutChar

            pop     ax
            pop     cx
            pop     bx
            pop     di
            retf
RectStdWin  endp
;*************************************************************************
; Procedure ClsWindow
; Parameters:
;            ah - attributes for output char
;            bh - Top Left Y coordinat Window
;            bl - Top Left X coordinat Window
;            dh - Bottom Right Y coordinat Window
;            dl - Bottom Right X coordinat Window
;
;*************************************************************************
ClsWindow   proc    far
            push    bx
            push    cx
            push    ax
            mov     al,20h
            xor     ch,ch
            mov     cl,dh
            sub     cl,bh
cwcont5:    push    cx
            xor     ch,ch
            mov     cl,dl
            sub     cl,bl
            push    bx
cwcont6:    Call    OutChar
            inc     bl
            loop    cwcont6
            pop     bx
            inc     bh
            pop     cx
            loop    cwcont5
            pop     ax
            pop     cx
            pop     bx
            retf
ClsWindow   endp
;*************************************************************************
; Procedure OutString
; Parameters:
;            ah - attributes for output char
;            bh - Y coordinat
;            bl - X coordinat
;            dh - Bottom Right Y coordinat Window
;            dl - Bottom Right X coordinat Window
;         es:bp - pointer to ASCIIZ string
;            si - offset to first char for output of string
;*************************************************************************
OutString   proc    far
            push    si
            push    bp
            push    ax
            push    cx
            push    bx
            mov     cl,bl
toucont1:   mov     al,es:[bp+si]
            cmp     al,0
            jne     toucont5
            jmp     touexit
toucont5:   cmp     al,0Dh
            jne     toucont4
            inc     si
            cmp     bh,dh
            ja      touexit
            inc     bh
            mov     bl,cl
            jmp     toucont3
toucont4:   cmp     bl,dl
            jbe     toucont2
            jmp     toucont3
toucont2:   Call    OutChar
            inc     bl
toucont3:   inc     si
            jmp     toucont1
touexit:    pop     bx
            pop     cx
            pop     ax
            pop     bp
            pop     si
            retf
OutString   endp
;*************************************************************************
; Procedure OutAttrStr
; Parameters:
;            ah - attributes for output
;            bh - Y coordinat
;            bl - X coordinat
;            dh - Bottom Right Y coordinat Window
;            dl - Bottom Right X coordinat Window
;*************************************************************************
OutAttrStr  proc    far
            push    bx
            push    cx
            mov     cl,bl
oacont4:    cmp     bl,dl
            jbe     oacont2
oacont1:    cmp     bh,dh
            jae     oaexit
            inc     bh
            mov     bl,cl
oacont2:    Call    OutAttr
            inc     bl
            jmp     oacont4
oaexit:     pop     cx
            pop     bx
            retf
OutAttrStr  endp
;*************************************************************************
; Procedure StoreScrImage
; Parameters:
;*************************************************************************
StoreScrImage proc    far
              cmp     bUserScrBuf,1
              je      stscimBegin
              retf
stscimBegin:  push    es
              push    ds
              push    esi
              push    edi
              push    cx
              push    ax

              mov     cx,VideoPageSize
              xor     esi,esi
              xor     edi,edi
              mov     ax,UserScrSeg
              mov     es,ax
              mov     ax,VideoSeg
              mov     ds,ax
              shr     cx,2
              cld
              rep     movsd

              pop     ax
              pop     cx
              pop     edi
              pop     esi
              pop     ds
              pop     es
              retf
StoreScrImage endp
;*************************************************************************
; Procedure RestScrImage
; Parameters:
;*************************************************************************
RestScrImage  proc    far
              cmp     bUserScrBuf,1
              je      rescimBegin
              push    es
              push    di
              push    cx
              mov     cx,VideoPageSize
              shr     cx,1
              mov     ax,VideoSeg
              mov     es,ax
              mov     ax,0720h
              xor     di,di
              cld
              rep     stosw
              pop     cx
              pop     di
              pop     es
              retf
rescimBegin:  push    es
              push    ds
              push    esi
              push    edi
              push    cx
              push    ax

              mov     cx,VideoPageSize
              xor     edi,edi
              xor     esi,esi
              mov     ax,VideoSeg
              mov     es,ax
              mov     ax,UserScrSeg
              mov     ds,ax
              shr     cx,2
              cld
              rep     movsd

              pop     ax
              pop     cx
              pop     edi
              pop     esi
              pop     ds
              pop     es
              retf
RestScrImage  endp
;*************************************************************************
; Procedure SwapScr2Buf
; Parameters:
;*************************************************************************
SwapScr2Buf   proc    far
              push    es
              push    ds
              push    ax
              push    esi
              push    edi
              push    ecx

              xor     esi,esi
              xor     edi,edi
              xor     ecx,ecx
              mov     cx,VideoPageSize
              shr     cx,2
              mov     ax,VideoBufSeg
              mov     es,ax
              mov     ax,VideoSeg
              mov     ds,ax
              cld
              rep     movsd
              pop     ecx
              pop     edi
              pop     esi
              pop     ax
              pop     ds
              pop     es
              retf
SwapScr2Buf   endp
;*************************************************************************
; Procedure SwapBuf2Scr
; Parameters:
;*************************************************************************
SwapBuf2Scr   proc    far
              push    es
              push    ds
              push    ax
              push    esi
              push    edi
              push    ecx

              xor     esi,esi
              xor     edi,edi
              xor     ecx,ecx
              mov     cx,VideoPageSize
              shr     cx,2
              mov     ax,VideoSeg
              mov     es,ax
              mov     ax,VideoBufSeg
              mov     ds,ax
              cld
              rep     movsd
              pop     ecx
              pop     edi
              pop     esi
              pop     ax
              pop     ds
              pop     es
              retf
SwapBuf2Scr   endp
;*************************************************************************
; Procedure GetCursor
; Parameters:  not used
;*************************************************************************
GetCursor   proc    far
            push    ax
            push    bx
            push    dx
            push    cx
            mov     bh,0
            mov     ah,3
            int     10h
            mov     StartCursor,dx
            pop     cx
            pop     dx
            pop     bx
            pop     ax
            retf
GetCursor   endp
;*************************************************************************
; Procedure StoreLine
; Parameters: wLineX, wLineY, AsmBuffer
;*************************************************************************
StoreLine   proc     far
            push     bx
            push     si

            mov      bh,byte ptr wLineY
            mov      bl,byte ptr wLineX
            lea      si,AsmBuffer

stlnLoop:   cmp      bl,ScrWidth
            jae      stlnExit
            Call     GetChar
            mov      [si],ax
            add      si,2
            inc      bl
            jmp      stlnLoop

stlnExit:   pop      si
            pop      bx
            retf
StoreLine   endp
;*************************************************************************
; Procedure RestLine
; Parameters: wLineX, wLineY, AsmBuffer
;*************************************************************************
RestLine    proc     far
            push     bx
            push     si

            mov      bh,byte ptr wLineY
            mov      bl,byte ptr wLineX
            lea      si,AsmBuffer

relnLoop:   cmp      bl,ScrWidth
            jae      relnExit
            mov      ax,[si]
            Call     OutChar
            add      si,2
            inc      bl
            jmp      relnLoop

relnExit:   pop      si
            pop      bx
            retf
RestLine    endp
;*************************************************************************
; Procedure PictLine
; Parameters: wLineX, wLineY
;*************************************************************************
PictLine    proc     far
            push     bx
            push     dx

            mov      bh,byte ptr wLineY
            mov      bl,byte ptr wLineX
            mov      ah,ctvMarkOut
            mov      al,'0'
            mov      dl,'0'

pilnLoop:   cmp      bl,ScrWidth
            jae      pilnExit
            inc      al
            cmp      al,':'
            jne      pilnOut
            inc      dl
            cmp      dl,':'
            jne      pilnDOut
            mov      dl,'0'
pilnDOut:   mov      al,dl
            and      ah,0F0h
            or       ah,0Eh
            Call     OutChar
            mov      al,'0'
            mov      ah,ctvMarkOut
            inc      bl
            jmp      pilnLoop
pilnOut:    Call     OutChar
            inc      bl
            jmp      pilnLoop

pilnExit:   pop      dx
            pop      bx
            retf
PictLine    endp
;*************************************************************************
; Procedure UProcessBarFill                 Universal process bar
; Parameters:  dProcessBarLen, dProcessBarPos
;*************************************************************************
UProcessBarFill  proc    far
                 push    ebx
                 push    eax
                 push    edx
                 push    ecx

                 xor     edx,edx
                 mov     eax,dProcessBarPos

                 xor     ecx,ecx
                 mov     cx,40
                 mul     ecx
                 mov     ecx,dProcessBarLen
                 inc     ecx
                 div     ecx
                 mov     bx,0B1Eh
                 mov     cx,ax
                 cmp     cx,0
                 jne     uprbfStart

                 mov     cx,20
                 mov     bx,0B1Eh
                 mov     al,' '
                 mov     ah,bHlpCurAttr
uprbfcont1:      Call    OutChar
                 inc     bl
                 loop    uprbfcont1
                 jmp     uprbfExit

uprbfStart:      mov     al,''
                 mov     ah,bHlpCurAttr
                 mov     dx,cx
                 shr     cx,1
                 push    cx
                 shl     cx,1
                 sub     dx,cx
                 pop     cx
                 cmp     cx,0
                 je      uprbfcont3

uprbfcont2:      Call    OutChar
                 inc     bl
                 loop    uprbfcont2
uprbfcont3:      cmp     dx,0
                 je      uprbfExit
                 mov     al,''
                 Call    OutChar

uprbfExit:       pop     ecx
                 pop     edx
                 pop     eax
                 pop     ebx
                 retf
UProcessBarFill  endp
;*************************************************************************
; Procedure UProcessBarWindow         Universal process bar window
; Parameters:  not used
;*************************************************************************
UProcessBarWindow  proc    far
                   pushad
                   mov     ah,bHlpWinAttr
                   mov     bx,0A1Ch
                   mov     dx,0C33h
                   Call    RectWindow
                   lea     si,sUProcessBarHdr
                   mov     ah,bHlpTxtAttr
                   mov     bx,0A21h
                   Call    WriteStr

                   mov     cx,20
                   mov     bx,0B1Eh
                   mov     al,' '
                   mov     ah,bHlpCurAttr
uprbwcont1:        Call    OutChar
                   inc     bl
                   loop    uprbwcont1

                   popad
                   retf
UProcessBarWindow  endp
