;۲۲۲۲۲۲۲۲۲۲۲۲
;۲۲              QView Module             ޱ۲۲۲
;۲۲        (c) Copyright  1995-2006       ް۲۲۲
;۲۲           AGCProduct ۲         ޱ۲۲۲
;۲۲۲                   by                  ޲۲۲
;۲۲             Alexandr Gazko            ۲۲۲
;۲۲            ver. 2.91  beta            ޲۲۲۲
;۲۲۲۲۲۲۲۲۲۲۲۲

.CODE CODE1
.386
;align 2
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure fpSetParms
; Parameters:
;۲۲۲۲۲۲۲۲۲۲۲۲
fpSetParms        proc    far
                  push    es
                  mov     ah,2Fh
                  int     21h
                  mov     ax,es
                  mov     wfimaDTASeg,ax
                  mov     wfimaDTAOfs,bx
                  pop     es
                  mov     ax,es
                  mov     wfimaNDTASeg,ax
                  push    es
                  push    ds
                  pop     ax
                  pop     ds
                  push    ax
                  mov     ah,1Ah
                  xor     dx,dx
                  int     21h
                  pop     ds
                  retf
fpSetParms        endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure fpRestoreParms
; Parameters:
;۲۲۲۲۲۲۲۲۲۲۲۲
fpRestoreParms    proc    far
                  push    ds
                  mov     dx,wfimaDTAOfs
                  mov     ax,wfimaDTASeg
                  mov     ds,ax
                  mov     ah,1Ah
                  int     21h
                  pop     ds
                  retf
fpRestoreParms    endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure GetCurPath
; Parameters:
;۲۲۲۲۲۲۲۲۲۲۲۲
GetCurPath        proc    far
                  mov     ah,19h
                  int     21h
                  mov     bfimaCurDrive,al
                  add     al,'A'
                  mov     byte ptr sfimaCurPath,al
                  mov     ah,47h
                  ;mov     dl,bfimaCurDrive
                  mov     dl,0
                  lea     si,sfimaCurPath+3
                  int     21h
                  retf
GetCurPath        endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure GetStartPath                        Use Qview
; Parameters:
;۲۲۲۲۲۲۲۲۲۲۲۲
GetStartPath      proc    far
                  push    eax
                  push    edx
                  push    esi
                  mov     ah,19h
                  int     21h
                  mov     bfimaStartDrive,al
                  add     al,'A'
                  mov     byte ptr sfimaStartPath,al
                  mov     ah,47h
                  mov     dl,0
                  lea     si,sfimaStartPath+3
                  int     21h
                  mov     bStartPathStored,1
                  pop     esi
                  pop     edx
                  pop     eax
                  retf
GetStartPath      endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure SetStartPath                         Use QView
; Parameters:
;۲۲۲۲۲۲۲۲۲۲۲۲
SetStartPath      proc    far
                  cmp     bStartPathStored,1
                  je      sestpaBegin
                  ret
sestpaBegin:      push    eax
                  push    edx
                  push    esi

                  mov     ah,0Eh
                  mov     dl,bfimaStartDrive
                  int     21h

                  mov     ah,3Bh
                  lea     dx,sfimaStartPath
                  int     21h

                  pop     esi
                  pop     edx
                  pop     eax
                  retf
SetStartPath      endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure fpChangeFileColor
; Parameters: es:di - file struction
; Return:     bfimaFileColor
;             bfimaFileDivider
;۲۲۲۲۲۲۲۲۲۲۲۲
fpChangeFileColor proc    far
;cfpFiles,cfpHidden,cfpSystem,cfpHidSys
;cfpDirectory,cfpDirHidden,cfpDirSystem,cfpDirHidSys
                  mov     al,es:[di]              ; file attributes
                  mov     bfimaFileDivider,' '
                  test    al,010000b
                  jz      fpchficoFile
;--- Directory -----------------------------------------------------------
                  mov     ah,cfpDirectory
                  and     al,0110b
                  jz      fpchficoExit
                  mov     bfimaFileDivider,''
                  mov     ah,cfpDirHidden
                  cmp     al,2
                  je      fpchficoDirExit
                  mov     bfimaFileDivider,''
                  mov     ah,cfpDirSystem
                  cmp     al,4
                  je      fpchficoDirExit
                  mov     bfimaFileDivider,''
                  mov     ah,cfpDirHidSys

fpchficoDirExit:  cmp     bfimaSysDirColor,1
                  je      fpchficoExit
                  mov     ah,cfpDirectory
                  jmp     fpchficoExit
;--- File ----------------------------------------------------------------
fpchficoFile:     mov     ah,cfpFiles
                  and     al,0110b
                  jz      fpchficoFileExit
                  mov     bfimaFileDivider,''
                  mov     ah,cfpHidden
                  cmp     al,2
                  je      fpchficoFileExit
                  mov     bfimaFileDivider,''
                  mov     ah,cfpSystem
                  cmp     al,4
                  je      fpchficoFileExit
                  mov     bfimaFileDivider,''
                  mov     ah,cfpHidSys

fpchficoFileExit: cmp     bfimaSysFileColor,1
                  je      fpchficoFilExit1
                  mov     ah,cfpFiles
fpchficoFilExit1: Call    fpTstFileExtHigh

fpchficoExit:     mov     bfimaFileColor,ah
                  retf
fpChangeFileColor endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure fpTstFileExtHigh
;۲۲۲۲۲۲۲۲۲۲۲۲
fpTstFileExtHigh  proc    far
                  push    edx
                  push    cx
                  push    di
                  push    ebx
                  cmp     byte ptr dfimaFileExt,0
                  jne     fptfehNext
                  mov     dword ptr dfimaFileExt,0
                  jmp     fptfehGetExt
fptfehNext:       cmp     byte ptr dfimaFileExt+1,0
                  jne     fptfehNext1
                  mov     word ptr dfimaFileExt+2,0
                  jmp     fptfehGetExt
fptfehNext1:      cmp     byte ptr dfimaFileExt+2,0
                  jne     fptfehGetExt
                  mov     word ptr dfimaFileExt+2,0
fptfehGetExt:     mov     edx,dfimaFileExt
                  cmp     edx,0
                  jne     fptfehBegin
                  mov     edx,dword ptr 0000002Eh
fptfehBegin:      lea     di,bfimaHighExec
                  mov     cx,6
fptfehMainLoop:   push    cx
                  push    di
                  mov     cx,16

fptfehLoop:       mov     ebx,dword ptr ds:[di]
                  cmp     ebx,edx
                  je      fptfehFound
                  cmp     ebx,0
                  je      fptfehNextLoop
                  add     di,4
                  dec     cx
                  jnz     fptfehLoop
fptfehNextLoop:   pop     di
                  add     di,64
                  pop     cx
                  dec     cx
                  jnz     fptfehMainLoop
                  jmp     fptfehExit

fptfehFound:      pop     di
                  pop     cx
                  mov     bx,cx
                  sub     bx,6
                  neg     bx
                  add     bx,offset cfpFileExec
                  mov     ah,[bx]
fptfehExit:       pop     ebx
                  pop     di
                  pop     cx
                  pop     edx
                  retf
fpTstFileExtHigh  endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure SortCompareName
;۲۲۲۲۲۲۲۲۲۲۲۲
SortCompareName   proc    near
                  push    cx
                  push    di
                  mov     al,es:[di]
                  and     al,010000b
                  mov     ah,es:[di+22]
                  and     ah,010000b
                  cmp     al,ah
                  jb      sortcoExit
                  ja      sortcoAbort

                  cmp     al,010000b
                  je      sortcoLoop

                  mov     al,es:[di]
                  and     al,10000000b
                  mov     ah,es:[di+22]
                  and     ah,10000000b
                  cmp     al,ah
                  jb      sortcoExit
                  ja      sortcoAbort

sortcoLoop:       mov     al,es:[di+9]
                  cmp     al,es:[di+22+9]
                  ja      sortcoExit
                  jb      sortcoAbort
                  cmp     al,0
                  je      sortcoExit
                  cmp     al,'.'
                  je      sortcoExit
                  inc     di
                  jmp     sortcoLoop
sortcoAbort:      stc
                  jmp     sortcoExit1
sortcoExit:       clc
sortcoExit1:      pop     di
                  pop     cx
                  ret
SortCompareName   endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure SortCompareExt
;۲۲۲۲۲۲۲۲۲۲۲۲
SortCompareExt    proc    near
                  push    cx
                  push    di
                  push    si
                  push    bx

                  mov     si,di
                  mov     bx,di
                  add     si,22
                  mov     al,es:[di]
                  and     al,010000b
                  mov     ah,es:[di+22]
                  and     ah,010000b
                  cmp     al,ah
                  jb      srtcoextExit
                  ja      srtcoextAbort
                  cmp     word ptr es:[di+9],2E2Eh
                  je      srtcoextAbort
                  cmp     al,010000b
                  je      srtcoextLoop1

                  mov     al,es:[di]
                  and     al,10000000b
                  mov     ah,es:[di+22]
                  and     ah,10000000b
                  cmp     al,ah
                  jb      srtcoextExit
                  ja      srtcoextAbort

srtcoextLoop1:    mov     al,es:[di+9]
                  cmp     al,'.'
                  je      srtcoextLoop2
                  cmp     al,0
                  je      srtcoextLoop2
                  inc     di
                  jmp     srtcoextLoop1

srtcoextLoop2:    mov     al,es:[si+9]
                  cmp     al,'.'
                  je      srtcoextLoop
                  cmp     al,0
                  je      srtcoextLoop
                  inc     si
                  jmp     srtcoextLoop1

srtcoextLoop:     mov     al,es:[di+9]
                  cmp     al,es:[si+9]
                  ja      srtcoextExit
                  jb      srtcoextAbort
                  cmp     al,0
                  je      srtcoextName
                  inc     di
                  inc     si
                  jmp     srtcoextLoop

srtcoextName:     mov     al,es:[bx+9]
                  cmp     al,es:[bx+22+9]
                  ja      srtcoextExit
                  jb      srtcoextAbort
                  cmp     al,0
                  je      srtcoextExit
                  cmp     al,'.'
                  je      srtcoextExit
                  inc     bx
                  jmp     srtcoextName

srtcoextAbort:    stc
                  jmp     srtcoextExit1
srtcoextExit:     clc
srtcoextExit1:    pop     bx
                  pop     si
                  pop     di
                  pop     cx
                  ret
SortCompareExt    endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure SortCompareSize
;۲۲۲۲۲۲۲۲۲۲۲۲
SortCompareSize   proc    near
                  push    cx
                  push    di
                  push    eax

                  mov     al,es:[di]
                  and     al,010000b
                  mov     ah,es:[di+22]
                  and     ah,010000b
                  cmp     al,ah
                  jb      srtcosizeExit
                  ja      srtcosizeAbort
                  cmp     word ptr es:[di+9],2E2Eh
                  je      srtcosizeAbort

                  mov     eax,dword ptr es:[di+5]
                  cmp     eax,dword ptr es:[di+22+5]
                  jb      srtcosizeExit
srtcosizeAbort:   stc
                  jmp     srtcosizeExit1
srtcosizeExit:    clc
srtcosizeExit1:   pop     eax
                  pop     di
                  pop     cx
                  ret
SortCompareSize   endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure SortCompareTime
;۲۲۲۲۲۲۲۲۲۲۲۲
SortCompareTime   proc    near
                  push    cx
                  push    di
                  push    eax

                  mov     al,es:[di]
                  and     al,010000b
                  mov     ah,es:[di+22]
                  and     ah,010000b
                  cmp     al,ah
                  jb      srtcotimeExit
                  ja      srtcotimeAbort
                  cmp     word ptr es:[di+9],2E2Eh
                  je      srtcotimeAbort

                  mov     eax,dword ptr es:[di+1]
                  cmp     eax,dword ptr es:[di+22+1]
                  jb      srtcotimeExit
srtcotimeAbort:   stc
                  jmp     srtcotimeExit1
srtcotimeExit:    clc
srtcotimeExit1:   pop     eax
                  pop     di
                  pop     cx
                  ret
SortCompareTime   endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure SortXchg
;۲۲۲۲۲۲۲۲۲۲۲۲
SortXchg          proc    near
                  push    di
                  push    cx
                  push    si
                  push    ds
                  push    es

                  push    ds
                  mov     si,di
                  push    si
                  lea     di,sSortBuffer
                  mov     ax,es
                  push    ds
                  pop     es
                  push    ax
                  pop     ds
                  cld
                  mov     cx,22
                  rep     movsb

                  push    ds
                  pop     es

                  pop     di
                  mov     si,di
                  add     si,22
                  push    si
                  mov     cx,22
                  rep     movsb
                  pop     di
                  pop     ds
                  lea     si,sSortBuffer
                  mov     cx,22
                  rep     movsb

                  pop     es
                  pop     ds
                  pop     si
                  pop     cx
                  pop     di
                  ret
SortXchg          endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure BubleSort
;۲۲۲۲۲۲۲۲۲۲۲۲
BubbleSort        proc    far
                  push    ax
                  push    bx
                  push    cx
                  cmp     bSortCurPos,0
                  je      busoExit
                  cmp     wfimaFileCount,1
                  jbe     busoExit
                  cmp     bSortCurPos,1
                  jne     busoProc
                  lea     bx,SortCompareName
                  jmp     busoBegin

busoProc:         cmp     bSortCurPos,2
                  jne     busoProc1
                  lea     bx,SortCompareExt
                  jmp     busoBegin

busoProc1:        cmp     bSortCurPos,3
                  jne     busoProc2
                  lea     bx,SortCompareSize
                  jmp     busoBegin

busoProc2:        cmp     bSortCurPos,4
                  jne     busoProc3
                  lea     bx,SortCompareTime
                  jmp     busoBegin

busoProc3:
                  jmp     busoExit

busoBegin:        mov     wSortProc,bx
                  mov     cx,wfimaFileCount
;                  dec     cx
                  mov     wSortCounter,cx
busoInit:         mov     bx,1
                  dec     wSortCounter
                  jz      busoExit
                  mov     cx,wSortCounter
                  mov     di,wSortStartAddr
busoNext:         Call    [wSortProc]
                  jc      busoCont
                  Call    SortXchg
                  sub     bx,bx
busoCont:         add     di,22
                  loop    busoNext
                  cmp     bx,0
                  je      busoInit
busoExit:         pop     cx
                  pop     bx
                  pop     ax
                  retf
BubbleSort        endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure StoreNameHSBuffer
;۲۲۲۲۲۲۲۲۲۲۲۲
StoreNameHSBuffer proc    far
                  push    es
                  push    si
                  push    di

                  mov     es,PSPValue
                  lea     si,hsBuffer
                  mov     di,81h
                  mov     byte ptr es:[di-1],64
                  mov     cx,13
                  cld
                  rep     movsb
;                  xor     al,al
;                  mov     cx,13
;                  mov     di,81h
;                  repnz   scasb
;                  mov     byte ptr es:[di-1],0Dh

                  pop     di
                  pop     si
                  pop     es
                  retf
StoreNameHSBuffer endp
;****************************************************************************
;Procedure  GetMZHeader
;Return:    NewHdrOfs
;****************************************************************************
GetMZHeader   proc    far
              cmp     FileSize,28
              ja      gmzoBegin
gmzoNotMZ:    stc
              retf
gmzoBegin:    push    ax
              push    bx
              push    cx
              push    dx
              mov     ax,4200h
              xor     dx,dx
              xor     cx,cx
              mov     bx,word ptr Handle
              int     21h
              mov     ah,3Fh
              mov     cx,27
              lea     dx,HeaderBuf
              int     21h
              pop     dx
              pop     cx
              pop     bx
              pop     ax
              cmp     word ptr HeaderBuf,5A4Dh
              jne     gmzoNotMZ
              clc
              retf
GetMZHeader   endp
;****************************************************************************
;Procedure  GetExtHdrOfs
;Return:    NewHdrOfs
;****************************************************************************
GetExtHdrOfs  proc    far
              mov     NewHdrOffs,0
              cmp     FileSize,40h
              ja      gehoBegin
gehoNotExt:   stc
              retf
gehoBegin:    push    ax
              push    bx
              push    cx
              push    dx
              mov     ax,4200h
              mov     dx,003Ch
              xor     cx,cx
              mov     bx,word ptr Handle
              int     21h
              mov     ah,3Fh
              mov     cx,4
              lea     dx,NewHdrOffs
              int     21h
              pop     dx
              pop     cx
              pop     bx
              pop     ax
              push    eax
              mov     eax,NewHdrOffs
              mov     dObjTableOfs,eax
              cmp     eax,FileSize
              pop     eax
              jae     gehoNotExt
              clc
              retf
GetExtHdrOfs  endp
;****************************************************************************
;Procedure  GetExtHdrInd
;Return:    NewHdrOfs
;****************************************************************************
GetExtHdrInd  proc    far
              push    ax
              push    bx
              push    cx
              push    dx
              mov     ax,4200h
              mov     dx,word ptr NewHdrOffs
              mov     cx,word ptr NewHdrOffs+2
              mov     bx,word ptr Handle
              int     21h
              mov     ah,3Fh
              mov     cx,2
              lea     dx,hsBuffer
              mov     word ptr hsBuffer,0
              int     21h
              pop     dx
              pop     cx
              pop     bx
              pop     ax
              clc
              retf
GetExtHdrInd  endp
;****************************************************************************
;Procedure  GetNwHeader
;Return:
;****************************************************************************
GetNwHeader   proc    far
              push    ax
              push    bx
              push    cx
              push    dx
              mov     ax,4200h
              mov     dx,word ptr NewHdrOffs
              mov     cx,word ptr NewHdrOffs+2
              mov     bx,word ptr Handle
              int     21h
              mov     ah,3Fh
              mov     cx,wNhdrSize
              lea     dx,hsBuffer
              mov     word ptr hsBuffer,0
              int     21h
              pop     dx
              pop     cx
              pop     bx
              jnc     gpehNext
gpehAbort:    pop     ax
              stc
              retf
gpehNext:     cmp     ax,wNHdrSize
              jb      gpehAbort
              pop     ax
              clc
              retf
GetNwHeader   endp
;*************************************************************************
; Procedure UpCase
; Parameters:
;            ah - char for UpCase
; Return:
;            ah - UpCased char
;*************************************************************************
UpCase      proc    far
            cmp     ah,'a'
            jb      upcexit
            cmp     ah,'z'
            ja      upccont1
            sub     ah,'a'-'A'
            jmp     short upcexit
upccont1:   cmp     ah,''
            jb      upcexit
            cmp     ah,''
            ja      upccont2
            sub     ah,''-''
            jmp     short upcexit
upccont2:   cmp     ah,''
            jb      upcexit
            cmp     ah,''
            ja      upcexit
            sub     ah,''-''
upcexit:
            retf
UpCase      endp
;*************************************************************************
; Procedure LowerCase
; Parameters:
;            ah - char for LowerCase
; Return:
;            ah - LowerCased char
;*************************************************************************
LowerCase   proc    far
            cmp     ah,'A'
            jb      locexit
            cmp     ah,'Z'
            ja      loccont1
            add     ah,'a'-'A'
            retf
loccont1:   cmp     ah,''
            jb      locexit
            cmp     ah,''
            ja      loccont2
            add     ah,''-''
            retf
loccont2:   cmp     ah,''
            jb      locexit
            cmp     ah,''
            ja      locexit
            add     ah,''-''
locexit:
            retf
LowerCase   endp
;*************************************************************************
; Procedure StrUpCase
; Parameters:
;             es:bx - pointer to ASCIIZ string
;*************************************************************************
StrUpCase   proc    far
            push    bx
            push    ax
succont1:   mov     al,es:[bx]
            cmp     al,0
            je      sucexit
            cmp     al,'z'
            ja      succont2
            cmp     al,'a'
            jb      succont2
            sub     al,32
            mov     es:[bx],al
succont2:   inc     bx
            jmp     succont1
sucexit:    pop     ax
            pop     bx
            retf
StrUpCase   endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure MyDelete
; Parameters: ds:si - ASCIIZ string
;                cl - position
;۲۲۲۲۲۲۲۲۲۲۲۲۲
MyDelete      proc     far
              push     si
              xor      ch,ch
              add      si,cx
MyDeleteloop: mov      al,[si+1]
              cmp      al,0
              je       MyDeleteexit
              mov      [si],al
              inc      si
              jmp      MyDeleteLoop
MyDeleteExit: mov      [si],al
              pop      si
              retf
MyDelete      endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure MyDelete2
; Parameters: ds:si - ASCIIZ string
;                cl - position
;۲۲۲۲۲۲۲۲۲۲۲۲۲
MyDelete2     proc     far
              push     cx
              push     si
              xor      ch,ch
              add      si,cx
              mov      ch,_CurStrLen
              sub      ch,cl
              mov      cl,ch
              xor      ch,ch
              cmp      cx,0
              je       MyDelet2Exit
MyDelet2loop: mov      al,[si+1]
              mov      [si],al
              inc      si
              loop     MyDelet2Loop
              mov      [si],al
MyDelet2Exit: pop      si
              pop      cx
              retf
MyDelete2     endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure MyInsert
; Parameters: ds:si - ASCIIZ string
;                cl - position
;                al - char
;۲۲۲۲۲۲۲۲۲۲۲۲۲
MyInsert     proc     far
              push     si
              xor      ch,ch
              add      si,cx
              cmp      _InsertMode,1
              jne      MyInsertOwer
MyInsertloop: xchg     al,[si]
              inc      si
              cmp      al,0
              jne      MyInsertloop
              mov      [si],al
              jmp      short MyInsertExit
MyInsertOwer: xchg     al,[si]
              dec      dh
              cmp      al,0
              jne      MyInsertExit
              mov      [si+1],al
              inc      dh
MyInsertExit: pop      si
              retf
MyInsert     endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure MyInsert2
; Parameters: ds:si - ASCII string
;                cl - position
;                al - char
;۲۲۲۲۲۲۲۲۲۲۲۲۲
MyInsert2     proc     far
              push     cx
              push     si
              xor      ch,ch
              add      si,cx
              cmp      _InsertMode,1
              jne      MyInset2Ower
              mov      ch,_CurStrLen
              sub      ch,cl
              mov      cl,ch
              xor      ch,ch
              cmp      cx,0
              je       MyInset2Exit
MyInset2loop: xchg     al,[si]
              inc      si
              loop     MyInset2loop
MyInset2Exit: mov      [si],al
              jmp      short MyIns2Exit1
MyInset2Ower: xchg     al,[si]
              cmp      _CurStrLen,0
              je       MyIns2Exit1
              dec      _CurStrLen
              dec      dh
              cmp      cl,_CurStrLen
              jbe      MyIns2Exit1
              pop      si
              push     si
              mov      cl,_CurStrLen
              xor      ch,ch
              add      si,cx
              mov      byte ptr [si+2],0
              inc      dh
              inc      _CurStrLen
MyIns2Exit1:  pop      si
              pop      cx
              retf
MyInsert2     endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure StrLen
; Parameters: ds:si - ASCIIZ string
; Return: al - StrLen
;۲۲۲۲۲۲۲۲۲۲۲۲۲
StrLen        proc     far
              push     si
              push     cx
              xor      cx,cx
strlenloop:   inc      cx
              lodsb
              cmp      al,0
              jne      strlenloop
              dec      cx
              mov      al,cl
              pop      cx
              pop      si
              retf
StrLen        endp
;*************************************************************************
; Procedure FStrSwapper
; Parameters:
;            si - current offset in buffer
; Return:
;            si - new offset in buffer
;*************************************************************************
FStrSwapper proc    far
            cmp     byte ptr SwapLog,1
            je      fstswpexit
            cmp     si,word ptr UpLoad               ; 54000
            jb      fstswpexit
            mov     eax,dword ptr FileSize
            sub     eax,dword ptr RealOfs
            cmp     eax,dword ptr BufferSize
            jbe     fstswpexit                       ;  㦥  

            push    edi
            push    eax
            push    ecx
            push    ebx
            push    edx
            push    ebp

            sub     si,word ptr SwapPos
            add     dword ptr RealOfs,esi            ; +(CurrBufPos-SwapPos)
            xor     di,di
            mov     cx,word ptr SwapPos
            push    ds
            push    es
            pop     ds
            cld
            rep     movsb
            pop     ds
            mov     eax,dword ptr RealOfs
            add     eax,dword ptr SwapPos
            mov     dword ptr TmpVar,eax
            mov     dx,word ptr TmpVar
            mov     cx,word ptr TmpVar+2
            Call    DeviceSeek
            mov     cx,word ptr BufferSize
            sub     cx,word ptr SwapPos
            mov     dx,word ptr SwapPos
            push    dx
            push    ds
            push    es
            pop     ds
            Call    DeviceRead
            pop     ds
            add     ax,word ptr SwapPos
            mov     word ptr EndBuffer,ax
            pop     si

fstswpexit1: pop     ebp
            pop     edx
            pop     ebx
            pop     ecx
            pop     eax
            pop     edi

fstswpexit: retf
FStrSwapper endp
;*************************************************************************
; Procedure Swapper
; Parameters:
;            si - current offset in buffer
; Return:
;            si - new offset in buffer
;*************************************************************************
Swapper     proc    far
            cmp     byte ptr SwapLog,1
            je      swpexit

            push    edi
            push    eax
            push    ecx
            push    ebx
            push    edx
            push    ebp

            mov     word ptr TmpSI,si
            mov     ax,word ptr CurOutOfs
            sub     word ptr TmpSI,ax

            cmp     si,word ptr UpLoad               ; 54000
            jb      swpcont2                         ; cmp DnLoad
            mov     eax,dword ptr FileSize
            sub     eax,dword ptr RealOfs
            cmp     eax,dword ptr BufferSize
            jbe     swpexit1                         ;  㦥  
            sub     si,word ptr SwapPos
            add     dword ptr RealOfs,esi            ; +(CurrBufPos-SwapPos)
            xor     di,di
            mov     cx,word ptr SwapPos
            push    ds
            push    es
            pop     ds
            cld
            rep     movsb
            pop     ds
            mov     eax,dword ptr RealOfs
            add     eax,dword ptr SwapPos
            mov     dword ptr TmpVar,eax
            mov     dx,word ptr TmpVar
            mov     cx,word ptr TmpVar+2
            Call    DeviceSeek
            mov     cx,word ptr BufferSize
            sub     cx,word ptr SwapPos
            mov     dx,word ptr SwapPos
            push    dx
            push    ds
            push    es
            pop     ds
            Call    DeviceRead
            pop     ds
            add     ax,word ptr SwapPos
            mov     word ptr EndBuffer,ax
            pop     si
            jmp     swpexit2

swpcont2:   cmp     si,word ptr DnLoad
            ja      swpexit1
            mov     eax,dword ptr RealOfs
            cmp     eax,0
            je      swpexit1
            cmp     eax,dword ptr SwapPos
            jb      swpcont3
            add     si,word ptr SwapPos
            add     eax,esi                        ; esi
            sub     eax,dword ptr BufferSize
            mov     dword ptr RealOfs,eax          ; RealOfs-SwpPos
            mov     di,word ptr BufferSize
            mov     cx,word ptr SwapPos
            push    word ptr SwapPos
            push    cx
            jmp     short swpcont4

swpcont3:   mov     cx,word ptr BufferSize
            mov     di,cx
            sub     cx,ax
            add     si,ax
            push    si
            mov     si,cx
            mov     dword ptr RealOfs,0
            push    ax

swpcont4:   push    ds
            push    es
            pop     ds
            std
            rep     movsb
            pop     ds

            mov     dx,word ptr RealOfs
            mov     cx,word ptr RealOfs+2
            Call    DeviceSeek
            pop     cx
            inc     cx
            xor     dx,dx
            push    ds
            push    es
            pop     ds
            Call    DeviceRead
            pop     ds
            mov     ax,word ptr BufferSize
            mov     word ptr EndBuffer,ax
            pop     si
swpexit2:   mov     word ptr CurOutOfs,si
            mov     ax,word ptr TmpSI
            sub     word ptr CurOutOfs,ax

swpexit1:   pop     ebp
            pop     edx
            pop     ebx
            pop     ecx
            pop     eax
            pop     edi

swpexit:    retf
Swapper     endp
;*************************************************************************
; Procedure Loader
; Parameters: RealOfs - real offset in file
;*************************************************************************
Loader      proc    far
            mov     al,byte ptr SwapLog
            cmp     al,1
            je      ldrexit

            push    edi
            push    eax
            push    ecx
            push    ebx
            push    edx
            push    ebp

            mov     eax,dword ptr RealOfs
            mov     dword ptr TmpVar,eax
            mov     dx,word ptr TmpVar
            mov     cx,word ptr TmpVar+2
            Call    DeviceSeek
            mov     cx,word ptr BufferSize
            xor     dx,dx
            push    ds
            push    es
            pop     ds
            Call    DeviceRead
            pop     ds
            mov     word ptr EndBuffer,ax

            pop     ebp
            pop     edx
            pop     ebx
            pop     ecx
            pop     eax
            pop     edi

ldrexit:    retf
Loader      endp
;*************************************************************************
; Procedure FileLoad
; Parameters: RealOfs - real offset in file
;*************************************************************************
FileLoad    proc    far
            push    edi
            push    eax
            push    ecx
            push    ebx
            push    edx
            push    ebp

            mov     eax,dword ptr RealOfs
            mov     dword ptr TmpVar,eax
            mov     dx,word ptr TmpVar
            mov     cx,word ptr TmpVar+2
            Call    DeviceSeek

            mov     cx,word ptr BufferSize
            xor     dx,dx
            push    ds
            push    es
            pop     ds
            Call    DeviceRead
            pop     ds
            mov     word ptr EndBuffer,ax

            pop     ebp
            pop     edx
            pop     ebx
            pop     ecx
            pop     eax
            pop     edi

            retf
FileLoad    endp
;*************************************************************************
; Procedure ChangeTabOn
;*************************************************************************
ChangeTabOn proc    far
            push    ax
            mov     ax,204Eh
            cmp     bTabONFlag,1
            je      chtoOn
            mov     ax,4646h
chtoOn:     mov     word ptr hTabON+13,ax
            pop     ax
            retf
ChangeTabOn endp
;*************************************************************************
; Procedure ChangeEditOn
;*************************************************************************
ChangeEditOn proc    far
             push    ax
             mov     ax,204Eh
             cmp     bEditEnable,1
             je      cheoOn
             mov     ax,4646h
cheoOn:      mov     word ptr hEditEnable+14,ax
             pop     ax
             retf
ChangeEditOn endp
;*************************************************************************
; Procedure ChangeTEditOn
;*************************************************************************
ChangeTEditOn proc    far
             push    ax
             mov     al,cStLineMes
             mov     ah,cStLineKey
             mov     byte ptr hTEditEnable[1],ah
             mov     byte ptr hTEditEnable[7],al
             cmp     bViewDevice,0
             je      chteoBegin
             mov     ah,cStLineGray
             mov     byte ptr hTEditEnable[1],ah
             mov     byte ptr hTEditEnable[7],ah

chteoBegin:  mov     ax,204Eh
             cmp     bTEditEnable,1
             je      chteoOn
             mov     ax,4646h
chteoOn:     mov     word ptr hTEditEnable+14,ax
             pop     ax
             retf
ChangeTEditOn endp
;*************************************************************************
; Procedure CorrectSize
;*************************************************************************
CorrectSize proc    far
            push    eax
            mov     eax,FileSize
            mov     OldFileSize,eax
            pop     eax
            retf
CorrectSize endp
;*************************************************************************
; Procedure SetWrapEn
; Parameters:
;*************************************************************************
SetWrapEn   proc    far
            push    si
            push    di
            push    cx
            push    es

            push    ds
            pop     es
            cld
            lea     si,sWrap
            mov     cx,6
            lea     di,hWrapEn+8
            cmp     WrapLog,1
            jne     swecont
            lea     si,sUnWrap
swecont:    rep     movsb
            pop     es
            pop     cx
            pop     di
            pop     si
            retf
SetWrapEn   endp
;*************************************************************************
; Procedure ChangeChar
; Parameters: al : char
;*************************************************************************
ChangeChar  proc    far
            cmp     al,80h
            jae     chchcont0
            retf

chchcont0:  cmp     bCharSet,0
            jne     chchcont1
            retf

chchcont1:  push    bx
            cmp     bCharSet,1                     ; Windows set
            jne     chchcont2
            lea     bx,Win2Ansi
            jmp     short chchxlat

chchcont2:  cmp     bCharSet,2
            jne     chchcont3
            lea     bx,Koi2Ansi
            jmp     short chchxlat

chchcont3:  cmp     bCharSet,3
            jne     chchcont4
            lea     bx,User2Ansi1
            jmp     short chchxlat

chchcont4:  cmp     bCharSet,4
            jne     chchcont5
            lea     bx,User2Ansi2
            jmp     short chchxlat

chchcont5:  cmp     bCharSet,5
            jne     chchcont6
            lea     bx,User2Ansi3
            jmp     short chchxlat

chchcont6:  cmp     bCharSet,6
            jne     chchexit
            lea     bx,User2Ansi4

chchxlat:   sub     al,80h
            xlat
chchexit:   pop     bx
            retf
ChangeChar  endp
;*************************************************************************
; Procedure ReChgChar
; Parameters: al : char
;*************************************************************************
ReChgChar   proc    far
            cmp     al,80h
            jae     rchccont0
            retf

rchccont0:  cmp     bCharSet,0
            jne     rchccont1
            retf

rchccont1:  push    bx
            cmp     bCharSet,1                     ; Windows set
            jne     rchccont2
            lea     bx,Ansi2Win
            jmp     short rchcxlat

rchccont2:  cmp     bCharSet,2
            jne     rchccont3
            lea     bx,Ansi2Koi
            jmp     short rchcxlat

rchccont3:  cmp     bCharSet,3
            jne     rchccont4
            lea     bx,Ansi2User1
            jmp     short rchcxlat

rchccont4:  cmp     bCharSet,4
            jne     rchccont5
            lea     bx,Ansi2User2
            jmp     short rchcxlat

rchccont5:  cmp     bCharSet,5
            jne     rchccont6
            lea     bx,Ansi2User3
            jmp     short rchcxlat

rchccont6:  cmp     bCharSet,6
            jne     rchcexit
            lea     bx,Ansi2User4

rchcxlat:   sub     al,80h
            xlat
rchcexit:   pop     bx
            retf
ReChgChar   endp
;*************************************************************************
; Procedure NameAnalis
; Parameters:
;            ds:bx - pointer to file name
;*************************************************************************
NameAnalis  proc    far
            push    ebx
            push    edi
            push    ecx
            push    edx
            push    esi
            push    es
            mov     PathFlag,1
            push    ds
            pop     es
            mov     di,bx
            mov     al,0
            mov     cx,127
            cld
            repne   scasb
            mov     dx,di
            mov     cx,di
            sub     cx,bx
            dec     di
            std
            push    di
            push    cx
            push    bx
            mov     bExtFlag,0
            mov     dword ptr bFileExt,0
            mov     cx,6
            mov     al,'.'
            repne   scasb
            cmp     cx,0
            je      nanNext
            mov     bExtFlag,1
            add     di,2
            mov     cx,3
            lea     bx,bFileExt
nanLoop:    mov     al,[di]
            cmp     al,0
            je      nanNext
            mov     [bx],al
            inc     bx
            inc     di
            loop    nanLoop
nanNext:    lea     bx,bFileExt
            Call    StrUpCase
            pop     bx
            pop     cx
            pop     di
            mov     al,'\'
            repne   scasb
            cmp     cx,0
            je      nanexit1
            mov     si,di
            add     si,2
            mov     cx,dx
            sub     cx,si
            mov     di,bx
            cld
            rep     movsb
            jmp     short nanexit
;--- No path found ----------------------------------------------------------
nanexit1:   mov     PathFlag,0
;--- Path parse -------------------------------------------------------------
nanexit:
            cld
            pop     es
            pop     esi
            pop     edx
            pop     ecx
            pop     edi
            pop     ebx
            retf
NameAnalis  endp
;*************************************************************************
; Procedure MakeFileName
;*************************************************************************
MakeFileName proc   far
            cmp     PathFlag,1
            je      mfncont1
            push    cx
            push    es
            push    si
            push    dx

            push    ds
            pop     es
            lea     si,FilePath
            lea     di,FilePath+128
            Call    StrLen
            xor     cx,cx
            mov     cl,al
            inc     cl
            rep     movsb

            mov     ah,19h
            int     21h
            add     al,'A'
            mov     ah,47h

            Lea     si,FilePath
            mov     [si],al
            mov     word ptr [si+1],5C3Ah
            add     si,3
            mov     dl,0
            int     21h
            Lea     di,FilePath
            mov     al,0
            mov     cx,128
            repne   scasb
            cmp     byte ptr [di-2],'\'
            jne     mfncont2
            dec     di
mfncont2:   mov     byte ptr [di-1],'\'
            lea     si,FilePath+128
            Call    StrLen
            xor     cx,cx
            mov     cl,al
            inc     cl
            cld
            rep     movsb
            Lea     cx,FilePath
            add     cx,127
            sub     cx,di
            mov     al,0
            rep     stosb
            lea     bx,FilePath
            Call    StrUpCase

            pop     dx
            pop     si
            pop     es
            pop     cx
            retf

mfncont1:   push    es
            push    bx

            push    ds
            pop     es
            lea     bx,FilePath
            Call    StrUpCase

            pop     bx
            pop     es
            retf
MakeFileName endp
;*************************************************************************
; Procedure AutoScanLF
; Parameters:
;            es:0000 - pointer to buffer
;            EndBuffer - buffer end
;*************************************************************************
AutoScanLF  proc    far
            push    ebx
            push    edi
            push    ecx
            push    edx
            push    esi

            cmp     LFCurPos,6
            jne     aslfupdate
            mov     LFCurPos,0
            mov     lfCRLF,0
            mov     lfCR,0
            mov     lfLF,0
            mov     lfLFCR,0
            mov     lfNULL,0
            xor     si,si
            mov     cx,word ptr EndBuffer
            cmp     cx,5000
            jb      aslfLoop
            mov     cx,5000

aslfLoop:   mov     al,es:[si]
            inc     si
            cmp     si,cx
            jae     aslfCase                          ; LineFeed case
; 0 - CR/LF, 1 - CR, 2 - LF, 3 - NULL, 4 - LF/CR
            cmp     al,0                              ; Null
            je      aslfNull
            cmp     al,13                             ; CR
            je      aslfCR
            cmp     al,10                             ; LF
            je      aslfLF
            jmp     short aslfLoop
;--- CR linefeed ------------------------------------------------------------
aslfCR:     cmp     byte ptr es:[si],10
            je      aslfCRLF
            inc     lfCR
            jmp     short aslfLoop
;--- CR/LF linefeed ---------------------------------------------------------
aslfCRLF:   inc     si
            inc     lfCRLF
            jmp     short aslfLoop
;--- LF linefeed ------------------------------------------------------------
aslfLF:     cmp     byte ptr es:[si],13
            je      aslfLFCR
            inc     lfLF
            jmp     short aslfLoop
;--- LF/CR linefeed ---------------------------------------------------------
aslfLFCR:   inc     si
            inc     lfLFCR
            jmp     short aslfLoop
;--- Null linefeed ----------------------------------------------------------
aslfNull:   inc     lfNULL
            jmp     short aslfLoop
;--- Case LineFeed ----------------------------------------------------------
aslfCase:   mov    ax,lfCRLF
            cmp    ax,lfCR
            jae    aslfCase1
            mov    ax,lfCR
            mov    LFCurPos,1

aslfCase1:  cmp    ax,lfLF
            jae    aslfCase2
            mov    ax,lfLF
            mov    LFCurPos,2

aslfCase2:  cmp    ax,lfNULL
            jae    aslfCase3
            mov    ax,lfNULL
            mov    LFCurPos,3

aslfCase3:  cmp    ax,lfLFCR
            jae    aslfUpdate
            mov    LFCurPos,4
;--- New LineFeed found -----------------------------------------------------
aslfupdate: lea    bx,LFArray
            xor    ax,ax
            mov    al,LFCurPos
            mov    si,ax
            shl    si,1
            add    si,ax
            mov    ax,[bx+si]
            mov    word ptr LFData,ax
            mov    al,[bx+si+2]
            mov    LFLength,al
            cmp     LFCurPos,5
            jne     aslfExit
            mov     WrapLog,0FFh
            mov     bTabOnFlag,0FFh
;--- Exit from rountime -----------------------------------------------------
aslfExit:
            pop     esi
            pop     edx
            pop     ecx
            pop     edi
            pop     ebx
            retf
AutoScanLF  endp
;*************************************************************************
; Procedure ScanCache                           Scan cache for address
; Parameters: ebp       : long address
;             bChar     : writing char
;             bOper     : operation ( 0 -read, 1- read & write )
;             bHexMask  : mask for existing value
;
; Return:     AL        : byte from long address if read Ok
;             CF        : if address not in cache
;*************************************************************************
ScanCache  proc     far
           push     ebp
           push     edx
           push     bx
           push     cx
           push     eax

           mov      eax,ebp
           mov      bx,ax
           and      bx,07F0h                     ; bx - address WrCacheTag
           shr      eax,11                       ; eax - tag 21 bit
           mov      cx,4
sccaLoop:  mov      edx,dword ptr WrCacheTag[bx]
           shl      edx,1                        ; CF - true flag
           jnc      sccaNext
           shr      edx,1                        ; edx - tag 21 bit
           cmp      eax,edx
           je       sccaFound
sccaNext:  add      bx,4
           loop     sccaLoop
           pop      eax
           stc
           jmp      short sccaExit

;--- Found cache string -----------------------------------------------------
sccaFound: shl      bx,2                         ; Cache string address
           and      bp,0Fh                       ; Number of byte in string
           add      bx,bp                        ; add byte offset
           pop      eax
           mov      al,byte ptr WrCacheData[bx]  ; al - byte value
           cmp      bOper,1                      ; Write byte ?
           jne      sccaOk
           mov      bModify,1
           and      al,bHexMask
           or       al,bChar
           mov      byte ptr WrCacheData[bx],al
sccaOk:    clc
sccaExit:  pop      cx
           pop      bx
           pop      edx
           pop      ebp
           mov      bOper,0
           retf
ScanCache  endp
;*************************************************************************
; Procedure   ReadBuffer
; Target:     Read a byte from buffer or cache
; Parameters: fs:si    - pointer in buffer
;             RealOfs  - real offset buffer in file
; Return:     AL       - char
;             CF       if error
;*************************************************************************
ReadBuffer  proc    far
            cmp     si,word ptr EndBuffer
            jae     rdbuAbort
            mov     al,fs:[si]
            cmp     bModify,0
            jne     rdbuBegin
            clc
            retf
rdbuBegin:  push    ebp
            mov     bOper,0
            xor     ebp,ebp
            mov     bp,si
            add     ebp,RealOfs
            Call    ScanCache
            pop     ebp
            clc
            retf
;--- Exit with error --------------------------------------------------------
rdbuAbort:  xor     al,al
            stc
            retf
ReadBuffer  endp
;*************************************************************************
; Procedure GetOutStrLen
; Parameters:
;         es:si - offset to first char for output of string
; Return:    curtmpLineLen - current output string length
;*************************************************************************
GetOutStrLen proc    far
            pushad

            mov     byte ptr TabLeftPos,0
            mov     ax,word ptr LeftPos
            mov     word ptr tmpLeftPos,ax
            mov     curtmpLineLen,0

            xor     bx,bx
            mov     bl,CurY
            shl     bx,1
            mov     si,word ptr curLineLen[bx]
            mov     curtmpLineSI,si
            mov     bx,0100h
            mov     dx,WindowSize
            mov     di,word ptr EndBuffer
            mov     cl,bl

goslcont1:  cmp     si,di
            jae     goslexit
;-- 砥  AL ᫥騩 ᨬ ------------------------------------------
goslcont5:  Call    ReadBuffer                 ; mov al,fs:[si] or cache read
            Call    ChangeChar
            cmp     LFLength,0
            je      goslcont14
;--- ஢ઠ   ப -----------------------------------------------
            cmp     al,LFData
            jne     goslcont14
            cmp     LFLength,1
            je      goslexit

            inc     si
            Call    ReadBuffer                 ; mov al,fs:[si] or cache read
            cmp     al,LFData+1
            je      goslexit
            dec     si
            Call    ReadBuffer                 ; mov al,fs:[si] or cache read
;--- ࠡ⪠ 砫쭮 ய᪠ ᨬ ---------------------------------
goslcont14: cmp     tmpLeftPos,0
            je      goslcont4
            dec     tmpLeftPos
            cmp     bTabONFlag,1
            jne     goslcont14a
            cmp     al,9                       ; Tab ?
            jne     goslcont14a
            cmp     byte ptr TabLeftPos,0
            jne     goslcont14b
            push    cx
            xor     ch,ch
            mov     cl,byte ptr LeftPos
            sub     cl,byte ptr tmpLeftPos
            dec     cl
            and     cl,7
            sub     cl,8
            neg     cl
            mov     TabLeftPos,cl
            pop     cx

goslcont14b: dec     TabLeftPos
            cmp     TabLeftPos,0
            je      goslcont14a
            inc     curtmpLineLen
            jmp     goslcont5

goslcont14a: inc     si
            inc     curtmpLineSI
            inc     curtmpLineLen
            jmp     goslcont5
;-- ࠡ⪠ ᨬ ⠡樨 ---------------------------------------------
goslcont4:  cmp     bTabONFlag,1
            jne     goslcont6
            cmp     al,09h                      ; Tabulaion
            jne     goslcont6

            push    cx
            xor     ch,ch
            mov     cl,bl
            add     cl,byte ptr LeftPos
            and     cl,7
            sub     cl,8
            neg     cl
            mov     al,20h

goslloop5:  cmp     bl,dl
            ja      goslcont11
            cmp     bl,CurX
            jne     goslcont12
            mov     curtmpLinefSI,si
goslcont12: inc     bl
            inc     curtmpLineLen
            loop    goslloop5

goslcont11: pop     cx
            jmp     goslcont3

;-- ஢ઠ ࠭ 뢮 ᫥ -------------------------------------------
goslcont6:  cmp     bl,dl
            jbe     goslcont2
;-- ᥪ ࠭, ஢塞 (Un)Wrap -----------------------------------
            cmp     WrapLog,1
            jne     goslexit
;-- ,   ᨬ 뢥 ----------------------------------------------
goslcont2:  cmp     bl,CurX
            jne     goslcont2a
            mov     curtmpLinefSI,si
goslcont2a: inc     bl
goslcont3:  inc     si                          ; 稢 Symbol pointer
            inc     curtmpLineSI
            inc     curtmpLineLen
            jmp     goslcont1

goslexit:   popad
            retf
GetOutStrLen endp
;*************************************************************************
; Procedure TEditWrByte
; Parameters:
;*************************************************************************
TEditWrByte proc    far
            push    ax
            push    bx
            push    cx
            push    dx

            mov     bx,word ptr Handle
            mov     ax,4200h
            mov     dx,word ptr curtmpLineFPos
            mov     cx,word ptr curtmpLineFPos+2
            int     21h

            mov     ah,40h
            lea     dx,bTEditChar
            mov     cx,1
            int     21h

            pop     dx
            pop     cx
            pop     bx
            pop     ax
            retf
TEditWrByte endp
;****************************************************************************
; Procedure InitMouse
;****************************************************************************
InitMouse   proc    far
            push    ax
            push    bx
            xor     ax,ax
            int     33h
            mov     wMousePresent,ax                     ; 0FFFFh if present
            pop     bx
            pop     ax
            retf
InitMouse   endp
;****************************************************************************
; Procedure MouseSet
; Parameters: bh - Y
;             bl - X
;****************************************************************************
MouseSet    proc    far
            cmp     wMousePresent,0FFFFh
            je      MouSeBeg
            retf
MouSeBeg:   push    ax
            push    cx
            push    dx
            mov     ax,4
            xor     cx,cx
            xor     dx,dx
            mov     cl,bl
            mov     dl,bh
            int     33h
            pop     dx
            pop     cx
            pop     ax
            retf
MouseSet    endp
;****************************************************************************
; Procedure MouseOn
;****************************************************************************
MouseOn     proc    far
            cmp     wMousePresent,0FFFFh
            je      MouOnBeg
            retf
MouOnBeg:   push    ax
            mov     ax,1
            int     33h
            pop     ax
            retf
MouseOn     endp
;****************************************************************************
; Procedure MouseOff
;****************************************************************************
MouseOff    proc    far
            cmp     wMousePresent,0FFFFh
            je      MouOffBeg
            retf
MouOffBeg:  push    ax
            mov     ax,2
            int     33h
            pop     ax
            retf
MouseOff    endp
;****************************************************************************
; Procedure MouseRead(var xx,yy,status:integer)
; Return:     wMouseX  - X
;             wMouseY  - Y
;             wMouseLB =1 if left button pressed
;             wMouseRB =1 if right button pressed
;****************************************************************************
MouseRead   proc    far
            cmp     wMousePresent,0FFFFh
            je      MouRdBeg
            retf
MouRdBeg:   push    ax
            push    bx
            push    cx
            push    dx
            mov     ax,3
            int     33h
            shr     cx,3
            shr     dx,3
            mov     wMouseX,cx
            mov     wMouseY,dx
            mov     wMouseLB,bx
            mov     wMouseRB,bx
            and     wMouseLB,1
            and     wMouseRB,2
            shr     wMouseRB,1
            mov     ax,wMouseLB
            or      ax,wMouseRB
            mov     wMousePress,ax
            pop     dx
            pop     cx
            pop     bx
            pop     ax
            retf
MouseRead   endp
;****************************************************************************
; Procedure MouseGetRelease(var xx,yy,status:integer)
; Return:     wMouseReleaseX  - X
;             wMouseReleaseY  - Y
;             wMouseReleaseCounter - counter
;****************************************************************************
MouseGetRelease     proc    far
                    cmp     wMousePresent,0FFFFh
                    je      MouGRBeg
                    retf
MouGRBeg:           push    ax
                    push    bx
                    push    cx
                    push    dx
                    mov     ax,6
                    xor     bx,bx
                    int     33h
                    shr     cx,3
                    shr     dx,3
                    mov     wMouseReleaseX,cx
                    mov     wMouseReleaseY,dx
                    mov     wMouseReleaseCounter,bx
                    pop     dx
                    pop     cx
                    pop     bx
                    pop     ax
                    retf
MouseGetRelease     endp
;****************************************************************************
; Procedure MouseXY(xx,yy:integer)
; Parameters: wMouseX - X
;             wMouseY - Y
;****************************************************************************
MouseXY     proc    far
            cmp     wMousePresent,0FFFFh
            je      MouXYBeg
            retf
MouXYBeg:   push    ax
            push    cx
            push    dx
            mov     cx,wMouseX
            mov     dx,wMouseY
            mov     ax,4
            int     33h
            pop     dx
            pop     cx
            pop     ax
            retf
MouseXY     endp
;****************************************************************************
; Procedure MouseSetBox
; Parameters: wMouseBox  structure  xx,yy,xx1,yy1:word
;****************************************************************************
MouseSetBox proc    far
            cmp     wMousePresent,0FFFFh
            je      MouSBBeg
            retf
MouSBBeg:   push    ax
            push    cx
            push    dx
            mov     cx,word ptr wMouseBox
            mov     dx,word ptr wMouseBox+4
            mov     ax,7
            int     33h
            mov     cx,word ptr wMouseBox+2
            mov     dx,word ptr wMouseBox+6
            mov     ax,8
            int     33h
            pop     dx
            pop     cx
            pop     ax
            retf
MouseSetBox endp
;****************************************************************************
; Procedure MouseInBox
; Parameters: wMouseInBox  structure  xx,yy,xx1,yy1:byte
; Return:     CF - if not in Box
;****************************************************************************
MouseInBox  proc    far
            push    ax
            push    bx
            push    dx
            mov     bx,word ptr wMouseInBox
            mov     dx,word ptr wMouseInBox+2
            mov     ax,wMouseX
            cmp     al,bl
            jb      MouIBAbort
            cmp     al,dl
            ja      MouIBAbort
            mov     ax,wMouseY
            cmp     al,bh
            jb      MouIBAbort
            cmp     al,dh
            ja      MouIBAbort
MouIBNorm:  clc
            jmp     short MouIBExit
MouIBAbort: stc
MouIBExit:  pop     dx
            pop     bx
            pop     ax
            retf
MouseInBox  endp
;****************************************************************************
;Procedure  PEFieldOut
;           es:si - end of buffer
;           eax   - value
;****************************************************************************
PEFieldOut    proc    far
              cmp     eax,0
              jne     pefoBegin
              push    si
              push    di
              push    cx
              mov     cx,8
              cld
              lea     di,sPENotUsed
              sub     si,7
              xchg    si,di
              rep     movsb
              pop     cx
              pop     di
              pop     si
              retf
pefoBegin:    Call    HexToStr
              retf
PEFieldOut    endp
;****************************************************************************
;Procedure  PEGetPhysOffs
;Parameters: di - real field number from object table
;****************************************************************************
PEGetPhysOffs proc    far
              mov     ax,di
              shl     di,5
              shl     ax,3
              add     di,ax
              add     di,20
              mov     eax,dword ptr es:[di]
              retf
PEGetPhysOffs endp
;****************************************************************************
;Procedure  NEGetPhysOffs
;Parameters: di - real field number from object table
;****************************************************************************
NEGetPhysOffs proc    far
              shl     di,3
              xor     eax,eax
              mov     ax,word ptr es:[di]
              push    cx
              mov     cl,bHdrAlign
              shl     eax,cl
              pop     cx
              retf
NEGetPhysOffs endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure InitHistFile
; Parameters:
;              hsRecSize - size of history record
; Return:
;              CF - error
;۲۲۲۲۲۲۲۲۲۲۲۲۲
InitHistFile   proc    far
               push    ax
               push    bx
               push    cx
               push    dx
               push    si
               push    di
               push    es
               push    ds

               cld
               push    ds
               pop     es

               cmp     bAutoHis,1                   ; Use history file ?
               jne     ihfiAbandon

               lea     si,QViewPath
               lea     bx,phsPath
ihfiCreate:    lodsb
               mov     [bx],al
               inc     bx
               cmp     al,0
               jne     ihfiCreate
               sub     bx,4
               cmp     word ptr hsRecSize,256
               jne     ihfiCont0
               mov     byte ptr [bx],'H'
               mov     byte ptr [bx+1],'I'
               mov     byte ptr [bx+2],'S'
               mov     hsCmpType,0                     ; 64 symbols compare
               jmp     short ihfiOpen

ihfiCont0:     mov     hsCmpType,1                     ; Str[0] - char counter
               mov     byte ptr [bx],'S'
               mov     byte ptr [bx+1],'R'
               cmp     word ptr hsRecSize,21
               jne     ihfiCont1
               mov     byte ptr [bx+2],'H'
               jmp     short ihfiOpen
ihfiCont1:     mov     byte ptr [bx+2],'A'
               cmp     word ptr hsRecSize,51
               je      ihfiOpen
               mov     byte ptr [bx+2],'J'
;--- Open history file ------------------------------------------------------
ihfiOpen:      lea     dx,phsPath
               mov     ax,3D42h
               int     21h
               jnc     ihfiCont2

               xor     cx,cx
               lea     dx,phsPath
               mov     ah,3Ch
               int     21h
               jc      ihfiAbandon

ihfiCont2:     mov     bx,ax
               mov     ax,4202h
               xor     cx,cx
               xor     dx,dx
               int     21h
               mov     word ptr hsFileSize,ax     ; DX:AX - file size
               mov     word ptr hsFileSize+2,dx

               mov     ah,3Eh
               int     21h
               jmp     ihfiNormal
;--- Abandon exit -----------------------------------------------------------
ihfiAbandon:   stc
               jmp     short ihfiExit
;--- Normal exit ------------------------------------------------------------
ihfiNormal:    clc
ihfiExit:      pop     ds
               pop     es
               pop     di
               pop     si
               pop     dx
               pop     cx
               pop     bx
               pop     ax
               retf
InitHistFile   endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure CheckHistRec
; Parameters:
;              phsPath   - path to history file
;              hsRecSize - size of history record
;              hsBufOfs  - offset to history record
; Return:
;              CF - record not found
;۲۲۲۲۲۲۲۲۲۲۲۲۲
CheckHistRec   proc    far
               push    ax
               push    bx
               push    cx
               push    dx
               push    si
               push    di
               push    es
               push    ds

               cld
               push    ds
               pop     es

               cmp     bAutoHis,1                   ; Use history file ?
               jne     chreAbandon
;--- Open history file ------------------------------------------------------
               xor     ecx,ecx
               lea     dx,phsPath
               mov     ax,3D42h
               int     21h
               jc      chreAbandon
               mov     bhsHandle,ax
               mov     dword ptr hsFilePos,0
               xor     ecx,ecx

chreLoop:      mov     bx,bhsHandle
               mov     ah,3Fh
               mov     cx,word ptr hsRecSize
               add     hsFilePos,ecx
               lea     dx,hsBuffer
               int     21h
               cmp     ax,hsRecSize
               jne     chreFileExit
               lea     si,hsBuffer
               mov     di,hsBufOfs
               mov     ah,[si]
               cmp     ah,[di]
               jne     chreLoop
               cmp     hsCmpType,0
               jne     chreCmpType1
               mov     cx,64
               jmp     short chreCmpBegin

chreCmpType1:  movzx   cx,byte ptr [si]
chreCmpBegin:  repe    cmpsb
               cmp     cx,0
               je      chreNormal
               jmp     chreLoop
;--- Abandon exit -----------------------------------------------------------
chreFileExit:  mov     bx,bhsHandle
               mov     ah,3Eh
               int     21h
chreAbandon:   stc
               jmp     short chreExit
;--- Normal exit ------------------------------------------------------------
chreNormal:    mov     bx,bhsHandle
               mov     ah,3Eh
               int     21h
               clc
chreExit:      pop     ds
               pop     es
               pop     di
               pop     si
               pop     dx
               pop     cx
               pop     bx
               pop     ax
               retf
CheckHistRec   endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure StoreHistStr
; Parameters:
;              phsPath   - path to history file
;              hsRecSize - size of history record
;              hsBufOfs  - offset to history record
;۲۲۲۲۲۲۲۲۲۲۲۲۲
StoreHistStr   proc    far
               pushad
               push    es
               push    ds

               cld
               push    ds
               pop     es

               cmp     bAutoHis,1                   ; Use history file ?
               jne     shstAbandon
;--- Find string in history file --------------------------------------------
               mov     byte ptr hsRecExist,0
               Call    CheckHistRec
               jc      shstNewRec                   ; String already exist
;--- Move record to top file ------------------------------------------------
               mov     eax,dword ptr hsRecSize
               sub     hsFilePos,eax
               mov     byte ptr hsRecExist,1
               cmp     hsRecSize,256
               je      shstNewRec
               cmp     dword ptr hsFilePos,0
               je      shstNormal
;--- Open history file ------------------------------------------------------
shstNewRec:    xor     cx,cx
               lea     dx,phsPath
               mov     ax,3D42h
               int     21h
               jc      shstAbandon
               mov     bhsHandle,ax
;--- Shift record of history file -------------------------------------------
               cmp     byte ptr hsRecExist,1
               je      shstLoop
               mov     bx,ax
               mov     ax,4202h
               xor     cx,cx
               xor     dx,dx
               int     21h
               mov     word ptr hsFilePos,ax     ; DX:AX - file size
               mov     word ptr hsFilePos+2,dx

shstLoop:      cmp     dword ptr hsFilePos,0
               je      shstSave
               xor     eax,eax
               mov     ax,word ptr hsRecSize
               sub     dword ptr hsFilePos,eax
               mov     bx,bhsHandle
               mov     ax,4200h
               mov     dx,word ptr hsFilePos
               mov     cx,word ptr hsFilePos+2
               int     21h
               mov     ah,3Fh
               mov     cx,word ptr hsRecSize
               lea     dx,hsBuffer
               int     21h
               mov     ah,40h
               mov     cx,word ptr hsRecSize
               lea     dx,hsBuffer
               int     21h
               jmp     shstLoop
;--- Save record to history file --------------------------------------------
shstSave:      mov     bx,bhsHandle                 ; Seek to begin file
               mov     ax,4200h
               xor     dx,dx
               xor     cx,cx
               int     21h

               mov     ah,40h
               mov     cx,word ptr hsRecSize
               mov     dx,hsBufOfs                  ; String offset
               int     21h

               xor     eax,eax
               mov     ax,hsRecSize
               shl     eax,5
               cmp     eax,hsFileSize
               jae     shstClose
               mov     hsFilePos,eax

               mov     ax,4200h
               mov     dx,word ptr hsFilePos
               mov     cx,word ptr hsFilePos+2
               int     21h

               mov     ah,40h
               xor     cx,cx
               mov     dx,hsBufOfs                  ; String offset
               int     21h

shstClose:     mov     ah,3Eh
               int     21h
               jmp     shstNormal                   ; Normal exit

;--- Abandon exit -----------------------------------------------------------
shstAbandon:   stc
               jmp     short shstExit
;--- Normal exit ------------------------------------------------------------
shstNormal:    clc
shstExit:      pop     ds
               pop     es
               popad
               retf
StoreHistStr   endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure NextHistFile
; Parameters:
;             hsFileLevel - level of file
;۲۲۲۲۲۲۲۲۲۲۲۲۲
NextHistFile   proc    far
               push    eax
               push    ecx
               mov     cx,hsFileLevel
               inc     cx
               xor     eax,eax
nehfLoop:      add     eax,dword ptr hsRecSize
               loop    nehfLoop
               cmp     eax,dword ptr hsFileSize
               jae     nehfExit
               inc     hsFileLevel
               mov     word ptr hsBufOfs,offset hsBuffer
               mov     hsFilePos,eax
               Call    LoadHistStr

               push    di
               push    si
               push    es
               mov     es,PSPValue
               lea     si,hsBuffer
               mov     di,81h
               mov     byte ptr es:[di-1],64
               mov     cx,64
               cld
               rep     movsb
               xor     al,al
               mov     cx,64
               mov     di,81h
               repnz   scasb
               mov     byte ptr es:[di-1],0Dh
               pop     es
               pop     si
               pop     di
               clc
               jmp     short nehfExit1
nehfExit:      stc
nehfExit1:     pop     eax
               pop     ecx
               retf
NextHistFile   endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure LoadHistStr
; Parameters:
;              phsPath   - path to history file
;              hsRecSize - size of history record
;              hsBufOfs  - offset to history record
;              hsFilePos - position in file
;۲۲۲۲۲۲۲۲۲۲۲۲۲
LoadHistStr    proc    far
               push    ax
               push    bx
               push    cx
               push    dx
               push    si
               push    di
               push    es
               push    ds

               cld
               push    ds
               pop     es

               cmp     bAutoHis,1                   ; Use history file ?
               jne     lhstAbandon
;--- Open history file ------------------------------------------------------
               lea     dx,phsPath
               mov     ax,3D42h
               int     21h
               jc      lhstAbandon
;--- Shift record of history file -------------------------------------------
               mov     bhsHandle,ax
               mov     bx,ax
               mov     ax,4200h
               mov     dx,word ptr hsFilePos
               mov     cx,word ptr hsFilePos+2
               int     21h

               mov     ah,3Fh
               mov     cx,word ptr hsRecSize
               mov     dx,hsBufOfs
               int     21h
               cmp     ax,hsRecSize
               jne     lhstAbandon

               mov     ah,3Eh
               int     21h
               jmp     lhstNormal                   ; Normal exit

;--- Abandon exit -----------------------------------------------------------
lhstAbandon:   stc
               jmp     short lhstExit
;--- Normal exit ------------------------------------------------------------
lhstNormal:    clc
lhstExit:      pop     ds
               pop     es
               pop     di
               pop     si
               pop     dx
               pop     cx
               pop     bx
               pop     ax
               retf
LoadHistStr    endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure DeleteHist
; Parameters:
;              phsPath   - path to history file
;              hsRecSize - size of history record
;              hsFilePos - position in file
;۲۲۲۲۲۲۲۲۲۲۲۲۲
DeleteHist     proc    far
               push    eax
               push    bx
               push    cx
               push    dx
               push    si
               push    di
               push    es
               push    ds

               cld
               push    ds
               pop     es

               cmp     bAutoHis,1                   ; Use history file ?
               jne     dehsAbandon
               mov     eax,dword ptr hsFilePos
               cmp     hsRecNum,0
               je      dehsNext
               xor     cx,cx
               mov     cl,hsRecNum
dehsFilePos:   add     eax,dword ptr hsRecSize
               loop    dehsFilePos
dehsNext:      mov     hsDstFilePos,eax
               add     eax,dword ptr hsRecSize
               mov     hsSrcFilePos,eax
;--- Open history file ------------------------------------------------------
               lea     dx,phsPath
               mov     ax,3D42h
               int     21h
               jc      dehsAbandon
               mov     bhsHandle,ax
;--- Shift record of history file -------------------------------------------

dehsLoop:      mov     bx,word ptr bhsHandle         ; Read source record
               mov     ax,4200h
               mov     dx,word ptr hsSrcFilePos
               mov     cx,word ptr hsSrcFilePos+2
               int     21h

               mov     ah,3Fh
               mov     cx,word ptr hsRecSize
               lea     dx,hsBuffer
               int     21h
               cmp     ax,hsRecSize
               jne     dehsTrunc

               mov     bx,word ptr bhsHandle         ; Save destination record
               mov     ax,4200h
               mov     dx,word ptr hsDstFilePos
               mov     cx,word ptr hsDstFilePos+2
               int     21h

               mov     ah,40h
               mov     cx,word ptr hsRecSize
               lea     dx,hsBuffer
               int     21h
               mov     eax,dword ptr hsRecSize
               add     hsSrcFilePos,eax
               add     hsDstFilePos,eax
               xor     eax,eax
               jmp     dehsLoop

dehsTrunc:     mov     bx,word ptr bhsHandle         ; Truncate history file
               mov     ax,4200h
               mov     dx,word ptr hsDstFilePos
               mov     cx,word ptr hsDstFilePos+2
               int     21h

               mov     ah,40h
               xor     cx,cx
               lea     dx,hsBuffer
               int     21h
               mov     eax,dword ptr hsDstFilePos
               mov     hsFileSize,eax
               mov     ah,3Eh
               int     21h
               jmp     dehsNormal                   ; Normal exit

;--- Abandon exit -----------------------------------------------------------
dehsAbandon:   stc
               jmp     short dehsExit
;--- Normal exit ------------------------------------------------------------
dehsNormal:    clc
dehsExit:      pop     ds
               pop     es
               pop     di
               pop     si
               pop     dx
               pop     cx
               pop     bx
               pop     eax
               retf
DeleteHist     endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure ClearHist
; Parameters:
;              phsPath   - path to history file
;۲۲۲۲۲۲۲۲۲۲۲۲۲
ClearHist      proc    far
               push    eax
               push    bx
               push    cx
               push    dx
               push    si
               push    di
               push    es
               push    ds

               cld
               push    ds
               pop     es

               cmp     bAutoHis,1                   ; Use history file ?
               jne     clhsAbandon
;--- Open history file ------------------------------------------------------
               lea     dx,phsPath
               mov     ax,3D42h
               int     21h
               jc      clhsAbandon
               mov     bhsHandle,ax
;--- Clear all records ------------------------------------------------------
               mov     bx,word ptr bhsHandle         ; Truncate history file
               mov     ax,4200h
               xor     dx,dx
               xor     cx,cx
               int     21h

               mov     bx,word ptr bhsHandle
               mov     ah,40h
               xor     cx,cx
               lea     dx,hsBuffer
               int     21h

               mov     ah,3Eh
               int     21h
               jmp     clhsNormal                   ; Normal exit
;--- Abandon exit -----------------------------------------------------------
clhsAbandon:   stc
               jmp     short clhsExit
;--- Normal exit ------------------------------------------------------------
clhsNormal:    clc
clhsExit:      pop     ds
               pop     es
               pop     di
               pop     si
               pop     dx
               pop     cx
               pop     bx
               pop     eax
               retf
ClearHist      endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure GetExtFileParm
; Return:
;              CF - error
;۲۲۲۲۲۲۲۲۲۲۲۲۲
GetExtFileParm proc    far
               pushad
               push    es
               push    ds

               cld
               push    ds
               pop     es
               lea     di,AsmBuffer+11
               mov     cx,17
               xor     al,al
               rep     stosb

               lea     si,QViewPath
               lea     bx,phsPath
gefpCreate:    lodsb
               mov     [bx],al
               inc     bx
               cmp     al,0
               jne     gefpCreate

               sub     bx,4
               mov     byte ptr [bx],'E'
               mov     byte ptr [bx+1],'H'
               mov     byte ptr [bx+2],'L'
;--- Open history file ------------------------------------------------------
               xor     ecx,ecx
               lea     dx,phsPath
               mov     ax,3D40h
               int     21h
               jc      gefpAbandon
               mov     bhsHandle,ax
               mov     dword ptr hsFilePos,0
               xor     ecx,ecx

gefpLoop:      mov     bx,bhsHandle
               mov     ah,3Fh
               mov     cx,48
               add     hsFilePos,ecx
               lea     dx,AsmBuffer
               int     21h
               cmp     ax,48
               jne     gefpFileExit
               mov     eax,dword ptr AsmBuffer
               cmp     eax,dword ptr bFileExt
               je      gefpNormal
               jmp     gefpLoop
;--- Abandon exit -----------------------------------------------------------
gefpFileExit:  mov     bx,bhsHandle
               mov     ah,3Eh
               int     21h
gefpAbandon:   stc
               jmp     short gefpExit
;--- Normal exit ------------------------------------------------------------
gefpNormal:    mov     bx,bhsHandle
               mov     ah,3Eh
               int     21h
               mov     al,AsmBuffer+4
               mov     OutMode,al
               mov     al,AsmBuffer+5
               mov     WrapLog,al
               mov     al,AsmBuffer+6
               mov     LFCurPos,al
               mov     al,AsmBuffer+7
               mov     bCharSet,al
               mov     al,AsmBuffer+8
               mov     bEditEnable,al
               mov     al,AsmBuffer+9
               mov     bTabOnFlag,al
               mov     al,AsmBuffer+10
               mov     btvHighOn,al
               cld
               lea     si,AsmBuffer+11
               lea     di,btvComDigit
               mov     cx,22
               rep     movsb
               clc
;--- Exit -------------------------------------------------------------------
gefpExit:      pop     ds
               pop     es
               popad
               retf
GetExtFileParm endp
;*************************************************************************
; Procedure HistoryScan
; Parameters:
;*************************************************************************
HistoryScan    proc    far
               push    ax
               push    bx
               push    cx
               push    dx
               push    si
               push    di
               push    es
               push    ds
               cld
               push    ds
               pop     es

               cmp     bAutoHis,1                   ; Use history file ?
               jne     hiscNoFile

               lea     dx,QViewPath
               mov     ax,3D40h
               int     21h
               jc      hiscNoFile

               mov     HistHandle,ax
               mov     dword ptr HistPointer,0
               mov     HistFileFlg,1
               mov     HistDataFlg,1
               mov     dword ptr HistPointer,0

hiscLoop:      mov     bx,HistHandle
               mov     ah,3Fh
               mov     cx,256                       ; Size of QVIEW.HIS record
               lea     dx,HistBuffer
               int     21h
               jnc     hisccont1

hiscError:     mov     ah,3Eh
               mov     bx,HistHandle
               int     21h
               jmp     hiscAbandon

hisccont1:     cmp     ax,256
               jb      hiscError
               mov     cx,64                    ; Size of header .INI
               lea     si,HistBuffer
               lea     di,FilePath
               repe    cmpsb
               cmp     cx,0
               je      hiscFound
               add     dword ptr HistPointer,256
               jmp     hiscLoop                 ; Not viewed file

;--- Found viewed file history record --------------------------------------
hiscFound:     mov     ah,3Eh
               mov     bx,HistHandle
               int     21h
               mov     eax,dword ptr HistBuffer[64]    ; FileSize
               cmp     eax,dword ptr FileSize
               ja      hiscFound1

               mov     eax,dword ptr HistBuffer[64+4]  ; RealOfs
               mov     RealOfs,eax
               mov     ax,word ptr HistBuffer[64+8]    ; CurrentSI
               mov     HistSI,ax

hiscFound1:    mov     al,byte ptr HistBuffer[64+10]   ; LFCurPos
               mov     LFCurPos,al
               mov     ax,word ptr HistBuffer[64+11]   ; LFData
               mov     word ptr LFData,ax
               mov     al,byte ptr HistBuffer[64+13]   ; LFLength
               mov     byte ptr LFLength,al
               mov     al,byte ptr HistBuffer[64+14]   ; bCharSet
               mov     byte ptr bCharSet,al
               cmp     byte ptr fOutMode,0FFh          ; Keys Override ?
               jne     hiscFound2

               mov     al,byte ptr HistBuffer[64+15]   ; OutMode
               mov     OutMode,al

hiscFound2:    mov     al,byte ptr HistBuffer[64+16]   ; WrapLog
               mov     WrapLog,al
               mov     al,byte ptr HistBuffer[64+17]   ; SearchOpt
               mov     SearchOpt,al
               mov     al,byte ptr HistBuffer[64+18]   ; bTabOnFlag
               mov     bTabOnFlag,al
               mov     al,byte ptr HistBuffer[64+19]   ; SegSize
               mov     SegSize,al
               mov     al,byte ptr HistBuffer[64+20]   ; bStepValue
               mov     bStepValue,al
               mov     al,byte ptr HistBuffer[64+21]   ; bAreaValue
               mov     bAreaValue,al
               mov     al,byte ptr HistBuffer[64+22]   ; bOffsValue
               mov     bOffsValue,al
               mov     al,byte ptr HistBuffer[64+23]   ; bTypeValue
               mov     bTypeValue,al
               push    ds
               pop     es
               lea     si,HistBuffer+64+24             ; BookMarks
               lea     di,BookMarkTxt
               mov     cx,168                          ; 3 books 26*2*3 bytes
               rep     movsb
               jmp     hiscNormal
;--- History file not found -------------------------------------------------
hiscNoFile:    mov     HistFileFlg,0
;--- Abandon exit -----------------------------------------------------------
hiscAbandon:   mov     HistDataFlg,0                ; Data not found
               mov     dword ptr HistPointer,0
               stc
               jmp     short hiscExit
;--- Normal exit ------------------------------------------------------------
hiscNormal:    clc
hiscExit:      pop     ds
               pop     es
               pop     di
               pop     si
               pop     dx
               pop     cx
               pop     bx
               pop     ax
               retf
HistoryScan    endp
;*************************************************************************
; Procedure HistorySave
; Parameters:
;*************************************************************************
HistorySave    proc    far
               pushad

               cmp     bAutoHis,1                   ; Use history file ?
               jne     hisaAbandon
;--- Make history record ---------------------------------------------------
               cld
               xor     edi,edi
               lea     esi,FilePath                    ; File path
               mov     ecx,64                          ; 3 books 26*2*3 bytes
               cmp     bDOS7FileName,1
               jne     hisaNoLong
               mov     byte ptr es:[di],22h
               inc     di
hisaNoLong:    rep     movsb
               cmp     bDOS7FileName,1
               jne     hisaNoLong1
               xor     di,di                     ; es:di -> Enviroment area
               xor     al,al
               mov     cx,64
               repnz   scasb
               mov     word ptr es:[di-1],0022h
hisaNoLong1:   mov     eax,dword ptr FileSize
               mov     dword ptr es:[64],eax    ; FileSize
               mov     eax,RealOfs
               mov     dword ptr es:[64+4],eax  ; RealOfs
               mov     ax,HistSI
               mov     word ptr es:[64+8],ax    ; CurrentSI
               mov     al,LFCurPos
               mov     byte ptr es:[64+10],al   ; LFCurPos
               mov     ax,word ptr LFData
               mov     word ptr es:[64+11],ax   ; LFData
               mov     al,byte ptr LFLength
               mov     byte ptr es:[64+13],al   ; LFLength
               mov     al,byte ptr bCharSet
               mov     byte ptr es:[64+14],al   ; LFLength
               mov     al,OutMode
               mov     byte ptr es:[64+15],al   ; OutMode
               mov     al,WrapLog
               mov     byte ptr es:[64+16],al   ; WrapLog
               mov     al,SearchOpt
               mov     byte ptr es:[64+17],al   ; SearchOpt
               mov     al,bTabOnFlag
               mov     byte ptr es:[64+18],al   ; bTabOnFlag
               mov     al,SegSize
               mov     byte ptr es:[64+19],al   ; SegSize
               mov     al,bStepValue
               mov     byte ptr es:[64+20],al   ; bStepValue
               mov     al,bAreaValue
               mov     byte ptr es:[64+21],al   ; bAreaValue
               mov     al,bOffsValue
               mov     byte ptr es:[64+22],al   ; bOffsValue
               mov     al,bTypeValue
               mov     byte ptr es:[64+23],al   ; bTypeValue
               mov     di,64+24                 ; BookMarks
               lea     esi,BookMarkTxt
               mov     ecx,168                  ; 3 books 26*2*3 bytes
               rep     movsb
;--- Store record to history file -------------------------------------------
               mov     hsRecSize,256
               Call    InitHistFile
               jc      hisaAbandon
               xor     cx,cx
               lea     dx,phsPath
               mov     ax,3D42h
               int     21h
               jc      hisaAbandon
               mov     bhsHandle,ax
               cmp     dword ptr hsFileSize,0
               je      hisaSave
;--- Load history file ------------------------------------------------------
               mov     bx,bhsHandle
               mov     ax,4200h
               xor     cx,cx
               xor     dx,dx
               int     21h
               mov     ah,3Fh
               mov     cx,word ptr hsFileSize
               mov     dx,256
               push    ds
               push    es
               pop     ds
               int     21h
               pop     ds
;--- Seek a target record ---------------------------------------------------
               mov     hsFilePos,0
hisaLoop:      add     hsFilePos,256
               mov     ax,word ptr hsFileSize
               cmp     word ptr hsFilePos,ax
               ja      hisaSave
               mov     si,word ptr hsFilePos
               xor     di,di
               mov     cx,64
               push    ds
               push    es
               pop     ds
               repe    cmpsb
               pop     ds
               cmp     cx,0
               je      hisaPack
               jmp     hisaLoop
;--- Pack a history file ----------------------------------------------------
hisaPack:      mov     di,word ptr hsFilePos
               mov     si,di
               add     si,256
               cmp     si,word ptr hsFileSize
               ja      hisaStore
               mov     cx,word ptr hsFileSize
               sub     cx,si
               push    ds
               push    es
               pop     ds
               rep     movsb
               pop     ds
               jmp     hisaStore
;--- Save a history file ----------------------------------------------------
hisaSave:      add     hsFileSize,256
               cmp     hsFileSize,8192
               jbe     hisaStore
               mov     hsFileSize,8192
hisaStore:     mov     bx,bhsHandle
               mov     ax,4200h
               xor     dx,dx
               xor     cx,cx
               int     21h
               mov     ah,40h
               mov     cx,word ptr hsFileSize
               xor     dx,dx
               push    ds
               push    es
               pop     ds
               int     21h
               pop     ds
               cmp     hsFileSize,8192
               jb      hisaClose
               mov     ax,4200h
               xor     cx,cx
               mov     dx,8192
               int     21h
               mov     ah,40h
               xor     cx,cx
               int     21h
hisaClose:     mov     ah,3Eh
               int     21h
               jnc     hisaNormal
;--- Abandon exit -----------------------------------------------------------
hisaAbandon:   stc
               jmp     short hisaExit
;--- Normal exit ------------------------------------------------------------
hisaNormal:    clc
hisaExit:      popad
               retf
HistorySave    endp
;*************************************************************************
; Procedure PrevHistFile
; Parameters:
;*************************************************************************
PrevHistFile   proc    far
               pushad

               cmp     bAutoHis,1                   ; Use history file ?
               jne     prhfAbandon

               cmp     hsFileLevel,0
               je      prhfAbandon

;--- Get record from history file -------------------------------------------
               mov     hsRecSize,256
               Call    InitHistFile
               jc      prhfAbandon

               xor     cx,cx
               lea     dx,phsPath
               mov     ax,3D42h
               int     21h
               jc      prhfAbandon

               mov     bhsHandle,ax
               cmp     dword ptr hsFileSize,0
               jne     prhfLoad
               mov     bx,bhsHandle
               mov     ah,3Eh
               int     21h
               jmp     prhfAbandon

;--- Load history file ------------------------------------------------------
prhfLoad:      mov     bx,bhsHandle
               mov     ax,4200h
               xor     cx,cx
               xor     dx,dx
               int     21h

               mov     ah,3Fh
               mov     cx,word ptr hsFileSize
               mov     dx,256
               push    ds
               push    es
               pop     ds
               int     21h
               pop     ds

;--- Swap a target record ---------------------------------------------------
               push    ds
               push    es
               pop     ds
               mov     si,256
               mov     di,0
               mov     cx,256
               cld
               rep     movsb
               pop     ds

               mov     ch,byte ptr hsFileLevel
               xor     cl,cl
               mov     si,512
               mov     di,256
               push    ds
               push    es
               pop     ds
               rep     movsb
               xor     si,si
               mov     cx,256
               rep     movsb
               pop     ds

;--- Save a history file ----------------------------------------------------
prhfStore:     mov     bx,bhsHandle
               mov     ax,4200h
               xor     dx,dx
               xor     cx,cx
               int     21h

               mov     ah,40h
               mov     cx,word ptr hsFileSize
               mov     dx,256
               push    ds
               push    es
               pop     ds
               int     21h
               pop     ds

               mov     ah,3Eh
               int     21h

               push    es
               push    ds

               push    es
               push    PSPValue
               pop     es
               pop     ds

               mov     si,256
               mov     di,81h
               mov     byte ptr es:[di-1],64
               mov     cx,64
               cld
               rep     movsb
               xor     al,al
               mov     cx,64
               mov     di,81h
               repnz   scasb
               mov     byte ptr es:[di-1],0Dh

               pop     ds
               pop     es
               dec     hsFileLevel
               jmp     prhfNormal
;--- Abandon exit -----------------------------------------------------------
prhfAbandon:   stc
               jmp     short prhfExit
;--- Normal exit ------------------------------------------------------------
prhfNormal:    clc
prhfExit:      popad
               pushf
               Call    FileLoad
               popf
               retf
PrevHistFile   endp
;*************************************************************************
; Procedure AnalisComLine
;*************************************************************************
AnalisComLine   proc    far
                pushad
                push    es
                mov     ax,PSPValue
                mov     tmpNameFlag,0
                mov     es,ax
                mov     btmpViewDevice,0
                cmp     dword ptr es:[81h],4F4D454Dh      ; Memory ?
                jne     ancomlineBeg
                cmp     dword ptr es:[85h],31205952h
                jne     ancomlineBeg
                cmp     word ptr es:[89h],424Dh
                je      anRealBegin

ancomlineBeg:   cmp     dword ptr es:[81h],56495244h      ; Logical drive ?
                jne     ancomlineBeg1
                cmp     word ptr es:[85h],2045h
                jne     ancomlineBeg1
                mov     btmpViewDevice,2              ; Drive view
                cmp     byte ptr es:[88h],':'
                jne     anErrComLine
                mov     al,byte ptr es:[87h]
                cmp     al,41h
                jb      anErrComLine
                cmp     al,5Ah
                ja      anErrComLine
                jmp     anRealBegin

ancomlineBeg1:  cmp     dword ptr es:[81h],504F4C46h    ; FDD ?
                jne     ancomlineBeg2
                cmp     dword ptr es:[85h],44205950h
                jne     ancomlineBeg2
                cmp     dword ptr es:[89h],204B5349h
                jne     ancomlineBeg2
                mov     btmpViewDevice,3              ; Physical drive
                mov     al,byte ptr es:[8Dh]
                sub     al,30h
                mov     byte ptr es:[8Eh],0
                jmp     anRealBegin

ancomlineBeg2:  cmp     dword ptr es:[81h],44524148h    ; HDD ?
                jne     ancomlineBeg3
                cmp     dword ptr es:[85h],53494420h
                jne     ancomlineBeg3
                cmp     word ptr es:[89h],204Bh
                jne     ancomlineBeg3
                mov     btmpViewDevice,3              ; Physical drive
                mov     al,byte ptr es:[8Bh]
                sub     al,30h
                add     al,80h
                mov     byte ptr es:[8Ch],0
                jmp     anRealBegin

ancomlineBeg3:  mov     si,80h
                mov     al,es:[si]
                inc     si
                cmp     al,00h                    ; AL - Lenght of ParamStr
                ja      ancont01

anErrComLine:   jmp     anAbandon

ancont01:       mov     al,es:[si]                ; AL <- Next byte from CmdLine
                inc     si
                cmp     al,20h
                je      ancont01                    ; ய ஡

                cmp     tmpNameFlag,1                ; Program name found ?
                je      anRealBegin                 ; Yes ! Go to program begin
                cmp     al,0Dh                    ; End of CmdLine ?
                jne     ancont08
                cmp     al,00h                    ; End of CmdLine ?
                jne     ancont08
                cmp     tmpNameFlag,1                ; Program name found ?
                jne     anErrComLine
                jmp     anRealBegin                 ; Yes ! Go to program begin

ancont08:       mov     dx,si                     ; 諨  䠩  
                dec     dx                        ; DS:DX <- pointer to FileName
ancont09:       mov     al,es:[si]
                inc     si
                cmp     al,20h
                ja      ancont09                    ; SI++ while not find space
                mov     byte ptr es:[si-1],0      ; FileName is ASCIIZ string
                mov     tmpNameFlag,1
                cmp     al,0Dh                    ; End of CmdLine ?
                je      anRealBegin                 ; Go to program begin
                cmp     al,00h                    ; End of CmdLine ?
                je      anRealBegin                 ; Go to program begin
                jmp     ancont01                    ; No ?! Go to find parameters

anRealBegin:    cmp     btmpViewDevice,0
                jne     anNormal
                push    ds
                push    es
                pop     ds
                mov     ax,4300h                 ; Read attributes AL=0
                int     21h
                pop     ds
                jc      anAbandon
anNormal:       clc
                jmp     anExit
anAbandon:      stc
anExit:         pop     es
                popad
                retf
AnalisComLine   endp
;*************************************************************************
; Procedure CommentSave
; Parameters:
;*************************************************************************
CommentSave    proc    far
               pushad
               push    es
               cmp     bCommBuf,1                      ; Use comment file ?
               jne     cosaAbandon
               cmp     bCommModify,1
               jne     cosaAbandon
;--- Store record to history file -------------------------------------------
               push    ds
               pop     es
               cld
               lea     si,FilePath
               lea     di,BufferName
cosaCreate:    lodsb
               stosb
               cmp     al,0
               jne     cosaCreate
               sub     di,4
               mov     byte ptr [di],'C'
               mov     byte ptr [di+1],'M'
               mov     byte ptr [di+2],'T'

               xor     cx,cx
               lea     dx,BufferName
               mov     ah,3Ch
               int     21h
               jc      cosaAbandon
               mov     bhsHandle,ax

               mov     ax,CommBufSeg
               mov     es,ax

               mov     bx,bhsHandle
               mov     ax,4200h
               xor     dx,dx
               xor     cx,cx
               int     21h

               mov     bx,bhsHandle
               mov     ah,40h
               mov     cx,2
               lea     dx,wCommCount
               int     21h

               mov     bx,bhsHandle
               mov     ah,40h
               mov     cx,2
               lea     dx,wpCommFree
               int     21h

               mov     bx,bhsHandle
               mov     ah,40h
               mov     cx,wCommCount
               shl     cx,2
               xor     dx,dx
               push    ds
               push    es
               pop     ds
               int     21h
               pop     ds

               mov     ah,40h
               mov     bx,bhsHandle
               mov     cx,wCommCount
               shl     cx,1
               mov     dx,4000
               push    ds
               push    es
               pop     ds
               int     21h
               pop     ds

               mov     ah,40h
               mov     bx,bhsHandle
               mov     cx,64000
               sub     cx,wpCommFree
               mov     dx,wpCommFree
               push    ds
               push    es
               pop     ds
               int     21h
               pop     ds

               mov     ah,3Eh
               mov     bx,bhsHandle
               int     21h
               jmp     cosaNormal
;--- Abandon exit -----------------------------------------------------------
cosaAbandon:   stc
               jmp     short cosaExit
;--- Normal exit ------------------------------------------------------------
cosaNormal:    clc
cosaExit:      pop     es
               popad
               retf
CommentSave    endp
;*************************************************************************
; Procedure CommentLoad
; Parameters:
;*************************************************************************
CommentLoad    proc    far
               pushad
               push    es
               cmp     bCommBuf,1                      ; Use comment file ?
               jne     colaAbandon
;--- Store record to history file -------------------------------------------
               push    ds
               pop     es
               cld
               lea     si,FilePath
               lea     di,BufferName
colaCreate:    lodsb
               stosb
               cmp     al,0
               jne     colaCreate
               sub     di,4
               mov     byte ptr [di],'C'
               mov     byte ptr [di+1],'M'
               mov     byte ptr [di+2],'T'

               xor     cx,cx
               lea     dx,BufferName
               mov     ax,3D42h
               int     21h
               jc      colaAbandon
               mov     bhsHandle,ax

               mov     ax,CommBufSeg
               mov     es,ax

               mov     bx,bhsHandle
               mov     ax,4200h
               xor     dx,dx
               xor     cx,cx
               int     21h

               mov     bx,bhsHandle
               mov     ah,3Fh
               mov     cx,2
               lea     dx,wCommCount
               int     21h

               mov     bx,bhsHandle
               mov     ah,3Fh
               mov     cx,2
               lea     dx,wpCommFree
               int     21h

               mov     bx,bhsHandle
               mov     ah,3Fh
               mov     cx,wCommCount
               shl     cx,2
               xor     dx,dx
               push    ds
               push    es
               pop     ds
               int     21h
               pop     ds

               mov     ah,3Fh
               mov     bx,bhsHandle
               mov     cx,wCommCount
               shl     cx,1
               mov     dx,4000
               push    ds
               push    es
               pop     ds
               int     21h
               pop     ds

               mov     ah,3Fh
               mov     bx,bhsHandle
               mov     cx,64000
               sub     cx,wpCommFree
               mov     dx,wpCommFree
               push    ds
               push    es
               pop     ds
               int     21h
               pop     ds

               mov     ah,3Eh
               mov     bx,bhsHandle
               int     21h
               jmp     colaNormal
;--- Abandon exit -----------------------------------------------------------
colaAbandon:   stc
               jmp     short colaExit
;--- Normal exit ------------------------------------------------------------
colaNormal:    clc
colaExit:      pop     es
               popad
               retf
CommentLoad    endp

;*************************************************************************
; Procedure TEditSaveMarkPos
; Parameters: si - current position
;*************************************************************************
TEditSaveMarkPos proc    far
                 push    eax
                 push    ecx
                 mov     eax,RealOfs
                 Call    TEditGetSI
                 add     eax,dTEditCurSI                 ;???
                 mov     ecx,teMarkBlkBeg
                 cmp     eax,ecx
                 ja      tesmpcont
                 mov     teBlkRealOfs,eax
                 push    eax
                 mov     eax,dTEditCurSI
                 sub     teBlkRealOfs,eax
                 mov     al,CurY
                 mov     bteCurY,al
                 mov     al,CurX
                 mov     bteCurX,al
                 pop     eax
                 mov     dteCurOutOfs,esi
                 xchg    eax,ecx
tesmpcont:       mov     teBlockBeg,ecx
                 mov     teBlockEnd,eax
                 pop     ecx
                 pop     eax
                 retf
TEditSaveMarkPos endp
;*************************************************************************
; Procedure TEditBlkMarkS
; Parameters:
;*************************************************************************
TEditBlkMarkS proc    far
              push    eax
              cmp     teBlkMarkFlag,1
              je      teblmaMarkOn
              cmp     bteShiftFlag,1
              je      teblmaSave
teblmaCont1:  mov     eax,RealOfs
              mov     teOldRealOfs,eax
              Call    TEditGetSI
              add     eax,dTEditCurSI                 ;???
              mov     teOldBlkOfs,eax
              mov     teBlkFlag,0FFh                  ; Marking flag off
              mov     dteOldOutOfs,esi
              mov     al,CurY
              mov     bteOldCurY,al
              mov     al,CurX
              mov     bteOldCurX,al
              jmp     teblmaExit

teblmaSave:   mov     teBlkFlag,1                     ; Marking ON
              mov     teBlkMarkFlag,1                 ; Show mark ON
              mov     eax,dteOldOutOfs
              mov     dteCurOutOfs,eax
              mov     al,bteOldCurY
              mov     bteCurY,al
              mov     al,bteOldCurX
              mov     bteCurX,al
              mov     eax,teOldRealOfs
              mov     teBlkRealOfs,eax
              mov     eax,teOldBlkOfs
              mov     teMarkBlkBeg,eax
teblmaStore:  Call    TEditSaveMarkPos
              jmp     teblmaExit
;--- Block marked -----------------------------------------------------------
teblmaMarkOn: cmp     bteShiftFlag,1
              jne     teblmaCont1
              cmp     teBlkFlag,1                     ; Marking On ?
              je      teblmaStore
              jmp     teblmaSave
teblmaExit:   pop     eax
              retf
TEditBlkMarkS endp
;*************************************************************************
; Procedure TEditGetSI
;*************************************************************************
TEditGetSI  proc    far
            pushad
            Call    GetOutStrLen
            xor     ecx,ecx
            mov     cl,CurX
            add     cx,LeftPos
            cmp     cx,curtmpLineLen
            jb      tedgCont1
            mov     cx,curtmpLineSI
            cmp     LFLength,1
            jbe     tedgExit
            inc     cx
            jmp     tedgExit
tedgCont1:  cmp     CurY,0
            je      tedgCont2
            inc     curtmpLinefSI
tedgCont2:  mov     cx,curtmpLinefSI
tedgExit:   mov     dTEditCurSI,ecx
            popad
            retf
TEditGetSI  endp
;*************************************************************************
; Procedure HlpFileInit
; Parameters: HelpPath
; Return:     bHFAvail - 1 if help file found, else 0
;             wHFSize  - size of help file
;*************************************************************************
HlpFileInit    proc    far
               push    dx
               push    cx
               push    bx
               push    ax
               mov     bHFAvail,0                    ; Help file not avaible
               lea     dx,HelpPath
               mov     ax,3D40h
               int     21h
               jc      hlfaExit
               mov     bHFAvail,1                    ; Help file avaible
               mov     word ptr wHFHandle,ax
               mov     bx,ax
               mov     ax,4202h
               xor     cx,cx
               xor     dx,dx
               int     21h
               mov     word ptr wHFSize,ax           ; DX:AX - file size
               mov     ah,3Eh
               int     21h
hlfaExit:      pop     ax
               pop     bx
               pop     cx
               pop     dx
               retf
HlpFileInit    endp
;*************************************************************************
; Procedure HlpFileLoad
; Parameters: HelpPath
;             wHFSize  - size of help file
;*************************************************************************
HlpFileLoad    proc    far
               push    dx
               push    cx
               push    bx
               push    ax

               lea     dx,HelpPath
               mov     ax,3D40h
               int     21h

               mov     bx,ax
               mov     ax,4200h
               xor     cx,cx
               xor     dx,dx
               int     21h

               mov     ah,3Fh
               mov     cx,word ptr wHFSize
               xor     dx,dx
               push    ds
               push    es
               pop     ds
               int     21h
               pop     ds

               mov     ah,3Eh
               int     21h
               pop     ax
               pop     bx
               pop     cx
               pop     dx
               retf
HlpFileLoad    endp
;*************************************************************************
; Procedure HlpFoundTopic
; Parameters: wHelpTopic - help topic number
;             es:0000    - help file
;             wHFSize    - size of help file
; Return:     CF if error
;             wHelpBeg
;             wHelpEnd
;*************************************************************************
HlpFoundTopic  proc    far
               xor     di,di                     ; es:di ->
               mov     cx,wHFSize

hlftLoop:      mov     al,'['                    ; topic token
               repnz   scasb
               cmp     cx,0
               je      hlftAbandon
               xor     dx,dx
               cmp     cx,4
               jbe     hlftAbandon
               sub     cx,4
               push    cx
               mov     cx,4
hlftLoop1:     mov     al,es:[di]
               Call    AsciiToHex
               jc      hlftAbandon1
               shl     dx,4
               or      dl,ah
               inc     di
               loop    hlftLoop1
               pop     cx
               cmp     dx,word ptr wHelpTopic
               jne     hlftLoop
               add     di,3
               mov     wHelpBeg,di
               mov     al,'['                    ; topic token
               repnz   scasb
               sub     di,3
               cmp     wHelpBeg,di
               jae     hlftAbandon
               mov     wHelpEnd,di
               mov     byte ptr es:[di],0
               clc
               retf

hlftAbandon1:  pop     cx
;--- Topic not found --------------------------------------------------------
hlftAbandon:   stc
               retf
HlpFoundTopic  endp
;*************************************************************************
; Procedure HlpMakeArray
; Parameters:
;             wHelpBeg   - begin topic text
;             wHelpEnd   - end topic text
; Return:
;             wHlpStrArray
;             wHlpMaxNum
;*************************************************************************
HlpMakeArray   proc    far
               mov     di,wHelpBeg               ; es:di -> topic text
               mov     cx,wHelpEnd
               sub     cx,di                     ; cx - topic text length
               inc     cx
               lea     bx,wHlpStrArray           ; line number
               mov     word ptr wHlpMaxNum,0

hlmaLoop:      mov     [bx],di
               inc     wHlpMaxNum
               mov     al,0Ah                    ; string divider
               repnz   scasb
               add     bx,2
               cmp     word ptr wHlpMaxNum,100
               jae     hlmaExit
               cmp     cx,0
               jne     hlmaLoop

hlmaExit:      retf
HlpMakeArray   endp
