;۲۲۲۲۲۲۲۲۲۲۲۲
;۲۲              QView Module             ޱ۲۲۲
;۲۲        (c) Copyright  1995-2006       ް۲۲۲
;۲۲           AGCProduct ۲         ޱ۲۲۲
;۲۲۲                   by                  ޲۲۲
;۲۲             Alexandr Gazko            ۲۲۲
;۲۲            ver. 2.91  beta            ޲۲۲۲
;۲۲۲۲۲۲۲۲۲۲۲۲

;*************************************************************************
; Procedure AsmBufLine                  Use Assembler and other...
; Parameters: bh  - line number
; Return:     bx - offset to asm buffer
;*************************************************************************
AsmBufLine  proc    far
            push    ecx
            push    edx
            push    eax

            xor     edx,edx
            cmp     bh,1
            je      ablExit
            mov     bl,1
            mov     cx,8
            push    cx
ablloop:    Call    GetChar
            Call    AsciiToHex
            shl     edx,4
            or      dl,ah
            inc     bl
            loop    ablloop
            pop     cx
            push    edx
            mov     bx,0101h
ablloop1:   Call    GetChar
            Call    AsciiToHex
            shl     edx,4
            or      dl,ah
            inc     bl
            loop    ablloop1
            pop     ebx
            sub     ebx,edx
            mov     dx,bx
            xor     ebx,ebx

ablExit:    mov     bx,dx
            pop     eax
            pop     edx
            pop     ecx
            retf
AsmBufLine  endp
;*************************************************************************
; Procedure InstrToBuffer
; Parameters: bh - line number
;*************************************************************************
InstrToBuffer proc    far
              lea     si,BufferName
              mov     bl,ScrWidth
              dec     bl
itbloop:      Call    GetChar
              dec     bl
              cmp     bl,10+1Ah
              je      itbexit1
              cmp     al,32
              je      itbloop
              mov     dl,bl
              add     dl,2
              mov     bl,11+1Ah
itbloop1:     Call    GetChar
              inc     bl
              cmp     bl,dl
              ja      itbexit1
              mov     [si],al
              inc     si
              jmp     itbloop1
itbexit1:     mov     byte ptr [si],0
              retf
InstrToBuffer endp
;*************************************************************************
; Procedure GetCurAdrAsm
; Parameters: bh - line number
;*************************************************************************
GetCurAdrAsm  proc    far
              push    ecx
              xor     ecx,ecx
              mov     bl,1
gcaaloop:     Call    GetChar
              inc     bl
              Call    AsciiToHex
              jc      gcaaexit
              shl     ecx,4
              or      cl,ah
              jmp     gcaaloop
gcaaexit:     mov     _CurAsmAdr,ecx
              pop     ecx
              retf
GetCurAdrAsm  endp
;*************************************************************************
; Procedure AsmWrCache
; Parameters:
;            al        - char
;            RealOfs   - real offset to buffer in file
;            si        - pointer in buffer
;*************************************************************************
AsmWrCache proc     far
           push     ebp
           mov      bChar,al                   ; Store char
           mov      bOper,1
           mov      ebp,RealOfs
           add      ebp,esi                    ; Make long address
           cmp      si,word ptr EndBuffer      ; New byte added
           jb       awcaBegin
           cmp      bViewDevice,0
           je       awcaApp
           pop      ebp
           retf
awcaApp:   Call     AppendByte

awcaBegin: mov      bHexMask,0
awcaScan:  Call     ScanCache                  ; Scan cache for address
           jnc      awcaExit
awcaAdd:   Call     AddByteCache               ; Move current string in cache
           jnc      awcaExit
           Call     UpdateQuery
           jnc      awcaAdd
awcaExit:  pop      ebp
           retf
AsmWrCache endp
;*************************************************************************
; Procedure AUpdateFile
; Parameters:
;*************************************************************************
AUpdateFile proc    far
            push    edi
            push    ebp
            push    ebx
            push    edx
            push    eax
            push    ecx
            push    fs
            push    es

            mov     ax,ds
            mov     fs,ax
            mov     es,ax

            lea     edi,MSG+11+1Ah
            lea     ebp,st_asm
            lea     esi,AsmBuffer+100
            call    Source
            xor     ecx,ecx
            mov     cx,dx

            pop     es
            pop     fs

            mov     bh,CurY
            Call    AsmBufLine
            mov     si,word ptr CurOutOfs
            add     si,bx
            lea     di,AsmBuffer+100
            mov     bHexWrite,0
            mov     bHexPos,0

aupfLoop:   mov     al,[di]
            push    ecx
            push    edi
            Call    AsmWrCache
            pop     edi
            pop     ecx
            inc     di
            inc     si
            loop    aupfLoop
            dec     si

            pop     ecx
            pop     eax
            pop     edx
            pop     ebx
            pop     ebp
            pop     edi
            retf
AUpdateFile endp
;*************************************************************************
; Procedure AUpdBuffer
; Parameters:
;*************************************************************************
AUpdBuffer  proc    far
            pushad
            push    fs
            push    es

            mov     ax,ds
            mov     fs,ax
            mov     es,ax

            lea     edi,MSG+11+1Ah
            lea     ebp,st_asm
            lea     esi,AsmBuffer+100
            call    Source

            mov     si,wAsmToBufOfs
            mov     cl,CurPosition
            lea     di,AsmBuffer+100

aupbuLoop:  cmp     _CurStrLen,20
            jae     aupbuExit
            push    dx
            mov     al,[di]
            Call    MyInsert2
            inc     _CurStrLen
            inc     cl
            inc     di
            inc     _CurAsmAdr
            pop     dx
            dec     dx
            cmp     dx,0
            jne     aupbuLoop

aupbuExit:  pop     es
            pop     fs
            popad
            retf
AUpdBuffer  endp
;*************************************************************************
; Procedure EditAsm
; Parameters:
;*************************************************************************
EditAsm     proc    far
            push    bx
            push    cx
            push    dx
            push    si
            push    di
            push    bp
            push    fs
            push    gs
            push    es

;--- Change KeyHelp line ----------------------------------------------------
            lea     si,hAssembler
            Call    OutHlpLine

;--- Initialisate variables, registers --------------------------------------
            mov     _ProcValue,0
            mov     ax,ds
            mov     fs,ax
            mov     gs,ax
            mov     bh,CurY
            Call    InstrToBuffer            ; Copy instruction to BufferName

edasError:  mov     bh,CurY                  ; Assemble error entry
            Call    GetCurAdrAsm             ; CurAdr -> _CurAsmAdr

            mov     bl,11+1Ah
            mov     dl,78-11-1Ah
            lea     si,BufferName
            Call    My_StRead                ; Edit string
            mov     byte ptr edaAsmJmp,al
            jc      edasExit                 ; ESC, TAB pressed (al=0)
            cmp     byte ptr _QuitKey,0      ; ENTER pressed - assemble !
            jne     edasExit                 ; Other fuctional key...

            mov     byte ptr _QuitKey,1      ; Assemble flag

            lea     si,AsmBuffer+100
            lea     di,BufferName
            Call    _Assemble
            jnc     edasExit
;--- Error assemble ---------------------------------------------------------
            cmp     al,1                     ; Invalid instruction ?
            jne     edasCont1
            lea     bp,ErrorMsg6
edasCont2:  Call    OutBlkError
            Call    OutToMode
            jmp     edasError

edasCont1:  cmp     al,2                     ; Invalid operands ?
            jne     edasExit
            lea     bp,ErrorMsg7
            jmp     short edasCont2
;--- Exit from rountime -----------------------------------------------------
edasExit:   pop     es
            pop     gs
            pop     fs
            pop     bp
            pop     di
            pop     si
            pop     dx
            pop     cx
            pop     bx
            cmp     _QuitKey,1
            je      edasUpdate
            mov     bHexWrite,1
            mov     bHexPos,0
            Call    OutToMode
            mov     ah,_QuitKey
            xor     al,al
            retf
;--- Update file ------------------------------------------------------------
edasUpdate: Call    AUpdateFile
            Call    OutToMode
            mov     ax,4D00h
            retf
EditAsm     endp
;*************************************************************************
; Procedure InputAsm
; Parameters:
;*************************************************************************
InputAsm    proc    far
            pushad
            push    fs
            push    gs
            push    es

;--- Initialisate variables, registers --------------------------------------
            mov     _ProcValue,1
            mov     al,CurPosition
            mov     ah,_CurStrLen
            push    ax
            mov     ax,ds
            mov     fs,ax
            mov     gs,ax
            mov     es,ax
            mov     bl,08h
            mov     bh,bInpAsmY1
            mov     ah,cDlgText
            lea     si,AsmMsg
            Call    WriteStr

inasError:  mov     bl,0Dh
            mov     bh,bInpAsmY2
            mov     ah,cDlgHeader
            lea     si,AssembleMsg
            Call    WriteStr

            mov     bh,bInpAsmY1
            mov     bl,0Dh
            mov     dl,59
            lea     si,BufferName
            Call    My_StRead                ; Edit string
            jc      inasAbort                ; ESC, TAB pressed (al=0)
            cmp     byte ptr _QuitKey,0      ; ENTER pressed - assemble !
            jne     inasAbort                ; Other fuctional key...

            mov     byte ptr _QuitKey,1      ; Assemble flag

            lea     si,AsmBuffer+100
            lea     di,BufferName
            Call    _Assemble
            jnc     inasExit
;--- Error assemble ---------------------------------------------------------
            cmp     al,1                     ; Invalid instruction ?
            jne     inasCont1
            lea     si,ErrorMsg6
inasCont2:  mov     bl,0Dh
            mov     bh,bInpAsmY2
            mov     ah,4Eh
            Call    WriteStr
            Call    ReadKey
            jmp     inasError

inasCont1:  cmp     al,2                     ; Invalid operands ?
            jne     inasExit
            lea     si,ErrorMsg7
            jmp     short inasCont2
;--- Abort rountime ---------------------------------------------------------
inasAbort:  mov     bl,08h
            mov     bh,bInpAsmY1
            mov     ah,cDlgText
            lea     si,HexMsg
            Call    WriteStr
            pop     ax
            mov     CurPosition,al
            mov     _CurStrLen,ah
            pop     es
            pop     gs
            pop     fs
            popad
            mov     _ProcValue,2
            stc
            retf
;--- Exit from rountime -----------------------------------------------------
inasExit:   mov     bl,08h
            mov     bh,bInpAsmY1
            mov     ah,cDlgText
            lea     si,HexMsg
            Call    WriteStr
            pop     ax
            mov     CurPosition,al
            mov     _CurStrLen,ah
            pop     es
            pop     gs
            pop     fs
            popad
            mov     _ProcValue,2
            Call    AUpdBuffer
            mov     _bAsmInpUsed,1
            clc
            retf
InputAsm    endp
;*************************************************************************
; Procedure EnterComment
; Parameters:
;*************************************************************************
EnterComment proc    far
             cmp     OutMode,2
             jne     encoDown
             cmp     bCommBuf,1
             je      encoBegin
encoDown:    retf
encoBegin:   pushad
             push    es
             cmp     wCommCount,1000
             jae     encoExit
             cmp     wpCommFree,6000
             jbe     encoExit
;--- Initialisate variables, registers --------------------------------------
             mov     _ProcValue,1
             mov     bh,CurY
             Call    GetComment               ; Copy comment to BufferName

encoLoop:    mov     bh,CurY                  ; Assemble error entry
             Call    GetCurAdrAsm             ; CurAdr -> _CurAsmAdr
             push    eax
             mov     eax,dBaseOfs
             sub     _CurAsmAdr,eax
             pop     eax
             mov     bh,CurY                  ; Assemble error entry
             mov     bl,bCommX                ; bCommX set a GetComment
             mov     dl,ScrWidth
             dec     dl
             cmp     dl,bl
             jbe     encoExit
             sub     dl,bl
             cmp     dl,57
             jbe     encoEdit
             mov     dl,57
encoEdit:    lea     si,BufferName
             Call    My_StRead                ; Edit string
             jc      encoExit
             cmp     byte ptr _QuitKey,0      ; ENTER pressed - go !
             je      encoStart
             cmp     byte ptr _QuitKey,15     ; TAB pressed - go !
             je      encoStart
             jmp     encoLoop                 ; Other fuctional key...
;--- Add comment to buffer --------------------------------------------------
encoStart:   xor     edi,edi
             mov     bCommModify,1
             mov     ax,CommBufSeg
             mov     es,ax
             cld
             cmp     wCommCount,0
             je      encoAdd
             mov     eax,_CurAsmAdr
             xor     ecx,ecx
             mov     cx,wCommCount
             repne   scasd
             jne     encoAdd
;             cmp     cx,0
;             je      encoAdd
             sub     di,4
             mov     bx,di
             shr     bx,1
             add     bx,4000
             mov     di,es:[bx]
             xor     cx,cx
             mov     cl,_CurStrLen
             inc     cl
             lea     si,BufferName
             rep     movsb
             jmp     encoExit

encoAdd:     mov     bx,wCommCount
             shl     bx,2
             mov     eax,_CurAsmAdr
             mov     es:[bx],eax
             inc     wCommCount
             mov     di,wpCommFree
             dec     di
             xor     cx,cx
             mov     cl,_CurStrLen
             inc     cl
             sub     di,58
             mov     wpCommFree,di
             shr     bx,1
             add     bx,4000
             mov     es:[bx],di

             lea     si,BufferName
             rep     movsb
;--- Exit from rountime -----------------------------------------------------
encoExit:    pop     es
             popad
             Call    OutToMode
             retf
EnterComment endp
;*************************************************************************
; Procedure PrevNextComm
; Parameters:
;*************************************************************************
PrevNextComm proc    far
             cmp     OutMode,2
             jne     pncoExit
             cmp     bCommBuf,1
             jne     pncoExit
             cmp     wCommCount,0
             je      pncoExit
             cmp     ah,155                ; Prev comment ?
             je      pncoPrev
;--- Next comment -----------------------------------------------------------
             mov     ax,wCommCurr
             inc     ax
             cmp     ax,wCommCount
             ja      pncoExit
             mov     wCommCurr,ax
             jmp     pncoStart
;--- Prev comment -----------------------------------------------------------
pncoPrev:    cmp     wCommCurr,1
             jbe     pncoExit
             dec     wCommCurr
;--- Go to comment ----------------------------------------------------------
pncoStart:   push    bx
             push    es
             mov     ax,CommBufSeg
             mov     es,ax
             mov     bx,wCommCurr
             dec     bx
             shl     bx,2
             mov     eax,dword ptr es:[bx]
             mov     TmpVar1,eax
             pop     es
             pop     bx
             jmp     Externgtad
;--- Normal exit from rountime ----------------------------------------------
pncoExit:    retf
PrevNextComm endp
;*************************************************************************
; Procedure GetComment
; Parameters: bh - line number
;*************************************************************************
GetComment    proc    far
              lea     si,BufferName
              mov     bl,ScrWidth
              dec     bl
gecoloop:     Call    GetChar
              dec     bl
              cmp     bl,10+1Ah
              je      gecoexit1
              cmp     al,32
              je      gecoloop
              mov     dl,bl
              add     dl,2
              mov     bCommX,dl
              inc     bCommX

gecoloop1:    Call    GetChar
              dec     bl
              cmp     bl,10+1Ah
              je      gecoexit2
              cmp     al,';'
              jne     gecoloop1
              inc     bl
              mov     bCommX,bl

gecoloop2:    Call    GetChar
              inc     bl
              cmp     bl,dl
              ja      gecoexit3
              mov     [si],al
              inc     si
              jmp     gecoloop2

gecoexit1:    mov     bCommX,11+1Ah
gecoexit2:    mov     byte ptr [si],';'
              inc     si
gecoexit3:    mov     byte ptr [si],0
              retf
GetComment    endp
