;۲۲۲۲۲۲۲۲۲۲۲۲
;۲۲              QView Module             ޱ۲۲۲
;۲۲        (c) Copyright  1995-2006       ް۲۲۲
;۲۲           AGCProduct ۲         ޱ۲۲۲
;۲۲۲                   by                  ޲۲۲
;۲۲             Alexandr Gazko            ۲۲۲
;۲۲            ver. 2.91  beta            ޲۲۲۲
;۲۲۲۲۲۲۲۲۲۲۲۲

.CODE CODE1
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure DiskTranslate
;۲۲۲۲۲۲۲۲۲۲۲۲
DiskTranslate           proc    near
                        mov   ax,word ptr bDPB
                        mov   dx,word ptr bDPB+2
                        div   word ptr wCylSect

                        xor   cx,cx
                        mov   ch,al
                        shl   ah,6
                        mov   cl,ah

                        mov   ax,dx
                        div   byte ptr wMaxSect
                        mov   dh,al
                        inc   ah
                        or    cl,ah
                        ret
DiskTranslate           endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure DeviceRead
; Parameters:
;             bViewDevice  0 - file, 1 - memory, 2 - disk
;             cx           count of bytes
;             ds:dx        buffer
;۲۲۲۲۲۲۲۲۲۲۲۲
DeviceRead              proc    far
                        mov     ah,GS:bViewDevice
;--- File read --------------------------------------------------------------
                        cmp     ah,0
                        jne     devreMem
                        mov     bx,GS:Handle
                        mov     ah,3fh            ; ⠥ 䠩
                        int     21h
                        retf
;--- Memory read ------------------------------------------------------------
devreMem:               cmp     ah,1
                        jne     devreDsk
                        push    esi
                        push    edi
                        push    es
                        push    ds
                        push    dx
                        push    cx

                        xor     eax,eax
                        mov     ax,GS:wMemSeg
                        shl     eax,4
                        xor     esi,esi
                        mov     si,GS:wMemOfs
                        add     eax,esi

                        push    eax

                        mov     si,cx
                        add     eax,esi
                        cmp     eax,dword ptr GS:FileSize
                        jb      devreMem1
                        sub     eax,dword ptr GS:FileSize
                        ;inc     eax
                        sub     cx,ax
devreMem1:              mov     GS:wMemSize,cx
                        push    ds
                        pop     es
                        mov     ax,GS:wMemSeg
                        mov     ds,ax
                        mov     si,GS:wMemOfs
                        mov     di,dx
                        cld
                        rep     movsb

                        pop     eax
                        xor     ecx,ecx
                        mov     cx,GS:wMemSize
                        add     eax,ecx
                        mov     dx,ax
                        shr     eax,16
                        mov     cx,ax
                        Call    DeviceSeek
                        xor     eax,eax
                        mov     ax,GS:wMemSize
                        clc
                        pop     cx
                        pop     dx
                        pop     ds
                        pop     es
                        pop     edi
                        pop     esi
                        retf
;--- Logical disk read ------------------------------------------------------
devreDsk:               cmp     ah,2
                        jne     devrePDsk
                        push    ds
                        push    es
                        push    esi
                        push    edi
                        push    edx
                        push    ecx
                        push    ebx

                        push    ds
                        pop     es                     ; Target segment
                        push    gs
                        pop     ds                     ; Data segment
                        mov     di,dx                  ; Target offset
                        mov     wSectorBlock,cx        ; Target length

                        mov     ax,ds
                        mov     word ptr bDPB+8,ax     ; Sector buffer segment
                        lea     ax,bSectorBuffer       ; Sector buffer offset
                        mov     word ptr bDPB+6,ax     ; Sector buffer offset
                        mov     eax,dSectorStart
                        mov     dword ptr bDPB,eax     ; Start sector
                        mov     word ptr bDPB+4,1      ; Number of sectors=1
                        xor     ebx,ebx
                        mov     bx,wSectorSize
                        mul     ebx
                        mov     bx,wSectorOffset
                        add     eax,ebx
                        mov     bx,wSectorBlock
                        add     eax,ebx
                        push    bx
                        push    eax
                        xor     eax,eax

devreDskLoop:           mov     al,byte ptr Handle     ; drive number (0 = A)
                        mov     cx,-1
                        lea     bx,bDPB
                        Int     25h                    ; Read sector
                        add     sp,2                   ; stack correct

                        lea     si,bSectorBuffer
                        add     si,wSectorOffset
                        mov     ax,wSectorSize
                        sub     ax,wSectorOffset
                        cmp     ax,wSectorBlock
                        jbe     devreDskCont1
                        mov     ax,wSectorBlock
devreDskCont1:          mov     cx,ax
                        sub     wSectorBlock,ax
                        cld
                        rep     movsb
                        mov     wSectorOffset,0
                        inc     dword ptr bDPB
                        cmp     wSectorBlock,0
                        jne     devreDskLoop

                        pop     eax                       ; Current position
                        mov     dx,ax
                        shr     eax,16
                        mov     cx,ax
                        Call    DeviceSeek
                        xor     eax,eax
                        pop     ax                        ; Block size
                        clc
                        pop     ebx
                        pop     ecx
                        pop     edx
                        pop     edi
                        pop     esi
                        pop     es
                        pop     ds
                        retf
;--- Physical disk read -----------------------------------------------------
devrePDsk:              cmp     ah,3
                        jne     devreOtherDevice
                        push    ds
                        push    es
                        push    esi
                        push    edi
                        push    edx
                        push    ecx
                        push    ebx

                        push    ds
                        pop     es                     ; Target segment
                        push    gs
                        pop     ds                     ; Data segment
                        mov     di,dx                  ; Target offset
                        mov     wSectorBlock,cx        ; Target length

                        mov     eax,dSectorStart
                        mov     dword ptr bDPB,eax     ; Start sector
                        xor     ebx,ebx
                        mov     bx,wSectorSize
                        mul     ebx
                        mov     bx,wSectorOffset
                        add     eax,ebx
                        mov     bx,wSectorBlock
                        add     eax,ebx
                        push    bx
                        push    eax
                        xor     eax,eax

devrePDskLoop:          Call    DiskTranslate
                        mov     ax,0201h
                        mov     dl,byte ptr Handle     ; drive number (0 = A)
                        lea     bx,bSectorBuffer
                        push    es
                        push    ds
                        pop     es
                        Int     13h                    ; Read sector
                        pop     es

                        lea     si,bSectorBuffer
                        add     si,wSectorOffset
                        mov     ax,wSectorSize
                        sub     ax,wSectorOffset
                        cmp     ax,wSectorBlock
                        jbe     devrePDskCont1
                        mov     ax,wSectorBlock
devrePDskCont1:         mov     cx,ax
                        sub     wSectorBlock,ax
                        cld
                        rep     movsb
                        mov     wSectorOffset,0
                        inc     dword ptr bDPB
                        cmp     wSectorBlock,0
                        jne     devrePDskLoop

                        pop     eax                       ; Current position
                        mov     dx,ax
                        shr     eax,16
                        mov     cx,ax
                        Call    DeviceSeek
                        xor     eax,eax
                        pop     ax                        ; Block size
                        clc
                        pop     ebx
                        pop     ecx
                        pop     edx
                        pop     edi
                        pop     esi
                        pop     es
                        pop     ds
                        retf
devreOtherDevice:       retf
DeviceRead              endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure DeviceWrite
; Parameters:
;             bViewDevice  0 - file, 1 - memory, 2 - disk
;             cx           count of bytes
;             ds:dx        buffer
;۲۲۲۲۲۲۲۲۲۲۲۲
DeviceWrite             proc    far
                        mov     ah,GS:bViewDevice
;--- File write -------------------------------------------------------------
                        cmp     ah,0
                        jne     devwrMem
                        mov     bx,GS:Handle
                        mov     ah,40h
                        int     21h
                        retf
;--- Memory write -----------------------------------------------------------
devwrMem:               cmp     ah,1
                        jne     devwrDsk
                        cmp     cx,0
                        jne     devwrMemBegin
                        retf
devwrMemBegin:          push    esi
                        push    edi
                        push    es
                        push    ds
                        push    dx
                        push    cx

                        xor     eax,eax
                        mov     ax,GS:wMemSeg
                        shl     eax,4
                        xor     esi,esi
                        mov     si,GS:wMemOfs
                        add     eax,esi

                        push    eax

                        mov     si,cx
                        add     eax,esi
                        cmp     eax,dword ptr GS:FileSize
                        jb      devwrMem1
                        sub     eax,dword ptr GS:FileSize
                        ;inc     eax
                        sub     cx,ax
devwrMem1:              mov     GS:wMemSize,cx

                        mov     ax,GS:wMemSeg
                        mov     es,ax
                        mov     di,GS:wMemOfs
                        mov     si,dx
                        cld
                        rep     movsb

                        pop     eax
                        xor     ecx,ecx
                        mov     cx,GS:wMemSize
                        add     eax,ecx
                        mov     dx,ax
                        shr     eax,16
                        mov     cx,ax
                        Call    DeviceSeek
                        xor     eax,eax
                        mov     ax,GS:wMemSize
                        clc
                        pop     cx
                        pop     dx
                        pop     ds
                        pop     es
                        pop     edi
                        pop     esi
                        retf
;--- Disk write -------------------------------------------------------------
devwrDsk:               cmp     ah,2
                        jne     devwrPDsk
                        cmp     cx,0
                        jne     devwrDskBegin
                        retf
devwrDskBegin:          push    ds
                        push    es
                        push    esi
                        push    edi
                        push    edx
                        push    ecx
                        push    ebx

                        push    ds
                        pop     es                     ; Target segment
                        push    gs
                        pop     ds                     ; Data segment

                        Call    DeviceLock
                        jc      devwrDskExit

                        mov     di,dx                  ; Target offset
                        mov     wSectorBlock,cx        ; Target length

                        mov     ax,ds
                        mov     word ptr bDPB+8,ax     ; Sector buffer segment
                        lea     ax,bSectorBuffer       ; Sector buffer offset
                        mov     word ptr bDPB+6,ax     ; Sector buffer offset
                        mov     eax,dSectorStart
                        mov     dword ptr bDPB,eax     ; Start sector
                        mov     word ptr bDPB+4,1      ; Number of sectors=1
                        xor     ebx,ebx
                        mov     bx,wSectorSize
                        mul     ebx
                        mov     bx,wSectorOffset
                        add     eax,ebx
                        mov     bx,wSectorBlock
                        add     eax,ebx
                        push    bx
                        push    eax
                        xor     eax,eax

devwrDskLoop:           mov     al,byte ptr Handle     ; drive number (0 = A)
                        mov     cx,-1
                        lea     bx,bDPB
                        Int     25h                    ; Read sector
                        add     sp,2                   ; stack correct

                        lea     si,bSectorBuffer
                        add     si,wSectorOffset
                        mov     ax,wSectorSize
                        sub     ax,wSectorOffset
                        cmp     ax,wSectorBlock
                        jbe     devwrDskCont1
                        mov     ax,wSectorBlock
devwrDskCont1:          mov     cx,ax
                        sub     wSectorBlock,ax
                        cld
                        push    ds
                        push    es
                        xchg    si,di
                        push    es
                        mov     ax,ds
                        pop     ds
                        mov     es,ax
                        rep     movsb
                        xchg    si,di
                        pop     es
                        pop     ds

                        mov     al,byte ptr Handle     ; drive number (0 = A)
                        mov     cx,-1
                        lea     bx,bDPB
                        Int     26h                    ; Write sector
                        add     sp,2                   ; stack correct

                        mov     wSectorOffset,0
                        inc     dword ptr bDPB
                        cmp     wSectorBlock,0
                        jne     devwrDskLoop

                        pop     eax                       ; Current position
                        mov     dx,ax
                        shr     eax,16
                        mov     cx,ax
                        Call    DeviceSeek
                        xor     eax,eax
                        pop     ax                        ; Block size

                        Call    DeviceUnLock

                        clc
devwrDskExit:           pop     ebx
                        pop     ecx
                        pop     edx
                        pop     edi
                        pop     esi
                        pop     es
                        pop     ds
                        retf
;--- Physical disk write ----------------------------------------------------
devwrPDsk:              cmp     ah,3
                        jne     devwrOtherDevice
                        cmp     cx,0
                        jne     devwrPDskBegin
                        retf
devwrPDskBegin:         push    ds
                        push    es
                        push    esi
                        push    edi
                        push    edx
                        push    ecx
                        push    ebx

                        push    ds
                        pop     es                     ; Target segment
                        push    gs
                        pop     ds                     ; Data segment

                        Call    DeviceLock
                        jc      devwrPDskExit

                        mov     di,dx                  ; Target offset
                        mov     wSectorBlock,cx        ; Target length

                        mov     eax,dSectorStart
                        mov     dword ptr bDPB,eax     ; Start sector
                        xor     ebx,ebx
                        mov     bx,wSectorSize
                        mul     ebx
                        mov     bx,wSectorOffset
                        add     eax,ebx
                        mov     bx,wSectorBlock
                        add     eax,ebx
                        push    bx
                        push    eax
                        xor     eax,eax

devwrPDskLoop:          Call    DiskTranslate
                        mov     ax,0201h
                        mov     dl,byte ptr Handle     ; drive number (0 = A)
                        lea     bx,bSectorBuffer
                        push    es
                        push    ds
                        pop     es
                        Int     13h                    ; Read sector
                        pop     es

                        lea     si,bSectorBuffer
                        add     si,wSectorOffset
                        mov     ax,wSectorSize
                        sub     ax,wSectorOffset
                        cmp     ax,wSectorBlock
                        jbe     devwrPDskCont1
                        mov     ax,wSectorBlock
devwrPDskCont1:         mov     cx,ax
                        sub     wSectorBlock,ax
                        cld
                        push    ds
                        push    es
                        xchg    si,di
                        push    es
                        mov     ax,ds
                        pop     ds
                        mov     es,ax
                        rep     movsb
                        xchg    si,di
                        pop     es
                        pop     ds

                        Call    DiskTranslate
                        mov     ax,0301h
                        mov     dl,byte ptr Handle     ; drive number (0 = A)
                        lea     bx,bSectorBuffer
                        push    es
                        push    ds
                        pop     es
                        Int     13h                    ; Read sector
                        pop     es

                        mov     wSectorOffset,0
                        inc     dword ptr bDPB
                        cmp     wSectorBlock,0
                        jne     devwrPDskLoop

                        pop     eax                       ; Current position
                        mov     dx,ax
                        shr     eax,16
                        mov     cx,ax
                        Call    DeviceSeek
                        xor     eax,eax
                        pop     ax                        ; Block size

                        Call    DeviceUnLock

                        clc
devwrPDskExit:          pop     ebx
                        pop     ecx
                        pop     edx
                        pop     edi
                        pop     esi
                        pop     es
                        pop     ds
                        retf
devwrOtherDevice:       retf
DeviceWrite             endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure DeviceSeek
; Parameters:
;             bViewDevice  0 - file, 1 - memory, 2 - disk
;             cx:dx - position
;۲۲۲۲۲۲۲۲۲۲۲۲
DeviceSeek              proc    far
                        mov     ah,GS:bViewDevice
;--- File read --------------------------------------------------------------
                        cmp     ah,0
                        jne     devseMem
                        mov     ax,4200h
                        mov     bx,GS:Handle
                        int     21h
                        retf
;--- Memory read ------------------------------------------------------------
devseMem:               cmp     ah,1
                        jne     devseDsk
                        xor     eax,eax
                        mov     ax,cx
                        shl     eax,16
                        xor     ebx,ebx
                        mov     bx,dx
                        add     eax,ebx
                        shr     eax,4
                        and     dx,0Fh
                        mov     GS:wMemSeg,ax
                        mov     GS:wMemOfs,dx
                        clc
                        retf
;--- Disk read --------------------------------------------------------------
devseDsk:               cmp     ah,3
                        ja      devseOtherDevice
                        push    ecx
                        push    edx
                        push    ebx
                        push    eax
                        xor     eax,eax
                        mov     ax,cx
                        shl     eax,16
                        xor     ebx,ebx
                        mov     bx,dx
                        add     eax,ebx
                        xor     edx,edx
                        mov     bx,GS:wSectorSize      ; Sector size in bytes
                        div     ebx
                        mov     GS:dSectorStart,eax
                        mov     GS:wSectorOffset,dx
                        pop     eax
                        pop     ebx
                        pop     edx
                        pop     ecx
                        retf
devseOtherDevice:       retf
DeviceSeek              endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure AccessDevice
; Parameters:
;             ah  2 - logical disk, 3 - phisical disk
;             dl  drive number
; Return:
;             CF if device not accessed
;۲۲۲۲۲۲۲۲۲۲۲۲
AccessDevice            proc    far
;--- Test current device type -----------------------------------------------
                        cmp     ah,2
                        je      devacDsk
                        cmp     ah,3
                        je      devacPDsk
                        mov     al,1                     ; device not support
                        stc
                        retf
;--- Logical disk access ----------------------------------------------------
devacDsk:               push    ds
                        push    esi
                        push    edi
                        push    edx
                        push    ecx
                        push    ebx

                        push    gs
                        pop     ds                     ; Data segment

                        mov     ax,ds
                        mov     word ptr bDPB+8,ax     ; Sector buffer segment
                        lea     ax,bSectorBuffer       ; Sector buffer offset
                        mov     word ptr bDPB+6,ax     ; Sector buffer offset
                        mov     dword ptr bDPB,0       ; Start sector
                        mov     word ptr bDPB+4,1      ; Number of sectors=1

                        mov     al,dl                  ; drive number (0 = A)
                        mov     cx,-1
                        lea     bx,bDPB
                        Int     25h                    ; Read sector
                        pushf
                        add     sp,2                   ; stack correct
                        popf
                        pop     ebx
                        pop     ecx
                        pop     edx
                        pop     edi
                        pop     esi
                        pop     ds
                        retf
;--- Physical disk read -----------------------------------------------------
devacPDsk:              push    ds
                        push    es
                        push    esi
                        push    edi
                        push    edx
                        push    ecx
                        push    ebx

                        mov     ax,gs
                        mov     es,ax                  ; Data segment
                        mov     ds,ax

                        mov     ax,0201h
                        mov     cx,0001h
                        mov     dh,0
                        lea     bx,bSectorBuffer
                        Int     13h                    ; Read sector

                        pop     ebx
                        pop     ecx
                        pop     edx
                        pop     edi
                        pop     esi
                        pop     es
                        pop     ds
                        retf
AccessDevice            endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure DeviceLock
; Parameters:
;             bViewDevice  2 - logical disk, 3 - phisical disk
;             Handle       drive number
;             wMSDOSVer    MS-DOS version
;۲۲۲۲۲۲۲۲۲۲۲۲
DeviceLock              proc    near
                        cmp     byte ptr wMSDOSVer,7
                        jae     devloBegin
                        clc
                        ret
devloBegin:             cmp     bViewDevice,2
                        je      devloLogical
                        cmp     bViewDevice,3
                        je      devloPhisical
                        stc
                        ret
;--- Logical device lock ----------------------------------------------------
devloLogical:           pushad
                        mov     ax,440Dh
                        mov     bh,1
                        mov     bl,byte ptr Handle
                        inc     bl
                        mov     ch,8
                        mov     cl,4Ah
                        mov     dx,0
                        int     21h
                        jc      devloLogicalExit
                        
                        mov     ax,440Dh
                        mov     bh,2
                        mov     bl,byte ptr Handle
                        inc     bl
                        mov     ch,8
                        mov     cl,4Ah
                        mov     dx,0
                        int     21h
                        jc      devloLogicalExit
                        
                        mov     ax,440Dh
                        mov     bh,3
                        mov     bl,byte ptr Handle
                        inc     bl
                        mov     ch,8
                        mov     cl,4Ah
                        mov     dx,0
                        int     21h
devloLogicalExit:       popad
                        ret
;--- Phisical device lock ---------------------------------------------------
devloPhisical:          pushad
                        mov     ax,440Dh
                        mov     bh,1
                        mov     bl,byte ptr Handle
                        mov     ch,8
                        mov     cl,4Bh
                        mov     dx,0
                        int     21h
                        jc      devloPhisicalExit
                        
                        mov     ax,440Dh
                        mov     bh,2
                        mov     bl,byte ptr Handle
                        mov     ch,8
                        mov     cl,4Bh
                        mov     dx,0
                        int     21h
                        jc      devloPhisicalExit
                        
                        mov     ax,440Dh
                        mov     bh,3
                        mov     bl,byte ptr Handle
                        mov     ch,8
                        mov     cl,4Bh
                        mov     dx,0
                        int     21h
devloPhisicalExit:      popad
                        ret
DeviceLock              endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure DeviceUnLock
; Parameters:
;             bViewDevice  2 - logical disk, 3 - phisical disk
;             Handle       drive number
;             wMSDOSVer    MS-DOS version
;۲۲۲۲۲۲۲۲۲۲۲۲
DeviceUnLock            proc    near
                        cmp     byte ptr wMSDOSVer,7
                        jae     devulBegin
                        clc
                        ret
devulBegin:             cmp     bViewDevice,2
                        je      devulLogical
                        cmp     bViewDevice,3
                        je      devulPhisical
                        stc
                        ret
;--- Logical device lock ----------------------------------------------------
devulLogical:           pushad
                        mov     ax,440Dh
                        mov     bl,byte ptr Handle
                        inc     bl
                        mov     ch,8
                        mov     cl,6Ah
                        int     21h

                        mov     ax,440Dh
                        mov     bl,byte ptr Handle
                        inc     bl
                        mov     ch,8
                        mov     cl,6Ah
                        int     21h

                        mov     ax,440Dh
                        mov     bl,byte ptr Handle
                        inc     bl
                        mov     ch,8
                        mov     cl,6Ah
                        int     21h
                        popad
                        ret
;--- Phisical device lock ---------------------------------------------------
devulPhisical:          pushad
                        mov     ax,440Dh
                        mov     bl,byte ptr Handle
                        mov     ch,8
                        mov     cl,6Bh
                        int     21h

                        mov     ax,440Dh
                        mov     bl,byte ptr Handle
                        mov     ch,8
                        mov     cl,6Bh
                        int     21h

                        mov     ax,440Dh
                        mov     bl,byte ptr Handle
                        mov     ch,8
                        mov     cl,6Bh
                        int     21h
                        popad
                        ret
DeviceUnLock            endp