;۲۲۲۲۲۲۲۲۲۲۲۲
;۲۲             Module Debugger           ޱ۲۲۲
;۲۲         (c) Copyright  1995-97        ް۲۲۲
;۲۲          AGC  Product ۲        ޱ۲۲۲
;۲۲۲                   by                  ޲۲۲
;۲۲             Alexandr Gazko            ۲۲۲
;۲۲             ver. 2.08 beta            ޲۲۲۲
;۲۲۲۲۲۲۲۲۲۲۲۲

.CODE CODE1
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure SaveCrypt
; Parameters:
;۲۲۲۲۲۲۲۲۲۲۲۲
SaveCrypt    proc    far
             push    edi
             push    esi
             push    ebp
             push    ebx
             push    edx
             push    eax
             push    ecx

             mov     bl,dWinXTop
             mov     bh,dWinYTop
             add     bx,0503h
             mov     dx,bx
             add     dx,0232h
             mov     ah,cDlgBox
             Call    RectWindow
             mov     ah,cDlgHeader
             push    bx
             add     bl,17
             lea     si,tDebugSave
             Call    WriteStr
             pop     bx
             add     bx,0101h
             dec     dl
             sub     dl,bl
             lea     si,BufferName
             mov     byte ptr [si],0
             Call    My_StRead
             jc      sacrNormal
             cmp     _QuitKey,0
             jne     sacrNormal
             cld
             lea     di,dbgLines+200
             lea     si,dbgSaveDataBeg
             mov     cx,dbgSaveDataLen
             rep     movsb

             lea     dx,BufferName
             mov     ah,3Ch
             xor     cx,cx
             Int     21h
             jc      sacrAbandon
             mov     bx,ax
             mov     ah,40h
             mov     cx,1280
             lea     dx,hsBuffer
             Int     21h
             mov     ah,3Eh
             Int     21h
             jmp     sacrNormal
;--- Abandon exit -----------------------------------------------------------
sacrAbandon: stc
             jmp     short sacrExit
;--- Normal exit ------------------------------------------------------------
sacrNormal:  xor     eax,eax
             mov     ax,dx
             clc
;--- Exit from rountime -----------------------------------------------------
sacrExit:    pop     ecx
             pop     eax
             pop     edx
             pop     ebx
             pop     ebp
             pop     esi
             pop     edi
             retf
SaveCrypt    endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure LoadCrypt
; Parameters:
;۲۲۲۲۲۲۲۲۲۲۲۲
LoadCrypt    proc    far
             push    edi
             push    esi
             push    ebp
             push    ebx
             push    edx
             push    eax
             push    ecx

             mov     bl,dWinXTop
             mov     bh,dWinYTop
             add     bx,0503h
             mov     dx,bx
             add     dx,0232h
             mov     ah,cDlgBox
             Call    RectWindow
             mov     ah,cDlgHeader
             push    bx
             add     bl,17
             lea     si,tDebugLoad
             Call    WriteStr
             pop     bx
             add     bx,0101h
             dec     dl
             sub     dl,bl
             lea     si,BufferName
             mov     byte ptr [si],0
             Call    My_StRead
             jc      locrNormal
             cmp     _QuitKey,0
             jne     locrNormal

             lea     dx,BufferName
             mov     ax,3D40h
             Int     21h
             jc      locrAbandon
             mov     bx,ax
             mov     ah,3Fh
             mov     cx,1280
             lea     dx,hsBuffer
             Int     21h
             mov     ah,3Eh
             Int     21h
             cld
             lea     si,dbgLines+200
             lea     di,dbgSaveDataBeg
             mov     cx,dbgSaveDataLen
             rep     movsb
             jmp     locrNormal
;--- Abandon exit -----------------------------------------------------------
locrAbandon: stc
             jmp     short locrExit
;--- Normal exit ------------------------------------------------------------
locrNormal:  xor     eax,eax
             mov     ax,dx
             clc
;--- Exit from rountime -----------------------------------------------------
locrExit:    pop     ecx
             pop     eax
             pop     edx
             pop     ebx
             pop     ebp
             pop     esi
             pop     edi
             retf
LoadCrypt    endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure GetCryptAddr
; Parameters:
; Return    :  ax - addr for jmp
;۲۲۲۲۲۲۲۲۲۲۲۲
GetCryptAddr proc    far
             push    esi
             push    ebx
             push    edx

             mov     bl,dWinXTop
             inc     bl
             mov     dl,8
             lea     si,BufferName
             mov     byte ptr [si],0
             Call    My_StRead
             jc      gcadAbandon
             cmp     _QuitKey,0
             jne     gcadAbandon
             xor     edx,edx
             lea     si,BufferName

gcadLoop:    lodsb
             cmp     al,0
             je      gcadNormal
             shl     edx,4
             Call    AsciiToHex
             jc      gcadAbandon
             or      dl,ah
             jmp     gcadLoop

;--- Abandon exit -----------------------------------------------------------
gcadAbandon: stc
             jmp     short gcadExit
;--- Normal exit ------------------------------------------------------------
gcadNormal:  xor     eax,eax
             mov     ax,dx
             clc
;--- Exit from rountime -----------------------------------------------------
gcadExit:    pop     edx
             pop     ebx
             pop     esi
             retf
GetCryptAddr endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure GetDataAddr
; Parameters:
; Return    :  ax - addr for jmp
;۲۲۲۲۲۲۲۲۲۲۲۲
GetDataAddr  proc    far
             push    esi
             push    ebx
             push    edx

             mov     bx,0E41h
             mov     dl,8
             lea     si,BufferName
             mov     byte ptr [si],0
             Call    My_StRead
             jc      gdadAbandon
             cmp     _QuitKey,0
             jne     gdadAbandon
             xor     edx,edx
             lea     si,BufferName

gdadLoop:    lodsb
             cmp     al,0
             je      gdadNormal
             shl     edx,4
             Call    AsciiToHex
             jc      gdadAbandon
             or      dl,ah
             jmp     gdadLoop

;--- Abandon exit -----------------------------------------------------------
gdadAbandon: stc
             jmp     short gdadExit
;--- Normal exit ------------------------------------------------------------
gdadNormal:  xor     eax,eax
             mov     ax,dx
             clc
;--- Exit from rountime -----------------------------------------------------
gdadExit:    pop     edx
             pop     ebx
             pop     esi
             retf
GetDataAddr  endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure OutCryptParm
; Parameters:
;۲۲۲۲۲۲۲۲۲۲۲۲
OutCryptParm proc    far
             push    edi
             push    esi
             push    ebp
             push    ebx
             push    edx
             push    eax
             push    ecx

             mov     eax,dword ptr BlockBeg
             lea     si,tDebugVal+7
             Call    HexToStr
             mov     eax,dword ptr BlockEnd
             lea     si,tDebugVal+21
             Call    HexToStr
             mov     eax,dword ptr BlockLen
             lea     si,tDebugVal+35
             Call    HexToStr
             xor     eax,eax
             mov     ax,dbgDataOfs
             add     ax,offset hsBuffer
             lea     si,tDebugVal+49
             Call    HexToStr

             mov     bx,0541h
             mov     dx,0F49h
             mov     ah,cDlgBox
             xor     bp,bp
             lea     si,tDebugVal
             call    OutString

             lea     si,tDebugMode
             xor     bx,bx
             mov     bl,dbgAsmMode
             shl     bl,3
             add     bl,dbgAsmMode
             add     si,bx
             mov     bx,1041h
             Call    WriteStr

             pop     ecx
             pop     eax
             pop     edx
             pop     ebx
             pop     ebp
             pop     esi
             pop     edi
             retf
OutCryptParm endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure OutCryptData
; Parameters:
;۲۲۲۲۲۲۲۲۲۲۲۲
OutCryptData proc    far
             push    edi
             push    esi
             push    ebp
             push    ebx
             push    edx
             push    eax
             push    ecx

             xor     eax,eax
             xor     esi,esi
             lea     si,hsBuffer
             mov     ax,dbgCurDataOfs
             add     si,ax                            ; move buffer pointer
             mov     eax,esi
             mov     dword ptr AddrDisAsm,eax

             mov     bh,dWinYBottom
             inc     bh
             mov     cx,4
             cld
;--- Main looop --------------------------------------------------------------
ocdaMLoop:   mov     bl,dWinXTop
             inc     bh
             push    ecx
             push    ebx
;--- Store ccurrent address to buffer ----------------------------------------
             push    esi
             mov     eax,dword ptr AddrDisAsm
             lea     si,MSG+8
             mov     byte ptr [si+1],':'
             Call    HexToStr
             pop     esi
;--- Disasseemble current instruction ----------------------------------------
             Lea     edi,MSG+11
             mov     cx,16
ocdaLoop:    lodsb
             Call    ByteToStr
             mov     byte ptr [di+2],20h
             add     di,3
             loop    ocdaLoop
             add     dword ptr AddrDisAsm,16
             pop     ebx
             mov     byte ptr [di],0
;--- Out insstruction to screen ----------------------------------------------
             push    esi
             lea     esi,MSG
             mov     ah,byte ptr cDlgText
             cld

ocdacont3:   lodsb
             cmp     al,0
             je      ocdacont4
             Call    OutChar
             inc     bl
             jmp     short ocdacont3

ocdacont4:   mov     word ptr ds:[si-1],2020h
             pop     esi

             mov     di,offset MSG
             mov     cx,136
             mov     al,32
             cld
             rep     stos byte ptr es:[di]

             pop     ecx
             loop    ocdaMLoop

ocdaexit:    pop     ecx
             pop     eax
             pop     edx
             pop     ebx
             pop     ebp
             pop     esi
             pop     edi
             retf
OutCryptData endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure OutAsmCrypt
; Parameters:
;۲۲۲۲۲۲۲۲۲۲۲۲
OutAsmCrypt proc    far
            push    edi
            push    esi
            push    ebp
            push    ebx
            push    edx
            push    eax
            push    ecx

            xor     eax,eax
            xor     esi,esi
            lea     si,hsBuffer
            mov     ax,dbgRealOfs
            add     si,ax                            ; move buffer pointer
            mov     edhCount,ax
            mov     eax,esi
            mov     dword ptr AddrDisAsm,eax

            mov     bh,dWinYTop
            mov     bl,dWinXTop

;--- Main loop --------------------------------------------------------------
oacrMLoop:  push    ebx
;--- Store current address to buffer ----------------------------------------
            push    esi
            mov     eax,dword ptr AddrDisAsm
            lea     si,MSG+8
            mov     byte ptr [si+1],':'
            Call    HexToStr
            pop     esi
;--- Disassemble current instruction ----------------------------------------
            Lea     edi,MSG+11
            lea     ebp,st_asm
            call    Source
            mov     cx,dx
            mov     di,11+offset MSG
            and     edx,0FFFFh
            add     dword ptr AddrDisAsm,edx
            add     edhCount,dx
            add     si,dx

            pop     ebx

;--- Out instruction to screen ----------------------------------------------
            push    esi
            lea     esi,MSG
            mov     ah,byte ptr cDlgText
            cld

oacrcont3:  lodsb
            cmp     al,0
            je      oacrcont4
            Call    OutChar
            inc     bl
            cmp     bl,dWinXBottom
            jae     oacrcont4
            jmp     short oacrcont3

oacrcont4:  mov     word ptr ds:[si-1],2020h
            pop     esi

;--- Clear window after instruction -----------------------------------------
            mov     al,32
            cmp     bl, dWinXBottom
            jae     oacrncont1
            xor     ch,ch
            mov     cl, dWinXBottom
            sub     cl,bl

oacrncont2: Call    OutChar
            inc     bl
            loop    oacrncont2

oacrncont1: inc     bh
            mov     bl,dWinXTop

            mov     di,offset MSG
            mov     cx,136
            cld
            rep     stos byte ptr es:[di]

            mov     ax,word ptr edhCount
            cmp     ax,word ptr dbgBufLen
            jb      oacrcont5

            mov     al,20h
            mov     ah,byte ptr cDlgText

oacrcont6:  cmp     bh,dWinYBottom
            ja      oacrexit

            mov     bl,dWinXTop
            xor     ch,ch
            mov     cl,dWinXBottom
            sub     cl,bl

oacrcont7:  Call    OutChar
            inc     bl
            loop    oacrcont7

            inc     bh
            jmp     short oacrcont6

oacrcont5:  cmp     bh,dWinYBottom
            jbe     oacrMLoop

oacrexit:   pop     ecx
            pop     eax
            pop     edx
            pop     ebx
            pop     ebp
            pop     esi
            pop     edi
            retf
OutAsmCrypt endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure MoveCryptStr
; Parameters:
;۲۲۲۲۲۲۲۲۲۲۲۲
MoveCryptStr proc    far
            push    edi
            push    esi
            push    ebp
            push    ebx
            push    edx
            push    eax
            push    ecx
            std
            lea     si,dbgLines+198
            mov     di,si
            inc     di
            mov     cx,199
            sub     cx,dbgLineNum
            rep     movsb
            cld

            xor     eax,eax
            xor     esi,esi
            lea     si,hsBuffer
            mov     ax,dbgCurOfs
            add     si,ax                            ; move buffer pointer
            mov     edhCount,ax
            mov     eax,esi
            mov     dword ptr AddrDisAsm,eax

            push    si
            lea     si,dbgLines+240
            push    si
            Lea     edi,MSG+11
            lea     ebp,st_asm
            call    Source
            mov     cx,dx
            mov     bx,dbgLineNum
            mov     dbgLines[bx],dl                   ; Store current cmd len
            push    cx
            std
            lea     di,hsBuffer
            add     di,dbgDataOfs
            dec     di
            mov     si,di
            sub     si,dx
            mov     cx,dbgDataOfs
            sub     cx,dbgCurOfs
            sub     cx,dx
            rep     movsb
            pop     cx
            pop     si
            pop     di
            cld
            rep     movsb                             ; Move Instr to buffer
            add     dbgBufLen,dx
            inc     dbgLineMax

mcrsExit:   pop     ecx
            pop     eax
            pop     edx
            pop     ebx
            pop     ebp
            pop     esi
            pop     edi
            retf
MoveCryptStr endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure DelInstr
; Parameters:
;۲۲۲۲۲۲۲۲۲۲۲۲
DelInstr    proc    far
            push    edi
            push    esi
            push    ebp
            push    ebx
            push    edx
            push    eax
            push    ecx

            mov     dx,dbgLineNum
            cmp     dx,dbgLineMax
            je      deinExit
            cmp     dbgLineMax,1
            je      deinOne
            cld
            xor     dx,dx
            lea     si,dbgLines
            add     si,dbgLineNum
            mov     dl,[si]
            mov     di,si
            inc     si
            mov     cx,199
            sub     cx,dbgLineNum
            rep     movsb

            xor     eax,eax
            xor     esi,esi
            lea     si,hsBuffer
            mov     ax,dbgCurOfs
            add     si,ax                            ; move buffer pointer
            mov     di,si
            add     si,dx
            mov     cx,dbgDataOfs
            sub     cx,dbgCurOfs
            sub     cx,dx
            rep     movsb

            sub     dbgBufLen,dx
            dec     dbgLineMax
            jmp     short deinExit

deinOne:    mov     byte ptr hsBuffer,0CBh            ; RET instr.
            mov     byte ptr dbgLines,1
            mov     dbgBufLen,1
            mov     dbgRealOfs,0
            mov     dbgCurOfs,0
            mov     dbgLineNum,0
            mov     dbgLineMax,1
            mov     bh,dWinYTop

deinExit:   pop     ecx
            pop     eax
            pop     edx
            pop     ebx
            pop     ebp
            pop     esi
            pop     edi
            retf
DelInstr    endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure GetCryptStr
; Parameters: bh - line number
;۲۲۲۲۲۲۲۲۲۲۲۲
GetCryptStr   proc    far
              push    dx
              lea     si,BufferName
              mov     bl,dWinXBottom
              dec     bl
              mov     dl,dWinXTop
              add     dl,10

gcsloop:      Call    GetChar
              dec     bl
              cmp     bl,dl
              je      gcsexit
              cmp     al,32
              je      gcsloop

              mov     dl,bl
              add     dl,2
              mov     bl,dWinXTop
              add     bl,11

gcsloop1:     Call    GetChar
              inc     bl
              cmp     bl,dl
              ja      gcsexit
              mov     [si],al
              inc     si
              jmp     gcsloop1

gcsexit:      mov     byte ptr [si],0
              pop     dx
              retf
GetCryptStr   endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure HorLine
; Parameters:
;             bl,al - x1,x2
;             bh    - y
;             ah    - attribut for out
;۲۲۲۲۲۲۲۲۲۲۲۲
HorLine       proc    far
              push    dx
              mov     dl,al
              mov     al,''
              Call    OutChar
              mov     al,''

holiLoop:     inc     bl
              Call    OutChar
              cmp     bl,dl
              jb      holiLoop
              mov     al,''
              Call    OutChar
              pop     dx
              retf
HorLine       endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure HorLineN
; Parameters:
;             bl,al - x1,x2
;             bh    - y
;             ah    - attribut for out
;۲۲۲۲۲۲۲۲۲۲۲۲
HorLineN      proc    far
              push    dx
              mov     dl,al
              mov     al,''

holiLoopN:    Call    OutChar
              inc     bl
              cmp     bl,dl
              jbe     holiLoopN
              pop     dx
              retf
HorLineN      endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure VerLine
; Parameters:
;             bh,al - y1,y2
;             bl    - x
;             ah    - attribut for out
;۲۲۲۲۲۲۲۲۲۲۲۲
VerLine       proc    far
              push    dx
              mov     dl,al
              mov     al,''
              Call    OutChar
              mov     al,''

veliLoop:     inc     bh
              Call    OutChar
              cmp     bh,dl
              jb      veliLoop

              mov     al,''
              Call    OutChar
              pop     dx
              retf
VerLine       endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure VerLineN
; Parameters:
;             bh,al - y1,y2
;             bl    - x
;             ah    - attribut for out
;۲۲۲۲۲۲۲۲۲۲۲۲
VerLineN      proc    far
              push    dx
              mov     dl,al
              mov     al,''

veliLoopN:    Call    OutChar
              inc     bh
              cmp     bh,dl
              jbe     veliLoopN

              pop     dx
              retf
VerLineN      endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure UInitScrBar
; Parameters:
;             bh,al - y1,y2
;             bl    - x
;             ah    - attribut for out
;۲۲۲۲۲۲۲۲۲۲۲۲
UInitScrlBar  proc    far
              push    bx
              push    ax
              push    dx
              mov     dl,al
              push    ax
              mov     al,ah
              shl     ah,4
              shr     al,4
              or      ah,al
              mov     al,''
              Call    OutChar
              pop     ax
              mov     al,''

uisbLoop:     inc     bh
              Call    OutChar
              cmp     bh,dl
              jb      uisbLoop
              mov     al,ah
              shl     ah,4
              shr     al,4
              or      ah,al
              mov     al,''
              Call    OutChar
              pop     dx
              pop     ax
              pop     bx
              retf
UInitScrlBar  endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure UScrlBarPos
; Parameters:
;             bh,al - y1,y2
;             bl    - x
;             ah    - attribut for out
;             dx    - maximum value
;             cx    - current value
;۲۲۲۲۲۲۲۲۲۲۲۲
UScrlBarPos   proc    far
              Call    UInitScrlBar
              push    ax
              push    dx
              xor     ah,ah
              sub     al,bh
              dec     al
              mul     cx
              pop     cx
              div     cx
              add     bh,al
              pop     ax
              inc     bh
              mov     al,0Ah
              mov     bMouseScrBarBH,bh
              Call    OutChar
              retf
UScrlBarPos   endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure WriteStr
; Parameters:
;             bx    - coordinates
;             ds:si - ASCIIZ string
;             ah    - color (attribut)
;۲۲۲۲۲۲۲۲۲۲۲۲
WriteStr      proc    far
              push    si
              push    bx
              cld

wrstLoop:     lodsb
              cmp     al,0
              je      wrstExit
              Call    OutChar
              inc     bl
              jmp     short wrstLoop

wrstExit:     pop     bx
              pop     si
              retf
WriteStr      endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure WrAttrStr
; Parameters:
;             bx    - coordinates
;             cx    - Length string
;             ah    - color (attribut)
;۲۲۲۲۲۲۲۲۲۲۲۲
WrAttrStr     proc    far
              push    cx
              push    bx

wratstLoop:   Call    OutAttr
              inc     bl
              loop    wratstLoop

              pop     bx
              pop     cx
              retf
WrAttrStr     endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure AsmScrlBar
; Parameters:
;۲۲۲۲۲۲۲۲۲۲۲۲
AsmScrlBar  proc    far
            push    bx
            push    ax
            push    dx
            push    cx
            mov     bx,033Fh
            mov     ah,cDlgScrBar
            mov     al,10h
            mov     dx,dbgLineMax
            inc     dx
            mov     cx,dbgLineNum
            Call    UScrlBarPos
            pop     cx
            pop     dx
            pop     ax
            pop     bx
            retf
AsmScrlBar  endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure DatScrlBar
; Parameters:
;۲۲۲۲۲۲۲۲۲۲۲۲
DatScrlBar  proc    far
            push    bx
            push    ax
            push    dx
            push    cx
            mov     bx,1241h
            mov     dx,1024
            sub     dx,dbgDataOfs
            inc     dx
            mov     cx,dbgCurDataOfs
            sub     cx,dbgDataOfs
            mov     ah,cDlgScrBar
            mov     al,15h
            Call    UScrlBarPos
            pop     cx
            pop     dx
            pop     ax
            pop     bx
            retf
DatScrlBar  endp
;۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure Debugger
; Parameters:
;۲۲۲۲۲۲۲۲۲۲۲۲
Debugger    proc    far
            pushad
            push    es
            push    fs
            push    gs

            mov     ax,ds                              ; All segment to DS
            mov     fs,ax
            mov     gs,ax
            mov     es,ax

            mov     byte ptr hsBuffer,0CBh            ; RETF instr.
            mov     byte ptr dbgLines,1
            mov     dbgBufLen,1
            mov     dbgRealOfs,0
            mov     dbgCurOfs,0
            mov     dbgLineNum,0
            mov     dbgLineMax,1
            mov     dbgRunFlag,0
            mov     dbgAsmMode,0
            mov     al,byte ptr SegSize
            mov     byte ptr OldSegSize,al
            mov     byte ptr SegSize,16

            mov     eax,BlockEnd
            cmp     eax,BlockBeg
            jae     dbgBlkMake
            xchg    eax,BlockBeg
            mov     BlockEnd,eax
dbgBlkMake: sub     eax,BlockBeg
            inc     eax
            mov     BlockLen,eax
            cmp     eax,BufferSize
            jbe     dbgBlkCont

            mov     eax,BufferSize
            lea     si,ErrorMsg11+29
            Call    HexToStr
            lea     bp,ErrorMsg11
            Call    OutBlkError
            jmp     dbgExit

dbgBlkCont: mov     bx,0205h
            mov     dx,164Ah
            mov     ah,cDlgBox
            mov     wMouseWinTop,bx
            call    RectWindow

            mov     dWinXTop,06h
            mov     dWinYTop,04h
            mov     dWinYBottom,10h
            mov     dWinXBottom,3Eh
            mov     al,dWinYBottom
            sub     al,dWinYTop
            mov     byte ptr dWinHigh,al

            mov     bx,1105h
            mov     ah,cDlgBox
            mov     al,4Ah
            Call    HorLine

            xor     eax,eax
            mov     ax,offset hsBuffer
            lea     si,tDebugAddr+15
            Call    HexToStr
            mov     ax,offset dbgLines
            dec     ax
            lea     si,tDebugAddr+31
            Call    HexToStr

            mov     bx,1242h
            mov     dx,1650h
            mov     ah,cDlgText
            xor     bp,bp
            lea     si,tDebugAddr
            call    OutString

            mov     bx,033Fh
            mov     ah,cDlgScrBar
            mov     al,10h
            Call    UInitScrlBar

            lea     si,tDebugHdr
            mov     bx,0209h
            mov     ah,cDlgHeader
            Call    WriteStr

            mov     bx,0441h
            mov     dx,0F49h
            mov     ah,cDlgText
            xor     bp,bp
            lea     si,tDebugStr
            call    OutString

            mov     ax,dbgDataOfs
            mov     dbgCurDataOfs,ax

            mov     _ProcValue,1
            mov     bh,dWinYTop
            mov     dbgYPos,bh

; Assembler editor ۲۲۲۲۲۲۲۲۲
dbgAsmEdit: mov     bx,023Fh
            mov     ah,cDlgBox
            mov     al,11h
            Call    VerLine

            lea     bx,MouRecDbgAsm
            mov     wMouseHlpRecOfs,bx

            mov     bx,1141h
            mov     ah,cDlgBox
            mov     al,16h
            Call    VerLine
            mov     word ptr wMouseInBox,0205h
            mov     word ptr wMouseInBox+2,113Fh
            mov     bMouseScrBarY1,03h
            mov     bMouseScrBarY2,10h
            mov     bMouseScrBarX,3Fh

            lea     si,hDebugAsm
            Call    OutHlpLine

            Call    HideCursor

            mov     bh,dbgYPos

dbgMLoop:   Call    OutCryptData
            Call    OutCryptParm
            Call    AsmScrlBar
            Call    OutAsmCrypt
            Call    GetCryptStr
            mov     bl,dWinXTop
            add     bl,11
            mov     dl,dWinXBottom
            sub     dl,dWinXTop
            sub     dl,12
            lea     si,BufferName
            mov     bMouseBoxCursY,bh
            Call    My_StRead
            jc      dbgExit

            cmp     byte ptr _QuitKey,0
            je      dbgAssemble

            cmp     _QuitKey,254                   ; Mouse pressed
            jne     dbgNxtKey
            Call    MouseDbg1Work
            cmp     ax,0
            je      dbgMLoop
            cmp     ax,011Bh
            je      dbgExit
            mov     _QuitKey,ah

dbgNxtKey:  cmp     byte ptr _QuitKey,80
            jne     dbgNxtKey1
            mov     ax,dbgLineMax
            dec     ax
            cmp     dbgLineNum,ax
            jae     dbgMLoop
            inc     bh
            cmp     bh,dWinYBottom
            jbe     dbgKeyDn
            dec     bh
            push    bx
            mov     bx,dbgLineNum
            sub     bx,word ptr dWinHigh
            xor     ah,ah
            mov     al,dbgLines[bx]
            pop     bx
            add     dbgRealOfs,ax
dbgKeyDn:   push    bx
            mov     bx,dbgLineNum
            xor     ah,ah
            mov     al,dbgLines[bx]
            pop     bx
            add     dbgCurOfs,ax
            inc     dbgLineNum
            jmp     dbgMLoop

dbgNxtKey1: cmp     byte ptr _QuitKey,72
            jne     dbgNxtKey2
            cmp     dbgLineNum,0
            je      dbgMLoop
            dec     bh
            dec     dbgLineNum
            cmp     bh,dWinYTop
            jae     dbgKeyUp
            inc     bh
            push    bx
            mov     bx,dbgLineNum
            xor     ah,ah
            mov     al,dbgLines[bx]
            pop     bx
            sub     dbgRealOfs,ax
dbgKeyUp:   push    bx
            mov     bx,dbgLineNum
            xor     ah,ah
            mov     al,dbgLines[bx]
            pop     bx
            sub     dbgCurOfs,ax
            jmp     dbgMLoop

;--- Save crypt file --------------------------------------------------------
dbgNxtKey2: cmp     byte ptr _QuitKey,60               ; F2 - Save
            jne     dbgNxtKey3
            mov     dbgYPos,bh
            Call    SaveCrypt
            jnc     dbgMLoop
            lea     bp,ErrorMsg4
            jmp     dbgAsmErrO

;--- Load crypt file --------------------------------------------------------
dbgNxtKey3: cmp     byte ptr _QuitKey,61               ; F3 - Load
            jne     dbgNxtKey4
            Call    LoadCrypt
            jnc     dbgLoad
            lea     bp,ErrorMsg4
            jmp     dbgAsmErrO

dbgLoad:    mov     bh,dbgYPos
            jmp     dbgMLoop

;--- Goto addr in rountime --------------------------------------------------
dbgNxtKey4: cmp     byte ptr _QuitKey,63               ; F5 - Goto
            jne     dbgNxtKey5
            Call    GetCryptAddr
            jc      dbgMLoop
            mov     cx,offset hsBuffer
            cmp     ax,cx
            jb      dbgAdrErr
            add     cx,dbgBufLen
            cmp     ax,cx
            jae     dbgAdrErr
            mov     cx,ax
            sub     cx,offset hsBuffer
            lea     si,dbgLines
            mov     dbgCurOfs,0
            mov     dbgLineNum,0
            xor     ax,ax
            cld

dbgAdrLoop: cmp     dbgCurOfs,cx
            jae     dbgAdrExit
            lodsb
            add     dbgCurOfs,ax
            inc     dbgLineNum
            jmp     dbgAdrLoop

dbgAdrExit: mov     cx,dbgBufLen
            cmp     dbgCurOfs,cx
            jb      dbgAdrMake
            sub     dbgCurOfs,ax
            dec     dbgLineNum
dbgAdrMake: mov     ax,dbgCurOfs
            mov     dbgRealOfs,ax
            mov     bh,dWinYTop
            jmp     dbgMLoop

dbgAdrErr:  lea     bp,ErrorMsg10
            jmp     dbgAsmErrO

;--- Erase procedure --------------------------------------------------------
dbgNxtKey5: cmp     byte ptr _QuitKey,64               ; F6 - ClearProc
            jne     dbgNxtKey6
dbgClrProc: mov     byte ptr hsBuffer,0CBh            ; RET instr.
            mov     byte ptr dbgLines,1
            mov     dbgBufLen,1
            mov     dbgRealOfs,0
            mov     dbgCurOfs,0
            mov     dbgLineNum,0
            mov     dbgLineMax,1
            mov     bh,dWinYTop
            jmp     dbgMLoop

;--- Clear data area --------------------------------------------------------
dbgNxtKey6: cmp     byte ptr _QuitKey,65               ; F7 - ClearData
            jne     dbgNxtKey7
            lea     di,hsBuffer
            add     di,dbgDataOfs
            mov     cx,1024
            sub     cx,dbgDataOfs
            cld
            xor     al,al
            rep     stosb
            jmp     dbgMLoop

;--- Delete current instruction ---------------------------------------------
dbgNxtKey7: cmp     byte ptr _QuitKey,66               ; F8 - Delete instruction
            jne     dbgNxtKey8
            Call    DelInstr
            jmp     dbgMLoop

;--- Run crypt procedure ----------------------------------------------------
dbgNxtKey8: cmp     byte ptr _QuitKey,67               ; F9 - Run
            jne     dbgNxtKey9
            mov     dbgRunFlag,1
            jmp     dbgExit

;--- Change data offset -----------------------------------------------------
dbgNxtKey9: cmp     byte ptr _QuitKey,62               ; F4 - DataOfs
            jne     dbgNxtKey10
            Call    GetDataAddr
            jc      dbgMLoop
            mov     cx,offset hsBuffer
            add     cx,dbgBufLen
            cmp     ax,cx
            jb      dbgAdrErr
            mov     cx,offset dbgLines
            cmp     ax,cx
            jae     dbgAdrErr
            sub     ax,offset hsBuffer
            mov     dbgDataOfs,ax
            mov     dbgCurDataOfs,ax
            jmp     dbgMLoop

;--- Goto data edit ---------------------------------------------------------
dbgNxtKey10:
            cmp     byte ptr _QuitKey,15               ; TAB - Goto data edit
            jne     dbgNxtKey11
            mov     dbgYPos,bh
            jmp     dbgDatEdit

dbgNxtKey11:
            cmp     byte ptr _QuitKey,104              ; Alt+ F1 - Mode
            jne     dbgNxtKey12
            xor     dbgAsmMode,1
            jmp     dbgMLoop

dbgNxtKey12:
            cmp     byte ptr _QuitKey,59               ; F1 - Help
            jne     dbgNxtKey13
            mov     word ptr wHelpTopic,12
            Call    HlpDialog
            jmp     dbgMLoop

dbgNxtKey13:
            cmp     byte ptr _QuitKey,73               ; PgUp
            jne     dbgNxtKey14
            mov     _QuitKey,72
            jmp     dbgNxtKey

dbgNxtKey14:
            cmp     byte ptr _QuitKey,81               ; PgDn
            jne     dbgNxtKey15
            mov     _QuitKey,80
            jmp     dbgNxtKey

dbgNxtKey15:
            jmp     dbgMLoop
;--- Assemble instruction ---------------------------------------------------
dbgAssemble:
            xor     eax,eax
            lea     si,hsBuffer
            mov     ax,si
            add     ax,dbgCurOfs
            mov     _CurAsmAdr,eax
            lea     si,dbgLines+240                   ; Pointer to tmp buffer
            lea     di,BufferName

            Call    _Assemble
            jc      dbgAsmErr1
;--- Insert new instruction -------------------------------------------------
            cmp     dbgAsmMode,0
            je      dbgAsm1
            Call    DelInstr
dbgAsm1:    Call    MoveCryptStr
            mov     ax,dbgBufLen
            cmp     ax,dbgDataOfs
            ja      dbgAsmErr3
            mov     _QuitKey,80
            jmp     dbgNxtKey
;--- Assemble error out -----------------------------------------------------
dbgAsmErr1: cmp     al,1
            jne     dbgAsmErr2

            lea     bp,ErrorMsg6
dbgAsmErrO: Call    OutBlkError
            jmp     dbgMLoop

dbgAsmErr2: lea     bp,ErrorMsg7
            jmp     dbgAsmErrO

dbgAsmErr3: lea     bp,ErrorMsg9
            jmp     dbgAsmErrO

; Data editor ۲۲۲۲۲۲۲۲۲
dbgDatEdit: mov     bx,023Fh
            mov     ah,cDlgBox
            mov     al,11h
            Call    VerLine

            lea     bx,MouRecDbgDat
            mov     wMouseHlpRecOfs,bx

            mov     bx,1141h
            mov     ah,cDlgBox
            mov     al,16h
            Call    VerLine
            mov     word ptr wMouseInBox,1206h
            mov     word ptr wMouseInBox+2,1540h
            mov     bMouseScrBarY1,12h
            mov     bMouseScrBarY2,15h
            mov     bMouseScrBarX,41h

            lea     si,hDebugDat
            mov     bl,00h
            mov     bh,ScrHigh
            Call    OutHlpLine

            mov     bh,dWinYBottom
            add     bh,2
            mov     bl,dWinXTop
            add     bl,11
            mov     dbgBytePos,0

dbgDLoop:   Call    MoveCursor
            push    bx
            Call    OutCryptData
            Call    OutCryptParm
            Call    DatScrlBar
            Call    OutAsmCrypt
            pop     bx
            mov     bMouseBoxCursY,bh
            mov     bMouseBoxCursX,bl
            Call    MouseOn
            Call    ReadKey
            cmp     ax,0FE00h                      ; Mouse pressed
            jne     dbgDKeyb
            Call    MouseDbg2Work
            cmp     ax,0
            je      dbgDLoop

dbgDKeyb:   Call     MouseOff
            cmp      al,0
            je       dbgExtKey                    ; ext key pressed
            cmp      ah,15
            je       dbgAsmEdit                   ; Tab pressed
            cmp      al,1Bh
            je       dbgExit                      ; ESC pressed

            Call     AsciiToHex
            jc       dbgDLoop
            lea      si,hsBuffer
            add      si,dbgCurDataOfs
            push     bx
            push     ax
            sub      bh,dWinYBottom
            sub      bh,2
            mov      di,bx
            shr      di,4
            and      di,0F0h
            add      si,di
            sub      bl,dWinXTop
            sub      bl,11
            xor      ax,ax
            mov      al,bl
            mov      bl,3
            div      bl
            xor      ah,ah
            add      si,ax
            pop      ax
            pop      bx
            cmp      dbgBytePos,0
            je       dbgInput
            and      byte ptr [si],0F0h
            or       [si],ah
            jmp      dbgMoveRight

dbgInput:   and      byte ptr [si],0Fh
            shl      ah,4
            or       [si],ah
            jmp      dbgMoveRight

;--- Extended key pressed ---------------------------------------------------
dbgExtKey:  cmp     ah,80
            jne     dbgExtKey1
dbgDnKey:   inc     bh
            cmp     bh,16h
            jb      dbgDLoop
            dec     bh
            lea     di,dbgLines
            sub     di,offset hsBuffer
            sub     di,64
            mov     ax,dbgCurDataOfs
            add     ax,16
            cmp     ax,di
            jae     dbgDLoop
            mov     dbgCurDataOfs,ax
            jmp     dbgDLoop

dbgExtKey1: cmp     ah,72
            jne     dbgExtKey2
dbgUpKey:   dec     bh
            cmp     bh,11h
            ja      dbgDLoop
            inc     bh
            mov     ax,dbgCurDataOfs
            sub     ax,16
            cmp     ax, dbgDataOfs
            jb      dbgDLoop
            mov     dbgCurDataOfs,ax
            jmp     dbgDLoop

dbgExtKey2: cmp     ah,75
            jne     dbgExtKey3
            cmp     byte ptr dbgBytePos,1
            jne     dbgLeft
            dec     dbgBytePos
            dec     bl
            jmp     dbgDLoop

dbgLeft:    inc     dbgBytePos
            sub     bl,2
            cmp     bl,10h
            ja      dbgDLoop
            mov     bl,63
            jmp     dbgUpKey

dbgExtKey3: cmp     ah,77
            jne     dbgExtKey4
dbgMoveRight:
            cmp     byte ptr dbgBytePos,0
            jne     dbgRight
            inc     dbgBytePos
            inc     bl
            jmp     dbgDLoop

dbgRight:   dec     dbgBytePos
            add     bl,2
            cmp     bl,64
            jb      dbgDLoop
            mov     bl,17
            jmp     dbgDnKey

;--- Goto addr in rountime --------------------------------------------------
dbgExtKey4: cmp     ah,63                                   ; F5 - Goto
            jne     dbgExtKey5
            Call    GetCryptAddr
            jc      dbgDLoop
            mov     cx,offset hsBuffer
            add     cx,dbgDataOfs
            cmp     ax,cx
            jb      dbgDAdrErr
            mov     cx,offset dbgLines
            cmp     ax,cx
            jae     dbgDAdrErr
            sub     ax,offset hsBuffer
            mov     dbgCurDataOfs,ax
            mov     bh,dWinYBottom
            add     bh,2
            mov     bl,dWinXTop
            add     bl,11
            mov     dbgBytePos,0
            jmp     dbgDLoop

dbgDAdrErr: lea     bp,ErrorMsg10
            Call    OutBlkError
            jmp     dbgDLoop

dbgExtKey5: cmp     ah,59                                   ; F1 - Help
            jne     dbgExtKey6
            mov     word ptr wHelpTopic,13
            Call    HlpDialog
            jmp     dbgDLoop

dbgExtKey6:
            jmp     dbgDLoop
;۲۲۲۲۲۲۲۲۲۲۲۲۲
;--- Exit from procedure ----------------------------------------------------
dbgExit:    Call    HideCursor
            mov     al,OldSegSize
            mov     byte ptr SegSize,al
            pop     gs
            pop     fs
            pop     es
            popad
            cmp     dbgRunFlag,1
            jne     dbgAbandon
;--- Run crypt procedure ----------------------------------------------------
            push    dword ptr RealOfs
            pushad
            push    ds
            push    fs
            push    gs
            push    es
            mov     eax,BlockBeg
            mov     RealOfs,eax
            Call    FileLoad
            xor     si,si
            mov     cx,word ptr BlockLen
            lea     di,hsBuffer
            add     di,dbgDataOfs
            mov     ax,es
            push    ds
            pop     es
            mov     ds,ax
            cld
            Call    far ptr CryptProc
            cld
            pop     es
            pop     gs
            pop     fs
            pop     ds

            mov     dx,word ptr BlockBeg
            mov     cx,word ptr BlockBeg+2
            Call    DeviceSeek

            mov     cx,word ptr BlockLen
            xor     dx,dx
            push    ds
            push    es
            pop     ds
            Call    DeviceWrite
            pop     ds
            popad
            pop     dword ptr RealOfs
            Call    FileLoad

dbgAbandon: Call    ChangeHelp
            Call    OutToMode
            retf
Debugger    endp
.DATA
;۲۲۲۲۲۲۲۲۲۲۲۲
; Data section
tDebugSave  db      ' Save Crypt As ',0
tDebugLoad  db      ' Load Crypt As ',0
tDebugAddr  db      ' From:',13,10
            db      '00000000',13,10
            db      ' To:',13,10
            db      '00000000',0
tDebugHdr   db      'Proc Crypt(BlkBeg[ds:si],BlkLen[cx],Data[es:di])',3Bh,'far ',0
tDebugStr   db      'BlockBeg',13,10,13,10,13,10
            db      'BlockEnd',13,10,13,10,13,10
            db      'BlockLen',13,10,13,10,13,10
            db      'ProcData',0

tDebugVal   db      '00000000',13,10,13,10,13,10
            db      '00000000',13,10,13,10,13,10
            db      '00000000',13,10,13,10,13,10
            db      '00000000',0

tDebugMode  db      ' Insert ',0
            db      'Override',0

dWinXTop    db      0                         ;\
dWinYTop    db      0                         ; \ Window coordinates for out
dWinXBottom db      0                         ; /
dWinYBottom db      0                         ;/
dWinHigh    db      0,0                       ; Window high
;--- Variable, where stored in crypt file ----------------------------Begin--
dbgSaveDataBeg  label word
dbgBufLen   dw      1                         ; Current crypt program length
dbgRealOfs  dw      0                         ; Offset to top instr. from win
dbgCurOfs   dw      0                         ; Current offset in buffer
dbgLineNum  dw      0                         ; Number of current string
dbgLineMax  dw      1                         ; Number of lines
dbgDataOfs  dw      832                       ; Data offset from buffer begin
dbgYPos     db      0                         ; Y position
dbgSaveDataEnd label word
dbgSaveDataLen      equ dbgSaveDataEnd - dbgSaveDataBeg
;--- Variable, where stored in crypt file ----------------------------End----
OldSegSize  db      0
dbgCurDataOfs dw    0                          ; Current data offset
dbgBytePos  db      0                          ; Position in edit byte
dbgRunFlag  db      0                          ; Run crypt procedure if =1
dbgAsmMode  db      0                          ; 0 - Insert, 1 - Override