;۲۲۲۲۲۲۲۲۲۲۲۲
;۲۲              QView Module             ޱ۲۲۲
;۲۲        (c) Copyright  1995-2006       ް۲۲۲
;۲۲           AGCProduct ۲         ޱ۲۲۲
;۲۲۲                   by                  ޲۲۲
;۲۲             Alexandr Gazko            ۲۲۲
;۲۲            ver. 2.91  beta            ޲۲۲۲
;۲۲۲۲۲۲۲۲۲۲۲۲

.CODE CODE1
;*************************************************************************
; Procedure Dec2Str
; Parameters:
;             eax   - dec value to convert
;             ds:si - pointer to output buffer
; Return:
;             ds:si - result
;*************************************************************************
Dec2Str     proc    far
            push    edx
            push    eax
            push    ecx
            push    edi
            push    ebx

            mov     bl,0
            cmp     eax,0
            jge     d2sCont                      ; Value >= 0
            mov     bl,'-'
            neg     eax

d2sCont:    xor     edx,edx
            xor     edi,edi
            mov     cx,10
            mov     di,cx
            add     si,11
            mov     byte ptr [si],0

d2sloop:    div     edi
            add     dl,30h
            dec     si
            mov     [si],dl
            xor     edx,edx
            cmp     eax,0
            jne     d2sloop

            cmp     bl,0
            je      d2sexit
            dec     si
            mov     [si],bl

d2sexit:    pop     ebx
            pop     edi
            pop     ecx
            pop     eax
            pop     edx
            retf
Dec2Str     endp
;*************************************************************************
; Procedure Chr2Str
; Parameters:
;           eax - chr value to decode
;         es:si - pointer to output buffer
; Return:
;         es:si - result
;*************************************************************************
Chr2Str     proc    far
            push    bx
            push    cx
            add     si,4
            mov     byte ptr [si],0
c2sloop:    dec     si
            mov     byte ptr es:[si],al
            shr     eax,8
            cmp     eax,0
            jne     c2sloop
            pop     cx
            pop     bx
            retf
Chr2Str     endp
;*************************************************************************
; Procedure Bin2Str
; Parameters:
;           eax - bin value to decode
;         es:si - pointer to output buffer
; Return:
;         es:si - result
;*************************************************************************
Bin2Str     proc    far
            push    bx
            push    cx
            push    dx
            add     si,32
            mov     byte ptr [si],0
b2sloop:    shr     eax,1
            mov     dl,30h
            adc     dl,0
            dec     si
            mov     byte ptr es:[si],dl
            cmp     eax,0
            jne     b2sloop
            pop     dx
            pop     cx
            pop     bx
            retf
Bin2Str     endp
;*************************************************************************
; Procedure Oct2Str
; Parameters:
;           eax - oct value to decode
;         es:si - pointer to output buffer
; Return:
;         es:si - result
;*************************************************************************
Oct2Str     proc    far
            push    bx
            push    cx
            add     si,11
            mov     byte ptr [si],0
o2sloop:    push    eax
            and     al,07h
            add     al,30h
            dec     si
            mov     byte ptr es:[si],al
            pop     eax
            shr     eax,3
            cmp     eax,0
            jne     o2sloop
            pop     cx
            pop     bx
            retf
Oct2Str     endp
;*************************************************************************
; Procedure Hex2Str
; Parameters:
;           eax - hex value to decode
;         es:si - pointer to output buffer
; Return:
;         es:si - result
;*************************************************************************
Hex2Str     proc    far
            push    bx
            push    cx
            add     si,8
            mov     byte ptr [si],0
            lea     bx,HexTable
h2sloop:    push    eax
            and     al,0Fh
            xlat
            dec     si
            mov     byte ptr es:[si],al
            pop     eax
            shr     eax,4
            cmp     eax,0
            jne     h2sloop
            pop     cx
            pop     bx
            retf
Hex2Str     endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure CalcStrClear
; Parameters:
;             ds:si - pointer to asciiz string
;             ah    - attribut for output
;             bx    - coordinates
;۲۲۲۲۲۲۲۲۲۲۲۲۲
CalcStrClear     proc    far
csclLoop:        lodsb
                 cmp     al,0
                 je      csclClear
                 Call    OutChar
                 inc     bl
                 jmp     short csclLoop

csclClear:       mov     al,20h
csclClrLoop:     cmp     bl,40h                    ; Right position for cls
                 ja      csclExit
                 Call    OutChar
                 inc     bl
                 jmp     short csclClrLoop
csclExit:        retf
CalcStrClear     endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure ChgCalcParm
;۲۲۲۲۲۲۲۲۲۲۲۲۲
ChgCalcParm      proc    far
                 push    eax
                 push    ebx
                 push    ecx
                 push    edx
                 push    esi
                 push    edi
                 push    ebp
                 push    es

                 cld
                 push    ds
                 pop     es

                 push    bx
                 push    dx
                 push    ax
                 mov     bx,0C0Eh
                 mov     dx,1013h
                 mov     ah, cGrpHeader
                 Call    OutAttrStr

                 mov     bx,0C0Eh
                 mov     dl,13h
                 add     bh,CalcMode
                 mov     dh,bh
                 mov     ah, cGrpHigh
                 Call    OutAttrStr
                 pop     ax
                 pop     dx
                 pop     bx

                 mov     bh,0Ch
                 xor     di,di
                 mov     cx,5

ccpaLoop:        mov     eax,dword ptr CalcResult
                 lea     si,BufStr
                 cmp     di,0
                 jne     ccpaNext1
                 Call    Dec2Str
                 jmp     ccpaOut
ccpaNext1:       cmp     di,1
                 jne     ccpaNext2
                 Call    Hex2Str
                 jmp     ccpaOut
ccpaNext2:       cmp     di,2
                 jne     ccpaNext3
                 Call    Oct2Str
                 jmp     ccpaOut
ccpaNext3:       cmp     di,3
                 jne     ccpaNext4
                 Call    Bin2Str
                 jmp     ccpaOut
ccpaNext4:       Call    Chr2Str
ccpaOut:         mov     bl,13h
                 mov     ah,cGrpTxt
                 Call    CalcStrClear
                 inc     bh
                 inc     di
                 loop    ccpaLoop

                 pop     es
                 pop     ebp
                 pop     edi
                 pop     esi
                 pop     edx
                 pop     ecx
                 pop     ebx
                 pop     eax
                 retf
ChgCalcParm      endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure _IsDelim
; Parmeters: al - char from string
; Return:    CF - if delimiter
;۲۲۲۲۲۲۲۲۲۲۲۲۲
_IsDelim         proc    far
                 push    cx
                 push    di
                 mov     cx,13
                 lea     di,OperStr
isdeLoop:        cmp     al,[di]
                 je      isdeOperFound
                 inc     di
                 loop    isdeLoop
                 jmp     isdeNext                ; Not operation
isdeOperFound:   stc
                 jmp     isdeExit
isdeNext:        cmp     al,0
                 je      isdeOperFound
                 clc
isdeExit:        pop     di
                 pop     cx
                 retf
_IsDelim         endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure _GetToken
;۲۲۲۲۲۲۲۲۲۲۲۲۲
_GetToken        proc    far
                 push    eax
                 push    ecx
                 push    esi
                 push    edi

                 mov     byte ptr TokenType,0
                 mov     byte ptr Token,0

                 lea     si,Token
                 cmp     byte ptr ds:[bp],0      ; End of string
                 jne     gettCont1
                 mov     byte ptr Token,0
                 mov     byte ptr TokenType,1    ; Delimiter
                 jmp     gettExit

gettCont1:       mov     al,ds:[bp]
                 mov     cx,13
                 lea     di,OperStr
gettLoop1:       cmp     al,[di]
                 je      gettOperFound
                 inc     di
                 loop    gettLoop1
                 jmp     gettCont2               ; Not operation

gettOperFound:   mov     [si],al
                 inc     si
                 inc     bp
                 cmp     al,'<'
                 jne     gettOper1
                 cmp     al,ds:[bp]
                 jne     gettExit                ; Error
                 inc     bp
                 jmp     gettOper2

gettOper1:       cmp     al,'>'
                 jne     gettOper2
                 cmp     al,ds:[bp]
                 jne     gettExit                ; Error
                 inc     bp

gettOper2:       mov     byte ptr [si],0
                 mov     byte ptr TokenType,1    ; Delimiter
                 jmp     gettExit

gettCont2:       Call    AsciiToHex
                 jc      gettExit
                 mov     byte ptr TokenType,2    ; Number

gettNumberLoop:  mov     [si],al
                 inc     si
                 inc     bp
                 mov     al,ds:[bp]
                 Call    _IsDelim
                 jnc     gettNumberLoop
                 mov     byte ptr Tok,0
                 mov     al,[si-1]
                 cmp     al,'0'
                 jb      gettNumbError
                 cmp     al,'9'
                 jbe     gettNumbExit
                 mov     Tok,al
                 cmp     al,'B'
                 je      gettNumbExit0
                 cmp     al,'O'
                 je      gettNumbExit0
                 cmp     al,'H'
                 je      gettNumbExit0
                 cmp     al,'D'
                 je      gettNumbExit0
                 mov     byte ptr Tok,0
                 cmp     CalcMode,1                 ; Hex mode ?
                 jne     gettNumbError
                 cmp     al,'A'
                 jb      gettNumbError
                 cmp     al,'F'
                 jbe     gettNumbExit
                 jmp     gettNumbError
gettNumbExit0:   mov     byte ptr [si-1],0
gettNumbExit:    mov     byte ptr [si],0
                 jmp     gettExit

gettNumbError:   mov     byte ptr TokenType,2
                 mov     byte ptr Tok,0FFh
                 jmp     gettNumbExit

gettExit:        pop     edi
                 pop     esi
                 pop     ecx
                 pop     eax
                 retf
_GetToken        endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure _CalcLevel1                        Operation: '+', '-'
; Parameters: ss:sp+2 - pointer to result (dword)
;۲۲۲۲۲۲۲۲۲۲۲۲۲
_CalcLevel1      proc    far
                 push    eax                   ; Store eax to stack
                 push    dword ptr 0           ; dd TmpResult
                 mov     bx,sp
                 add     bx,12                 ; Scip TmpResult+RetAddr+eax
                 mov     si,word ptr ss:[bx]
                 push    si                    ; Store to stack result addr
                 Call    _CalcLevel2

_cal1Loop:       mov     al,byte ptr Token
                 cmp     al,'+'
                 je      _cal1Work
                 cmp     al,'-'
                 je      _cal1Work
                 jmp     short _cal1Exit

_cal1Work:       Call    _GetToken
                 push    sp
                 Call    _CalcLevel2
                 mov     bx,sp
                 add     bx,12                 ; Scip TmpResult+RetAddr+eax
                 mov     si,word ptr ss:[bx]
                 push    sp                    ; Store to stack TmpResult addr
                 push    si                    ; Store to stack result addr
                 Call    _Arith                ; Run operation in al
                 jmp     short _cal1Loop

_cal1Exit:       pop     eax                   ; Delete TmpResult from stack
                 pop     eax                   ; Restore eax
                 retf     2                     ; Return with restore stack
_CalcLevel1      endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure _CalcLevel2                    Operation: '*', '/','%','&','|','^'
; Parameters: ss:sp+2 - pointer to result (dword)
;۲۲۲۲۲۲۲۲۲۲۲۲۲
_CalcLevel2      proc    far
                 push    eax                   ; Store eax to stack
                 push    dword ptr 0           ; dd TmpResult
                 mov     bx,sp
                 add     bx,12                 ; Scip TmpResult+RetAddr+eax
                 mov     si,word ptr ss:[bx]
                 push    si                    ; Store to stack result addr
                 Call    _CalcLevel3

_cal2Loop:       mov     al,byte ptr Token
                 cmp     al,'*'
                 je      _cal2Work
                 cmp     al,'/'
                 je      _cal2Work
                 cmp     al,'&'
                 je      _cal2Work
                 cmp     al,'|'
                 je      _cal2Work
                 cmp     al,'^'
                 je      _cal2Work
                 cmp     al,'%'
                 je      _cal2Work
                 jmp     short _cal2Exit

_cal2Work:       Call    _GetToken
                 push    sp
                 Call    _CalcLevel3
                 mov     bx,sp
                 add     bx,12                 ; Scip TmpResult+RetAddr+eax
                 mov     si,word ptr ss:[bx]
                 push    sp                    ; Store to stack TmpResult addr
                 push    si                    ; Store to stack result addr
                 Call    _Arith                ; Run operation in al
                 jmp     short _cal2Loop

_cal2Exit:       pop     eax                   ; Delete TmpResult from stack
                 pop     eax                   ; Restore eax
                 retf     2                     ; Return with restore stack
_CalcLevel2      endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure _CalcLevel3                        Operation: '<<', '>>'
; Parameters: ss:sp+2 - pointer to result (dword)
;۲۲۲۲۲۲۲۲۲۲۲۲۲
_CalcLevel3      proc    far
                 push    eax                   ; Store eax to stack
                 push    dword ptr 0           ; dd TmpResult
                 mov     bx,sp
                 add     bx,12                 ; Scip TmpResult+RetAddr+eax
                 mov     si,word ptr ss:[bx]
                 push    si                    ; Store to stack result addr
                 Call    _CalcLevel4

_cal3Loop:       mov     al,byte ptr Token
                 cmp     al,'<'
                 je      _cal3Work
                 cmp     al,'>'
                 je      _cal3Work
                 jmp     short _cal3Exit

_cal3Work:       Call    _GetToken
                 push    sp
                 Call    _CalcLevel4
                 mov     bx,sp
                 add     bx,12                 ; Scip TmpResult+RetAddr+eax
                 mov     si,word ptr ss:[bx]
                 push    sp                    ; Store to stack TmpResult addr
                 push    si                    ; Store to stack result addr
                 Call    _Arith                ; Run operation in al
                 jmp     short _cal3Loop

_cal3Exit:       pop     eax                   ; Delete TmpResult from stack
                 pop     eax                   ; Restore eax
                 retf     2                     ; Return with restore stack
_CalcLevel3      endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure _CalcLevel4                        Operation: '~','+','-' unary
; Parameters: ss:sp+2 - pointer to result (dword)
;۲۲۲۲۲۲۲۲۲۲۲۲۲
_CalcLevel4      proc    far
                 push    eax                   ; Store eax to stack

                 xor     al,al
                 cmp     TokenType,1           ; Delimiter
                 jne     _cal4Get
                 mov     al,byte ptr Token
                 cmp     al,'+'
                 je      _cal4Work
                 cmp     al,'-'
                 je      _cal4Work
                 cmp     al,'~'
                 je      _cal4Work
                 jmp     short _cal4Get

_cal4Work:       Call    _GetToken
_cal4Get:        mov     bx,sp
                 add     bx,8                  ; Scip RetAddr+eax
                 mov     si,word ptr ss:[bx]
                 push    si                    ; Store to stack result addr
                 Call    _CalcLevel5

                 cmp     al,0
                 je      _cal4Exit
                 mov     bx,sp
                 add     bx,8                  ; Scip RetAddr+eax
                 mov     si,word ptr ss:[bx]
                 push    si                    ; Store to stack result addr
                 Call    _Unary

_cal4Exit:       pop     eax                   ; Restore eax
                 retf     2                     ; Return with restore stack
_CalcLevel4      endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure _CalcLevel5                        Operation: '~','+','-' unary
; Parameters: ss:sp+2 - pointer to result (dword)
;۲۲۲۲۲۲۲۲۲۲۲۲۲
_CalcLevel5      proc    far
                 push    eax                   ; Store eax to stack

                 cmp     TokenType,1           ; Delimiter
                 jne     _cal5Primitive
                 cmp     byte ptr Token,'('
                 jne     _cal5Primitive

                 Call    _GetToken
                 mov     bx,sp
                 add     bx,8                  ; Scip RetAddr+eax
                 mov     si,word ptr ss:[bx]
                 push    si                    ; Store to stack result addr
                 Call    _CalcLevel1

                 cmp     byte ptr Token,')'
                 je      _cal5Next
                 mov     al,2                  ; Not found ')'
                 jmp     calcError             ; Jmp to OutError with SP rest

_cal5Next:       Call    _GetToken
                 jmp     _cal5Exit

_cal5Primitive:  mov     bx,sp
                 add     bx,8                  ; Scip RetAddr+eax
                 mov     si,word ptr ss:[bx]
                 push    si                    ; Store to stack result addr
                 Call    _Primitive

_cal5Exit:       pop     eax                   ; Restore eax
                 retf     2                     ; Return with restore stack
_CalcLevel5      endp

;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure _Primitive                         Operation: Number value return
; Parameters: ss:sp+2 - pointer to result (dword)
;۲۲۲۲۲۲۲۲۲۲۲۲۲
_Primitive       proc    far
                 push    ax                    ; Store eax to stack
                 push    si
                 mov     si,sp
                 add     si,8                  ; Scip RetAddr+eax
                 mov     bx,word ptr ss:[si]   ; bx <- Result address

                 mov     al,TokenType
                 cmp     al,2                  ; Number
                 je      _primNumber
                 mov     al,0                  ; Syntax error
                 jmp     calcError             ; Jmp to OutError with SP rest

_primNumber:     Call    _GetNumber
                 Call    _GetToken

_primExit:       pop     si                    ; Delete TmpResult from stack
                 pop     ax                    ; Restore eax
                 retf     2                     ; Return with restore stack
_Primitive       endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure _GetNumber                         Operation: Token -> result
; Parameters: Token - pointer to number (ASCIIZ string format)
;             ss:bx - pointer to dword result value
;             Tok   - last char from ASCIIZ string
;۲۲۲۲۲۲۲۲۲۲۲۲۲
_GetNumber       proc    far
                 push    di
                 push    si
                 push    eax
                 push    edx

                 xor     edx,edx
                 xor     eax,eax
                 lea     si,Token
                 cld
                 cmp     byte ptr Tok,0
                 je      _genuAnalis                ; default mode
                 cmp     byte ptr Tok,'H'           ; Hex mode
                 je      _genuHLoop
                 cmp     byte ptr Tok,'D'           ; Dec mode
                 je      _genuDLoop
                 cmp     byte ptr Tok,'O'           ; Oct mode
                 je      _genuOLoop
                 cmp     byte ptr Tok,'B'           ; Bin mode
                 je      _genuBLoop
                 jmp     _genuError

_genuAnalis:     cmp     CalcMode,0                 ; Dec mode
                 jne     _genuNext
_genuDLoop:      lodsb
                 cmp     al,0
                 je      _genuExit
                 cmp     al,'0'
                 jb      _genuError
                 cmp     al,'9'
                 ja      _genuError
                 sub     al,'0'
                 push    ecx
                 push    eax
                 mov     eax,edx
                 xor     edx,edx
                 mov     ecx,10
                 mul     ecx
                 mov     edx,eax
                 pop     eax
                 pop     ecx
                 add     edx,eax
                 jmp     _genuDLoop

_genuNext:       cmp     CalcMode,1                 ; Hex mode
                 jne     _genuNext1
_genuHLoop:      lodsb
                 cmp     al,0
                 je      _genuExit
                 shl     edx,4
                 Call    AsciiToHex
                 jc      _genuError
                 or      dl,ah
                 jmp     _genuHLoop

_genuNext1:      cmp     CalcMode,2                 ; Oct mode
                 jne     _genuNext2
_genuOLoop:      lodsb
                 cmp     al,0
                 je      _genuExit
                 cmp     al,'0'
                 jb      _genuError
                 cmp     al,'7'
                 ja      _genuError
                 sub     al,'0'
                 shl     edx,3
                 add     edx,eax
                 jmp     _genuOLoop

_genuNext2:      cmp     CalcMode,3                 ; Bin mode
                 jne     _genuError
_genuBLoop:      lodsb
                 cmp     al,0
                 je      _genuExit
                 cmp     al,'0'
                 jb      _genuError
                 cmp     al,'1'
                 ja      _genuError
                 sub     al,'0'
                 shl     edx,1
                 add     edx,eax
                 jmp     _genuBLoop

_genuError:      mov     al,1                  ; Number syntax error
                 jmp     calcError             ; Jmp to OutError with SP rest

_genuExit:       mov     dword ptr ss:[bx],edx
                 pop     edx
                 pop     eax
                 pop     si
                 pop     di
                 retf
_GetNumber       endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure AnalisError
; Parameters:  al - error number
;۲۲۲۲۲۲۲۲۲۲۲۲۲
AnalisError proc    far
            push    es
            push    si
            push    bp
            push    bx
            push    ax
            push    dx

            push    ds
            pop     es

            cmp     al,0
            jne     _anerNext
            lea     bp,CalcErrorMsg
            jmp     short _anerOut

_anerNext:  cmp     al,1
            jne     _anerNext1
            lea     bp,CalcErrorMsg1
            jmp     short _anerOut

_anerNext1: cmp     al,2
            jne     _anerNext2
            lea     bp,CalcErrorMsg2
            jmp     short _anerOut

_anerNext2: cmp     al,4
            jne     _anerNext3
            lea     bp,CalcErrorMsg4
            jmp     short _anerOut

_anerNext3: lea     bp,CalcErrorMsg3

_anerOut:   mov     ah,4Eh
            mov     bx,0C1Ch
            mov     dx,0E33h
            Call    RectWindow
            xor     si,si
            mov     ah,4Fh
            mov     bx,0D1Eh
            mov     dx,0E4Eh
            Call    OutString

            Call    MouseOn
            Call    ReadKey

            pop     dx
            pop     ax
            pop     bx
            pop     bp
            pop     si
            pop     es
            retf
AnalisError endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure _Arith
; Parameters:  al      - operation
;              ss:sp+4 - pointer to TmpResult
;              ss:sp+2 - pointer to result
;۲۲۲۲۲۲۲۲۲۲۲۲۲
_Arith      proc    far
            push    eax
            push    edx
            push    si
            push    di
            push    bx

            mov     bx,sp
            add     bx,18
            mov     si,word ptr ss:[bx+2]             ; Pointer to TmpResult
            mov     di,word ptr ss:[bx]               ; Pointer to Result
            mov     edx,dword ptr ss:[di]

            cmp     al,'+'
            jne     _aritNext
            add     edx,dword ptr ss:[si]
            jmp     _aritExit

_aritNext:  cmp     al,'-'
            jne     _aritNext1
            sub     edx,dword ptr ss:[si]
            jmp     _aritExit

_aritNext1: cmp     al,'&'
            jne     _aritNext2
            and     edx,dword ptr ss:[si]
            jmp     _aritExit

_aritNext2: cmp     al,'|'
            jne     _aritNext3
            or      edx,dword ptr ss:[si]
            jmp     _aritExit

_aritNext3: cmp     al,'^'
            jne     _aritNext4
            xor     edx,dword ptr ss:[si]
            jmp     _aritExit

_aritNext4: cmp     al,'*'
            jne     _aritNext5
            mov     eax,dword ptr ss:[si]
            mul     edx
            mov     edx,eax
            jmp     _aritExit

_aritNext5: cmp     al,'/'
            jne     _aritNext6
            mov     eax,edx
            xor     edx,edx
            cmp     dword ptr ss:[si],0
            jne     _aritNext5a
            mov     al,4                  ; Number syntax error
            jmp     calcError             ; Jmp to OutError with SP rest
_aritNext5a:
            div     dword ptr ss:[si]
            mov     edx,eax
            jmp     _aritExit

_aritNext6: cmp     al,'%'
            jne     _aritNext7
            mov     eax,edx
            xor     edx,edx
            div     dword ptr ss:[si]
            jmp     _aritExit

_aritNext7: cmp     al,'<'
            jne     _aritNext8
            push    cx
            mov     cl,byte ptr ss:[si]
            shl     edx,cl
            pop     cx
            jmp     _aritExit

_aritNext8: cmp     al,'>'
            jne     _aritNext9
            push    cx
            mov     cl,byte ptr ss:[si]
            shr     edx,cl
            pop     cx
            jmp     _aritExit

_aritNext9:
_aritExit:  mov     dword ptr ss:[di],edx
            pop     bx
            pop     di
            pop     si
            pop     edx
            pop     eax
            retf     4
_Arith      endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure _Unary
; Parameters:  al      - operation
;              ss:sp+2 - pointer to result
;۲۲۲۲۲۲۲۲۲۲۲۲۲
_Unary      proc    far
            push    eax
            push    edx
            push    si
            push    di
            push    bx

            mov     bx,sp
            add     bx,18
            mov     di,word ptr ss:[bx]               ; Pointer to Result
            mov     edx,dword ptr ss:[di]

            cmp     al,'-'
            jne     _unarNext
            neg     edx
            jmp     _unarExit

_unarNext:  cmp     al,'~'
            jne     _unarNext1
            not     edx
            jmp     _unarExit

_unarNext1:
_unarExit:  mov     dword ptr ss:[di],edx
            pop     bx
            pop     di
            pop     si
            pop     edx
            pop     eax
            retf     2
_Unary      endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure Calculate
;۲۲۲۲۲۲۲۲۲۲۲۲۲
Calculate        proc    far
                 push    eax
                 push    ebx
                 push    ecx
                 push    edx
                 push    esi
                 push    edi
                 push    ebp
                 push    es
                 push    gs

                 cld
                 push    ds
                 pop     es
                 push    ds
                 pop     gs

                 lea     di,CalcStr
                 Call    _SpaceSkip               ; Delete spaces from string
                 mov     bp,di                    ; Global pointer to CalcStr
                 mov     _RestSP,sp               ; Store current SP
                 Call    _GetToken
                 cmp     byte ptr Token,0
                 jne     calcBegin
                 mov     al,0                     ; Syntax error
calcError:       Call    AnalisError
                 mov     sp,_RestSP
                 stc
                 jmp     calcAbandon
calcBegin:       push    dword ptr 0
                 push    sp
                 Call    _CalcLevel1              ; Recursive calc
                 pop     dword ptr CalcResult
                 clc
calcAbandon:     pop     gs
                 pop     es
                 pop     ebp
                 pop     edi
                 pop     esi
                 pop     edx
                 pop     ecx
                 pop     ebx
                 pop     eax
                 retf
Calculate        endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure CalcDialog
;۲۲۲۲۲۲۲۲۲۲۲۲۲
CalcDialog  proc    far
            push    ebx
            push    ecx
            push    edx
            push    esi
            push    edi
            push    ebp
            push    fs
            push    gs
            push    es

            push    ds
            pop     es
            mov     bx,080Ch
            mov     dx,1142h
            mov     ah, cDlgBox
            mov     wMouseWinTop,bx
            Call    RectWindow
            mov     bx,0821h
            mov     dx,0A42h
            lea     bp,CalcHeader
            xor     si,si
            mov     ah, cDlgHeader
            Call    OutString
            mov     bx,0A0Eh
            mov     dx,1142h
            lea     bp,CalcData
            xor     si,si
            mov     ah, cDlgText
            Call    OutString
            mov     bx,0C0Eh
            mov     dx,1013h
            mov     ah, cGrpHeader
            mov     word ptr wMouseInBox,0B0Dh
            mov     word ptr wMouseInBox+2,1013h
            Call    OutAttrStr

            lea     bx,MouRecCalc
            mov     wMouseHlpRecOfs,bx

            mov     bx,0C13h
            mov     dx,1040h
            mov     ah, cGrpTxt
            Call    OutAttrStr

            lea     si,hCalculate
            mov     bh,ScrHigh
            mov     bl,00h
            Call    OutHlpLine

            mov     _ProcValue,1

calcLoop:   Call    ChgCalcParm
            mov     bx,0A0Eh
            mov     dl,51
            lea     si,CalcStr

            Call    My_StRead
            jc      calcExit
            cmp     _QuitKey,0
            je      calcEval

            cmp     _QuitKey,254                   ; Mouse pressed
            jne     calcNextK
            Call    MouseCalcWork
            cmp     ax,0
            je      calcLoop
            cmp     ax,011Bh
            je      calcExit
            cmp     ax,1C0Dh
            je      calcEval
            mov     _QuitKey,ah

calcNextK:  cmp     _QuitKey,60                    ; F2 - Dec
            jne     calcNext
            mov     CalcMode,0
            jmp     calcLoop

calcNext:   cmp     _QuitKey,61                    ; F3 - Hex
            jne     calcNext1
            mov     CalcMode,1
            jmp     calcLoop

calcNext1:  cmp     _QuitKey,62                    ; F4 - Oct
            jne     calcNext2
            mov     CalcMode,2
            jmp     calcLoop

calcNext2:  cmp     _QuitKey,63                    ; F5 - Bin
            jne     calcNext3
            mov     CalcMode,3
            jmp     calcLoop

calcNext3:  cmp     _QuitKey,59                    ; F1 - Help
            jne     calcNext4
            mov     word ptr wHelpTopic,14
            Call    HlpDialog
            jmp     calcLoop

calcNext4:  cmp     _QuitKey,32                    ; Alt+'D' - Dec
            jne     calcNext5
            mov     CalcMode,0
            jmp     calcLoop

calcNext5:  cmp     _QuitKey,35                    ; Alt+'H' - Hex
            jne     calcNext6
            mov     CalcMode,1
            jmp     calcLoop

calcNext6:  cmp     _QuitKey,24                    ; Alt+'O' - Oct
            jne     calcNext7
            mov     CalcMode,2
            jmp     calcLoop

calcNext7:  cmp     _QuitKey,48                    ; Alt+'B' - Bin
            jne     calcNext8
            mov     CalcMode,3
            jmp     calcLoop

calcNext8:
            jmp     calcLoop

calcEval:   lea     bx,CalcStr
            Call    StrUpCase
            Call    Calculate
            jmp     calcLoop

;--- Abort input instruction -------------------------------------------------
calcExit:
            pop     es
            pop     gs
            pop     fs
            pop     ebp
            pop     edi
            pop     esi
            pop     edx
            pop     ecx
            pop     ebx
            Call    OutToMode
            retf
CalcDialog  endp
.DATA
;----------------------------------------------------------------------------
; Module data
;----------------------------------------------------------------------------
_RestSP        dw      0
CalcHeader     db      ' Calculator ',0
CalcData       db      '',13,10,13,10
               db      'Dec:',13,10
               db      'Hex:',13,10
               db      'Oct:',13,10
               db      'Bin:',13,10
               db      'Chr:',0
CalcStr        db      52 dup (0)
Token          db      52 dup (0)
OperStr        db      '+-*/&|^%<>~()'
TokenType      db      0
Tok            db      0
CalcResult     dd      0
BufStr         db      33 dup (0)
;ConvProcLst    dw      offset Dec2Str
;               dw      offset Hex2Str
;               dw      offset Oct2Str
;               dw      offset Bin2Str
;               dw      offset Chr2Str
CalcErrorMsg   db      'Syntax error ...',0
CalcErrorMsg1  db      'Number syntax error',0
CalcErrorMsg2  db      'Close ) not found...',0
CalcErrorMsg3  db      'Found error ...',0
CalcErrorMsg4  db      'Division by zero...',0