;۲۲۲۲۲۲۲۲۲۲۲۲
;۲۲              QView Module             ޱ۲۲۲
;۲۲        (c) Copyright  1995-2006       ް۲۲۲
;۲۲           AGCProduct ۲         ޱ۲۲۲
;۲۲۲                   by                  ޲۲۲
;۲۲             Alexandr Gazko            ۲۲۲
;۲۲            ver. 2.91  beta            ޲۲۲۲
;۲۲۲۲۲۲۲۲۲۲۲۲

;*************************************************************************
; Procedure AddByteCache                      string with address to cache
; Parameters: ebp       : long address
;             bChar     : writing char
;             bHexMask  : mask for existing value
;
; Return:     AL        : byte from long address if read Ok
;             CF        : if not found zero string
;*************************************************************************
AddByteCache  proc     far
           push     ebp
           push     edx
           push     bx
           push     cx
           push     eax

           mov      eax,ebp
           mov      bx,ax
           and      bx,07F0h                     ; bx - address WrCacheTag
           shr      eax,10                       ; eax - tag 21 bit
           stc
           rcr      eax,1
           mov      cx,4
abcaLoop:  mov      edx,dword ptr WrCacheTag[bx]
           shl      edx,1                        ; CF - true flag
           jnc      abcaFound
           add      bx,4
           loop     abcaLoop
           pop      eax
           stc
           jmp      short abcaExit

;--- Found zero cache string ------------------------------------------------
abcaFound: mov      dword ptr WrCacheTag[bx],eax ; Store tag field
           shl      bx,2                         ; Cache string address
           push     esi
           push     di
           push     es
           push     ds
           lea      di,WrCacheData
           add      di,bx
           mov      esi,ebp
           and      si,0FFF0h
           sub      esi,RealOfs
           mov      cx,16
           mov      ax,es
           push     ds
           pop      es
           mov      ds,ax
           rep      movsb
           pop      ds
           pop      es
           pop      di
           pop      esi
           and      bp,0Fh                       ; Number of byte in string
           add      bx,bp                        ; add byte offset
           pop      eax
           mov      al,byte ptr WrCacheData[bx]  ; al - byte value
           and      al,bHexMask
           or       al,bChar
           mov      byte ptr WrCacheData[bx],al
           mov      bModify,1
           clc
abcaExit:  pop      cx
           pop      bx
           pop      edx
           pop      ebp
           retf
AddByteCache  endp
;*************************************************************************
; Procedure AppendByte
; Parameters:
;*************************************************************************
AppendByte  proc    far
            push    ax
            push    bx
            push    cx
            push    dx

            mov     bx,word ptr Handle            ; FilePos to end of file
            mov     ax,4202h
            xor     dx,dx
            xor     cx,cx
            int     21h

            mov     ah,40h
            lea     dx,pAddedByte
            mov     cx,1
            int     21h

            inc     FileSize
            mov     eax,dword ptr BufferSize
            cmp     FileSize,eax
            ja      apbyNext
            inc     word ptr EndBuffer
            jmp     short apbyExit

apbyNext:   mov     byte ptr SwapLog,0
            inc     word ptr EndBuffer
            cmp     EndBuffer,eax
            jbe     apbyExit
            dec     word ptr EndBuffer
            Call    Swapper

apbyExit:   Call    OutFileSize
            pop     dx
            pop     cx
            pop     bx
            pop     ax
            retf
AppendByte  endp
;*************************************************************************
; Procedure WriteCache
; Parameters:
;            al        - char
;            OutMode   - view mode (1 or 2)
;            RealOfs   - real offset to buffer in file
;            si        - pointer in buffer
;*************************************************************************
WriteCache proc     far
           push     ebp
           mov      bChar,al                   ; Store char
           mov      bOper,1
           mov      ebp,RealOfs
           add      ebp,esi                    ; Make long address
           cmp      si,word ptr EndBuffer      ; New byte added
           jb       wrcaBegin

           Call     AppendByte

wrcaBegin: mov      bHexMask,0
           cmp      bHexWrite,1                ; Hex input or ascii
           jne      wrcaScan
           Call     AsciiToHex                 ; Convert input char
           jc       wrcaExit
           mov      bChar,ah
           mov      bHexMask,0F0h
           cmp      bHexPos,1                  ; Position in byte
           je       wrcaScan
           shr      bHexMask,4
           shl      bChar,4
wrcaScan:  Call     ScanCache                  ; Scan cache for address
           jnc      wrcaExit
wrcaAdd:   Call     AddByteCache               ; Move current string in cache
           jnc      wrcaExit
           Call     UpdateQuery
           jnc      wrcaAdd
wrcaExit:  pop      ebp
           jc       wrcaOut
           cmp      bHexWrite,0
           je       wrcaMove
           inc      bHexPos
           cmp      bHexPos,1
           ja       wrcaMove
wrcaOut:   Call     OutToMode
           retf
wrcaMove:  mov      ax,4D00h                   ; Move right
           Call     HorScroll
           retf
WriteCache endp
;*************************************************************************
; Procedure ClearCache
; Parameters:  not used
;*************************************************************************
ClearCache   proc    far
             push    es
             push    di
             push    cx
             push    eax
             push    bx
             push    dx
             lea     di,WrCacheTag
             mov     cx,10240
             push    ds
             pop     es
             xor     al,al
             cld
             rep     stosb
             mov     bModify,0
             mov     eax,OldFileSize
             mov     FileSize,eax
             xor     eax,eax
             mov     ax,si
             add     eax,RealOfs
             cmp     eax,FileSize
             jbe     clcaTrunc
             mov     eax,FileSize
             sub     eax,RealOfs
             mov     si,ax
;--- Truncate/padded file to file size --------------------------------------
clcaTrunc:   xor     eax,eax
             mov     cx,word ptr FileSize+2
             mov     dx,word ptr FileSize
             Call    DeviceSeek
             mov     ah,40h
             xor     cx,cx
             Call    DeviceWrite

             Call    OutFileSize
             pop     dx
             pop     bx
             pop     eax
             pop     cx
             pop     di
             pop     es
             retf
ClearCache   endp
;*************************************************************************
; Procedure SaveCache
; Parameters:  not used
;*************************************************************************
SaveCache    proc    far
             cmp     bModify,0
             jne     sacaBegin
             retf
sacaBegin:   push    eax
             push    bx
             push    cx
             push    dx
             push    si
             push    di
;--- Truncate/padded file to file size --------------------------------------
             mov     cx,word ptr FileSize+2
             mov     dx,word ptr FileSize
             Call    DeviceSeek
             xor     cx,cx
             Call    DeviceWrite
;--- Update file from write cache -------------------------------------------
             xor     si,si
             lea     di,WrCacheData
             mov     cx,512                             ; 128*4 strings
sacaLoop:    mov     eax,dword ptr WrCacheTag[si]
             shl     eax,1
             jnc     sacaNext
             shl     eax,10
             and     eax,0FFFFF800h
             mov     dx,si
             and     dx,07F0h
             or      ax,dx
             push    cx
             mov     cx,16
             add     eax,16
             cmp     eax,dword ptr FileSize
             jb      sacaNext1
             push    eax
             sub     eax,dword ptr FileSize
             mov     cx,ax
             sub     cx,16
             neg     cx
             pop     eax
sacaNext1:   push    cx
             sub     eax,16
             mov     dx,ax
             shr     eax,16
             mov     cx,ax
             Call    DeviceSeek

             pop     cx
             mov     dx,di
             Call    DeviceWrite
             pop     cx

sacaNext:    add     si,4
             add     di,16
             loop    sacaLoop

             mov     eax,dword ptr FileSize
             mov     OldFileSize,eax
             pop     di
             pop     si
             pop     dx
             pop     cx
             pop     bx
             pop     eax
             retf
SaveCache    endp
;*************************************************************************
; Procedure PutChanges
; Parameters:  not used
;*************************************************************************
PutChanges   proc    far
             cmp     bModify,0
             jne     puchBegin
puchRet:     retf
puchBegin:   Call    QueryFileName
             jc      puchRet
             push    ax
             push    dx
             push    cx
             mov     ah,3Ch
             lea     dx,hsBuffer
             xor     cx,cx
             int     21h
             mov     wCHandle,ax
             pop     cx
             pop     dx
             pop     ax
             jc      puchRet
             push    eax
             push    bx
             push    cx
             push    dx
             push    si
             push    di

             xor     si,si
             lea     di,WrCacheData
             mov     cx,512                             ; 128*4 strings
             mov     word ptr bCacheBufStr[15],0A0Dh

puchLoop:    mov     eax,dword ptr WrCacheTag[si]
             shl     eax,1                              ;  ⮢୮
             jnc     puchNext
;--- ப 﫠 -----------------------------------------------------
             shl     eax,10
             and     eax,0FFFFF800h
             mov     dx,si
             and     dx,07F0h
             or      ax,dx
             push    cx
             mov     cx,16
             add     eax,16
             cmp     eax,dword ptr FileSize
             jb      puchNext1

             push    eax
             sub     eax,dword ptr FileSize
             mov     cx,ax
             sub     cx,16
             neg     cx
             pop     eax

puchNext1:   push    cx                    ;  CX - ᫮ 뢠 ⮢
             sub     eax,16
             mov     dBaseCacheAdr,eax
             mov     dx,ax
             shr     eax,16
             mov     cx,ax
             Call    DeviceSeek
             pop     cx
             push    cx
             lea     dx,bCacheBuffer
             Call    DeviceRead
             pop     cx

;--- DI - Cache string, CX - length -----------------------------------------
             push    di
             push    si
             lea     bx,bCacheBuffer

puchWrite:   mov     al,[di]
             cmp     al,[bx]
             je      puchWrNext

             push    es

             push    ds
             pop     es
             lea     si,bCacheBufStr+7
             mov     eax,dBaseCacheAdr
             Call    HexToStr
             mov     eax,dBaseCacheAdr
             cmp     eax,dword ptr OldFileSize
             jb      puchOld
             mov     word ptr bCacheBufStr[10],'--'
             jmp     short puchNew

puchOld:     push    di
             mov     al,[bx]
             lea     di,bCacheBufStr+10
             Call    ByteToStr
             pop     di

puchNew:     push    di
             mov     al,[di]
             lea     di,bCacheBufStr+13
             Call    ByteToStr
             pop     di

             pop     es

             push    bx
             push    cx
             push    dx
             mov     bx,wCHandle
             mov     ah,40h
             mov     cx,17
             lea     dx,bCacheBufStr
             int     21h
             pop     dx
             pop     cx
             pop     bx

puchWrNext:  inc     dBaseCacheAdr
             inc     di
             inc     bx
             loop    puchWrite
             pop     si
             pop     di

             pop     cx
;--- 室  ᫥饩 ப ---------------------------------------------
puchNext:    add     si,4
             add     di,16
             dec     cx
             cmp     cx,0
             jne     puchLoop

             mov     bx,wCHandle
             mov     ah,3Eh
             int     21h

             pop     di
             pop     si
             pop     dx
             pop     cx
             pop     bx
             pop     eax
             retf
PutChanges   endp
;*************************************************************************
; Procedure GetCRK
; Parameters:  not used
;*************************************************************************
GetCRK       proc    far
             Call    QueryBaseOffs
             jnc     gcrkStart
gcrkRet:     retf
gcrkStart:   Call    QueryFileName
             jc      gcrkRet
             push    ax
             push    dx
             push    cx
             mov     ax,3D00h
             lea     dx,hsBuffer
             xor     cx,cx
             int     21h
             mov     wCHandle,ax
             pop     cx
             pop     dx
             pop     ax
             jc      gcrkRet

             pushad

             mov     bFirstRead,0
;--- Read .CRK file ---------------------------------------------------------
gcrkLoop:    mov     bx,wCHandle
             mov     ah,3Fh
             mov     cx,17
             lea     dx,bCacheBufStr
             int     21h
             jc      gcrkEndLoop
             cmp     ax,17
             jb      gcrkEndLoop
;--- Check format -----------------------------------------------------------
             mov     cx,8
             lea     si,bCacheBufStr
             xor     edx,edx

gcrkLoopTst: mov     al,[si]
             Call    AsciiToHex
             jc      gcrkAbnormal
             shl     edx,4
             or      dl,ah
             inc     si
             loop    gcrkLoopTst

             cmp     bFirstRead,0
             jne     gcrkNext1
             mov     bFirstRead,1
             mov     dCRKFirstAddr,edx

gcrkNext1:   mov     dCRKCurAddr,edx

             cmp     byte ptr [si],':'
             jne     gcrkAbnormal
             add     si,2

             mov     al,[si]
             Call    AsciiToHex
             jc      gcrkAbnormal
             mov     cl,ah
             shl     cl,4
             inc     si
             mov     al,[si]
             Call    AsciiToHex
             jc      gcrkAbnormal
             or      cl,ah
             mov     bCRKOldByte,cl

             add     si,2
             mov     al,[si]
             Call    AsciiToHex
             jc      gcrkAbnormal
             mov     cl,ah
             shl     cl,4
             inc     si
             mov     al,[si]
             Call    AsciiToHex
             jc      gcrkAbnormal
             or      cl,ah
             mov     bCRKNewByte,cl

;--- Update file ------------------------------------------------------------
             cmp     dCRKBaseOfs,0
             je      gcrkSeek
             mov     eax,dCRKCurAddr
             sub     eax,dCRKFirstAddr
             add     eax,dCRKBaseOfs
             mov     dCRKCurAddr,eax

gcrkSeek:    mov     dx,word ptr dCRKCurAddr
             mov     cx,word ptr dCRKCurAddr+2
             Call    DeviceSeek

             mov     cx,1
             lea     dx,bCRKRealByte
             Call    DeviceRead

             mov     al,bCRKRealByte
             cmp     al,bCRKOldByte
             jne     gcrkAbnormal

             mov     dx,word ptr dCRKCurAddr
             mov     cx,word ptr dCRKCurAddr+2
             Call    DeviceSeek

             mov     cx,1
             lea     dx,bCRKNewByte
             Call    DeviceWrite
             jmp     gcrkLoop
;--- Abnormal exit ----------------------------------------------------------
gcrkAbnormal:
            mov     ah,4Eh
            mov     bx,0A1Ch
            mov     dx,0C33h
            Call    RectWindow
            lea     si,bCacheBufStr
            mov     byte ptr [si+15],0
            mov     ah,4Fh
            mov     bx,0B1Eh
            Call    WriteStr
            Call    MouseOn
            Call    ReadKey

;--- Exit from rountime -----------------------------------------------------
gcrkEndLoop: mov     bx,wCHandle
             mov     ah,3Eh
             int     21h
             popad
             Call    FileLoad
             Call    OutToMode
             retf
GetCRK       endp
;*************************************************************************
; Procedure UpdateQuery
; Parameters:  not used
; Return:  CF - if review/cansel
;*************************************************************************
UpdateQuery  proc    far
             mov     bTEditEnable,0FFh
             cmp     bModify,0
             jne     upquBegin
             clc
             retf
upquBegin:   push    es
             push    si
             push    bp
             push    bx
             push    dx

             push    ds
             pop     es

             mov     ah,4Eh
             mov     bx,0A15h
             mov     dx,0D3Bh
             mov     wMouseWinTop,bx
             Call    RectWindow
             lea     bp,tUpdateQuery
             xor     si,si
             mov     ah,4Eh
             mov     bx,0B17h
             mov     dx,1D3Bh
             Call    OutString
             Call    MouseOn
upquLoop:    Call    Readkey
             cmp     ax,0FE00h
             jne     upquKeyb
             Call    MouseUpQuWork
upquKeyb:    cmp     al,0
             je      upquLoop
             cmp     ah,1                          ; Esc
             je      upquCansel
             cmp     ah,11h                        ; 'W'rite
             je      upquWrite
             cmp     al,'w'                        ; 'W'rite
             je      upquWrite
             cmp     al,'W'                        ; 'W'rite
             je      upquWrite
             cmp     al,''                        ; 'W'rite
             je      upquWrite
             cmp     al,''                        ; 'W'rite
             je      upquWrite
             cmp     ah,20h                        ; 'D'iscard
             je      upquDiscard
             cmp     al,'d'                        ; 'D'iscard
             je      upquDiscard
             cmp     al,'D'                        ; 'D'iscard
             je      upquDiscard
             cmp     al,''                        ; 'D'iscard
             je      upquDiscard
             cmp     al,''                        ; 'D'iscard
             je      upquDiscard
             cmp     ah,13h                        ; 'R'eview
             je      upquCansel
             cmp     al,'r'                        ; 'R'eview
             je      upquCansel
             cmp     al,'R'                        ; 'R'eview
             je      upquCansel
             cmp     al,''                        ; 'R'eview
             je      upquCansel
             cmp     al,''                        ; 'R'eview
             je      upquCansel
             jmp     short upquLoop
;--- Cansel/review choose ---------------------------------------------------
upquCansel:  stc
             jmp     short upquExit
;--- Write choose -----------------------------------------------------------
upquWrite:   Call    SaveCache
;--- Discard choose ---------------------------------------------------------
upquDiscard: Call    ClearCache
             clc
;--- Exit from rountime -----------------------------------------------------
upquExit:    pop     dx
             pop     bx
             pop     bp
             pop     si
             pop     es
             pushf
             jc      upquExit1
             Call    FileLoad
upquExit1:   push    eax
             xor     eax,eax
             mov     ax,si
             add     eax,RealOfs
             cmp     eax,FileSize
             jbe     upquExit2
             mov     eax,FileSize
             sub     eax,RealOfs
             mov     si,ax
upquExit2:   pop     eax
             Call    OutToMode
             popf
             retf
UpdateQuery  endp
;*************************************************************************
; Procedure RemoveCache                     string with address from cache
; Parameters: ebp       : long address
;             bChar     : old char
;*************************************************************************
RemoveCache proc     far
           push     ebp
           push     edx
           push     bx
           push     cx
           push     eax

           mov      eax,ebp
           mov      bx,ax
           and      bx,07F0h                     ; bx - address WrCacheTag
           shr      eax,10                       ; eax - tag 21 bit
           stc
           rcr      eax,1
           mov      cx,4
recaLoop:  mov      edx,dword ptr WrCacheTag[bx]
           cmp      edx,eax                      ; CF - true flag
           je       recaFound
           add      bx,4
           loop     recaLoop
           pop      eax
           jmp      recaExit

;--- Found zero cache string ------------------------------------------------
recaFound: shl      bx,2                         ; Cache string address

           push     bx
           push     bp
           and      bp,0Fh                       ; Number of byte in string
           add      bx,bp                        ; add byte offset
           mov      al,bChar
           mov      byte ptr WrCacheData[bx],al
           pop      bp
           pop      bx

           push     esi
           push     di
           push     es
           push     ds
           cld
           lea      di,WrCacheData
           add      di,bx
           mov      esi,ebp
           and      si,0FFF0h
           sub      esi,RealOfs
           mov      cx,16
           mov      ax,es
           push     ds
           pop      es
           mov      ds,ax
           repe     cmpsb
           cmp      cx,0
           pop      ds
           pop      es
           pop      di
           pop      esi
           pop      eax
           jne      recaExit
           shr      bx,2
           mov      dword ptr WrCacheTag[bx],0  ; Store tag field
           mov      cx,512
           xor      bx,bx
recaLoop1: mov      edx,dword ptr WrCacheTag[bx]
           shl      edx,1                        ; CF - true flag
           jc       recaExit
           add      bx,4
           loop     recaLoop1
           mov      bModify,0

recaExit:  pop      cx
           pop      bx
           pop      edx
           pop      ebp
           retf
RemoveCache endp
;*************************************************************************
; Procedure UndoCurByte
; Parameters: si - position in buffer
;*************************************************************************
UndoCurByte proc    far
            cmp     bModify,0
            je      ucbyAbort
            cmp     si,word ptr EndBuffer
            jae     ucbyAbort
            mov     al,fs:[si]
            mov     bChar,al
            push    ebp
            xor     ebp,ebp
            mov     bp,si
            add     ebp,RealOfs
            Call    RemoveCache
            pop     ebp
            mov     ax,4D00h
            Call    HorScroll
ucbyAbort:  retf
UndoCurByte endp
;*************************************************************************
; Procedure UndoByteBS
; Parameters: si - position in buffer
;*************************************************************************
UndoByteBS  proc    far
            mov     ax,4B00h
            Call    HorScroll
            cmp     bModify,0
            je      ubybsAbort
            cmp     si,word ptr EndBuffer
            jae     ubybsAbort
            mov     al,fs:[si]
            mov     bChar,al
            push    ebp
            xor     ebp,ebp
            mov     bp,si
            add     ebp,RealOfs
            Call    RemoveCache
            pop     ebp
            Call    OutToMode
ubybsAbort: retf
UndoByteBS endp
