;۲۲۲۲۲۲۲۲۲۲۲۲
;۲۲            Assembler module           ޱ۲۲۲
;۲۲         (c) Copyright  1995-96        ް۲۲۲
;۲۲          AGC  Product ۲        ޱ۲۲۲
;۲۲۲                   by                  ޲۲۲
;۲۲             Alexandr Gazko            ۲۲۲
;۲۲            ver. 1.90  beta            ޲۲۲۲
;۲۲۲۲۲۲۲۲۲۲۲۲

                 include   asm486t.inc
.CODE
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure _GetSegPrefix
; Parameters:
;             DS:SI - analys string

; Return:
;             CF    - error
;             _aSEG = 0 - invalid
;             _aSEG = 1 - far call/jmp segment found
;             _aSEG = prefix
;
;۲۲۲۲۲۲۲۲۲۲۲۲۲
_GetSegPrefix    proc      far
                 push      di
                 push      bx
                 push      es
                 push      cx
                 push      ds
                 pop       es
                 xor       bx,bx
                 mov       cx,3

_gsploop:        mov       di,word ptr segments_table[bx]
                 add       bx,2
                 cmp       bx,seg_tablelen
                 jbe       _gspcont1
                 mov       al,[si]
                 Call      AsciiToHex
                 jc        _gspcont2
                 mov       byte ptr _aSEG,1
                 xor       cx,cx
                 push      si
_gspcloop:       lodsb
                 Call      AsciiToHex
                 jc        _gspcont3
                 shl       cx,4
                 or        cl,ah
                 jmp       _gspcloop
_gspcont3:       pop       si
                 mov       word ptr _farJmpSeg,cx
                 clc
                 jmp       _gspexit
_gspcont2:       mov       byte ptr _aSEG,0
                 stc
                 jmp       _gspexit                    ; Prefix not found

_gspcont1:       push      si
                 push      cx
                 repe      cmpsb
                 pop       cx
                 pop       si
                 jne       _gsploop
                 inc       di
                 mov       cl,[di]
                 mov       _aSEG,cl
                 clc
_gspexit:        pop       cx
                 pop       es
                 pop       bx
                 pop       di
                 retf
_getSegPrefix    endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure _CmpAttrSet
; Parameters:
;             DS:SI - analys string

; Return:
;             DS:SI - new pointer to string
;             _aW = 0 - byte ptr
;                   1 - word ptr
;                   3 - dword ptr
;                   4 - default
;                   5 - pword ptr
;
;۲۲۲۲۲۲۲۲۲۲۲۲۲
_CmpAttrSet      proc      far
                 push      ax
                 push      es
                 push      di
                 push      si
                 mov       byte ptr _aW,4
                 push      gs
                 pop       es
                 lea       di,_Attributes
                 mov       cx,7
                 repe      cmpsb
                 jne       _casnext
                 mov       byte ptr _aW,0
                 pop       di
                 push      si
                 jmp       _casexit
_casnext:        mov       cx,7
                 pop       si
                 push      si
                 lea       di,_Attributes+7
                 repe      cmpsb
                 jne       _casnext1
                 mov       byte ptr _aW,1
                 pop       di
                 push      si
                 jmp       _casexit

_casnext1:       mov       cx,8
                 pop       si
                 push      si
                 lea       di,_Attributes+14
                 repe      cmpsb
                 jne       _casnext2
                 mov       byte ptr _aW,3
                 pop       di
                 push      si
                 jmp       _casexit

_casnext2:       mov       cx,8
                 pop       si
                 push      si
                 lea       di,_Attributes+22
                 repe      cmpsb
                 jne       _casexit
                 mov       byte ptr _aW,5
                 pop       di
                 push      si

_casexit:        pop       si
                 pop       di
                 pop       es
                 pop       ax
                 retf
_CmpAttrSet      endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure _GetRegisters
; Parameters:
;             DS:SI - string
;
; Return:    CF if error
;
;۲۲۲۲۲۲۲۲۲۲۲۲۲
_GetRegisters    proc      far
; Base registers                    Segment registers    Special registers
; ~~~~~~~~~~~~~~                    ~~~~~~~~~~~~~~~~~    ~~~~~~~~~~~~~~~~~
; EAX ECX EDX EBX ESP EBP ESI EDI   CS DS SS ES FS GS    Control: CR0 etc
; AX  CX  DX  BX  SP  BP  SI  DI                         Debug  : DR0 etc
; AL  CL  DL  BL  AH  CH  DH  BH                         Test   : TR0 etc
                 push      si
                 push      di
                 push      es
                 push      cx
                 cld
                 push      ax
                 mov       al,_aW
                 mov       _aWTmp,al
                 pop       ax
                 mov       byte ptr _aW,4
                 mov       byte ptr _RegsType,0      ; No correct type
                 mov       byte ptr _RegsData,0      ; Cod of regs
                 cmp       byte ptr [si+1],'S'
                 jne       _greptmp1
                 cmp       byte ptr [si+2],0
                 je        _gregSegReg               ; Segment regs
_greptmp1:       cmp       byte ptr [si],'E'
                 je        _greg32reg                ; EAX,ECX, etc
                 cmp       byte ptr [si+1],'R'
                 je        _gregSpecial              ; Special regs
                 jmp       _gregBaseRegs             ; Base regs
;--- EAX,ECX, .... ------------------------------------------------------------
_greg32reg:      cmp       byte ptr [si+2],'H'
                 je        _gregError
                 cmp       byte ptr [si+2],'L'
                 je        _gregError
                 mov       byte ptr _RegsType,1
                 inc       si
                 mov       byte ptr _aW,3
                 jmp       _gregBaseRegs1

_gregBaseRegs:   mov       byte ptr _aW,1
_gregBaseRegs1:  inc       byte ptr _RegsType
                 lea       di,_sBaseRegs
                 mov       ax,[si]
                 xor       cx,cx
_gregloop1:      cmp       ax,[di]
                 je        _gregcont1
                 inc       cx
                 add       di,2
                 cmp       cx,16
                 jb        _gregloop1
                 jmp       _gregError
_gregcont1:      cmp       cx,8
                 jb        _gregcont2
                 sub       cx,8
                 mov       byte ptr _aW,0
_gregcont2:      mov       _RegsData,cl
                 jmp       _gregexit
;--- CS,DS, .... --------------------------------------------------------------
_gregSegReg:     mov       byte ptr _RegsType,3
                 mov       al,[si]                     ; CS DS SS ES FS GS
                 mov       cx,6
                 lea       di,_sSegRegs
                 repne     scasb
                 jne       _gregError
                 mov       ax,di
                 sub       ax,offset _sSegRegs
                 dec       ax
                 mov       _RegsData,al
                 jmp       _gregexit
;--- Special registers --------------------------------------------------------
_gregSpecial:    mov       byte ptr _RegsType,4
                 mov       al,[si+2]
                 Call      AsciiToHex
                 jc        _gregError
                 mov       _RegsData,ah
                 cmp       byte ptr [si],'C'
                 jne       _gregSpecial1
                 mov       byte ptr _SpecialRegs,0
                 jmp       _gregexit
_gregSpecial1:   cmp       byte ptr [si],'D'
                 jne       _gregSpecial2
                 mov       byte ptr _SpecialRegs,1
                 jmp       _gregexit
_gregSpecial2:   cmp       byte ptr [si],'T'
                 jne       _gregSpecial3
                 mov       byte ptr _SpecialRegs,4
                 jmp       _gregexit
_gregSpecial3:   jmp       _gregError
;--- Exit - error -------------------------------------------------------------
_gregError:      mov       byte ptr _RegsType,0
                 push      ax
                 mov       al,_aWTmp
                 mov       _aW,al
                 pop       ax
                 stc
                 jmp       _gregexit1
;--- Exit - normal ------------------------------------------------------------
_gregexit:       clc
_gregexit1:      pop       cx
                 pop       es
                 pop       di
                 pop       si
                 retf
_GetRegisters    endp

;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure _GetImmConst
; Parameters:
;             DS:SI - string
;
; Return:    CF if error
;
;۲۲۲۲۲۲۲۲۲۲۲۲۲
_GetImmConst     proc      far
                 push      si
                 push      di
                 push      es
                 push      ecx
                 xor       ecx,ecx
                 mov       al,[si]
                 Call      AsciiToHex
                 jc        _gimcError
_gimcloop:       lodsb
                 Call      AsciiToHex
                 jc        _gimcexit
                 shl       ecx,4
                 or        cl,ah
                 jmp       _gimcloop
;--- Exit - error -------------------------------------------------------------
_gimcError:      stc
                 jmp       _gimcexit1
;--- Exit - normal ------------------------------------------------------------
_gimcexit:       mov       _ImmConst,ecx
                 clc
_gimcexit1:      pop       ecx
                 pop       es
                 pop       di
                 pop       si
                 retf
_GetImmConst     endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure _GetRel1632
; Parameters:
;             DS:SI - string
;
; Return:    CF if error
;
;۲۲۲۲۲۲۲۲۲۲۲۲۲
_GetRel1632      proc      far
                 push      si
                 push      di
                 push      es
                 push      ecx
                 xor       ecx,ecx
                 mov       al,[si]
                 Call      AsciiToHex
                 jc        _grelError
_grelloop:       lodsb
                 Call      AsciiToHex
                 jc        _grelexit
                 shl       ecx,4
                 or        cl,ah
                 jmp       _grelloop
;--- Exit - error -------------------------------------------------------------
_grelError:      stc
                 jmp       _grelexit1
;--- Exit - normal ------------------------------------------------------------
_grelexit:       mov       _farJmpOfs,ecx
                 clc
_grelexit1:      pop       ecx
                 pop       es
                 pop       di
                 pop       si
                 retf
_GetRel1632      endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure _Get32RegCode
; Parameters:
;             DS:SI - string
;
; Return:    CF if error
;            AL Code
;۲۲۲۲۲۲۲۲۲۲۲۲۲
_Get32RegCode    proc      far
                 push      cx
                 push      di
                 cmp       byte ptr [si],'E'
                 jne       _g32rcError
                 mov       ax,[si+1]
                 mov       cx,8
                 lea       di,_sBaseRegs
_g32rcloop:      cmp       ax,[di]
                 je        _g32rcFound
                 add       di,2
                 loop      _g32rcloop
                 jmp       _g32rcError
;--- Found register -----------------------------------------------------------
_g32rcFound:     mov       ax,8
                 sub       ax,cx
                 add       si,3
                 jmp       _g32rcExit
;--- Exit with error ----------------------------------------------------------
_g32rcError:     stc
                 jmp       _g32rcExit1
;--- Normal exit --------------------------------------------------------------
_g32rcExit:      clc
_g32rcExit1:     pop       di
                 pop       cx
                 retf
_Get32RegCode    endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure _Get32Disp
; Parameters:
;             DS:SI - string
;
; Return:    CF if error
;۲۲۲۲۲۲۲۲۲۲۲۲۲
_Get32Disp       proc      far
                 push      ecx
                 push      edx
                 xor       ecx,ecx
                 xor       dx,dx
_g32d16loop3:    lodsb                                  ; Get constant
                 inc       dx
                 Call      AsciiToHex
                 jc        _g32d16next1
                 shl       ecx,4
                 or        cl,ah
                 jmp       _g32d16loop3

_g32d16next1:    cmp       byte ptr _NegPresent,0
                 je        _g32d16temp2
                 neg       ecx
_g32d16temp2:    mov       _DispConst,ecx
                 cmp       byte ptr [si-1],']'
                 jne       _g32dError
                 cmp       dx,3
                 ja        _g32d16next2
                 mov       byte ptr _DispSize,1           ; Byte offset
                 or        byte ptr _ModRM,01000000b
                 jmp       _g32dExit
_g32d16next2:    mov       byte ptr _DispSize,4           ; DWord offset
                 or        byte ptr _ModRM,10000000b
                 jmp       _g32dExit
;--- Exit with error ----------------------------------------------------------
_g32dError:      stc
                 jmp       _g32dExit1
;--- Normal exit --------------------------------------------------------------
_g32dExit:       clc
_g32dExit1:      pop       edx
                 pop       ecx
                 retf
_Get32Disp       endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure _GetRMAnalis
; Parameters:
;             DS:SI - string
;
; Return:    CF if error
;
;۲۲۲۲۲۲۲۲۲۲۲۲۲
_GetRMAnalis     proc      far
                 push      dx
                 push      di
                 push      es
                 push      ecx
                 mov       byte ptr _aAdr,16               ; 16 -16 bit, 32 - 32 bit
                 mov       dword ptr _DispConst,0
                 mov       byte ptr _DispSize,0           ; No Disp
                 mov       byte ptr _NegPresent,0
                 inc       si                             ; Skip '['
                 Call      _Get32RegCode
                 jnc       _grma32regs
                 cmp       byte ptr [si+1],']'
                 jne       _grmatemp1
                 mov       al,[si]                      ; First char analis
                 Call      AsciiToHex
                 jnc       _grmaDispCont
                 jmp       _grmaError
_grmatemp1:      mov       al,[si+1]                      ; First char analis
                 Call      AsciiToHex
                 jnc       _grmaDispCont
;--- 16 bit address -----------------------------------------------------------
                 mov       byte ptr _aAdr,16
                 lea       di,_sModRM16
                 push      ds
                 pop       es
                 mov       dx,0500h

_grma16loop1:    push      si
                 push      di
                 mov       cx,5
                 repe      cmpsb
                 pop       di
                 pop       si
                 je        _grma16next
                 add       di,5
                 inc       dl
                 cmp       dl,4
                 jb        _grma16loop1

                 mov       dh,2

_grma16loop2:    push      si
                 push      di
                 mov       cx,2
                 repe      cmpsb
                 pop       di
                 pop       si
                 je        _grma16next
                 add       di,2
                 inc       dl
                 cmp       dl,8
                 jb        _grma16loop2
                 jmp       _grmaError                   ; Not Found - Error !

_grma16next:     mov       byte ptr _ModRM,dl           ; DL - R/M
                 shr       dx,8
                 add       si,dx
                 cmp       byte ptr [si],']'
                 je        _grmaExit
                 cmp       byte ptr [si],'-'
                 jne       _grma16temp1
                 mov       byte ptr _NegPresent,1
                 jmp       _grma16temp1a
_grma16temp1:    cmp       byte ptr [si],'+'
                 jne       _grmaError
_grma16temp1a:
                 inc       si
                 xor       ecx,ecx
                 xor       dx,dx
_grma16loop3:    lodsb                                  ; Get constant
                 inc       dx
                 Call      AsciiToHex
                 jc        _grma16next1
                 shl       ecx,4
                 or        cl,ah
                 jmp       _grma16loop3

_grma16next1:    cmp       byte ptr _NegPresent,0
                 je        _grma16temp2
                 neg       ecx
_grma16temp2:    mov       _DispConst,ecx
                 cmp       byte ptr [si-1],']'
                 jne       _grmaError
;                 cmp       ecx,0FFFFh
;                 ja        _grmaError
                 cmp       dx,4
                 jae       _grma16next2
                 mov       byte ptr _DispSize,1           ; Byte offset
                 or        byte ptr _ModRM,01000000b
                 jmp       _grmaExit
_grma16next2:    mov       byte ptr _DispSize,2           ; Word offset
                 or        byte ptr _ModRM,10000000b
                 jmp       _grmaExit
;--- 32 bit address -----------------------------------------------------------
_grma32regs:     mov       byte ptr _aAdr,32
                 mov       byte ptr _ModRM,00000000b
                 mov       dh,al
                 cmp       al,4                           ; ESP - only extended
                 je        _grma32ext
                 cmp       byte ptr [si],']'              ; r/m -reg, mod=00
                 jne       _grma32cont
                 mov       _ModRM,al
                 jmp       _grmaExit
_grma32cont:     cmp       byte ptr [si],'-'
                 jne       _grma32temp1
                 mov       byte ptr _NegPresent,1
                 jmp       _grma32temp1a
_grma32temp1:    cmp       byte ptr [si],'+'
                 je        _grma32temp1a
;----------------------------------------------------------------------------
                 cmp       byte ptr [si],'*'
                 jne       _grmaError

                 mov       dword ptr _DispConst,0
                 mov       byte ptr _DispSize,4
                 mov       byte ptr _aAdr,32
                 mov       byte ptr _ModRM,00000100b
                 mov       byte ptr _SIB,00000101b
                 shl       al,3
                 or        byte ptr _SIB,al

                 mov       al,byte ptr [si+1]
                 Call      AsciiToHex
                 jc        _grmaError
                 shr       ah,1
                 cmp       ah,3
                 jb        _grmadcnext2a
                 mov       ah,3
_grmadcnext2a:   shl       ah,6
                 or        byte ptr _SIB,ah
                 jmp       _grmaExit
;----------------------------------------------------------------------------
_grma32temp1a:   inc       si
                 push      si
                 Call      _Get32RegCode
                 pop       si
                 jnc       _grma32ext                      ; with SIB
                 mov       _ModRM,dh
                 Call      _Get32Disp
                 jc        _grmaError
                 jmp       _grmaExit

_grma32ext:      mov       byte ptr _aAdr,32
                 mov       byte ptr _ModRM,00000100b
                 mov       byte ptr _SIB,dh                ; BASE register
                 cmp       dh,4
                 jne       _grma32ext1
                 inc       si
_grma32ext1:     Call      _Get32RegCode
                 jnc       _grma32ext2                     ; Index found
                 or        byte ptr _SIB,00100000b         ; No index reg
                 cmp       byte ptr [si-1],']'
                 je        _grmaExit
                 Call      _Get32Disp
                 jc        _grmaError
                 jmp       _grmaExit
_grma32ext2:     shl       al,3                            ; Make SS-Index-Base
                 or        byte ptr _SIB,al
                 cmp       byte ptr [si],'*'
                 jne       _grma32ext4                     ; No scale found
                 inc       si
                 mov       al,byte ptr [si]
                 Call      AsciiToHex
                 jc        _grmaError
                 shr       ah,1
                 cmp       ah,3
                 jb        _grma32ext3
                 mov       ah,3
_grma32ext3:     shl       ah,6
                 or        byte ptr _SIB,ah
                 inc       si
_grma32ext4:     cmp       byte ptr [si],']'
                 je        _grmaExit
                 cmp       byte ptr [si],'-'
                 jne       _grma32temp2
                 mov       byte ptr _NegPresent,1
                 jmp       _grma32temp2a
_grma32temp2:    cmp       byte ptr [si],'+'
                 jne       _grmaError
_grma32temp2a:
                 inc       si
                 Call      _Get32Disp                      ; Get disp
                 jc        _grmaError
                 jmp       _grmaExit
;--- Found disp16/32 + may by IR*SS--------------------------------------------
_grmaDispCont:   xor       ecx,ecx
                 mov       _DigitCount,0
_grmadcloop:     lodsb
                 Call      AsciiToHex
                 jc        _grmadcnext
                 shl       ecx,4
                 or        cl,ah
                 inc       _DigitCount
                 jmp       _grmadcloop

_grmadcnext:     dec       si
                 mov       _DispConst,ecx
                 mov       al,[si]
                 cmp       al,']'
                 je        _grmadcnext1                     ; Only disp found
                 cmp       al,'+'
                 jne       _grmaError                       ; Illegal operand
; + IR*SS found - 32 bit address
                 mov       byte ptr _DispSize,4
                 inc       si
                 Call      _Get32RegCode
                 jc        _grmaError
                 mov       byte ptr _aAdr,32
                 mov       byte ptr _ModRM,00000100b
                 mov       byte ptr _SIB,00000101b
                 shl       al,3
                 or        byte ptr _SIB,al
                 cmp       byte ptr [si],'*'
                 jne       _grmaExit                     ; No scale found
                 mov       al,byte ptr [si+1]
                 Call      AsciiToHex
                 jc        _grmaError
                 shr       ah,1
                 cmp       ah,3
                 jb        _grmadcnext2
                 mov       ah,3
_grmadcnext2:    shl       ah,6
                 or        byte ptr _SIB,ah
                 jmp       _grmaExit

_grmadcnext1:    mov       byte ptr _aAdr,16
                 mov       byte ptr _ModRM,00000110b
                 mov       byte ptr _DispSize,2
                 cmp       _DigitCount,5
                 jb        _grmaExit
                 mov       byte ptr _aAdr,32
;                mov       byte ptr _ModRM,00000100b
;                mov       byte ptr _SIB,00100101b
                 mov       byte ptr _ModRM,00000101b
                 mov       byte ptr _DispSize,4
                 jmp       _grmaExit
;--- Exit with error ----------------------------------------------------------
_grmaError:      stc
                 jmp       _grmaexit1
;--- Exit with no error -------------------------------------------------------
_grmaExit:       clc
_grmaexit1:      pop       ecx
                 pop       es
                 pop       di
                 pop       dx
                 retf
_GetRMAnalis     endp

;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure _AnalysOp
; Parameters:
;             GS:DI - string
;             AL - code of end operand
;
; Return:    CF if error
;            GS:DI - new pointer to string
;
;۲۲۲۲۲۲۲۲۲۲۲۲۲
_AnalysOp        proc      far
                 push      si
                 push      ds
                 lea       si,_buffer
                 cmp       byte ptr [si],0
                 je        _anoerror
                 Call      _CmpAttrSet
                 cmp       al,2                         ; Segment prefix ?
                 jne       _anonext1
                 Call      _GetSegPrefix
                 jc        _anoerror                    ; Invalid segment prefix
                 Call      _GetWord                     ; Next part of operand
                 lea       si,_buffer
_anonext1:       cmp       al,2
                 je        _anoerror
                 cmp       byte ptr _aSEG,1
                 je        _anoGetRel16_32
                 mov       al,byte ptr [si]
                 cmp       al,'['
                 je        _anoGetRMDisp

;                 Call      AsciiToHex
;                 jnc       _anoGetImm
;--- Register analys (base, segment, special) --------------------------------
                 push      di
                 Call      _GetRegisters
                 pop       di
;                 jc        _anoerror
                 jc       _anoGetImm
                 mov       byte ptr _OpType,0
                 jmp       _anomakeop
;--- Immediate constant found ------------------------------------------------
_anoGetImm:      Call      _GetImmConst
                 jc        _anoerror
                 mov       byte ptr _OpType,1
                 jmp       _anomakeop
;--- Memory operands ---------------------------------------------------------
_anoGetRMDisp:   Call      _GetRMAnalis
                 jc        _anoerror
                 mov       byte ptr _OpType,2
                 jmp       _anomakeop
;--- Relocation 16/32 (in _farJmpSeg segment) -----------------------------------
_anoGetRel16_32: Call      _GetRel1632
                 jc        _anoerror
                 mov       byte ptr _OpType,3
                 jmp       _anomakeop
;--- Make operand info from all flags ----------------------------------------
_anomakeop:      push      di
                 xor       ax,ax
                 mov       al,byte ptr _OpCount
                 mov       si,ax
                 dec       si
                 shl       si,3                             ; *8
                 mov       di,si
                 shl       si,1                             ; *16
                 add       si,di                            ; *24
                 lea       di,_OpArray
                 add       di,si
                 lea       si,_OpFields
                 mov       cx,24
                 cld
                 rep       movsb
                 pop       di
                 clc
                 jmp       _anoexit
_anoerror:       stc
_anoexit:        pop       ds
                 pop       si
                 retf
_AnalysOp        endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure _GetWord
; Parameters:
;             GS:DI - string
;
; Return:    CF if EOF  & al=0
;            GS:DI - new pointer to string
;            AL = 1 - ',' found
;                 2 - ':' found
;
;۲۲۲۲۲۲۲۲۲۲۲۲۲
_GetWord         proc      far
                 push      si
                 lea       si,_buffer
_gewloop:        mov       al,gs:[di]
                 mov       [si],al
                 cmp       al,0
                 je        _geweof
                 cmp       al,','
                 je        _gewcont2
                 cmp       al,':'
                 je        _gewcont3
                 inc       di
                 inc       si
                 jmp       _gewloop

_gewcont3:       mov       al,2
                 jmp       _gewcont4
_gewcont2:       mov       al,1
_gewcont4:       clc
                 inc       di
                 jmp       _gewexit
_geweof:         stc
_gewexit:        mov       byte ptr [si],0
                 pop       si
                 retf
_GetWord         endp

;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure _SpaceSkip
; Parameters:
;             GS:DI - string
;
; Return:    Delete spaceses from string
;
;۲۲۲۲۲۲۲۲۲۲۲۲۲
_SpaceSkip       proc      far
                 push      ds
                 push      si
                 push      cx
                 mov       si,di
                 push      gs
                 pop       ds
                 xor       cx,cx

_spsloop:        mov       al,[si]
                 cmp       al,0
                 je        _spsexit
                 cmp       al,32
                 jne       _spscont1
                 Call      MyDelete
                 jmp       _spsloop
_spscont1:       inc       si
;                 inc       cl
                 jmp       _spsloop

_spsexit:        pop       cx
                 pop       si
                 pop       ds
                 retf
_SpaceSkip       endp

;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure _GetOperands
; Parameters:
;             GS:DI - Address assembing commnad (parameters)
;
; Return:    CF if Error (no operands found)
;            AL operands number
;
;۲۲۲۲۲۲۲۲۲۲۲۲۲
_GetOperands     proc      far
                 push      di
                 push      bx
                 push      si
                 push      cx
                 push      dx
                 push      bp

                 push      di
                 push      cx
                 push      ax
                 lea       di,_OpFields
                 mov       al,0
                 mov       cx,4*24
                 rep       stosb
                 lea       di,_OpFields
                 mov       byte ptr [di],4
                 mov       byte ptr [di+24],4
                 mov       byte ptr [di+2*24],4
                 mov       byte ptr [di+3*24],4
                 pop       ax
                 pop       cx
                 pop       di

                 mov       byte ptr _OpCount,1
                 Call      _SpaceSkip                 ; Delete spaceses
_gtonext:        Call      _GetWord                   ; Copy to _buffer next operand
                 jc        _gtolast                   ; In buffer last oparand
                 Call      _AnalysOp                  ; Analysing operand
                 jc        _gtoexit
                 cmp       byte ptr gs:[di],0
                 je        _gtoexit
                 inc       byte ptr _OpCount
                 jmp       _gtonext
_gtolast:        Call      _AnalysOp
_gtoexit:        pop       bp
                 pop       dx
                 pop       cx
                 pop       si
                 pop       bx
                 pop       di
                 retf
_GetOperands     endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure _MakeCommand
; Parameters:
;             FS:SI - Address of code
;             DS:BX - of table
;
; Return:     CF if Error
;
;۲۲۲۲۲۲۲۲۲۲۲۲۲
_MakeCommand     proc      far
                 lea       di,_OpArray
_mcmdMainLoop:   mov       byte ptr _AdrPrefix,0
                 mov       byte ptr _OpPrefix,0
                 mov       byte ptr _SIBPresent,0
                 mov       byte ptr _SBit,0
                 mov       byte ptr _SBitMask,0
                 mov       byte ptr _WBitSet,0
                 mov       byte ptr _3OpPresent,0
                 mov       byte ptr _SBitNoSet,0
                 mov       byte ptr _NoTypeCheck,0
                 xor       cx,cx
                 mov       al,[bx]                        ; Get first byte
                 cmp       al,41                          ; 40 groups
                 ja        _mcmderror
                 mov       dx,bx
                 cmp       al,0
                 jne       _mcmdgroup1
;--- Group 0 : A,Imm ----------------------------------------------------------
                 cmp       byte ptr _OpCount,2            ; Number of operands
                 je        _mcmd0cont1
_mcmdGoToNext:   xor       cx,cx
                 mov       bx,dx
                 mov       cl,[bx+1]                      ; Next cmd format
                 add       bx,cx
                 add       bx,2
                 jmp       _mcmdMainLoop

_mcmd0cont1:     cmp       [di].__OpType,0                 ; FirstOp analys
                 jne       _mcmdGoToNext
                 cmp       [di].__RegsType,1               ; Base reg ?
                 jb        _mcmdGoToNext
                 cmp       [di].__RegsType,2               ; Ext Base reg ?
                 ja        _mcmdGoToNext
                 cmp       [di].__RegsData,0               ; AL,AX,EAX ?
                 jne       _mcmdGoToNext
                 cmp       [di+24].__OpType,1              ; SecondOp analys
                 jne       _mcmdGoToNext
                 mov       al,[di].__aW
                 and       al,1
                 or        al,[bx+2]
                 mov       fs:[si],al
                 cmp       [di].__aW,0
                 jne       _mcmd0cont2
                 mov       al,byte ptr [di+24].__ImmConst
                 mov       fs:[si+1],al
                 jmp       _mcmdnormal
_mcmd0cont2:     mov       al,[di].__aW
                 and       al,2
                 shl       al,4
                 cmp       al,SegSize
                 je        _mcmd0cont4
                 mov       al,[di].__aW
                 shl       al,4
                 cmp       al,SegSize
                 je        _mcmd0cont3
                 mov       al,fs:[si]
                 mov       byte ptr fs:[si],66h
                 mov       fs:[si+1],al
                 inc       si
_mcmd0cont3:     cmp       [di].__aW,1
                 jne       _mcmd0cont4
                 mov       ax,word ptr [di+24].__ImmConst
                 mov       fs:[si+1],ax
                 jmp       _mcmdnormal
_mcmd0cont4:     cmp       [di].__aW,3
                 jne       _mcmderror
                 mov       eax,[di+24].__ImmConst
                 mov       fs:[si+1],eax
                 jmp       _mcmdnormal

_mcmdgroup1:     cmp       al,1
                 jne       _mcmdgroup2
;--- Group 1 : r/m,imm --------------------------------------------------------
                 cmp       byte ptr _OpCount,2            ; Number of operands
                 jne       _mcmdGoToNext
                 cmp       [di].__OpType,0                 ; Reg ?
                 je        _mcmd1cont1
                 cmp       [di].__OpType,2                 ; Memory ?
                 jne       _mcmdGoToNext
                 mov       al,[di].__ModRM
                 and       al,00000111b
                 cmp       al,00000100b
                 jne       _mcmd1cont0
                 cmp       [di].__aAdr,32
                 jne       _mcmd1cont0
                 mov       byte ptr _SIBPresent,1
_mcmd1cont0:     mov       al,[di].__aAdr
                 cmp       al,SegSize
                 je        _mcmd1cont1a
                 mov       _AdrPrefix,67h
                 jmp       _mcmd1cont1a
_mcmd1cont1:     cmp       [di].__RegsType,1               ; Base reg ?
                 jb        _mcmdGoToNext
                 cmp       [di].__RegsType,2               ; Ext Base reg ?
                 ja        _mcmdGoToNext
                 mov       al,[di].__RegsData              ; al <- reg code
                 or        al,11000000b                    ; al <- mod=11
                 mov       [di].__ModRM,al                 ; ModRM <- al

_mcmd1cont1a:    cmp       [di+24].__OpType,1              ; SecondOp Imm ?
                 jne       _mcmdGoToNext
                 mov       al,[di].__aW                    ; Type conversion
                 and       al,1                            ; w bit <- aW
                 or        al,[bx+2]                       ; al <- COP
                 cmp       byte ptr _SBitNoSet,1
                 je        _mcmd1cont1z
                 cmp       dword ptr [di+24].__ImmConst,0FFh
                 ja        _mcmd1cont1b
                 cmp       byte ptr _SBitMask,1
                 je        _mcmd1cont1b
                 or        al,00000010b                    ; COP <- s bit
_mcmd1cont1z:    mov       byte ptr _SBit,1

_mcmd1cont1b:    cmp       _AdrPrefix,0
                 je        _mcmd1cont1d
                 mov       byte ptr fs:[si],67h
                 inc       si
_mcmd1cont1d:    mov       fs:[si],al                      ; Put COP to buffer
                 cmp       [di].__aW,0                     ; Byte ptr ?
                 jne       _mcmd1cont2
                 cmp       [di].__aSeg,1
                 jbe       _mcmd1cont1e
                 mov       fs:[si+1],al
                 mov       al,[di].__aSeg
                 mov       fs:[si],al
                 inc       si
_mcmd1cont1e:    cmp       byte ptr [bx+1],1               ; Ext COP ?
                 je        _mcmd1cont1c
                 mov       al,[bx+3]
                 or        [di].__ModRM,al                 ; Make Ext COP

_mcmd1cont1c:    mov       al,[di].__ModRM
                 mov       fs:[si+1],al                    ; Put ModRM byte
                 cmp       _SIBPresent,1
                 jne       _mcmd1cont1f
                 mov       al,[di].__SIB
                 mov       fs:[si+2],al
                 inc       si
_mcmd1cont1f:    cmp       [di].__DispSize,0
                 je        _mcmd1cont1g
                 push      eax
                 push      si
                 push      di
                 push      cx
                 xor       cx,cx
                 mov       cl,[di].__DispSize
                 add       si,2
                 mov       eax,[di].__DispConst
                 mov       _DispData,eax
                 lea       di,_DispData
                 xchg      si,di
                 rep       movsb
                 pop       cx
                 pop       di
                 pop       si
                 xor       ax,ax
                 mov       al,[di].__DispSize
                 add       si,ax
                 pop       eax

_mcmd1cont1g:    mov       al,byte ptr [di+24].__ImmConst
                 mov       fs:[si+2],al
                 jmp       _mcmdnormal

_mcmd1cont2:     mov       al,[di].__aW
                 and       al,2
                 shl       al,4
                 cmp       al,SegSize
                 je        _mcmd1cont2a
                 mov       al,[di].__aW
                 shl       al,4
                 cmp       al,SegSize
                 je        _mcmd1cont2a
                 mov       al,fs:[si]
                 mov       byte ptr fs:[si],66h
                 mov       fs:[si+1],al
                 inc       si
_mcmd1cont2a:    cmp       [di].__aSeg,1                    ; Segment prefix ?
                 jbe       _mcmd1cont3
                 mov       al,fs:[si]
                 mov       fs:[si+1],al
                 mov       al,[di].__aSeg
                 mov       fs:[si],al
                 inc       si
_mcmd1cont3:     cmp       [di].__aW,1
                 jne       _mcmd1cont4
                 cmp       byte ptr [bx+1],1
                 je        _mcmd1cont3a
                 mov       al,[bx+3]
                 or        [di].__ModRM,al
_mcmd1cont3a:    mov       al,[di].__ModRM
                 mov       fs:[si+1],al
                 cmp       _SIBPresent,1
                 jne       _mcmd1cont3f
                 mov       al,[di].__SIB
                 mov       fs:[si+2],al
                 inc       si
_mcmd1cont3f:    cmp       [di].__DispSize,0
                 je        _mcmd1cont3g
                 push      eax
                 push      si
                 push      di
                 push      cx
                 xor       cx,cx
                 mov       cl,[di].__DispSize
                 add       si,2
                 mov       eax,[di].__DispConst
                 mov       _DispData,eax
                 lea       di,_DispData
                 xchg      si,di
                 rep       movsb
                 pop       cx
                 pop       di
                 pop       si
                 xor       ax,ax
                 mov       al,[di].__DispSize
                 add       si,ax
                 pop       eax

_mcmd1cont3g:    cmp       byte ptr _SBit,0
                 je        _mcmd1cont3h
                 mov       al,byte ptr [di+24].__ImmConst
                 mov       fs:[si+2],al
                 jmp       _mcmdnormal
_mcmd1cont3h:    mov       ax,word ptr [di+24].__ImmConst
                 mov       fs:[si+2],ax
                 jmp       _mcmdnormal
_mcmd1cont4:     cmp       [di].__aW,3
                 jne       _mcmderror
                 cmp       byte ptr [bx+1],1
                 je        _mcmd1cont4a
                 mov       al,[bx+3]
                 or        [di].__ModRM,al
_mcmd1cont4a:    mov       al,[di].__ModRM
                 mov       fs:[si+1],al
                 cmp       _SIBPresent,1
                 jne       _mcmd1cont4f
                 mov       al,[di].__SIB
                 mov       fs:[si+2],al
                 inc       si
_mcmd1cont4f:    cmp       [di].__DispSize,0
                 je        _mcmd1cont4g
                 push      eax
                 push      si
                 push      di
                 push      cx
                 xor       cx,cx
                 mov       cl,[di].__DispSize
                 add       si,2
                 mov       eax,[di].__DispConst
                 mov       _DispData,eax
                 lea       di,_DispData
                 xchg      si,di
                 rep       movsb
                 pop       cx
                 pop       di
                 pop       si
                 xor       ax,ax
                 mov       al,[di].__DispSize
                 add       si,ax
                 pop       eax

_mcmd1cont4g:    cmp       byte ptr _SBit,0
                 je        _mcmd1cont4h
                 mov       al,byte ptr [di+24].__ImmConst
                 mov       fs:[si+2],al
                 jmp       _mcmdnormal
_mcmd1cont4h:    mov       eax,[di+24].__ImmConst
                 mov       fs:[si+2],eax
                 jmp       _mcmdnormal

_mcmdgroup2:     cmp       al,2
                 jne       _mcmdgroup3
;--- Group 2 : r/m,r ---------------------------------------------------------
                 cmp       byte ptr _OpCount,2            ; Number of operands
                 jne       _mcmdGoToNext
                 cmp       [di].__OpType,0                 ; Reg ?
                 je        _mcmd2cont1
                 cmp       [di].__OpType,2                 ; Memory ?
                 jne       _mcmdGoToNext
                 mov       al,[di].__ModRM
                 and       al,00000111b
                 cmp       al,00000100b
                 jne       _mcmd2cont0
                 cmp       [di].__aAdr,32
                 jne       _mcmd2cont0
                 mov       byte ptr _SIBPresent,1
_mcmd2cont0:     mov       al,[di].__aAdr
                 cmp       al,SegSize
                 je        _mcmd2cont1a
                 mov       _AdrPrefix,67h
                 jmp       _mcmd2cont1a
_mcmd2cont1:     cmp       [di].__RegsType,1               ; Base reg ?
                 jb        _mcmdGoToNext
                 cmp       [di].__RegsType,2               ; Ext Base reg ?
                 ja        _mcmdGoToNext
                 mov       al,[di].__RegsData              ; al <- reg code
                 or        al,11000000b                    ; al <- mod=11
                 mov       [di].__ModRM,al                 ; ModRM <- al

_mcmd2cont1a:    cmp       [di+24].__OpType,0              ; SecondOp Reg ?
                 jne       _mcmdGoToNext
                 cmp       [di+24].__RegsType,1            ; Base reg ?
                 jb        _mcmdGoToNext
                 cmp       [di+24].__RegsType,2            ; Ext Base reg ?
                 ja        _mcmdGoToNext
                 mov       al,[di].__aW
                 cmp       al,4
                 jne       _mcmd2cont1b
                 mov       al,[di+24].__aW
                 mov       [di].__aW,al
_mcmd2cont1b:    cmp       al,[di+24].__aW
                 jne       _mcmdGoToNext                   ; Type mismath
                 cmp       _AdrPrefix,0
                 je        _mcmd2cont1d
                 mov       byte ptr fs:[si],67h
                 inc       si
_mcmd2cont1d:    cmp       [di].__aW,0
                 je        _mcmd2cont2a
                 mov       al,[di].__aW
                 and       al,2
                 shl       al,4
                 cmp       al,SegSize
                 je        _mcmd2cont2a
                 mov       al,[di].__aW
                 shl       al,4
                 cmp       al,SegSize
                 je        _mcmd2cont2a
                 mov       byte ptr fs:[si],66h
                 inc       si

_mcmd2cont2a:    cmp       [di].__aSeg,1
                 jbe       _mcmd2cont1e
                 mov       al,[di].__aSeg
                 mov       fs:[si],al
                 inc       si
_mcmd2cont1e:    cmp       byte ptr [bx+2],0Fh
                 jne       _mcmd2cont1b1
                 mov       byte ptr fs:[si],0Fh
                 inc       bx
                 inc       si
_mcmd2cont1b1:   cmp       byte ptr _WBitSet,0
                 je        _mcmd2cont1t
                 mov       al,[bx+2]
                 jmp       _mcmd2cont1q
_mcmd2cont1t:    mov       al,[di].__aW                    ; Type conversion
                 and       al,1                            ; w bit <- aW
                 or        al,[bx+2]                       ; al <- COP
_mcmd2cont1q:    mov       fs:[si],al                      ; Put COP to buffer
                 mov       al,[di+24].__RegsData
                 shl       al,3
                 or        al,[di].__ModRM
                 mov       fs:[si+1],al                    ; Put ModRM byte
                 cmp       _SIBPresent,1
                 jne       _mcmd2cont1f
                 mov       al,[di].__SIB
                 mov       fs:[si+2],al
                 inc       si
_mcmd2cont1f:    cmp       [di].__DispSize,0
                 je        _mcmd2cont4
                 push      eax
                 push      si
                 push      di
                 push      cx
                 xor       cx,cx
                 mov       cl,[di].__DispSize
                 add       si,2
                 mov       eax,[di].__DispConst
                 mov       _DispData,eax
                 lea       di,_DispData
                 xchg      si,di
                 rep       movsb
                 pop       cx
                 pop       di
                 pop       si
                 xor       ax,ax
                 mov       al,[di].__DispSize
                 add       si,ax
                 pop       eax
_mcmd2cont4:     cmp       byte ptr _3OpPresent,0        ; 3 Op present ?
                 je        _mcmdnormal
                 mov       al,byte ptr [di+24*2].__ImmConst
                 mov       fs:[si+2],al
                 jmp       _mcmdnormal

_mcmdgroup3:     cmp       al,3
                 jne       _mcmdgroup4
;--- Group 3 : r/m16/32,r16/32 ------------------------------------------------
                 cmp       [di+24].__aW,0
                 je        _mcmdGotoNext
                 mov       byte ptr _WBitSet,1
                 mov       al,2
                 jmp       _mcmdgroup2

_mcmdgroup4:     cmp       al,4
                 jne       _mcmdgroup5
;--- Group 4 : r16/32,r/m16/32 ------------------------------------------------
                 cmp       [di].__aW,0
                 je        _mcmdGotoNext
                 mov       byte ptr _WBitSet,1
                 mov       al,11
                 jmp       _mcmdgroup11

_mcmdgroup5:     cmp       al,5
                 jne       _mcmdgroup6
;--- Group 5 : +reg32 ---------------------------------------------------------
                 cmp       byte ptr _OpCount,1            ; Number of operands
                 jne       _mcmdGoToNext
                 cmp       [di].__OpType,0                 ; Reg ?
                 jne       _mcmdGoToNext
                 cmp       [di].__RegsType,2               ; Ext Base reg ?
                 jne       _mcmdGoToNext
                 mov       al,[bx+2]
                 cmp       al,0Fh
                 jne       _mcmd5cont1
                 mov       byte ptr fs:[si],0Fh
                 inc       si
                 inc       bx
_mcmd5cont1:     mov       al,[bx+2]
                 or        al,[di].__RegsData
                 mov       fs:[si],al
                 jmp       _mcmdnormal

_mcmdgroup6:     cmp       al,6
                 jne       _mcmdgroup7
;--- Group 6 : r/m1632,im8-----------------------------------------------------
                 cmp       byte ptr _OpCount,2            ; Number of operands
                 jne       _mcmdGoToNext
                 cmp       [di].__OpType,0                 ; Reg ?
                 je        _mcmd6cont1
                 cmp       [di].__OpType,2                 ; Memory ?
                 jne       _mcmdGoToNext
                 mov       al,[di].__ModRM
                 and       al,00000111b
                 cmp       al,00000100b
                 jne       _mcmd6cont0
                 cmp       [di].__aAdr,32
                 jne       _mcmd6cont0
                 mov       byte ptr _SIBPresent,1
_mcmd6cont0:     mov       al,[di].__aAdr
                 cmp       al,SegSize
                 je        _mcmd6cont1a
                 mov       _AdrPrefix,67h
                 jmp       _mcmd6cont1a
_mcmd6cont1:     cmp       [di].__RegsType,1               ; Base reg ?
                 jb        _mcmdGoToNext
                 cmp       [di].__RegsType,2               ; Ext Base reg ?
                 ja        _mcmdGoToNext
                 mov       al,[di].__RegsData              ; al <- reg code
                 or        al,11000000b                    ; al <- mod=11
                 mov       [di].__ModRM,al                 ; ModRM <- al

_mcmd6cont1a:    cmp       [di].__aW,0                     ; Byte type ?
                 je        _mcmdGoToNext
                 cmp       [di+24].__OpType,1              ; Imm ?
                 jne       _mcmdGoToNext
                 cmp       dword ptr [di+24].__ImmConst,0FFh         ; Imm8 ?
                 ja        _mcmdGoToNext
                 mov       al,[di].__aW
                 cmp       al,4
                 jne       _mcmd6cont1b
                 mov       al,SegSize
                 shr       al,4
                 or        al,1
                 mov       [di].__aW,al
_mcmd6cont1b:    cmp       _AdrPrefix,0
                 je        _mcmd6cont1d
                 mov       byte ptr fs:[si],67h
                 inc       si
_mcmd6cont1d:    mov       al,[di].__aW
                 and       al,2
                 shl       al,4
                 cmp       al,SegSize
                 je        _mcmd6cont2a
                 mov       al,[di].__aW
                 shl       al,4
                 cmp       al,SegSize
                 je        _mcmd6cont2a
                 mov       byte ptr fs:[si],66h
                 inc       si

_mcmd6cont2a:    cmp       [di].__aSeg,1
                 jbe       _mcmd6cont1e
                 mov       al,[di].__aSeg
                 mov       fs:[si],al
                 inc       si
_mcmd6cont1e:    cmp       byte ptr [bx+2],0Fh
                 jne       _mcmd6cont1b1
                 mov       byte ptr fs:[si],0Fh
                 inc       bx
                 inc       si
_mcmd6cont1b1:   mov       al,[bx+2]
                 mov       fs:[si],al                      ; Put COP to buffer
                 mov       al,[bx+3]                       ; Ext COP
                 or        al,[di].__ModRM
                 mov       fs:[si+1],al                    ; Put ModRM byte
                 cmp       _SIBPresent,1
                 jne       _mcmd6cont1f
                 mov       al,[di].__SIB
                 mov       fs:[si+2],al
                 inc       si
_mcmd6cont1f:    cmp       [di].__DispSize,0
                 je        _mcmd6cont3
                 push      eax
                 push      si
                 push      di
                 push      cx
                 xor       cx,cx
                 mov       cl,[di].__DispSize
                 add       si,2
                 mov       eax,[di].__DispConst
                 mov       _DispData,eax
                 lea       di,_DispData
                 xchg      si,di
                 rep       movsb
                 pop       cx
                 pop       di
                 pop       si
                 xor       ax,ax
                 mov       al,[di].__DispSize
                 add       si,ax
                 pop       eax
_mcmd6cont3:     mov       al,byte ptr [di+24].__ImmConst
                 mov       fs:[si+2],al
                 jmp       _mcmdnormal

_mcmdgroup7:     cmp       al,7
                 jne       _mcmdgroup8
;--- Group 7 : rel16/32 -------------------------------------------------------
                 cmp       byte ptr _OpCount,1            ; Number of operands
                 jne       _mcmdGoToNext
                 cmp       [di].__OpType,1                 ; Imm ?
                 jne       _mcmdGoToNext
                 mov       al,[bx+1]
                 mov       _CmdLen,al
                 mov       al,[bx+2]
                 cmp       al,0Fh
                 jne       _mcmd7cont1
                 mov       byte ptr fs:[si],0Fh
                 inc       si
                 inc       bx
_mcmd7cont1:     mov       al,[bx+2]
                 mov       fs:[si],al
                 cmp       SegSize,16
                 je        _mcmd7cont2
                 add       byte ptr _CmdLen,4
                 xor       eax,eax
                 mov       al,_CmdLen
                 add       eax,_CurAsmAdr
                 push      ecx
                 mov       ecx,dword ptr _ImmConst
                 sub       ecx,eax
                 mov       eax,ecx
                 pop       ecx
                 mov       fs:[si+1],eax
                 jmp       _mcmdnormal
_mcmd7cont2:     add       byte ptr _CmdLen,2
                 xor       eax,eax
                 mov       al,_CmdLen
                 add       eax,_CurAsmAdr
                 push      ecx
                 mov       ecx,dword ptr _ImmConst
                 sub       ecx,eax
                 mov       eax,ecx
                 pop       ecx
                 mov       fs:[si+1],ax
                 jmp       _mcmdnormal

_mcmdgroup8:     cmp       al,8
                 jne       _mcmdgroup9
;--- Group 8 : r/m16 ---------------------------------------------------------
                 cmp       byte ptr _OpCount,1            ; Number of operands
                 jne       _mcmdGoToNext
                 cmp       [di].__OpType,2                 ; Memory ?
                 je        _mcmd8Memory
                 cmp       [di].__OpType,0                 ; Registr ?
                 jne       _mcmdGoToNext
                 cmp       [di].__RegsType,1
                 jb        _mcmdGoToNext
                 cmp       [di].__RegsType,2
                 ja        _mcmdGoToNext
                 mov       al,11000000b
                 or        al,[di].__RegsData
                 mov       [di].__ModRM,al
                 jmp       _mcmd8cont1a

_mcmd8Memory:    mov       al,[di].__ModRM
                 and       al,00000111b
                 cmp       al,00000100b
                 jne       _mcmd8cont0
                 cmp       [di].__aAdr,32
                 jne       _mcmd8cont0
                 mov       byte ptr _SIBPresent,1
_mcmd8cont0:     mov       al,[di].__aAdr
                 cmp       al,SegSize
                 je        _mcmd8cont1a
                 mov       _AdrPrefix,67h
_mcmd8cont1a:    mov       al,[di].__aW
                 cmp       al,4
                 jne       _mcmd8cont1b
                 mov       al,SegSize
                 shr       al,4
                 or        al,1
                 mov       [di].__aW,al
_mcmd8cont1b:    cmp       byte ptr [di].__aW,0        ; Only near pointer
                 je        _mcmdGotoNext
                 cmp       byte ptr [di].__aW,5        ; Only near pointer
                 je        _mcmdGotoNext
                 cmp       _AdrPrefix,0
                 je        _mcmd8cont1d
                 mov       byte ptr fs:[si],67h
                 inc       si
_mcmd8cont1d:    cmp       byte ptr SegSize,16
                 jne       _mcmd8cont1c
                 cmp       byte ptr [di].__aW,1
                 je        _mcmd8cont2a
                 mov       byte ptr fs:[si],66h
                 inc       si
                 jmp       _mcmd8cont2a

_mcmd8cont1c:    cmp       byte ptr [di].__aW,3
                 je        _mcmd8cont2a
                 mov       byte ptr fs:[si],66h
                 inc       si

_mcmd8cont2a:    cmp       [di].__aSeg,1
                 jbe       _mcmd8cont1e
                 mov       al,[di].__aSeg
                 mov       fs:[si],al
                 inc       si
_mcmd8cont1e:    mov       al,[bx+1]
                 mov       _CmdLen,al
                 cmp       byte ptr [bx+2],0Fh
                 jne       _mcmd8cont1b1
                 dec       byte ptr _CmdLen
                 mov       byte ptr fs:[si],0Fh
                 inc       bx
                 inc       si
_mcmd8cont1b1:   mov       al,[bx+2]
                 mov       fs:[si],al                      ; Put COP to buffer
                 cmp       byte ptr _CmdLen,1
                 je        _mcmd8cont1x
                 mov       al,[bx+3]
                 or        [di].__ModRM,al
_mcmd8cont1x:    mov       al,[di].__ModRM
                 mov       fs:[si+1],al                    ; Put ModRM byte
                 cmp       _SIBPresent,1
                 jne       _mcmd8cont1f
                 mov       al,[di].__SIB
                 mov       fs:[si+2],al
                 inc       si
_mcmd8cont1f:    cmp       [di].__DispSize,0
                 je        _mcmdnormal
                 push      eax
                 push      si
                 push      di
                 push      cx
                 xor       cx,cx
                 mov       cl,[di].__DispSize
                 add       si,2
                 mov       eax,[di].__DispConst
                 mov       _DispData,eax
                 lea       di,_DispData
                 xchg      si,di
                 rep       movsb
                 pop       cx
                 pop       di
                 pop       si
                 pop       eax
                 jmp       _mcmdnormal

_mcmdgroup9:     cmp       al,9
                 jne       _mcmdgroup10
;--- Group 9 : ptr 16:16/32 ---------------------------------------------------
                 cmp       byte ptr _OpCount,1            ; Number of operands
                 jne       _mcmdGoToNext
                 cmp       [di].__OpType,3                 ; Ptr ?
                 jne       _mcmdGoToNext
                 mov       al,[bx+2]
                 cmp       al,0Fh
                 jne       _mcmd9cont1
                 mov       byte ptr fs:[si],0Fh
                 inc       si
                 inc       bx
_mcmd9cont1:     mov       al,[bx+2]
                 mov       fs:[si],al
                 cmp       SegSize,16
                 je        _mcmd9cont2
                 mov       eax,dword ptr _farJmpOfs
                 mov       fs:[si+1],eax
                 mov       ax,word ptr _farJmpSeg
                 mov       fs:[si+5],ax
                 jmp       _mcmdnormal
_mcmd9cont2:     mov       ax,word ptr _farJmpOfs
                 mov       fs:[si+1],eax
                 mov       ax,word ptr _farJmpSeg
                 mov       fs:[si+3],ax
                 jmp       _mcmdnormal

_mcmdgroup10:    cmp       al,10
                 jne       _mcmdgroup11
;--- Group 10: r/m32 ---------------------------------------------------------
                 cmp       byte ptr _OpCount,1            ; Number of operands
                 jne       _mcmdGoToNext
                 cmp       [di].__OpType,2                 ; Memory ?
                 jne       _mcmdGoToNext
                 mov       al,[di].__ModRM
                 and       al,00000111b
                 cmp       al,00000100b
                 jne       _mcmd10cont0
                 cmp       [di].__aAdr,32
                 jne       _mcmd10cont0
                 mov       byte ptr _SIBPresent,1
_mcmd10cont0:    mov       al,[di].__aAdr
                 cmp       al,SegSize
                 je        _mcmd10cont1a
                 mov       _AdrPrefix,67h
_mcmd10cont1a:   mov       al,[di].__aW
                 cmp       al,4
                 jne       _mcmd10cont1b
                 mov       al,SegSize
                 shr       al,4
                 or        al,1
                 mov       [di].__aW,al
_mcmd10cont1b:   cmp       byte ptr [di].__aW,5        ; pword ptr
                 jne       _mcmd10cont1c
                 mov       byte ptr [di].__aW,3
_mcmd10cont1c:   cmp       byte ptr [di].__aW,3        ; Only far pointer
                 jne       _mcmdGotoNext
                 cmp       _AdrPrefix,0
                 je        _mcmd10cont1d
                 mov       byte ptr fs:[si],67h
                 inc       si
_mcmd10cont1d:   cmp       byte ptr SegSize,32
                 je        _mcmd10cont2a
                 mov       byte ptr fs:[si],66h
                 inc       si

_mcmd10cont2a:   cmp       [di].__aSeg,1
                 jbe       _mcmd10cont1e
                 mov       al,[di].__aSeg
                 mov       fs:[si],al
                 inc       si
_mcmd10cont1e:   mov       al,[bx+1]
                 mov       _CmdLen,al
                 cmp       byte ptr [bx+2],0Fh
                 jne       _mcmd10cont1b1
                 dec       byte ptr _CmdLen
                 mov       byte ptr fs:[si],0Fh
                 inc       bx
                 inc       si
_mcmd10cont1b1:  mov       al,[bx+2]
                 mov       fs:[si],al                      ; Put COP to buffer
                 cmp       byte ptr _CmdLen,1
                 je        _mcmd10cont1x
                 mov       al,[bx+3]
                 or        [di].__ModRM,al
_mcmd10cont1x:   mov       al,[di].__ModRM
                 mov       fs:[si+1],al                    ; Put ModRM byte
                 cmp       _SIBPresent,1
                 jne       _mcmd10cont1f
                 mov       al,[di].__SIB
                 mov       fs:[si+2],al
                 inc       si
_mcmd10cont1f:   cmp       [di].__DispSize,0
                 je        _mcmdnormal
                 push      eax
                 push      si
                 push      di
                 push      cx
                 xor       cx,cx
                 mov       cl,[di].__DispSize
                 add       si,2
                 mov       eax,[di].__DispConst
                 mov       _DispData,eax
                 lea       di,_DispData
                 xchg      si,di
                 rep       movsb
                 pop       cx
                 pop       di
                 pop       si
                 pop       eax
                 jmp       _mcmdnormal

_mcmdgroup11:    cmp       al,11
                 jne       _mcmdgroup12
;--- Group 11 : r,r/m ---------------------------------------------------------
                 cmp       byte ptr _OpCount,2            ; Number of operands
                 jne       _mcmdGoToNext
                 cmp       [di+24].__OpType,0                 ; Reg ?
                 je        _mcmd11cont1
                 cmp       [di+24].__OpType,2                 ; Memory ?
                 jne       _mcmdGoToNext
                 mov       al,[di+24].__ModRM
                 and       al,00000111b
                 cmp       al,00000100b
                 jne       _mcmd11cont0
                 cmp       [di+24].__aAdr,32
                 jne       _mcmd11cont0
                 mov       byte ptr _SIBPresent,1
_mcmd11cont0:    mov       al,[di+24].__aAdr
                 cmp       al,SegSize
                 je        _mcmd11cont1a
                 mov       _AdrPrefix,67h
                 jmp       _mcmd11cont1a
_mcmd11cont1:    cmp       [di+24].__RegsType,1               ; Base reg ?
                 jb        _mcmdGoToNext
                 cmp       [di+24].__RegsType,2               ; Ext Base reg ?
                 ja        _mcmdGoToNext
                 mov       al,[di+24].__RegsData              ; al <- reg code
                 or        al,11000000b                    ; al <- mod=11
                 mov       [di+24].__ModRM,al                 ; ModRM <- al

_mcmd11cont1a:   cmp       [di].__OpType,0              ; SecondOp Reg ?
                 jne       _mcmdGoToNext
                 cmp       [di].__RegsType,1            ; Base reg ?
                 jb        _mcmdGoToNext
                 cmp       [di].__RegsType,2            ; Ext Base reg ?
                 ja        _mcmdGoToNext
                 mov       al,[di+24].__aW
                 cmp       al,4
                 jne       _mcmd11cont1b
                 mov       al,[di].__aW
                 mov       [di+24].__aW,al
_mcmd11cont1b:   cmp       byte ptr _NoTypeCheck,1
                 je        _mcmd11cont1s
                 cmp       al,[di].__aW
                 jne       _mcmdGoToNext                   ; Type mismath
_mcmd11cont1s:   cmp       _AdrPrefix,0
                 je        _mcmd11cont1d
                 mov       byte ptr fs:[si],67h
                 inc       si
_mcmd11cont1d:   cmp       [di].__aW,0
                 je        _mcmd11cont2a
                 mov       al,[di].__aW
                 and       al,2
                 shl       al,4
                 cmp       al,SegSize
                 je        _mcmd11cont2a
                 mov       al,[di].__aW
                 shl       al,4
                 cmp       al,SegSize
                 je        _mcmd11cont2a
                 mov       byte ptr fs:[si],66h
                 inc       si

_mcmd11cont2a:   cmp       [di+24].__aSeg,1
                 jbe       _mcmd11cont1e
                 mov       al,[di+24].__aSeg
                 mov       fs:[si],al
                 inc       si
_mcmd11cont1e:   cmp       byte ptr [bx+2],0Fh
                 jne       _mcmd11cont1b1
                 mov       byte ptr fs:[si],0Fh
                 inc       bx
                 inc       si
_mcmd11cont1b1:  cmp       byte ptr _WBitSet,0
                 je        _mcmd11cont1t
                 mov       al,[bx+2]
                 jmp       _mcmd11cont1q
_mcmd11cont1t:   mov       al,[di+24].__aW                    ; Type conversion
                 and       al,1                            ; w bit <- aW
                 or        al,[bx+2]                       ; al <- COP
_mcmd11cont1q:   mov       fs:[si],al                      ; Put COP to buffer
                 mov       al,[di].__RegsData
                 shl       al,3
                 or        al,[di+24].__ModRM
                 mov       fs:[si+1],al                    ; Put ModRM byte
                 cmp       _SIBPresent,1
                 jne       _mcmd11cont1f
                 mov       al,[di+24].__SIB
                 mov       fs:[si+2],al
                 inc       si
_mcmd11cont1f:   cmp       [di+24].__DispSize,0
                 je        _mcmd11cont4
                 push      eax
                 push      si
                 push      di
                 push      cx
                 xor       cx,cx
                 mov       cl,[di+24].__DispSize
                 add       si,2
                 mov       eax,[di+24].__DispConst
                 mov       _DispData,eax
                 lea       di,_DispData
                 xchg      si,di
                 rep       movsb
                 pop       cx
                 pop       di
                 pop       si
                 xor       ax,ax
                 mov       al,[di].__DispSize
                 add       si,ax
                 pop       eax
_mcmd11cont4:    cmp       byte ptr _3OpPresent,0        ; 3 Op present ?
                 je        _mcmdnormal
                 cmp       byte ptr [di].__aW,1
                 je        _mcmd11cont5
                 mov       eax,[di+24*2].__ImmConst
                 mov       fs:[si+2],eax
                 jmp       _mcmdnormal
_mcmd11cont5:    mov       ax,word ptr [di+24*2].__ImmConst
                 mov       fs:[si+2],ax
                 jmp       _mcmdnormal

_mcmdgroup12:    cmp       al,12
                 jne       _mcmdgroup13
;--- Group 12: r/m -----------------------------------------------------------
                 cmp       byte ptr _OpCount,1            ; Number of operands
                 jne       _mcmdGoToNext
                 cmp       [di].__OpType,0                 ; Reg ?
                 je        _mcmd12cont1
                 cmp       [di].__OpType,2                 ; Memory ?
                 jne       _mcmdGoToNext
                 mov       al,[di].__ModRM
                 and       al,00000111b
                 cmp       al,00000100b
                 jne       _mcmd12cont0
                 cmp       [di].__aAdr,32
                 jne       _mcmd12cont0
                 mov       byte ptr _SIBPresent,1
_mcmd12cont0:    mov       al,[di].__aAdr
                 cmp       al,SegSize
                 je        _mcmd12cont1a
                 mov       _AdrPrefix,67h
                 jmp       _mcmd12cont1a
_mcmd12cont1:    cmp       [di].__RegsType,1               ; Base reg ?
                 jb        _mcmdGoToNext
                 cmp       [di].__RegsType,2               ; Ext Base reg ?
                 ja        _mcmdGoToNext
                 mov       al,[di].__RegsData              ; al <- reg code
                 or        al,11000000b                    ; al <- mod=11
                 mov       [di].__ModRM,al                 ; ModRM <- al

_mcmd12cont1a:   mov       al,[di].__aW
                 cmp       al,4
                 jne       _mcmd12cont1b
                 mov       al,SegSize
                 shr       al,4
                 or        al,1
                 mov       [di].__aW,al
_mcmd12cont1b:   cmp       _AdrPrefix,0
                 je        _mcmd12cont1d
                 mov       byte ptr fs:[si],67h
                 inc       si
_mcmd12cont1d:   cmp       [di].__aW,0
                 je        _mcmd12cont2a
                 mov       al,[di].__aW
                 and       al,2
                 shl       al,4
                 cmp       al,SegSize
                 je        _mcmd12cont2a
                 mov       al,[di].__aW
                 shl       al,4
                 cmp       al,SegSize
                 je        _mcmd12cont2a
                 mov       byte ptr fs:[si],66h
                 inc       si

_mcmd12cont2a:   cmp       [di].__aSeg,1
                 jbe       _mcmd12cont1e
                 mov       al,[di].__aSeg
                 mov       fs:[si],al
                 inc       si
_mcmd12cont1e:   mov       al,[bx+1]
                 mov       _CmdLen,al
                 cmp       byte ptr [bx+2],0Fh
                 jne       _mcmd12cont1b1
                 dec       byte ptr _CmdLen
                 mov       byte ptr fs:[si],0Fh
                 inc       bx
                 inc       si
_mcmd12cont1b1:  cmp       byte ptr _WBitSet,0
                 je        _mcmd12cont1t
                 mov       al,[bx+2]
                 jmp       _mcmd12cont1q
_mcmd12cont1t:   mov       al,[di].__aW                    ; Type conversion
                 and       al,1                            ; w bit <- aW
                 or        al,[bx+2]                       ; al <- COP
_mcmd12cont1q:   mov       fs:[si],al                      ; Put COP to buffer
                 cmp       byte ptr _CmdLen,1
                 je        _mcmd12cont1x
                 mov       al,[bx+3]
                 or        [di].__ModRM,al
_mcmd12cont1x:   mov       al,[di].__ModRM
                 mov       fs:[si+1],al                    ; Put ModRM byte
                 cmp       _SIBPresent,1
                 jne       _mcmd12cont1f
                 mov       al,[di].__SIB
                 mov       fs:[si+2],al
                 inc       si
_mcmd12cont1f:   cmp       [di].__DispSize,0
                 je        _mcmdnormal
                 push      eax
                 push      si
                 push      di
                 push      cx
                 xor       cx,cx
                 mov       cl,[di].__DispSize
                 add       si,2
                 mov       eax,[di].__DispConst
                 mov       _DispData,eax
                 lea       di,_DispData
                 xchg      si,di
                 rep       movsb
                 pop       cx
                 pop       di
                 pop       si
                 pop       eax
                 jmp       _mcmdnormal

_mcmdgroup13:    cmp       al,13
                 jne       _mcmdgroup14
;--- Group 13: +reg16/32-------------------------------------------------------
                 cmp       byte ptr _OpCount,1            ; Number of operands
                 jne       _mcmdGoToNext
                 cmp       [di].__OpType,0                 ; Reg ?
                 jne       _mcmdGoToNext
                 cmp       [di].__RegsType,1               ; Base reg ?
                 jne       _mcmd13cont0
                 cmp       [di].__aW,1
                 jne       _mcmdGoToNext
                 cmp       byte ptr SegSize,16
                 je        _mcmd13cont0a
                 mov       byte ptr fs:[si],66h
                 inc       si
                 jmp       _mcmd13cont0a
_mcmd13cont0:    cmp       [di].__RegsType,2               ; Ext Base reg ?
                 jne       _mcmdGoToNext
                 cmp       byte ptr SegSize,32
                 je        _mcmd13cont0a
                 mov       byte ptr fs:[si],66h
                 inc       si
_mcmd13cont0a:
                 mov       al,[bx+2]
                 cmp       al,0Fh
                 jne       _mcmd13cont1
                 mov       byte ptr fs:[si],0Fh
                 inc       si
                 inc       bx
_mcmd13cont1:    mov       al,[bx+2]
                 or        al,[di].__RegsData
                 mov       fs:[si],al
                 jmp       _mcmdnormal

_mcmdgroup14:    cmp       al,14
                 jne       _mcmdgroup15
;--- Group 14: imm16,imm8 -----------------------------------------------------
                 cmp       byte ptr _OpCount,2            ; Number of operands
                 jne       _mcmdGoToNext
                 cmp       byte ptr [di].__OpType,1                 ; Imm ?
                 jne       _mcmdGoToNext
                 cmp       byte ptr [di+24].__OpType,1              ; Imm ?
                 jne       _mcmdGoToNext
                 mov       al,[bx+2]
                 mov       fs:[si],al
                 mov       ax,word ptr [di].__ImmConst
                 mov       fs:[si+1],ax
                 mov       al,byte ptr [di+24].__ImmConst
                 mov       fs:[si+3],al
                 jmp       _mcmdnormal

_mcmdgroup15:    cmp       al,15
                 jne       _mcmdgroup16
;--- Group 15: r16/32,r/m16/32,imm16/32----------------------------------------
                 cmp       byte ptr _OpCount,3            ; Number of operands
                 jne       _mcmdGoToNext
                 cmp       [di].__aW,0
                 je        _mcmdGotoNext
                 cmp       [di+24*2].__OpType,1
                 jne       _mcmdGotoNext
                 mov       byte ptr _WBitSet,1            ; No set w bit
                 dec       byte ptr _OpCount
                 mov       byte ptr _3OpPresent,1
                 mov       al,11
                 jmp       _mcmdgroup11

_mcmdgroup16:    cmp       al,16
                 jne       _mcmdgroup17
;--- Group 16: A,Imm8 ---------------------------------------------------------
                 cmp       byte ptr _OpCount,2            ; Number of operands
                 jne       _mcmdGoToNext
                 cmp       [di].__OpType,0                 ; Reg ?
                 jne       _mcmdGoToNext
                 cmp       [di+24].__OpType,1              ; Imm ?
                 jne       _mcmdGoToNext
                 cmp       [di].__RegsData,0               ; AL,AX,EAX ?
                 jne       _mcmdGoToNext
                 cmp       [di].__RegsType,1               ; Base reg ?
                 jne       _mcmd16cont0
                 cmp       [di].__aW,1
                 jne       _mcmd16cont0a
                 cmp       byte ptr SegSize,16
                 je        _mcmd16cont0a
                 mov       byte ptr fs:[si],66h
                 inc       si
                 jmp       _mcmd16cont0a
_mcmd16cont0:    cmp       [di].__RegsType,2               ; Ext Base reg ?
                 jne       _mcmdGoToNext
                 cmp       byte ptr SegSize,32
                 je        _mcmd16cont0a
                 mov       byte ptr fs:[si],66h
                 inc       si
_mcmd16cont0a:   mov       al,[di].__aW
                 and       al,1
                 or        al,[bx+2]
                 mov       fs:[si],al
                 mov       al,byte ptr [di+24].__ImmConst
                 mov       fs:[si+1],al
                 jmp       _mcmdnormal

_mcmdgroup17:    cmp       al,17
                 jne       _mcmdgroup18
;--- Group 17: A,DX -----------------------------------------------------------
                 cmp       byte ptr _OpCount,2            ; Number of operands
                 jne       _mcmdGoToNext
                 cmp       [di].__OpType,0                 ; Reg ?
                 jne       _mcmdGoToNext
                 cmp       [di+24].__OpType,0              ; Reg ?
                 jne       _mcmdGoToNext
                 cmp       [di].__RegsData,0               ; AL,AX,EAX ?
                 jne       _mcmdGoToNext
                 cmp       [di+24].__RegsData,2            ; DX ?
                 jne       _mcmdGoToNext
                 cmp       [di+24].__RegsType,1            ; DX ?
                 jne       _mcmdGoToNext
                 cmp       [di+24].__aW,1                  ; DX ?
                 jne       _mcmdGoToNext
                 cmp       [di].__RegsType,1               ; Base reg ?
                 jne       _mcmd17cont0
                 cmp       [di].__aW,1
                 jne       _mcmd17cont0a
                 cmp       byte ptr SegSize,16
                 je        _mcmd17cont0a
                 mov       byte ptr fs:[si],66h
                 inc       si
                 jmp       _mcmd17cont0a
_mcmd17cont0:    cmp       [di].__RegsType,2               ; Ext Base reg ?
                 jne       _mcmdGoToNext
                 cmp       byte ptr SegSize,32
                 je        _mcmd17cont0a
                 mov       byte ptr fs:[si],66h
                 inc       si
_mcmd17cont0a:   mov       al,[di].__aW
                 and       al,1
                 or        al,[bx+2]
                 mov       fs:[si],al
                 jmp       _mcmdnormal

_mcmdgroup18:    cmp       al,18
                 jne       _mcmdgroup19
;--- Group 18: imm8 -----------------------------------------------------------
                 cmp       byte ptr _OpCount,1            ; Number of operands
                 jne       _mcmdGoToNext
                 cmp       [di].__OpType,1                 ; Imm ?
                 jne       _mcmdGoToNext
                 mov       al,[bx+2]
                 mov       fs:[si],al
                 mov       al,byte ptr [di].__ImmConst
                 cmp       al,3
                 jne       _mcmd18cont1
                 mov       byte ptr fs:[si],0CCh
                 jmp       _mcmdnormal
_mcmd18cont1:
                 mov       fs:[si+1],al
                 jmp       _mcmdnormal

_mcmdgroup19:    cmp       al,19
                 jne       _mcmdgroup20
;--- Group 19: rel8 -----------------------------------------------------------
                 cmp       byte ptr _OpCount,1            ; Number of operands
                 jne       _mcmdGoToNext
                 cmp       [di].__OpType,1                 ; Imm ?
                 jne       _mcmdGoToNext
                 mov       eax,_CurAsmAdr
                 add       eax,2
                 push      ecx
                 mov       ecx,dword ptr _ImmConst
                 sub       ecx,eax
                 mov       eax,ecx
                 pop       ecx
                 cmp       eax,127
                 jg        _mcmdGoToNext
                 cmp       eax,-128
                 jl        _mcmdGoToNext
                 mov       ah,al
                 mov       al,[bx+2]
                 mov       fs:[si],al
                 mov       fs:[si+1],ah
                 jmp       _mcmdnormal

_mcmdgroup20:    cmp       al,20
                 jne       _mcmdgroup21
;--- Group 20: r/m,sreg -------------------------------------------------------
                 cmp       [di+24].__OpType,0                ; Regs ?
                 jne       _mcmdGoToNext
                 cmp       [di+24].__RegsType,3              ; Segment regs ?
                 jne       _mcmdGoToNext
                 cmp       [di].__aW,0
                 je        _mcmdGotoNext
                 cmp       [di].__aW,3
                 je        _mcmdGotoNext
                 mov       [di+24].__aW,1
                 mov       [di+24].__RegsType,1
                 mov       byte ptr _WBitSet,1
                 mov       al,2
                 jmp       _mcmdgroup2

_mcmdgroup21:    cmp       al,21
                 jne       _mcmdgroup22
;--- Group 21: sreg,r/m -------------------------------------------------------
                 cmp       [di].__OpType,0                ; Regs ?
                 jne       _mcmdGoToNext
                 cmp       [di].__RegsType,3              ; Segment regs ?
                 jne       _mcmdGoToNext
                 cmp       [di+24].__aW,0
                 je        _mcmdGotoNext
                 cmp       [di+24].__aW,3
                 je        _mcmdGotoNext
                 mov       [di].__aW,1
                 mov       [di].__RegsType,1
                 mov       byte ptr _WBitSet,1
                 mov       al,11
                 jmp       _mcmdgroup11

_mcmdgroup22:    cmp       al,22
                 jne       _mcmdgroup23
;--- Group 22: reg,imm --------------------------------------------------------
                 cmp       byte ptr _OpCount,2            ; Number of operands
                 jne       _mcmdGoToNext
                 cmp       [di].__OpType,0                 ; Reg ?
                 jne       _mcmdGoToNext
                 cmp       [di+24].__OpType,1              ; Imm ?
                 jne       _mcmdGoToNext
                 xor       ah,ah
                 cmp       [di].__RegsType,1               ; Base reg ?
                 jne       _mcmd22cont0
                 cmp       [di].__aW,1
                 jne       _mcmd22cont0a
                 mov       ah,8
                 cmp       byte ptr SegSize,16
                 je        _mcmd22cont0a
                 mov       byte ptr fs:[si],66h
                 inc       si
                 jmp       _mcmd22cont0a
_mcmd22cont0:    cmp       [di].__RegsType,2               ; Ext Base reg ?
                 jne       _mcmdGoToNext
                 mov       ah,8
                 cmp       byte ptr SegSize,32
                 je        _mcmd22cont0a
                 mov       byte ptr fs:[si],66h
                 inc       si
_mcmd22cont0a:
                 mov       al,[bx+2]
                 or        al,[di].__RegsData
                 or        al,ah
                 mov       fs:[si],al
                 mov       eax,[di+24].__ImmConst
                 cmp       [di].__aW,0
                 jne       _mcmd22cont1
                 mov       fs:[si+1],al
                 jmp       _mcmdnormal

_mcmd22cont1:    cmp       [di].__aW,1
                 jne       _mcmd22cont2
                 mov       fs:[si+1],ax
                 jmp       _mcmdnormal

_mcmd22cont2:    mov       fs:[si+1],eax
                 jmp       _mcmdnormal

_mcmdgroup23:    cmp       al,23
                 jne       _mcmdgroup24
;--- Group 23: r/m,imm --------------------------------------------------------
                 mov       byte ptr _SBitMask,1
                 mov       al,1
                 jmp       _mcmdgroup1

_mcmdgroup24:    cmp       al,24
                 jne       _mcmdgroup25
;--- Group 24: r32,SpecReg ----------------------------------------------------
                 cmp       byte ptr _OpCount,2            ; Number of operands
                 jne       _mcmdGoToNext
                 cmp       [di].__OpType,0                 ; Reg ?
                 jne       _mcmdGoToNext
                 cmp       [di+24].__OpType,0              ; Reg ?
                 jne       _mcmdGoToNext
                 cmp       [di].__RegsType,2               ; Ext Base reg ?
                 jne       _mcmdGoToNext
                 cmp       [di+24].__RegsType,4            ; Special reg ?
                 jne       _mcmdGoToNext
                 mov       byte ptr fs:[si],0Fh
                 mov       al,[bx+3]
                 or        al,_SpecialRegs
                 mov       fs:[si+1],al
                 mov       al,[di].__RegsData
                 or        al,11000000b
                 mov       ah,[di+24].__RegsData
                 shl       ah,3
                 or        al,ah
                 mov       fs:[si+2],al
                 jmp       _mcmdnormal

_mcmdgroup25:    cmp       al,25
                 jne       _mcmdgroup26
;--- Group 25: SpecReg,r32 ----------------------------------------------------
                 cmp       byte ptr _OpCount,2            ; Number of operands
                 jne       _mcmdGoToNext
                 cmp       [di].__OpType,0                ; Reg ?
                 jne       _mcmdGoToNext
                 cmp       [di+24].__OpType,0             ; Reg ?
                 jne       _mcmdGoToNext
                 cmp       [di+24].__RegsType,2           ; Ext Base reg ?
                 jne       _mcmdGoToNext
                 cmp       [di].__RegsType,4              ; Special reg ?
                 jne       _mcmdGoToNext
                 mov       byte ptr fs:[si],0Fh
                 mov       al,[bx+3]
                 or        al,_SpecialRegs
                 or        al,2
                 mov       fs:[si+1],al
                 mov       al,[di+24].__RegsData
                 or        al,11000000b
                 mov       ah,[di].__RegsData
                 shl       ah,3
                 or        al,ah
                 mov       fs:[si+2],al
                 jmp       _mcmdnormal

_mcmdgroup26:    cmp       al,26
                 jne       _mcmdgroup27
;--- Group 26: r16/32,r/m8/16 -------------------------------------------------
                 cmp       [di].__aW,0
                 je        _mcmdGotoNext
                 cmp       [di+24].__aW,3
                 je        _mcmdGotoNext
                 mov       byte ptr _NoTypeCheck,1
                 mov       al,11
                 jmp       _mcmdgroup11

_mcmdgroup27:    cmp       al,27
                 jne       _mcmdgroup28
;--- Group 27: Imm8,A ---------------------------------------------------------
                 cmp       byte ptr _OpCount,2            ; Number of operands
                 jne       _mcmdGoToNext
                 cmp       [di+24].__OpType,0                 ; Reg ?
                 jne       _mcmdGoToNext
                 cmp       [di].__OpType,1              ; Imm ?
                 jne       _mcmdGoToNext
                 cmp       [di+24].__RegsData,0               ; AL,AX,EAX ?
                 jne       _mcmdGoToNext
                 cmp       [di+24].__RegsType,1               ; Base reg ?
                 jne       _mcmd27cont0
                 cmp       [di+24].__aW,1
                 jne       _mcmd27cont0a
                 cmp       byte ptr SegSize,16
                 je        _mcmd27cont0a
                 mov       byte ptr fs:[si],66h
                 inc       si
                 jmp       _mcmd27cont0a
_mcmd27cont0:    cmp       [di+24].__RegsType,2               ; Ext Base reg ?
                 jne       _mcmdGoToNext
                 cmp       byte ptr SegSize,32
                 je        _mcmd27cont0a
                 mov       byte ptr fs:[si],66h
                 inc       si
_mcmd27cont0a:   mov       al,[di+24].__aW
                 and       al,1
                 or        al,[bx+2]
                 mov       fs:[si],al
                 mov       al,byte ptr [di].__ImmConst
                 mov       fs:[si+1],al
                 jmp       _mcmdnormal

_mcmdgroup28:    cmp       al,28
                 jne       _mcmdgroup29
;--- Group 28: sreg2bit -------------------------------------------------------
                 cmp       byte ptr _OpCount,1            ; Number of operands
                 jne       _mcmdGoToNext
                 cmp       [di].__OpType,0                 ; Reg ?
                 jne       _mcmdGoToNext
                 cmp       [di].__RegsType,3               ; Segment reg ?
                 jne       _mcmdGoToNext
                 cmp       [di].__RegsData,3               ; Main seg reg ?
                 ja        _mcmdGoToNext
_mcmd28cont0:    mov       al,[bx+2]
                 cmp       al,0Fh
                 jne       _mcmd28cont1
                 mov       byte ptr fs:[si],0Fh
                 inc       si
                 inc       bx
_mcmd28cont1:    mov       al,[bx+2]
                 mov       ah,[di].__RegsData
                 shl       ah,3
                 or        al,ah
                 mov       fs:[si],al
                 jmp       _mcmdnormal

_mcmdgroup29:    cmp       al,29
                 jne       _mcmdgroup30
;--- Group 29: sreg3bit -------------------------------------------------------
                 cmp       byte ptr _OpCount,1            ; Number of operands
                 jne       _mcmdGoToNext
                 cmp       [di].__OpType,0                 ; Reg ?
                 jne       _mcmdGoToNext
                 cmp       [di].__RegsType,3               ; Segment reg ?
                 jne       _mcmdGoToNext
                 cmp       [di].__RegsData,3               ; Main seg reg ?
                 jbe       _mcmdGoToNext
                 jmp       _mcmd28cont0

_mcmdgroup30:    cmp       al,30
                 jne       _mcmdgroup31
;--- Group 30: imm ------------------------------------------------------------
                 cmp       byte ptr _OpCount,1            ; Number of operands
                 jne       _mcmdGoToNext
                 cmp       [di].__OpType,1                 ; Imm ?
                 jne       _mcmdGoToNext
                 cmp       [di].__aW,4
                 jne       _mcmd30cont1
                 cmp       byte ptr SegSize,16
                 jne       _mcmd30cont0
                 mov       [di].__aW,1
                 jmp       _mcmd30cont1
_mcmd30cont0:    mov       [di].__aW,3
_mcmd30cont1:    cmp       [di].__aW,0
                 je        _mcmd30cont1a
                 cmp       [di].__aW,1
                 jne       _mcmd30cont0a
                 cmp       byte ptr SegSize,16
                 je        _mcmd30cont1a
                 mov       byte ptr fs:[si],66h
                 inc       si
                 jmp       _mcmd30cont1a
_mcmd30cont0a:   cmp       byte ptr SegSize,32
                 je        _mcmd30cont1a
                 mov       byte ptr fs:[si],66h
                 inc       si
_mcmd30cont1a:   mov       al,[bx+2]
                 mov       fs:[si],al
                 cmp       [di].__aW,0
                 jne       _mcmd30cont2
                 or        byte ptr fs:[si],2
                 mov       al,byte ptr [di].__ImmConst
                 mov       fs:[si+1],al
                 jmp       _mcmdnormal
_mcmd30cont2:    cmp       [di].__aW,1
                 jne       _mcmd30cont3
                 mov       ax,word ptr [di].__ImmConst
                 mov       fs:[si+1],ax
                 jmp       _mcmdnormal
_mcmd30cont3:    mov       eax,dword ptr [di].__ImmConst
                 mov       fs:[si+1],eax
                 jmp       _mcmdnormal

_mcmdgroup31:    cmp       al,31
                 jne       _mcmdgroup32
;--- Group 31: r/m,imm8 -------------------------------------------------------
                 mov       byte ptr _SBitNoSet,1
                 mov       al,1
                 jmp       _mcmdgroup1

_mcmdgroup32:    cmp       al,32
                 jne       _mcmdgroup33
;--- Group 32: imm16 or nil ---------------------------------------------------
                 cmp       byte ptr _OpCount,1            ; Number of operands
                 jne       _mcmdGoToNext
                 cmp       [di].__OpType,1                 ; Imm ?
                 jne       _mcmd32cont1
                 mov       al,[bx+2]
                 mov       fs:[si],al
                 mov       ax,word ptr [di].__ImmConst
                 mov       fs:[si+1],ax
                 jmp       _mcmdnormal
_mcmd32cont1:    mov       al,[bx+2]
                 or        al,1
                 mov       fs:[si],al
                 jmp       _mcmdnormal

_mcmdgroup33:    cmp       al,33
                 jne       _mcmdgroup34
;--- Group 33: r/m8 -----------------------------------------------------------
                 cmp       byte ptr _OpCount,1            ; Number of operands
                 jne       _mcmdGoToNext
                 cmp       [di].__OpType,0                 ; Reg ?
                 je        _mcmd33cont1
_mcmd33cont0:    cmp       [di].__OpType,2                 ; Memory ?
                 jne       _mcmdGoToNext
_mcmd33cont1:    cmp       [di].__aW,0                     ; Byte ?
                 jne       _mcmdGoToNext
                 mov       al,12
                 jmp       _mcmdgroup12

_mcmdgroup34:    cmp       al,34
                 jne       _mcmdgroup35
;--- Group 34: DX,A -----------------------------------------------------------
                 cmp       byte ptr _OpCount,2            ; Number of operands
                 jne       _mcmdGoToNext
                 cmp       [di].__OpType,0                 ; Reg ?
                 jne       _mcmdGoToNext
                 cmp       [di+24].__OpType,0              ; Reg ?
                 jne       _mcmdGoToNext
                 cmp       [di+24].__RegsData,0               ; AL,AX,EAX ?
                 jne       _mcmdGoToNext
                 cmp       [di].__RegsData,2            ; DX ?
                 jne       _mcmdGoToNext
                 cmp       [di].__RegsType,1            ; DX ?
                 jne       _mcmdGoToNext
                 cmp       [di].__aW,1                  ; DX ?
                 jne       _mcmdGoToNext
                 cmp       [di+24].__RegsType,1               ; Base reg ?
                 jne       _mcmd34cont0
                 cmp       [di+24].__aW,1
                 jne       _mcmd34cont0a
                 cmp       byte ptr SegSize,16
                 je        _mcmd34cont0a
                 mov       byte ptr fs:[si],66h
                 inc       si
                 jmp       _mcmd34cont0a
_mcmd34cont0:    cmp       [di+24].__RegsType,2               ; Ext Base reg ?
                 jne       _mcmdGoToNext
                 cmp       byte ptr SegSize,32
                 je        _mcmd34cont0a
                 mov       byte ptr fs:[si],66h
                 inc       si
_mcmd34cont0a:   mov       al,[di+24].__aW
                 and       al,1
                 or        al,[bx+2]
                 mov       fs:[si],al
                 jmp       _mcmdnormal

_mcmdgroup35:    cmp       al,35
                 jne       _mcmdgroup36
;--- Group 35: A,+r16/32 ------------------------------------------------------
                 cmp       byte ptr _OpCount,2            ; Number of operands
                 jne       _mcmdGoToNext
                 cmp       [di].__OpType,0                 ; Reg ?
                 jne       _mcmdGoToNext
                 cmp       [di+24].__OpType,0                 ; Reg ?
                 jne       _mcmdGoToNext
                 mov       al,[di].__aW
                 cmp       al,[di+24].__aW
                 jne       _mcmdGoToNext
                 cmp       [di].__RegsData,0
                 jne       _mcmdGoToNext
                 cmp       [di+24].__RegsType,1               ; Base reg ?
                 jne       _mcmd35cont0
                 cmp       [di+24].__aW,1
                 jne       _mcmdGoToNext
                 cmp       byte ptr SegSize,16
                 je        _mcmd35cont0a
                 mov       byte ptr fs:[si],66h
                 inc       si
                 jmp       _mcmd35cont0a
_mcmd35cont0:    cmp       [di+24].__RegsType,2               ; Ext Base reg ?
                 jne       _mcmdGoToNext
                 cmp       byte ptr SegSize,32
                 je        _mcmd35cont0a
                 mov       byte ptr fs:[si],66h
                 inc       si
_mcmd35cont0a:
                 mov       al,[bx+2]
                 or        al,[di+24].__RegsData
                 mov       fs:[si],al
                 jmp       _mcmdnormal

_mcmdgroup36:    cmp       al,36
                 jne       _mcmdgroup37
;--- Group 36: +r16/32,A ------------------------------------------------------
                 cmp       byte ptr _OpCount,2            ; Number of operands
                 jne       _mcmdGoToNext
                 cmp       [di].__OpType,0                 ; Reg ?
                 jne       _mcmdGoToNext
                 cmp       [di+24].__OpType,0                 ; Reg ?
                 jne       _mcmdGoToNext
                 mov       al,[di].__aW
                 cmp       al,[di+24].__aW
                 jne       _mcmdGoToNext
                 cmp       [di+24].__RegsData,0
                 jne       _mcmdGoToNext
                 cmp       [di].__RegsType,1               ; Base reg ?
                 jne       _mcmd36cont0
                 cmp       [di].__aW,1
                 jne       _mcmdGoToNext
                 cmp       byte ptr SegSize,16
                 je        _mcmd36cont0a
                 mov       byte ptr fs:[si],66h
                 inc       si
                 jmp       _mcmd36cont0a
_mcmd36cont0:    cmp       [di].__RegsType,2               ; Ext Base reg ?
                 jne       _mcmdGoToNext
                 cmp       byte ptr SegSize,32
                 je        _mcmd36cont0a
                 mov       byte ptr fs:[si],66h
                 inc       si
_mcmd36cont0a:
                 mov       al,[bx+2]
                 or        al,[di].__RegsData
                 mov       fs:[si],al
                 jmp       _mcmdnormal

_mcmdgroup37:    cmp       al,37
                 jne       _mcmdgroup38
;--- Group 37: r/m,1 ----------------------------------------------------------
                 cmp       byte ptr _OpCount,2            ; Number of operands
                 jne       _mcmdGoToNext
                 cmp       [di].__OpType,0                 ; Reg ?
                 jne       _mcmd37cont0
                 cmp       [di].__RegsType,1               ; Base Reg ?
                 je        _mcmd37cont1
                 cmp       [di].__RegsType,2               ; Ext Base Reg ?
                 jne       _mcmdGoToNext
                 jmp       _mcmd37cont1
_mcmd37cont0:    cmp       [di].__OpType,2                 ; Memory ?
                 jne       _mcmdGoToNext
_mcmd37cont1:    cmp       [di+24].__OpType,1              ; Imm ?
                 jne       _mcmdGoToNext
                 cmp       dword ptr [di+24].__ImmConst,1
                 jne       _mcmdGoToNext
                 mov       byte ptr _OpCount,1
                 mov       al,12
                 jmp       _mcmdgroup12

_mcmdgroup38:    cmp       al,38
                 jne       _mcmdgroup39
;--- Group 38: r/m,CL ---------------------------------------------------------
                 cmp       byte ptr _OpCount,2            ; Number of operands
                 jne       _mcmdGoToNext
                 cmp       [di].__OpType,0                 ; Reg ?
                 jne       _mcmd38cont0
                 cmp       [di].__RegsType,1               ; Base Reg ?
                 je        _mcmd38cont1
                 cmp       [di].__RegsType,2               ; Ext Base Reg ?
                 jne       _mcmdGoToNext
                 jmp       _mcmd38cont1
_mcmd38cont0:    cmp       [di].__OpType,2                 ; Memory ?
                 jne       _mcmdGoToNext
_mcmd38cont1:    cmp       [di+24].__OpType,0              ; Reg ?
                 jne       _mcmdGoToNext
                 cmp       [di+24].__RegsType,1            ; Base reg ?
                 jne       _mcmdGoToNext
                 cmp       [di+24].__aW,0                  ; byte reg ?
                 jne       _mcmdGoToNext
                 cmp       [di+24].__RegsData,1            ; CL ?
                 jne       _mcmdGoToNext
                 mov       byte ptr _OpCount,1
                 mov       al,12
                 jmp       _mcmdgroup12

_mcmdgroup39:    cmp       al,39
                 jne       _mcmdgroup40
;--- Group 39: r/m16/32,r16/32,imm8 -------------------------------------------
                 cmp       byte ptr _OpCount,3            ; Number of operands
                 jne       _mcmdGoToNext
                 cmp       [di].__aW,0
                 je        _mcmdGotoNext
                 cmp       [di+24*2].__OpType,1
                 jne       _mcmdGotoNext
                 mov       byte ptr _WBitSet,1            ; No set w bit
                 dec       byte ptr _OpCount
                 mov       byte ptr _3OpPresent,1
                 mov       al,2
                 jmp       _mcmdgroup2

_mcmdgroup40:    cmp       al,40
                 jne       _mcmdgroup41
;--- Group 40: r/m16/32,r16/32,CL ---------------------------------------------
                 cmp       byte ptr _OpCount,3            ; Number of operands
                 jne       _mcmdGoToNext
                 cmp       [di].__aW,0
                 je        _mcmdGotoNext
                 cmp       [di+24*2].__OpType,0
                 jne       _mcmdGotoNext
                 cmp       [di+24*2].__RegsType,1
                 jne       _mcmdGotoNext
                 cmp       [di+24*2].__aW,0
                 jne       _mcmdGotoNext
                 cmp       [di+24*2].__RegsData,1
                 jne       _mcmdGotoNext
                 mov       byte ptr _WBitSet,1            ; No set w bit
                 dec       byte ptr _OpCount
                 mov       al,2
                 jmp       _mcmdgroup2

_mcmdgroup41:    cmp       al,41
                 jne       _mcmderror                    ; ??? Not may by ???
;--- Group 41: One byte command -----------------------------------------------
                 cmp       byte ptr _OpCount,1            ; Number of operands
                 jne       _mcmd41cont1
                 cmp       [di].__OpType,1                 ; Imm ?
                 jne       _mcmd41cont1
                 mov       al,[bx+2]
                 mov       fs:[si],al
                 mov       al,byte ptr [di].__ImmConst
                 mov       fs:[si+1],al
                 jmp       _mcmdnormal

_mcmd41cont1:    mov       al,[bx+2]
                 mov       fs:[si],al
                 mov       al,[bx+3]
                 mov       fs:[si+1],al
                 jmp       _mcmdnormal
;--- Normal exit ---------------------------------------------------------------
_mcmdnormal:     clc
                 jmp       _mcmdexit
;--- Exit with error -----------------------------------------------------------
_mcmderror:      stc
;--- Exit from procedure -------------------------------------------------------
_mcmdexit:
                 retf
_MakeCommand     endp
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Procedure _Assemble
; Parameters:
;             FS:SI - Address of code
;             GS:DI - Address assembing command
;
; Return:    AL = 0 succesful
;            CF if Error
;            => AL error code
;               1 illegal instruction
;               2 illegal operands
;
;۲۲۲۲۲۲۲۲۲۲۲۲۲
_Assemble        proc      far
                 push      bx
                 push      cx
                 push      si
                 push      di
                 push      bp
                 push      es
                 push      ds
                 push      gs

                 push      ds
                 pop       es

                 lea       bx,_srcstring

_asmcpyloop:     mov       al,gs:[di]
                 mov       [bx],al
                 inc       di
                 inc       bx
                 cmp       al,0
                 jne       _asmcpyloop

                 lea       di,_srcstring
                 push      ds
                 pop       gs

                 mov       bx,di
                 Call      StrUpCase
                 lea       bx,_buffer
                 xor       cx,cx

_asmloop:        mov       al,gs:[di]
                 mov       [bx],al
                 inc       cx
                 cmp       al,0
                 je        _asmcont2
                 cmp       al,32
                 je        _asmcont1
                 inc       di
                 inc       bx
                 jmp       _asmloop

_asmcont1:       mov       byte ptr [bx],0
_asmcont2:       xor       bx,bx
                 push      si
                 push      di

_asmloop3:       mov       si,word ptr prefix_table[bx]
                 add       bx,2
                 cmp       bx,prf_tablelen
                 jbe       _asmcont6
                 xor       bx,bx
                 jmp       _asmloop2                   ; Prefix not found

_asmcont6:       lea       di,_buffer
                 push      cx
                 repe      cmpsb
                 pop       cx
                 jne       _asmloop3
                 mov       bx,si
                 pop       di
                 pop       si
                 mov       al,[bx+1]
                 mov       fs:[si],al
                 inc       si
                 xor       cx,cx
_asmloop5:       mov       al,gs:[di]
                 cmp       al,32
                 jne       _asmcont9
                 inc       di
                 jmp       _asmloop5
_asmcont9:
                 lea       bx,_buffer
_asmloop4:       mov       al,gs:[di]
                 mov       [bx],al
                 inc       cx
                 cmp       al,0
                 je        _asmcont7
                 cmp       al,32
                 je        _asmcont8
                 inc       di
                 inc       bx
                 jmp       _asmloop4

_asmcont8:       mov       byte ptr [bx],0
_asmcont7:       xor       bx,bx
                 push      si
                 push      di


_asmloop2:       mov       si,word ptr command_table[bx]
                 add       bx,2
                 cmp       bx,cmd_tablelen
                 jbe       _asmcont3
                 pop       di
                 pop       si

                 jmp       _asmerror1                   ; Command not found
_asmcont3:       lea       di,_buffer
                 push      cx
                 repe      cmpsb
                 pop       cx
                 jne       _asmloop2
                 mov       bx,si
                 pop       di
                 pop       si
                 cmp       byte ptr [bx],0
                 je        _extendedasm                 ; Instruction use parameters
                 mov       dl,[bx]
                 mov       di,si
                 mov       si,bx
                 inc       si
                 cmp       byte ptr [si],66h
                 jne       _asmcont4
                 cmp       byte ptr SegSize,16
                 je        _asmcont5
                 inc       si
                 dec       dl
                 jmp       _asmcont5

_asmcont4:       cmp       byte ptr [si],67h
                 jne       _asmcont5
                 dec       dl
                 inc       si
                 cmp       SegSize,16
                 je        _asmcont5
                 mov       byte ptr [di],66h
                 inc       di
_asmcont5:       xor       dh,dh
                 mov       cx,dx
                 push      fs
                 pop       es
                 rep       movsb
                 jmp       _normalexit
;--- Instruction use parameters ----------------------------------------------
_extendedasm:
; BX - last byte mnemonic, SI - output code, DI - Next operand
                 Call      _GetOperands              ; Set all flags
                 jnc       _extendedasm1
                 cmp       byte ptr [bx+1],32
                 je        _extendedasm1
                 cmp       byte ptr [bx+1],41
                 jne       _asmerror2
_extendedasm1:   inc       bx
                 Call      _MakeCommand
                 jc        _asmerror2
;--- Normal assemble - exit --------------------------------------------------
_normalexit:     xor       al,al
                 clc
                 jmp       _asmexit
;--- Illegal instruction -----------------------------------------------------
_asmerror1:      mov       al,1
                 stc
                 jmp       _asmexit
;--- Illegal operand ---------------------------------------------------------
_asmerror2:      mov       al,2
                 stc
                 jmp       _asmexit

_asmexit:        pop       gs
                 pop       ds
                 pop       es
                 pop       bp
                 pop       di
                 pop       si
                 pop       cx
                 pop       bx
                 retf
_Assemble        endp
.DATA
;۲۲۲۲۲۲۲۲۲۲۲۲۲
; Data for assembler ۲۲۲۲۲۲۲۲۲
;۲۲۲۲۲۲۲۲۲۲۲۲۲
_srcstring       db        60 dup(0)
_buffer          db        60 dup(0)
_OpCount         db        0
_Attributes      db        'BYTEPTR'
                 db        'WORDPTR'
                 db        'DWORDPTR'
                 db        'PWORDPTR'

_OpStruct        Struc
__aW              db        4                          ; Operand size
__aAdr            db        0                          ; Address size (0 -16 bit, 1 - 32 bit)
__aSEG            db        0                          ; Segment prefix
__farJmpSeg       dw        0                          ; Segment to far jump
__ModRM           db        0                          ; Mod R/M
__SIB             db        0                          ; scale index base
__farJmpOfs       dd        0                          ; Offset to far jump
__ExtRegFlag      db        0                          ; Eax,Ecx etc => 1
__RegsType        db        0                          ; 0 - No, 1 - Base, 2 -ext, 3 -seg, 4- special
__RegsData        db        0                          ; Regs cod
__ImmConst        dd        0                          ; Immediate constant
__DispConst       dd        0                          ; Disp
__DispSize        db        0                          ; 0 - Not,
__OpType          db        0                          ; reg=0,r/m=2,imm=1,rel=3
                 ends
;--- Operands field --------------------------------------------------------------
_OpFields        label     word
_aW              db        4                          ; Operand size
_aAdr            db        0                          ; Address size (0 -16 bit, 1 - 32 bit)
_aSEG            db        0                          ; Segment prefix
_farJmpSeg       dw        0                          ; Segment to far jump
_ModRM           db        0                          ; Mod R/M
_SIB             db        0                          ; scale index base
_farJmpOfs       dd        0                          ; Offset to far jump
_ExtRegFlag      db        0                          ; Eax,Ecx etc => 1
_RegsType        db        0                          ; 0 - No, 1 - Base, 2 -ext, 3 -seg, 4- special
_RegsData        db        0                          ; Regs cod
_ImmConst        dd        0                          ; Immediate constant
_DispConst       dd        0                          ; Disp
_DispSize        db        0                          ; 0 - Not,
_OpType          db        0                          ; reg,r/m,imm,rel
;--- Operands array --------------------------------------------------------------
_OpArray         db        3*24 dup (0)
_AdrPrefix       db        0
_SIBPresent      db        0
_OpPrefix        db        0
_DispData        dd        0
_SBit            db        0
_SBitMask        db        0
_NegPresent      db        0
_WBitSet         db        0
_CurAsmAdr       dd        0                         ; Current assemble adress
_CmdLen          db        0                         ; Command len (Confidentional)
_3OpPresent      db        0                         ; 3 operand present
_SpecialRegs     db        0                         ; CR,TR,DR
_aWTmp           db        0
_SBitNoSet       db        0
_NoTypeCheck     db        0
_sSegRegs        db        'ECSDFG'
_sBaseRegs       db        'AXCXDXBXSPBPSIDIALCLDLBLAHCHDHBH'
_sModRM16        db        'BX+SIBX+DIBP+SIBP+DISIDIBPBX'
;۲۲۲۲۲۲۲۲۲۲۲۲۲

cmd_tablelen     equ       asm_command-command_table
prf_tablelen     equ       segments_table-prefix_table
seg_tablelen     equ       command_table-segments_table