#include <qlib.h>
#include <stdlib.h>
#include <ctype.h>
#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <mem.h>
#include <string.h>
#include <dll.h>

#include "qdll.h"
#include "lefile.h"
#include "cmdline.h"

#define VERSION "0.43"

//#define debug

#define ZLIBSUPPORT                    // what can I say? ZLIB rocks!

#ifdef  ZLIBSUPPORT
extern "C" const char * zlibVersion (void);
extern "C" int   compress(byte *dest,dword *destLen,byte *source,dword sourceLen);
extern "C" int   uncompress(byte *dest,dword *destLen,byte *source,dword sourceLen);
#endif

extern "C" dword figure_bss_size(void *,dword);  // ptr LE img, LE img siz
extern "C" dword le_size(t_lehead *);            // expects pointer to LE header
extern "C" byte  le_load(t_lehead *,word,byte *);// file handle, LEhead pointer, place to store
extern "C" void  le_fixup(t_lehead *,byte *);    // LEhead ponter, buffer to fixup

void error(char *s) {
  printf("%s\n",s);
  exit(0);
}

sword file_exist(char *fn)
{
  dword dummy;
  return getfattr(fn,&dummy);
};

word tok_numtokens(char *s)
{
  byte c,n;

  c=0; n=0;
  while(s[c]!=0)
  {
    if(s[c]==',') n++;
    c++;
  };
  return n+1;
};

char *tok_gettoken(char *s,byte num)
{
  byte c,i;
  char *z;

  if((num>tok_numtokens(s))||num==0) return NULL;
  c=0; num--;
  /* skip all tokens BEFORE wanted token */

  while((num>0)&&(s[c]!=0))
  {
    if(s[c]==',')
    {
      num--;
    }
    c++;
  }
  if(num>0) return NULL;
  i=c;

/* skip tokens past the wanted one */
  while(s[c]!=0)
  {
    if(s[c]==',') break;
    c++;
  }

  if((c-i)<1) return NULL;

  z=(char *) malloc((c-i)+1); setmem(z,(c-i)+1,0);
  strncpy(z,&s[i],c-i);
  return z;
};

void main(int argc,char *argv[])
{
  struct t_exehead   exehdr;           // used for getting initial info
  struct t_lehead   *lehdr;            // LE file header (need dynamic resizing)
  struct t_QDLL_fhdr dllhdr;           // QDLL file header

  byte   *resdata;                     // the "resident data" from the LE header
  byte   *exeimage;                    // executable image
  byte   *compbuf;                     // compression buffer

  dword  lehdr_offset;                 // offset of the LE header
  dword  headerimagesize;              // size of the resident LE header stuff
  dword  exeimagesize;                 // LE executable image size
  dword  comprsize;                    // compressed size
  dword  bsssize;                      // size of the DLL bss

  dword  cnt;                          // general counter

  sword  fi,fo;                        // in and out file
  FILE  *deff,*wrpf;                   // definition file, (output) wrapper file
  char   fpat[68],fnam[9],fext[5];     // used for splitting filename
  char   filename[128];                // general-purpose file name :-)
  char   strng[80];

// program operation bools
  byte   b_bsselim;                    // eliminate BSS bool
  byte   b_compress;                   // compression bool
  byte   b_logo;                       // force show logo
  byte   b_quiet;                      // quiet operation bool
  byte   b_stats;                      // file stats bool
  byte   b_usedefs;                    // use .def files


/* ------ CODE BEGINS ------*/
  setmem(fpat,sizeof(fpat),0);
  setmem(fnam,sizeof(fnam),0);
  setmem(fext,sizeof(fext),0);
  cl_init(argc,argv);

  if(cl_numparms()<1)
  {
    printf("Usage: QDLLFIX <exe-file> [-bcdqs]\n");
    printf("  b: BSS elim, c: compress, d: use .def files, q: quiet, s: stats\n");
    exit(0);
  }

  b_bsselim=b_compress=b_usedefs=b_quiet=b_stats=0;

  compbuf=   (byte *) getenv("QDLLFIX");        // parse ENV var first
  if(compbuf!=NULL)
  {
    while(compbuf[cnt]!=0)
    {
      switch(toupper(compbuf[cnt]))
      {
        case 'B':b_bsselim=1;  break;
        case 'C':b_compress=1; break;
        case 'D':b_usedefs=1;  break;
        case 'L':b_logo=1;     break;
        case 'Q':b_quiet=1;    break;
        case 'S':b_stats=1;    break;
      }
      cnt++;
    }
  }

  if(cl_switchnum('b')|cl_switchnum('B'))b_bsselim=1;
  if(cl_switchnum('c')|cl_switchnum('C'))b_compress=1;
  if(cl_switchnum('d')|cl_switchnum('D'))b_usedefs=1;
  if(cl_switchnum('l')|cl_switchnum('L'))b_logo=1;
  if(cl_switchnum('q')|cl_switchnum('Q'))b_quiet=1;
  if(cl_switchnum('s')|cl_switchnum('S'))b_stats=1; // show stats even if quiet!
  if(!(b_quiet&!b_logo)) printf(" QDLLFiX v%s by Sune Marcher\n",VERSION);

  strcpy(filename,cl_getparm(1));
  fsplit(filename,fpat,fnam,fext);

  if(!file_exist(filename))
  {
    strcat(filename,".exe");
    if(!file_exist(filename)) error("couldn't find infile");
  }

  if( (fi=open(filename,O_BINARY|O_RDONLY))==-1)
    error("couldn't open input file");

  if (read(fi,&exehdr,sizeof(exehdr))!=sizeof(exehdr))
    error("Couldn't read EXE header");
    
  lehdr_offset=(512*(exehdr.pagecnt-1))+((exehdr.pagemod+7)& 0xFFF8);

  #ifdef debug
    printf("LEoffset = %#x",lehdr_offset);
  #endif

  if (filelength(fi)<lehdr_offset) error("file too small to be a LE file");

  lehdr=(t_lehead *) malloc(sizeof(t_lehead));
  setmem(lehdr,sizeof(t_lehead),0);

  lseek(fi,lehdr_offset,SEEK_SET);
  read(fi,lehdr,sizeof(t_lehead));

  if ((lehdr->sig)!=LE_MAGIC) error("not a LE file");

// get stuff from the LE file
  headerimagesize=lehdr->objecttable+lehdr->loadersize;// size of header+resident data
  lehdr=(t_lehead *) realloc(lehdr,headerimagesize);  // resize header

  resdata=(byte *) (sizeof(t_lehead)+((dword) lehdr));// pointer to resident data
  read(fi,resdata,headerimagesize-sizeof(t_lehead));  // read the resident data
  exeimagesize=le_size(lehdr);                        // size of LE exe image

  strcpy(filename,fpat); strcat(filename,fnam); strcat(filename,".qdl");
  if((fo=open(filename,O_BINARY|O_RDWR|O_CREAT|O_TRUNC))==-1)
    error("couldn't create output file");

// read in the LE exec image
  if(!b_quiet) printf("copying LE-EXE image...");
  lseek(fi,(headerimagesize+lehdr_offset+511)&(0xFFFFFFFF-511),SEEK_SET);

  exeimage=(byte *) malloc(exeimagesize);        // get memory for the LE exe image
  setmem(exeimage,exeimagesize,0);               // zero the memory
  le_load(lehdr,fi,exeimage);                    // load the image...With assembly code

  if(b_bsselim)
  {
    bsssize=figure_bss_size(exeimage,exeimagesize);
    exeimagesize-=bsssize;
  } else bsssize=0;

// construct header for QDLL file
  setmem(&dllhdr,sizeof(dllhdr),0);
  if(b_compress) dllhdr.flags|=QF_COMPRESSED;
  dllhdr.sig=QDLL_SIG;
  dllhdr.version=DLL_VERSION;
  dllhdr.imagesize=exeimagesize;            // physical size
  dllhdr.bsssize=bsssize;
  dllhdr.numrelocs=headerimagesize;         // numrelocs==fixupsize..
  dllhdr.entrypoint=lehdr->entryoffset;
  strcpy(dllhdr.idstring,"Created by QDLLFIX");


  if(b_compress)
  {
    #ifdef ZLIBSUPPORT
      if(!b_quiet) printf("compressing: ");
      compbuf=(byte *) malloc(exeimagesize+12+(exeimagesize/100));
      if(!::compress(compbuf,&comprsize,exeimage,exeimagesize))
      {
        if(!b_quiet) printf("reduced to %d",comprsize);
        dllhdr.compressedsize=comprsize;
        write(fo,&dllhdr,sizeof(dllhdr));
        write(fo,compbuf,comprsize);
      } else printf("error!");
      free(compbuf);
    #else
      printf("WARNING: Compression not supported\n");
    #endif
  } else
  {
    write(fo,&dllhdr,sizeof(dllhdr));
    write(fo,exeimage,exeimagesize);             // write the raw image to file
  }

  if(!b_quiet) printf("done\n");

  // I need to figure out how the heck fixups work in a LE file...
  // I need to be able to port it to a simpler format.
  // Right now, the header+"resident data" (fixups) is just copied directly.
  if(!b_quiet) printf("copying fixup info...");
  write(fo,lehdr,headerimagesize);
  if(!b_quiet) printf("done\n");

  if(b_stats)
  {
    if(b_bsselim) {
      printf("image size:            %d\n",exeimagesize);
      printf("image BSS size:        %d\n",bsssize);
    }
    if(b_compress|b_bsselim) {
      printf("original image size:   %d\n",exeimagesize+bsssize);
    }
    if(b_compress) {
      printf("compressed image size: %d\n",dllhdr.compressedsize);
      printf("compression ratio:     %d%%\n",ftol((double) dllhdr.compressedsize/(exeimagesize+bsssize)*100));
    }
    if(b_bsselim)  {
      printf("BSS reduction ratio:   %d%%\n",ftol((double) exeimagesize/(exeimagesize+bsssize)*100));
    }
    printf("fixup info size:       %d\n",headerimagesize);
    printf("entrypoint:            %X\n",dllhdr.entrypoint);
  }

  close(fo);
  close(fi);

  if(!b_usedefs) exit(0);

// try to open a "definition" file for the DLL.
// If the definition file does not exist, we're done.
  strcpy(filename,fpat); strcat(filename,fnam); strcat(filename,".def");
  if((deff=fopen(filename,"rb"))==NULL) exit(0);

  strcpy(filename,fpat); strcat(filename,fnam); strcat(filename,".wrp");
  if((wrpf=fopen(filename,"wb"))==NULL)
  {
    printf("couldn't create \"dlltest.wrp\"\n");
    fclose(deff);
    exit(0);
  }
  if(!b_quiet) printf("generating DLL wrapper file\n");

  fprintf(wrpf,"/* ***************************************\n");
  fprintf(wrpf,"   DLL function wrapper file\n");
  fprintf(wrpf,"*************************************** */\n");

// parse the definition file, generate wrapper file
  char *t1,*t2,*t3;
  dword numparms;

  while(!feof(deff))
  {
    do
    {
      setmem(strng,80,0);
      fscanf(deff,"%s",strng);
      for(cnt=0;cnt<strlen(strng);cnt++)
      {
        if(strng[cnt]==';')
        {
          strng[cnt]='\0';
          break;
        }
      }
    } while( (!feof(deff))&&(strlen(strng)<1));

    t1=tok_gettoken(strng,1);
    t2=tok_gettoken(strng,2);
    t3=tok_gettoken(strng,3);

    numparms=tok_numtokens(strng);

    if(numparms<3) fprintf(wrpf,"%s %s(void)\n",t2,t1);
    else
    {
      fprintf(wrpf,"%s %s(%s p1",t2,t1,t3);

      if(numparms>3)
      {
        for(cnt=4;cnt<=numparms;cnt++)
        {
          free(t3);
          t3=tok_gettoken(strng,cnt);
          fprintf(wrpf,",%s p%d",t3,cnt-2);
        }
        fprintf(wrpf,")\n");
        free(t3);
      }
    }
    t3=tok_gettoken(strng,3);

    fprintf(wrpf,"{\n");
    fprintf(wrpf,"  %s (*callfunc)(",t2);
    if(numparms<3) fprintf(wrpf,"void");
    else
    {
      fprintf(wrpf,"%s",t3);
      if(numparms>3)
      {
        for(cnt=4;cnt<=tok_numtokens(strng);cnt++)
        {
          free(t3);
          t3=tok_gettoken(strng,cnt);
          fprintf(wrpf,",%s",t3);
        }
      }
    }
    fprintf(wrpf,");\n");

    fprintf(wrpf,"  callfunc=(%s(*)(",t2);

    if(numparms<3) fprintf(wrpf,"void");
    else
    {
      if(numparms>3)
      {
        for(cnt=3;cnt<=numparms;cnt++)
        {
          free(t3);
          t3=tok_gettoken(strng,cnt);
          fprintf(wrpf,t3);
          if(cnt<tok_numtokens(strng)) fprintf(wrpf,",");
        };
        free(t3);
      }
    }

    fprintf(wrpf,")) dll_import_nam(dllhnd,\"%s\");\n",t1); // note that "dllhnd" will have to be changed by hand...

    free(t1);
    free(t2);
    if(t3!=NULL) free(t3);

    fprintf(wrpf,"  if((sdword)callfunc!=ERROR) ");
    strlwr(t2);
    if(strcmp(t2,"void")!=0) fprintf(wrpf,"return ");
    fprintf(wrpf,"callfunc(");
    if(tok_numtokens(strng)>2)
    {
      for(cnt=3;cnt<=tok_numtokens(strng);cnt++)
      {
        fprintf(wrpf,"p%d",cnt-2);
        if(cnt<tok_numtokens(strng)) fprintf(wrpf,",");
      }
    }
    fprintf(wrpf,");\n};\n");
  }
  fclose(deff);
  fclose(wrpf);
};