; OS detection v1.03
; Usage : Detects OS present and sets _os... accordingly.

; NEW v1.01 - added support for DesqView (Dec 17/96)
; NEW v1.02 - change to _os_typ, _os_ver_major, _os_ver_minor
;             added _dos_ver_major, _dos_ver_minor
; NEW v1.03 - Now detects WinNT if %OS%=="Windows_NT"

include os.inc

.code
detect_os proc private
  mov _os_ver_major,0
  mov _os_ver_minor,0
  mov _os_typ,OS_DOS    ; assume DOS until otherwise

  mov ax,160ah  ;get Win 3.x/95 version
  int 2fh
  test ax,ax
  jnz try_winnt
windoze_found:
  mov _os_ver_major,bh   ;assume >= 3
  mov _os_ver_minor,bl

  .if bh>3
    mov _os_typ,OS_WIN32   ; Win 95+ or NT 4.x+
  .elseif bl>11   ;BUG! is this 11 or 11h?
    mov _os_typ,OS_WINNT   ; Win NT 3.x
    jmp getDOSver
  .else  
    mov _os_typ,OS_WIN     ; Win 3.x
    jmp getDOSver
  .endif

try_winnt:
  callp getenv,"OS"
  test eax,eax  ;NULL?
  jz try_dv

  callp strcmp,eax,"Windows_NT"
  test eax,eax
  jnz try_dv

  mov _os_typ,OS_WINNT   ; Win NT
  ;BUG! : what is the version?
  jmp getDOSver

try_dv:
  mov     ax,2B01h   ;detect Desqview
  mov     cx,4445h
  mov     dx,5351h
  int     21h
  cmp     al,0FFh
  jz      try_os2
  mov _os_typ,OS_DV    ;Desqview detected!
  mov _os_ver_major,0
  mov _os_ver_minor,0  ;BUG! : what is the version?
  jmp getDOSver

try_os2:
  mov ax,4010h
  xor bx,bx
  int 2fh
  cmp ax,4010h
  je getDOSver
  mov _os_typ,OS_OS2
  mov _os_ver_major,bl
  mov _os_ver_minor,bh

getDOSver:
  mov ax,3000h
  int 21h
  mov _dos_ver_major,al
  mov _dos_ver_minor,ah
  .if _os_typ == OS_DOS
    mov _os_ver_major,al
    mov _os_ver_minor,ah
  .endif
  ret
detect_os endp

