include src\qlib.inc
include stdio.inc
include dos.inc
include alloc.inc
include fcntl.inc  ;O_... constants
include string.inc

.data
  _fmode dw O_TEXT    ;system default

.code

;reads data into in buffer
; in:EDX=FILE*
_FILE_READ proc private
  ;assumes buf is empty and is in use (ie: _IOFBF or _IOLBF)
  test [edx].FILE.flags,_F_STR
  jnz __EOF
  mov eax,[edx].FILE.bufsiz
  dec eax   ;FIX : v2.11 b2 : read 1 less in case ungetc() will be needed
  callp read,[edx].FILE.handle,[edx].FILE.buf,eax
  cmp eax,EOF
  je __EOF
  mov [edx].FILE.isiz,eax
  mov [edx].FILE.ipos,0  ;when ipos==isiz then buffer is empty
  test eax,eax    ;; v2.10 b2 : Need these 2 lines
  jz __EOF        ;;
  ret
__EOF:
  mov eax,EOF
  or [edx].FILE.flags,_F_EOF
  ret
_FILE_READ endp
  
;flushes out-bound data
; in:EDX=FILE*
_FILE_WRITE proc private
  callp write,[edx].FILE.handle,[edx].FILE.buf,[edx].FILE.osiz
  mov [edx].FILE.osiz,0
  ret
_FILE_WRITE endp

fflush proc uses edx,dev:dword
  mov edx,dev
  .if [edx].FILE.lastop == _LO_READ
    mov [edx].FILE.isiz,0
    mov [edx].FILE.ipos,0  ;when ipos==isiz then buffer is empty
  .elseif [edx].FILE.lastop == _LO_WRITE
    .if [edx].FILE.osiz
      call _FILE_WRITE
      cmp eax,ERROR
      je __ERROR
    .endif
  .endif
  ret
__ERROR:
  or [edx].FILE.flags,_F_ERR
  ret
fflush endp

fgetc proc uses edx ebx,dev:dword
  mov edx,dev
  .if ! ([edx].FILE.flags & _F_READ)
    mov eax,ERROR  ;or EOF
    ret
  .endif
  .if [edx].FILE.lastop == _LO_WRITE
    mov eax,ERROR  ;or EOF
    ret
  .else
    mov [edx].FILE.lastop,_LO_READ
  .endif
  .if [edx].FILE.flags & (_F_EOF or _F_ERR)
    mov eax,EOF
    ret
  .endif
  mov eax,[edx].FILE.ipos
  .if eax == [edx].FILE.isiz
@@:
    call _FILE_READ
    cmp eax,EOF
    je __EOF
    mov eax,[edx].FILE.ipos
  .endif
  cmp eax,[edx].FILE.isiz
  je @b
  mov ebx,[edx].FILE.buf
  add ebx,[edx].FILE.ipos
  inc [edx].FILE.ipos
  inc [edx].FILE.cpos
  mov bl,[ebx]
  test [edx].FILE.flags,_F_LBUF  ;;FIX v2.11 b2 : do not check for EOF on line buffered streams ie:stdin
  jnz @f
  mov eax,[edx].FILE.ipos   ;; FIX v2.10 b2 : this needs to be here (to check for EOF)
  cmp eax,[edx].FILE.isiz
  .if zero?
    call _FILE_READ         ;; FIX v2.11 b1 : ignore EOF here (this is just to set EOF flag so that feof() will work)
  .endif
@@:
  xor eax,eax
  mov al,bl
__EOF:
  ret
fgetc endp

fputc proc uses edx ebx,char:byte,dev:dword
  mov edx,dev
  .if ! ([edx].FILE.flags & _F_WRIT)
    mov eax,ERROR  ;or EOF
    ret
  .endif
  .if [edx].FILE.lastop == _LO_READ
    mov eax,ERROR  ;or EOF
    ret
  .else
    mov [edx].FILE.lastop,_LO_WRITE
  .endif
  .if [edx].FILE.flags & (_F_EOF or _F_ERR)
    mov eax,EOF
    ret
  .endif
  mov eax,[edx].FILE.osiz
  .if eax == [edx].FILE.bufsiz
    call _FILE_WRITE
    cmp eax,ERROR
    je __ERROR
  .endif
  mov ebx,[edx].FILE.buf
  add ebx,[edx].FILE.osiz
  inc [edx].FILE.osiz
  inc [edx].FILE.cpos
  mov al,char
  mov [ebx],al
  .if [edx].FILE.buftyp  ;_IONBF or _IOLBF
    call _FILE_WRITE
    cmp eax,ERROR
    je __ERROR
  .endif
  ret
__ERROR:
  or [edx].FILE.flags,_F_ERR
  ret
fputc endp

fread proc,buf:dword,siz:dword,n:dword,dev:dword
  local cnt:dword
  pushad
  mov edx,dev
  mov cnt,0
  .if ! ([edx].FILE.flags & _F_READ)
    popad
    mov eax,ERROR  ;or EOF
    ret
  .endif
  .if [edx].FILE.lastop == _LO_WRITE
    popad
    mov eax,ERROR  ;or EOF
    ret
  .else
    mov [edx].FILE.lastop,_LO_READ
  .endif
  .if [edx].FILE.flags & (_F_EOF or _F_ERR)
    popad
    mov eax,EOF
    ret
  .endif
  mov edi,buf
  mov ebx,siz    ;size of each element
@@:
  mov ecx,[edx].FILE.ipos
  mov eax,[edx].FILE.isiz
  .if eax==ecx
    call _FILE_READ
    cmp eax,EOF
    je __EOF
    jmp @b
  .endif
  sub eax,ecx  ;EAX = amount of data avail.
  ;copy what we need for current element (or all if need be)
  .if eax >= ebx
    ;copy the rest of ebx
    mov esi,[edx].FILE.buf
    add esi,[edx].FILE.ipos
    mov ecx,ebx
    copyECX  ;destroys AL
    inc cnt
    add [edx].FILE.ipos,ebx
    mov ebx,siz
    add [edx].FILE.cpos,ebx
    dec n
    jnz @b
__EOF:
    popad
    mov eax,cnt
    ret
  .else
    ;copy as much as we can and read more data in
    mov esi,[edx].FILE.buf
    mov ecx,eax
    sub ebx,eax
    copyECX  ;destroys AL
    mov [edx].FILE.isiz,0 ;may be needed after all (_F_STR)
    call _FILE_READ
    cmp eax,__EOF
    je __EOF
    jmp @b
  .endif
fread endp

fwrite proc,buf:dword,siz:dword,n:dword,dev:dword
  local cnt:dword
  pushad
  mov edx,dev
  mov cnt,0
  .if ! ([edx].FILE.flags & _F_WRIT)
    popad
    mov eax,ERROR  ;or EOF
    ret
  .endif
  .if [edx].FILE.flags & (_F_EOF or _F_ERR)
    popad
    mov eax,EOF
    ret
  .endif
  .if [edx].FILE.lastop == _LO_READ
    popad
    mov eax,ERROR
    ret
  .else
    mov [edx].FILE.lastop,_LO_WRITE
  .endif
  mov esi,buf
  mov ebx,siz    ;size of each element
@@:
  mov eax,[edx].FILE.osiz
  mov ecx,[edx].FILE.bufsiz
  .if eax == ecx
    ;flush buffer
    call _FILE_WRITE
    cmp eax,ERROR
    je __ERROR
    jmp @b
  .endif
  ;copy whatever we can to output buffer
  sub ecx,eax  ;ECX = amount of space avail in buffer
  .if ecx >= ebx
    ;copy the rest of ebx
    mov edi,[edx].FILE.buf
    add edi,eax
    mov ecx,ebx
    copyECX  ;destroys AL
    inc cnt  ;# of elements written
    add [edx].FILE.osiz,ebx
    add [edx].FILE.cpos,ebx
    mov ebx,siz
    dec n
    jnz @b
    .if [edx].FILE.buftyp  ;_IONBF or _IOLBF
      call _FILE_WRITE
      cmp eax,ERROR
      je __ERROR
    .endif
    popad
    mov eax,cnt
    ret
  .else
    ;copy as much as we can and then flush data
    mov edi,[edx].FILE.buf
    sub ebx,ecx
    add [edx].FILE.osiz,ecx
    add [edx].FILE.cpos,ecx
    copyECX  ;destroys AL
    call _FILE_WRITE
    cmp eax,ERROR
    je __ERROR
    jmp @b
  .endif
__ERROR:
  popad
  or [edx].FILE.flags,_F_ERR
  ret
fwrite endp

_putch proc,char:word
  callp fputc,char,stdout
  ret
_putch endp

_endseg

end
