#ifndef __STDLIB_H__
#define __STDLIB_H__

#include <stddef.h>

#include <alloc.h>

#include <process.h>

#ifdef __cplusplus
  extern "C" {
#endif

typedef void (* atexit_t)(void);

#define _SYS_TIMER (*((dword *) 0x46c))

extern int atexit(atexit_t func);

extern void *getenv(char *s);

//ANSI C stuff
extern dword atol(char *s);
extern word atoi(char *s);

extern dword itoa(word i,char *s,byte rax);
extern dword ltoa(dword i,char *s,byte rax);
extern dword ultoa(dword i,char *s,byte rax);

extern double ftoa(double,void *,dword);
extern double etoa(double,void *,dword);
extern dword ftol(double);

extern void perror(char * s);
extern char * sys_errlist[];
extern dword sys_nerr;

extern void srand(word);
extern word rand(void);
extern word random(word);
extern void randomize(void);

#ifdef __cplusplus
  }
#endif

#define RAND_MAX 0x7FFF

#define EXIT_SUCCESS 0
#define EXIT_FAILURE 1

#define max(a,b)        (((a) > (b)) ? (a) : (b))
#define min(a,b)        (((a) < (b)) ? (a) : (b))

#endif
