externdef getbyte :near
externdef getword :near
externdef getdword :near

_info struct
  typ db ?      ;Type (see _TYPE_... below)
  siz db ?      ;Size in bits  (Zero if operand in O_NONE, -1 if unknown)
  reg db ?      ;Register # (0=al/ax/eax, 1=cl/cx/ecx, etc.) (0=es, etc.)
  sreg db ?     ;Default seg reg for MR
  reg1 db ?     ;Reg #1 (MR) (base in SIB)  (-1 = not used)
  scale db ?    ;SIB scale  (0-indicates it's not a SIB)
  scale2 db ?   ;SIB scale  (0,1,2,3)  ;SHL x,scale2
  reg2 db ?     ;Reg #2 (MR) (index in SIB) (-1 = not used)
  off dd ?      ;displacement or Relative JMP displacement 
  nooff db ?    ;no offset (MR only)
  jseg dw ?     ;Segment for FAR JMP/CALL
_info ends

;_info.typ Types : Memory reference Type/JMP Type
_TYPE_NONE EQU 0
_TYPE_MRF  EQU 1  ;float
_TYPE_MRI  EQU 2  ;int/mmx
;jmp_typ Types
_JT_NONE EQU 0
_JT_JMP  EQU 1  ;jmp/call
_JT_Jx   EQU 2  ;jx/jcxz (conditional)

_lodsb macro
  ;FS:ESI = source
  call getbyte
  jc _invalid_page
  inc esi
  movzx eax,al
endm

_lodsbi macro   ;i=do not goto _invalid_page on error
  ;FS:ESI = source
  call getbyte
  movzx eax,al
  pushf
  inc esi
  popf  
endm

_lodsw macro
  call getword
  jc _invalid_page
  add esi,2
  movzx eax,ax
endm

_lodsd macro
  call getdword
  jc _invalid_page
  add esi,4
endm

callstruct struct   ;50 bytes  (32h)
  _edi dd ?     ;0 
  _esi dd ?     ;4
  _ebp dd ?     ;8
  _res dd ?     ;0ch reserved
  _ebx dd ?     ;10h
  _edx dd ?     ;14h
  _ecx dd ?     ;18h
  _eax dd ?     ;1ch
  _flg dw ?     ;20h flags
  _es dw ?      ;22h segments (NOT selectors)
  _ds dw ?      ;24h "
  _fs dw ?      ;26h "
  _gs dw ?      ;28h "
  _ip dw ?      ;2ah ignored in some calls
  _cs dw ?      ;2ch "
  _sp dw ?      ;2eh must be 0 to use system stacks
  _ss dw ?      ;30h "
callstruct ends

set_size_databits macro
  local _done,_32
  ;sets [ecx]._info.siz based on data bits
  cmp databits,1  ;32bit?
  je _32
  mov [ecx]._info.siz,16   ;16bits
  jmp _done
_32:
  mov [ecx]._info.siz,32   ;32bits
_done:
endm

set_size_BL macro
  local _done,_8,_16,_32,_1632,_64,_80
  ;sets [ecx]._info.siz based on BL
  mov al,bl
  and al,111b
  cmp al,S_16
  jb _8
  je _16
  cmp al,S_1632
  jb _32
  je _1632
  cmp al,S_80
  jb _64
  je _80
  mov [ecx]._info.siz,-1  ;unknown
  jmp _done
_8:
  mov [ecx]._info.siz,8
  jmp _done
_16:
  mov [ecx]._info.siz,16
  jmp _done
_32:
  mov [ecx]._info.siz,32
  jmp _done
_1632:
  set_size_databits
  jmp _done
_64:
  mov [ecx]._info.siz,64
  jmp _done
_80:
  mov [ecx]._info.siz,80
_done:
endm

get_mod_rm macro
  local __
  ;get MOD_RM byte
  cmp got_mod_rm,1
  je __
  _lodsb
  mov mod_rm,al
  mov got_mod_rm,1
__:
endm

get_sib macro
  local __
  ;get SIB byte
  cmp got_sib,1
  je __
  _lodsb
  mov sib,al
  mov got_sib,1
__:
endm

_mask_rm macro x:REQ
  and x,00000111b
endm

_mask_reg macro x:REQ
  and x,00111000b
  shr x,3
endm

_mask_mod macro x:REQ
  and x,11000000b
  shr x,6
endm

_mask_ss macro x:REQ
  and x,11000000b
  shr x,6
endm

_mask_idx macro x:REQ
  and x,00111000b
  shr x,3
endm

_mask_base macro x:REQ
  and x,00000111b
endm
