;
; Quick Generic 80x86 Disassembler
; 8086 thru PII/MMX w/FPU (loadall,foof bug and more)
; mailto:sub_death@geocities.com
; http://qforce.home.ml.org
;
; Feel free to use this in freeware stuff as long as you give me credits
; for it. Questions? Email me.
;
; [Based on Dazmit v1.03 by fluff@geocities.com] - thanx Michael
;
; To compile with MASM v6.11+: (if you don't have QLIB)
;   ml /c /Cx /Cp dasm.asm
; If you have QLIB:
;   masm2obj dasm
; Should be easy to convert to TASM and other assemblers.
;
; Also see getdata.asm in the \samples\dasm to add needed functions for DASM.
; I've included these funcs seperate because my debugger (QDebug) already
; provides these funcs so I don't need them inside DASM.OBJ. The sample in
; the \samples\dasm directory will Disassemble COMs to ASM files (it requires
; QLIB).
;

.386p
.model flat,c
.code
assume fs:_TEXT,gs:_TEXT

; Notes:
;   EBP is used thru-out many PROCs in here so no LOCAL vars are allowed or
;   arguments.  (To prevent EBP from being corrupted)

include dasm.inc     ;in \INC directory

include flags.inc
include _dasm.inc
include dasm.equ
include opcodes.inc
include nemonics.inc

REMOVEZEROS EQU 0                          ;Remove useless zeros

;
; Imports
;

; getbyte() getword() getdword()   - see dasm.inc
;Reads byte/word/dword at (FS:ESI) and protects against page faults
;Returns CARRY if page fault occurs, else returns data in EAX
;Must preserve all regs (except EAX)

;
; Exports
;

JMP_Flag db ?           ;set if instruction contains a JMP/Jx/CALL
JMP_Address dd ?        ;linear address if jump is used
MR_Flag db ?            ;set if instruction contains a MOD/RM reference
MR_Type db ?            ;instruction type (0=integer 1=float 2=mmx)
MR_Address dd ?         ;address of mem reference
MR_Size db ?            ;size of reference (in bits)
MR_Segment db ?         ;segment used in instruction (could be overrided)
DO_Prefix db ?          ;is instruction a prefix byte?

;
; In:
;       FS:ESI -> Buffer to read bytes from (the code)
;       ES:EDI -> Buffer to output string to (the string)
;       DS:ECX -> Reversed PUSHAD data structure
;                 This is used for MR_... calculations (see above)
;                   and J(E)CXZ prediction
;       EDX == EFlags (for Jcond prediction (see JMP_Address/JMP_Flag)
;       EBX == Program Base (ie: 0h-PMODE32 apps  100h-COM files)
;       AL == Default segment size (0=16bit / 1=32bit)
; Out:
;       ECX == Instruction's length in bytes
;       ES:EDI -> Buffer filled with Dasm string
;       FS:ESI -> points to next byte after instruction 
;                 incremented by one on page faults or invalid opcodes
;       All other registers not changed

.code
align 4
DecodeOpcode proc
  pushad
  mov JMP_Flag,0                        ;no jump
  mov MR_Flag,0                         ;no mem reference
  mov oldstk,esp                        ;in case we gotta abort
  mov seg_flag,0                        ;seg override in use
  mov DO_Prefix,0                       ;not a prefix
  mov prg_base,ebx
  mov JMP_flags,edx
  mov input_off,esi
  mov input_sel,fs
  mov output_off,edi
  mov output_sel,es
  mov MR_registers,ecx
  mov ebp,edi
  mov defsegsize,al
  mov databits,al
  mov addrbits,al
  mov got_mod_rm,0       ;mod/rm has been retreived?
  mov _prefix,0          ;1st Prefix Type (used in _just_prefix())

__prefix:

  _lodsb
  cmp al,66h
  jne @f
  mov al,defsegsize
  xor al,1
  mov databits,al
  cmp _prefix,0
  jne __prefix
  mov _prefix,66h
  jmp __prefix
@@:
  cmp al,67h
  jne @f
  mov al,defsegsize
  xor al,1
  mov addrbits,al
  cmp _prefix,0
  jne __prefix
  mov _prefix,67h
  jmp __prefix
@@:
  cmp al,26h
  jne @f
  cmp seg_flag,1
  je _just_prefix
  mov seg_flag,1
  mov seg_over,SO_ES
  cmp _prefix,0
  jne __prefix
  mov _prefix,1
  jmp __prefix
@@:
  cmp al,2eh
  jne @f
  cmp seg_flag,1
  je _just_prefix
  mov seg_flag,1
  mov seg_over,SO_CS
  cmp _prefix,0
  jne __prefix
  mov _prefix,1
  jmp __prefix
@@:
  cmp al,36h
  jne @f
  cmp seg_flag,1
  je _just_prefix
  mov seg_flag,1
  mov seg_over,SO_SS
  cmp _prefix,0
  jne __prefix
  mov _prefix,1
  jmp __prefix
@@:
  cmp al,3eh
  jne @f
  cmp seg_flag,1
  je _just_prefix
  mov seg_flag,1
  mov seg_over,SO_DS
  cmp _prefix,0
  jne __prefix
  mov _prefix,1
  jmp __prefix
@@:
  cmp al,64h
  jne @f
  cmp seg_flag,1
  je _just_prefix
  mov seg_flag,1
  mov seg_over,SO_FS
  cmp _prefix,0
  jne __prefix
  mov _prefix,1
  jmp __prefix
@@:
  cmp al,65h
  jne @f
  cmp seg_flag,1
  je _just_prefix
  mov seg_flag,1
  mov seg_over,SO_GS
  cmp _prefix,0
  jne __prefix
  mov _prefix,1
  jmp __prefix
@@:
  ;Prefixes done
  ;lookup in opcodes table
  dec esi  ;move back to 1st opcode byte
  lea edi,opcodes
_next_opcode:
  push edi
  push esi
  mov bl,[edi]                          ;Opcode Size
  test bl,bl
  jz _invalid_opcode                    ;Opcode not found
_next_byte:
  inc edi
  ;some instructions may extend into an invalid page while other may not!
  ;So this LODSB will NOT immediately JMP to _invalid_page on a PAGE fault
  _lodsbi
  jc _do_next
  cmp al,[edi]
  jne _do_next
  dec bl
  jnz _next_byte
  ;Found Opcode
  jmp _got_opcode
_do_next:
  mov got_mod_rm,0       ;mod/rm has not been retreived
  pop esi
  pop edi
  xor eax,eax
  mov al,[edi]
  add edi,eax
  add edi,SIZEOF_OPCODE
  jmp _next_opcode
_got_opcode:
  inc edi   ;skip over last opcode byte
  ;init do_operand
  mov _force_pp_siz,0    ;used to force pp if siz!=defsegsize
  mov _force_pp,0        ;used to force pp always!
  mov _far_ptr,0         ;indicates it's a 'FAR PTR'
  mov got_sib,0          ;SIB byte has been retreived?
  mov put_ptr,0          ;put 'x PTR'
  mov _info1.typ,0
  mov _info2.typ,0
  mov _info3.typ,0
  mov jmp_typ,0

  xor cl,cl  ;operand count
  mov eax,[edi]          ;get operand 1,2,3,type?
  mov opr1,al
  mov opr2,ah
  cmp al,O_NONE
  je @f
  inc cl
@@:
  cmp ah,O_NONE
  je @f
  inc cl
@@:
  shr eax,16
  mov opr3,al
  mov oprx,ah   ;Operand Type
  cmp al,O_NONE
  je @f
  inc cl
@@:
  mov oprc,cl

  test ah,OB_MATCH
  jz @f
  ;mod_rm is present and must match ah to be a match
  xor ah,OB_MATCH  ;remove MATCH bit
  mov bl,ah
  get_mod_rm
  mov al,mod_rm
  _mask_reg al
  cmp bl,al
  jne _do_next
@@:
  add esp,8     ;Skip over ESI/EDI on stack
  add edi,5     ;Skip to OpcodeStrName
  xor eax,eax
  mov ax,[edi]
;check if special opcode (due to databits -ie: pushad)
  cmp databits,1
  jne _not_special
  mov ebx,offset mnemonics_special
@@:
  cmp ax,[ebx]
  jne _next_special
  mov ax,[ebx+2]
  jmp _not_special
_next_special:
  add ebx,4
  cmp word ptr[ebx],0
  jne @b
_not_special:
  imul eax,10
  add eax,offset mnemonics
  mov opcode_name,eax
;check if JMP/CALL  (in case it's not a REL jump)
  cmp dword ptr[eax],' pmj'
  jne @f
  mov jmp_typ,_JT_JMP
@@:
  cmp dword ptr[eax],'llac'
  jne @f
  mov jmp_typ,_JT_JMP
@@:

  mov cl,5
  cmp byte ptr[eax+4],' '
  je @f
  mov cl,10     ;string length
@@:
  call _putstrCL

  mov bl,opr1
  cmp bl,O_NONE
  je _done_instr
  mov ecx,offset _info1
  call _do_operand
  mov bl,opr2
  cmp bl,O_NONE
  je _done_instr
  mov ecx,offset _info2
  call _do_operand
  mov bl,opr3
  cmp bl,O_NONE
  je _done_instr
  mov ecx,offset _info3
  call _do_operand
_done_instr:

  ;Now use info in _info? to determine size of MR, Jump, etc.
  call _pp_chk_
  call _mr_chk_
  call _jmp_chk_

  mov bl,opr1
  cmp bl,O_NONE
  je _done_print
  mov ecx,offset _info1
  call _put_operand
  mov bl,opr2
  cmp bl,O_NONE
  je _done_print
  mov al,','
  call _putb
  mov ecx,offset _info2
  call _put_operand
  mov bl,opr3
  cmp bl,O_NONE
  je _done_print
  mov al,','
  call _putb  
  mov ecx,offset _info3
  call _put_operand
_done_print:
  ;NEW : v0.95 : indicate if it's a Prefix (REPx, LOCK, etc.)
  ;Check if DO_Prefix needs to be set
  mov eax,output_off
  cmp word ptr[eax],'er'     ;REPx
  jne @f
  cmp byte ptr[eax+1],'p'
  jne @f
  mov DO_Prefix,1
  jmp _done
@@:  ;it's not "REP"
  cmp dword ptr[eax],'kcol'  ;LOCK
  jne @f
  mov DO_Prefix,1
  jmp _done
@@:
_done:
  cmp seg_flag,0
  je @f
  jmp _just_prefix
@@:
  xor al,al
  call _putb
  sub esi,input_off  ;ESI = size used
  mov [esp].callstruct._ecx,esi  ;save into ECX on stack
  popad
  add esi,ecx
  ret
DecodeOpcode endp

_do_operand proc private
  ;In : BL = opr?
  ;   : ECX -> info block to be filled out

  xor eax,eax
  mov al,bl
  and al,0f8h
  shr eax,1   ;convert to DWORDs
  jmp [_do_operand_table + eax]
_do_operand endp

_O_NONE:
  mov [ecx]._info.typ,_TYPE_NONE
  ret

_O_SEGR:
  set_size_databits         ;set size based on databits
  mov [ecx]._info.typ,_TYPE_NONE
  mov _force_pp_siz,1           ;Force pp if siz!=defsegsize
  mov al,oprx
  cmp al,OB_SR
  jne @f
  get_mod_rm
  xor edx,edx
  mov dl,mod_rm   ;Segment #
  _mask_reg dl
  mov [ecx]._info.reg,dl
  ret
@@:
  mov dl,oprx
  mov [ecx]._info.reg,dl
  ret

_O_CR:
_O_DR:
_O_TR:
  get_mod_rm
  mov dl,mod_rm   ;CRx
  _mask_reg dl
  mov [ecx]._info.reg,dl
  mov [ecx]._info.siz,32
  mov [ecx]._info.typ,_TYPE_NONE
  ret

_O_R8:
;_O_R16
;_O_R32
;_O_R1632
  ;If oprx == OB_SR then Register # is in mod_rm, else it's oprx
  set_size_BL  ;trashes AL
  mov [ecx]._info.typ,_TYPE_NONE

  mov al,oprx
  cmp al,OB_SR
  jne @f
  get_mod_rm
  mov dl,mod_rm
  _mask_reg dl
  mov [ecx]._info.reg,dl
  ret
@@:
  mov dl,oprx
  mov [ecx]._info.reg,dl
  ret

_O_MMX32:
;_O_MMX64
  ;If oprx == OB_MMXR then Register # is in mod_rm, else it's oprx
  mov al,oprx
  cmp al,OB_MMXR
  jne @f
  get_mod_rm
  mov dl,mod_rm
  _mask_reg dl
  mov [ecx]._info.reg,dl
  set_size_BL  ;trashes AL
  mov [ecx]._info.typ,_TYPE_NONE
  ret
@@:
  mov dl,oprx
  mov [ecx]._info.reg,dl
  set_size_BL  ;trashes AL
  mov [ecx]._info.typ,_TYPE_NONE
  ret

_O_I8:
;_O_I16
;_O_I32
;_O_I1632
_O_I8EXP:  ;imm data (8bit expanded to 16/32 bit)
  ;imm data
  mov [ecx]._info.siz,-1   ;gotta set as unknown so 'x PTR' will be used
  mov [ecx]._info.typ,_TYPE_NONE
  ret

_O_1:
  mov [ecx]._info.siz,-1   ;gotta set as unknown so 'x PTR' will be used
  mov [ecx]._info.typ,_TYPE_NONE
  ret

_O_CL:
  mov [ecx]._info.siz,8
  mov [ecx]._info.typ,_TYPE_NONE
  ret

_O_RM8:
;_O_RM16
;_O_RM32
;_O_RM1632
_O_MMXRM64:
  ;reg/mem reference (based on mod_rm field)
  get_mod_rm
  set_size_BL
  mov al,mod_rm
  _mask_mod al
  cmp al,11b
  je @f
  mov [ecx]._info.typ,_TYPE_MRI
  jmp set_MR  ;setup memory reference (may get SIB)
@@:
  ;register (in rm field)
  mov al,mod_rm
  _mask_rm al
  mov [ecx]._info.reg,al
  mov [ecx]._info.typ,_TYPE_NONE
  ret

_O_M16:
;_O_M32   ;FPU only
;_O_M1632
;_O_M64   ;FPU only
;_O_M80   ;FPU only
;_O_M     ;FPU only
  ;mem reference
  set_size_BL
  get_mod_rm
  mov [ecx]._info.typ,_TYPE_MRI
  jmp set_MR  ;setup memory reference (may get SIB)

_O_ACC8:
;_O_ACC16
;_O_ACC32
;_O_ACC1632
  ;accumulator (EAX,AX,AL)
  set_size_BL
  mov [ecx]._info.typ,_TYPE_NONE
  mov [ecx]._info.reg,RO_EAX  ;make printing easier
  ret

_O_OFFS16:
;_O_OFFS32
;_O_OFFS1632
  mov [ecx]._info.siz,-1        ;size of data is unknown
  mov [ecx]._info.typ,_TYPE_MRI
  mov [ecx]._info.sreg,SO_DS    ;always use DS segment

  mov [ecx]._info.nooff,0       ;offset is there   ;FIX : v0.92 : all these were missing
  mov [ecx]._info.reg1,-1       ;no register
  mov [ecx]._info.reg2,-1       ;no register
  mov [ecx]._info.scale2,0      ;no scale
  mov [ecx]._info.scale,0       ;no scale

  and bl,111b   ;FIX : v0.94 : was 11b
  cmp bl,S_16
  je _OFF16
  cmp bl,S_32
  je _OFF32
;determine size with addrbits
  cmp addrbits,1
  je _OFF32
_OFF16:
  _lodsw
  mov [ecx]._info.off,eax
  ret
_OFF32:
  _lodsd
  mov [ecx]._info.off,eax
  ret

_O_DX:
  mov [ecx]._info.siz,16
  mov [ecx]._info.typ,_TYPE_NONE
  ret

_O_REL8:
;_O_REL16
;_O_REL32
;_O_REL1632
  ;Relative JMP/Jx/CALL/LOOP/JCXZ
  mov [ecx]._info.siz,-1          ;size of data is unknown
  mov [ecx]._info.typ,_TYPE_NONE  ;not a MR type
;determine TYPE with opcode_name check
  mov jmp_typ,_JT_JMP
  mov edx,opcode_name
  cmp dword ptr[edx],' pmj'     ;JMP?
  je @f
  cmp dword ptr[edx],'llac'     ;CALL?
  je @f
  mov jmp_typ,_JT_Jx   ;Must be Jx/JCXZ/LOOP
@@:
  and bl,111b   ;FIX : v0.94 : this was 11b
  cmp bl,S_16
  je _REL16
  cmp bl,S_32
  je _REL32
  cmp bl,S_8
  je _REL8
;determine size with addrbits
  cmp addrbits,1
  je _REL32
_REL16:
  _lodsw
  movzx eax,ax  ;FIX : v0.91 : was Sign extending
  add eax,esi
  add eax,prg_base
  mov [ecx]._info.off,eax
  ret
_REL32:
  _lodsd
  add eax,esi
  add eax,prg_base
  mov [ecx]._info.off,eax
  ret
_REL8:
  _lodsb
  ;FIX : v0.91 : must sign extend based on addrbits
  cmp addrbits,1
  je _REL8_32
  movsx ax,al  ;16bit sign extend
  movzx eax,ax
  add eax,esi
  add eax,prg_base
  mov [ecx]._info.off,eax
  ret
_REL8_32:
  movsx eax,al ;32bit sign extend
  add eax,esi
  add eax,prg_base
  mov [ecx]._info.off,eax
  ret

_O_FAR16:      ;JMP/CALL only
;_O_FAR32
;_O_FAR1632
  mov [ecx]._info.siz,-1   ;force pp
  mov [ecx]._info.typ,_TYPE_NONE
  cmp addrbits,1
  je _FAR32
;16bit Far address (32bits)
  _lodsw
  mov [ecx]._info.off,eax
  _lodsw
  mov [ecx]._info.jseg,ax
  ret
_FAR32:
  _lodsd
  mov [ecx]._info.off,eax
  _lodsd  ;BUG!: is it a DWORD, should be...
  mov [ecx]._info.jseg,ax
  ret
  
_O_FPUR:
  mov [ecx]._info.siz,80   ;80bit Float
  mov [ecx]._info.typ,_TYPE_NONE
  mov dl,oprx
  mov [ecx]._info.reg,dl
  ret

_O_ST:
  mov [ecx]._info.siz,80   ;80bit Float
  mov [ecx]._info.typ,_TYPE_NONE
  mov [ecx]._info.reg,0
  ret

_O_F32:
;_O_F64
;_O_F80
  set_size_BL
  mov [ecx]._info.typ,_TYPE_MRF
  jmp set_MR

set_MR proc private  ;Handles 16/32/SIBs
  mov [ecx]._info.scale,0    ;by default assume is not SIB
  mov [ecx]._info.scale2,0   ;by default assume is not SIB
  mov [ecx]._info.off,0      ;by default assume Zero displacement
  mov [ecx]._info.reg1,-1    ;may not be used
  mov [ecx]._info.reg2,-1    ;may not be used
  mov [ecx]._info.sreg,SO_DS ;by default assume DS segment
  mov [ecx]._info.nooff,0    ;by default it has a displacement
  get_mod_rm  ;just in case
  cmp addrbits,1
  je _32
;16bit addressing
  mov al,mod_rm
  _mask_mod al
  cmp al,01b
  jb _special
  je _dis8
  cmp al,11b
  jb _dis16
;ERROR - SHOULD NOT GET HERE! mod = 11 (no memory reference)
  jmp _invalid_opcode
_special:
  mov al,mod_rm
  _mask_rm al
  cmp al,110b
  je _direct
_nodis16:
  ;no displacement
  mov [ecx]._info.nooff,1
  jmp set_regs
_dis16:     ;[index+base+16bit displacement]
  _lodsw
  xor ebx,ebx
  mov bx,ax
  mov [ecx]._info.off,ebx
set_regs:
  mov al,mod_rm
  _mask_rm al
  cmp al,001b
  jb _000
  je _001
  cmp al,011b
  jb _010
  je _011
  cmp al,101b
  jb _100
  je _101
  cmp al,111b
  jb _110
_111:
  mov [ecx]._info.reg1,RO_EBX
  ret
_000:
  mov [ecx]._info.reg1,RO_EBX
  mov [ecx]._info.reg2,RO_ESI
  ret
_001:
  mov [ecx]._info.reg1,RO_EBX
  mov [ecx]._info.reg2,RO_EDI
  ret
_010:
  mov [ecx]._info.sreg,SO_SS
  mov [ecx]._info.reg1,RO_EBP
  mov [ecx]._info.reg2,RO_ESI
  ret
_011:
  mov [ecx]._info.sreg,SO_SS
  mov [ecx]._info.reg1,RO_EBP
  mov [ecx]._info.reg2,RO_EDI
  ret
_100:
  mov [ecx]._info.reg1,RO_ESI
  ret
_101:
  mov [ecx]._info.reg1,RO_EDI
  ret
_110:
  mov [ecx]._info.sreg,SO_SS
  mov [ecx]._info.reg1,RO_EBP
  ret

_dis8:      ;[index+base+sign extended 8bit displacement]
  _lodsb
  movsx ax,al
  mov [ecx]._info.off,eax
  jmp set_regs

_direct:    ;16bit displacement
  _lodsw
  mov [ecx]._info.off,eax
  ret

_32:
  ;detect if r/m = 100b
  mov al,mod_rm
  _mask_rm al
  cmp al,100b    ;ESP
  jne not_sib32
;it's a SIB
  get_sib
  mov al,sib
  _mask_ss al
  mov [ecx]._info.scale2,al    ;0,1,2,3  ;SHL x,scale2

  ;convert scale to #
  mov dl,1
  test al,al
  jz _s1
@@:
  shl dl,1
  dec al
  jnz @b
_s1:
  mov [ecx]._info.scale,dl    ;1,2,4 or 8

  mov al,sib
  _mask_idx al
  cmp al,RO_ESP
  jne @f
  cmp [ecx]._info.scale2,0
  je _esp_
  jmp _invalid_opcode  ;Index=ESP Scale!=0  (invalid)
@@:
  mov [ecx]._info.reg2,al  ;(index)
_esp_:   ;No index
  mov al,sib
  _mask_base al
  mov bl,mod_rm
  _mask_mod bl
  cmp bl,00b
  jne @f
  cmp al,101b
  jne @f
;[EBP] form.  Encoded as disp32 only. (no base - but still has index)
  jmp _32_10  ;BL = mod
@@:
  ;check if SS is used (if al=RO_EBP or RO_ESP)
  cmp al,RO_EBP
  je @f
  cmp al,RO_ESP
  je @f
  jmp _notSS
@@:
  mov [ecx]._info.sreg,SO_SS
_notSS:
  mov [ecx]._info.reg1,al   ;(base)
  jmp _32_dis  ;BL = mod

not_sib32:
  mov al,mod_rm
  mov bl,al
  _mask_rm al
  _mask_mod bl
  cmp al,101b
  jne @f
  cmp bl,00b
  jne @f
;[EBP] form. Encoded as disp32 only.
  jmp _32_10  ;BL = mod
@@:
  ;check if SS is used (if al=RO_EBP)  (ESP can not be used here -> SIB)
  cmp al,RO_EBP
  jne @f
  mov [ecx]._info.sreg,SO_SS
@@:
  mov [ecx]._info.reg1,al
;check for displacement
_32_dis:   ;in : BL = MOD bits
  cmp bl,01b
  jb _32_00
  je _32_01
  cmp bl,11b  ;FIX : v0.91 : this was testing AL
  jb _32_10
;ERROR - SHOULD NOT GET HERE! mod = 11 (no memory reference)
  jmp _invalid_opcode
_32_00:
  ;no displacement
  mov [ecx]._info.nooff,1
  ret
_32_01:
  ;8bit sign extended displacement
  _lodsb
  movsx eax,al
  mov [ecx]._info.off,eax
  ret
_32_10:
  ;32bit displacement
  _lodsd
  mov [ecx]._info.off,eax
  ret
set_MR endp

_just_prefix proc private
  ;Just returning Segment Override/db 66h/db 67h/etc.
  mov DO_Prefix,1
  mov esp,oldstk
  mov ebp,output_off

  mov bl,_prefix
  cmp bl,1
  je @f
  ;must be 66h or 67h
  mov eax,'db 0'
  call _putd
  mov al,bl
  call _puthexb
  mov al,'h'
  call _putb
  jmp _done
@@:
  call _putSEGOVER
_done:
  xor al,al
  call _putb
  popad
  inc esi
  mov ecx,1
  mov JMP_Flag,0  ;no jump
  mov MR_Flag,0   ;no memory reference
  ret
_just_prefix endp

_invalid_opcode proc private
  mov esp,oldstk
  mov esi,input_off
  mov ebp,output_off
  mov eax,'db 0'
  call _putd
  _lodsb
  call _puthexb
  mov ax,'h '
  call _putw
  mov edi,ebp
  mov esi,offset _io_str
  mov ecx,sizeof _io_str
  rep movsb
  popad
  inc esi
  mov ecx,1
  mov JMP_Flag,0  ;no jump
  mov MR_Flag,0   ;no memory reference
  ret
_invalid_opcode endp

_invalid_page proc private
  mov esp,oldstk
  mov esi,offset _ip_str
  mov edi,output_off
  mov ecx,sizeof _ip_str
  rep movsb
  popad
  inc esi
  mov ecx,1
  mov JMP_Flag,0  ;no jump
  mov MR_Flag,0   ;no memory reference
  ret
_invalid_page endp

.data
_io_str db ';-= Invalid Opcode =-',0
_ip_str db ';-= Invalid Address =-',0

.code
;Printing phase opcodes
_put_operand proc private
  ;In : BL = opr?
  ;   : ECX -> info block to be filled out

  xor eax,eax
  mov al,bl
  and al,0f8h
  shr eax,1   ;convert to DWORDs
  jmp [_put_operand_table + eax]
_put_operand endp

P_O_NONE:
  ret  ;nothing to print!

P_O_SEGR:
  xor eax,eax
  mov al,[ecx]._info.reg
  shl eax,2
  add eax,segregs
  call _putstr
  ret

P_O_CR:
  mov ax,'cr'
  call _putw
  xor eax,eax
  mov al,[ecx]._info.reg
  add al,'0'
  call _putb
  ret

P_O_DR:
  mov ax,'dr'
  call _putw
  xor eax,eax
  mov al,[ecx]._info.reg
  add al,'0'
  call _putb
  ret

P_O_TR:
  mov ax,'tr'
  call _putw
  xor eax,eax
  mov al,[ecx]._info.reg
  add al,'0'
  call _putb
  ret

P_O_ACC8:
;P_O_ACC16:
;P_O_ACC32:
;P_O_ACC1632:
P_O_R8 proc private
;P_O_R16:
;P_O_R32:
;P_O_R1632:
  ;BL = opr type info?
  xor eax,eax
  mov al,[ecx]._info.reg
  and bl,111b
  cmp bl,S_16
  jb _8
  je _16
  cmp bl,S_1632
  jb _32
  cmp databits,1
  je _32
_16:
  shl eax,2
  add eax,regs1632
  inc eax  ;skip 'E'
  call _putstr
  ret
_8:
  shl eax,2
  add eax,regs8
  call _putstr
  ret
_32:
  shl eax,2
  add eax,regs1632
  call _putstr
  ret
P_O_R8 endp

P_O_MMX32:
;P_O_MMX64:
  mov ax,'mm'
  call _putw
  mov al,[ecx]._info.reg
  add al,'0'
  call _putb
  ret

P_O_I8 proc private
;P_O_I16:
;P_O_I32:
;P_O_I1632:
  ;BL = opr type info?
  xor eax,eax
  and bl,111b
  cmp bl,S_16
  jb _8
  je _16
  cmp bl,S_1632
  jb _32
  cmp databits,1
  je _32
_16:
  _lodsw
  call _puthexw
  ret
_8:
  _lodsb
  call _puthexb
  ret
_32:
  _lodsd
  call _puthexd
  ret
P_O_I8 endp

P_O_I8EXP proc
  ; FIX : v0.94 : This must detect what size to print based on operand #1
  ;this is always operand #2
  ;must detect size based on operand #1

  _lodsb
  movsx eax,al

  mov bl,opr1  
  and bl,111b
  cmp bl,S_16
  jb _8
  je _16
  cmp bl,S_1632
  jb _32
  je _1632
  jmp _invalid_opcode   ;will not happen
_8:
  call _puthexb
  ret
_16:
  call _puthexw
  ret
_1632:
  cmp databits,0
  je _16
_32:
  call _puthexd
  ret
P_O_I8EXP endp

P_O_1:
  mov al,'1'
  call _putb
  ret

P_O_CL:
  mov ax,'cl'
  call _putw
  ret

P_O_RM8:
;P_O_RM16:
;P_O_RM32:
;P_O_RM1632:
  cmp [ecx]._info.typ,_TYPE_MRI
  je P_O_M16
  jmp P_O_R8

P_O_MMXRM64:
  cmp [ecx]._info.typ,_TYPE_MRI
  je P_O_M16
  jmp P_O_MMX32

P_O_F32:
;P_O_F64:
;P_O_F80:
P_O_M16 proc private  ;NOTE : Must support M8 too
;P_O_M32:
;P_O_M1632:
;P_O_M64:
;P_O_M80:
;P_O_M:
  ;BL = opr type info?
  test [ecx]._info.typ,_TYPE_MRF
  jnz @f
  call _putPTRi
  jmp _ptr_done
@@:
  call _putPTRf
_ptr_done:
  call _putSEGOVER
  mov al,'['
  call _putb
  mov dl,[ecx]._info.reg1
  mov dh,[ecx]._info.reg2
  mov bl,[ecx]._info.scale
  mov bh,[ecx]._info.nooff
  mov _plus,0   ;Plus sign needed?
;print Reg1
  cmp dl,-1
  je _reg2
  xor eax,eax
  mov al,dl
  shl eax,2
  add eax,regs1632
  cmp addrbits,1
  je @f
  inc eax   ;16bit register
@@:
  call _putstr
  mov _plus,1
_reg2:
  cmp dh,-1
  je _scale
  cmp _plus,0
  je @f
  mov al,'+'
  call _putb
@@:
  xor eax,eax
  mov al,dh
  shl eax,2
  add eax,regs1632
  cmp addrbits,1
  je @f
  inc eax   ;16bit register
@@:
  call _putstr
  mov _plus,1
_scale:
  cmp bl,0
  je _noscale
  cmp bl,1
  je _noscale   ;do not print *1 (useless)
  mov al,'*'
  call _putb
  mov al,bl
  add al,'0'
  call _putb
  mov _plus,1
_noscale:
  test bh,bh
  jnz _nodis
  cmp _plus,0
  je @f
  mov al,'+'
  call _putb
@@:
  ;now print offset (if any)
  test bh,bh
  jnz _nodis
  mov eax,[ecx]._info.off
  call _puthexd
_nodis:
  mov al,']'
  call _putb
  ret
P_O_M16 endp

P_O_FAR16:
;P_O_FAR32:
;P_O_FAR1632:
  mov ax,[ecx]._info.jseg
  call _puthexw
  mov al,':'
  call _putb
  mov eax,[ecx]._info.off
  call _puthexd
  ret

P_O_OFFS16:
;P_O_OFFS32:
;P_O_OFFS1632:
  call _putPTRi
  call _putSEGOVER
  mov al,'['
  call _putb
  mov eax,[ecx]._info.off
  call _puthexd
  mov al,']'
  call _putb
  ret

P_O_DX:
  mov ax,'dx'
  call _putw
  ret

P_O_REL8:
;P_O_REL16:
;P_O_REL32:
;P_O_REL1632:
  mov eax,[ecx]._info.off
  call _puthexd
  ret

P_O_FPUR:
  mov ax,'st'
  call _putw
  mov al,'('
  call _putb
  mov al,[ecx]._info.reg
  add al,'0'
  call _putb
  mov al,')'
  call _putb
  ret

P_O_ST:
  mov ax,'st'
  call _putw
  ret

_pp_chk_ proc private
  ;This PROC determine if 'x PTR' needs to be printed
  ; If opr1.siz == opr2.siz == opr3.siz then pp is FALSE else TRUE
  cmp oprc,1
  jb _0
  je _1
  cmp oprc,3
  jb _2
;3 operands
  mov al,_info1.siz
  cmp al,_info2.siz
  je @f
  mov put_ptr,1
  ret
@@:
  mov al,_info2.siz
  cmp al,_info3.siz
  je @f
  mov put_ptr,1
@@:
  ret
_2:
  mov al,_info1.siz
  cmp al,_info2.siz
  je @f
  mov put_ptr,1
@@:
  ret
_1:
  mov put_ptr,1   ;only one operand, must do it
  ret
_0:
  ;there are no operands
  ret
_pp_chk_ endp

_mr_chk_ proc private
  ;Calculate MR_Address
  ;find MR in info1,2,3
  test _info1.typ,_TYPE_MRI or _TYPE_MRF
  jz _2
  ;operand 1 contains a MR
  mov ecx,offset _info1
  jmp _doit
_2:
  test _info2.typ,_TYPE_MRI or _TYPE_MRF
  jz _3
  ;operand 2 contains a MR
  mov ecx,offset _info2
  jmp _doit
_3:
  test _info3.typ,_TYPE_MRI or _TYPE_MRF
  jnz @f
  ret  ;no mem-ref in instruction
@@:
  ;operand 3 contains a MR
  mov ecx,offset _info3
_doit:
  cmp addrbits,1
  je _32
;16bit regs.
  xor eax,eax   ;displacement
  mov ebx,MR_registers   ;current CPU registers for opcode
  xor edx,edx
  mov dl,[ecx]._info.reg1
  cmp dl,-1
  je @f
  shl edx,2  ;dwords
  mov dx,[ebx+edx]
  add eax,edx
@@:
  mov dl,[ecx]._info.reg2
  cmp dl,-1
  je @f
  shl edx,2  ;dwords
  mov dx,[ebx+edx]
  add eax,edx
  jmp _16done

_32:
  xor eax,eax   ;displacement
  mov ebx,MR_registers   ;current CPU registers for opcode
  xor edx,edx
  mov dl,[ecx]._info.reg1
  cmp dl,-1
  je @f
  shl edx,2  ;dwords
  add eax,[ebx+edx]
@@:
  mov dl,[ecx]._info.reg2
  cmp dl,-1
  je @f
  shl edx,2  ;dwords
  mov edx,[ebx+edx]
  push cx
  mov cl,[ecx]._info.scale2  ;SHL x,scale2  (=0 if no scale)
  shl edx,cl
  pop cx
  add eax,edx
@@:
_16done:
  cmp [ecx]._info.nooff,1   ;FIX : v0.92 : forget to check this here!
  je @f
  add eax,[ecx]._info.off
@@:
  mov MR_Address,eax
;Setup Segment
  mov al,[ecx]._info.sreg
  cmp seg_flag,1
  jne @f
  mov al,seg_over
@@:
  mov MR_Segment,al
;Setup MR_Size
  mov al,[ecx]._info.siz
  mov MR_Size,al
;Setup MR_Type
  mov al,[ecx]._info.typ
  and al,_TYPE_MRF   ;only return TRUE=float FALSE=int
  mov MR_Type,al
;Set Flag
  mov MR_Flag,1
  ret
_mr_chk_ endp

_jmp_chk_ proc private
  ;Calculate JMP_Address
  cmp oprc,1
  je @f
_ret:
  ret ;not a JMP instruction
@@:
  cmp jmp_typ,0
  je _ret
  mov ecx,offset _info1
  mov eax,[ecx]._info.off   ;Jmp offset
  mov JMP_Address,eax
  cmp jmp_typ,_JT_JMP
  je _yes
;Determine if JMP will take place (based on Eflags)
  mov ebx,JMP_flags
  mov eax,opcode_name

;FIX : v0.91 : many had incorrect spelling 

  cmp dword ptr[eax],'  bj'
  je _jb
  cmp dword ptr[eax],'eanj'
  je _jb
  cmp dword ptr[eax],' eaj' ;(was jea) 
  je _jae
  cmp dword ptr[eax],' bnj'
  je _jae
  cmp dword ptr[eax],' ebj'
  je _jbe
  cmp dword ptr[eax],' anj'
  je _jbe
  cmp dword ptr[eax],'  aj'
  je _ja
  cmp dword ptr[eax],'ebnj'
  je _ja
  cmp dword ptr[eax],'  zj'
  je _jz
  cmp dword ptr[eax],'  ej'
  je _jz
  cmp dword ptr[eax],' znj'
  je _jnz
  cmp dword ptr[eax],' enj'
  je _jnz
  cmp dword ptr[eax],'  lj'
  je _jl
  cmp dword ptr[eax],'egnj'
  je _jl
  cmp dword ptr[eax],' egj'
  je _jge
  cmp dword ptr[eax],' lnj'
  je _jge
  cmp dword ptr[eax],' elj'
  je _jle
  cmp dword ptr[eax],' gnj'
  je _jle
  cmp dword ptr[eax],'  gj'
  je _jg
  cmp dword ptr[eax],'elnj'
  je _jg
  cmp dword ptr[eax],'  sj'
  je _js
  cmp dword ptr[eax],' snj'
  je _jns
  cmp dword ptr[eax],'  cj'
  je _jc
  cmp dword ptr[eax],' cnj'
  je _jnc
  cmp dword ptr[eax],'  oj'
  je _jo
  cmp dword ptr[eax],' onj'
  je _jno
  cmp dword ptr[eax],'  pj'
  je _jp
;  cmp dword ptr[eax],' epj'
;  je _jp
  cmp dword ptr[eax],' pnj'
  je _jnp
;  cmp dword ptr[eax],' opj'
;  je _jnp
  cmp dword ptr[eax],'zxcj'
  je _jcxz
  cmp dword ptr[eax],'xcej'
  je _jecxz
;ERROR - SHOULD NOT GET HERE!
  jmp _invalid_opcode
_jb:                    ;CF=1
  test ebx,_CPU_CF
  jnz _yes
  jmp _no
_jae:                   ;CF=0
  test ebx,_CPU_CF
  jz _yes
  jmp _no
_jbe:                   ;CF=1 or ZF=1
  test ebx,_CPU_CF
  jnz _yes
  test ebx,_CPU_ZF
  jnz _yes
  jmp _no
_ja:                    ;CF=0 and ZF=0
  test ebx,_CPU_CF
  jnz _no
  test ebx,_CPU_ZF
  jnz _no
  jmp _yes
_jz:                    ;ZF=1
  test ebx,_CPU_ZF
  jnz _yes
  jmp _no
_jnz:                   ;ZF=0
  test ebx,_CPU_ZF
  jz _yes
  jmp _no
_jl:                    ;SF!=OF
  test ebx,_CPU_SF or _CPU_OF
  jpo _yes
  jmp _no
_jge:                   ;SF==OF
  test ebx,_CPU_SF or _CPU_OF
  jpe _yes
  jmp _no
_jle:                   ;ZF=1 or SF!=OF
  test ebx,_CPU_ZF
  jnz _yes
  test ebx,_CPU_SF or _CPU_OF
  jpo _yes  ;FIX : v0.91 : was jpe
  jmp _no
_jg:                    ;ZF=0 and SF==OF
  test ebx,_CPU_ZF
  jnz _no
  test ebx,_CPU_SF or _CPU_OF
  jpo _no  ;FIX : v0.91 : was jpe
  jmp _yes
_js:                    ;SF=1
  test ebx,_CPU_SF
  jnz _yes
  jmp _no
_jns:                   ;SF=0
  test ebx,_CPU_SF
  jz _yes
  jmp _no
_jc:                    ;CF=1
  test ebx,_CPU_CF
  jnz _yes
  jmp _no
_jnc:                   ;CF=0
  test ebx,_CPU_CF
  jz _yes
  jmp _no
_jo:                    ;OF=1
  test ebx,_CPU_OF
  jnz _yes
  jmp _no
_jno:                   ;OF=0
  test ebx,_CPU_OF
  jz _yes
  jmp _no
_jp:                    ;PF=1
  test ebx,_CPU_PF
  jnz _yes
  jmp _no
_jnp:                   ;PF=0
  test ebx,_CPU_PF
  jz _yes
  jmp _no
_jcxz:
  mov ebx,MR_registers
  cmp word ptr[ebx].callstruct._ecx,0
  jz _yes
  jmp _no
_jecxz:
  mov ebx,MR_registers
  cmp dword ptr[ebx].callstruct._ecx,0
  jz _yes
  jmp _no
_yes:
  mov JMP_Flag,1
_no:
  ret
_jmp_chk_ endp

_putstr proc private
  ;In : EAX = string (ASCIZ)
  push bx
@@:
  mov bl,[eax]
  test bl,bl
  jz done
  mov es:[ebp],bl
  inc eax
  inc ebp
  jmp @b
done:
  pop bx
  ret
_putstr endp

_putstrCL proc private
  ;In : EAX = string
  ;   : CL = Size
  push bx
@@:
  mov bl,[eax]
  mov es:[ebp],bl
  inc eax
  inc ebp
  dec cl
  jnz @b
  pop bx
  ret
_putstrCL endp

_putPTRi proc private
  ;have already calculated _force_pp_... stuff
  ; BL = opr?
  cmp put_ptr,1
  je @f
  ret
@@:
  cmp _far_ptr,1
  je _far
  and bl,111b
  cmp bl,S_16
  jb _8
  je _16
  cmp bl,S_1632
  jb _32
  je _x
  cmp bl,S_80
  jb _64
  je _80
_?:
  mov eax,offset ???_PTR
  call _putstr
  ret
_8:
  mov eax,offset BYTE_PTR
  call _putstr
  ret
_x:
  cmp databits,1
  je _32
_16:
  mov eax,offset WORD_PTR
  call _putstr
  ret
_32:
  mov eax,offset DWORD_PTR
  call _putstr
  ret
_64:
  mov eax,offset QWORD_PTR
  call _putstr
  ret
_80:
  mov eax,offset TWORD_PTR
  call _putstr
  ret
_far:
  mov eax,offset FAR_PTR
  call _putstr
  ret
_putPTRi endp

_putPTRf proc private
  ;have already calculated _force_pp_... stuff
  ; BL = opr?
  cmp put_ptr,1
  je @f
  ret
@@:
  and bl,111b
; 8/16 not used in FPU opcodes
  cmp bl,S_32
  je _32
  cmp bl,S_80
  jb _64
  je _80
_?:
  mov eax,offset ???_PTR
  call _putstr
  ret
_32:
  mov eax,offset REAL4_PTR
  call _putstr
  ret
_64:
  mov eax,offset REAL8_PTR
  call _putstr
  ret
_80:
  mov eax,offset REAL10_PTR
  call _putstr
  ret
_putPTRf endp

_putSEGOVER proc private
  ;print segment override if used.
  cmp seg_flag,0
  je @f
  xor eax,eax
  mov al,seg_over
  shl eax,2
  add eax,segregs
  call _putstr
  mov al,':'
  call _putb
  mov seg_flag,0   ;seg override used!
@@:
  ret
_putSEGOVER endp

_putd:
  ror eax,16
  call _putw
  ror eax,16

_putw:
  mov es:[ebp],ah
  mov es:[ebp+1],al
  add ebp,2
  ret

_putb:
  mov es:[ebp],al
  inc ebp
  ret

_puthexd:
  if REMOVEZEROS
    mov putzeros,0
  endif
  push eax
  push ecx
  mov cl,8
  call _puthexn
  pop ecx
  pop eax
  ret

_puthexw:
  if REMOVEZEROS
    mov putzeros,0
  endif
  push eax
  push ecx
  mov cl,4
  rol eax,16
  call _puthexn
  pop ecx
  pop eax
  ret

_puthexb:
  if REMOVEZEROS
    mov putzeros,0
  endif
  push eax
  push ecx
  mov cl,2
  ror eax,8
  call _puthexn
  pop ecx
  pop eax
  ret

_puthexn:
  rol eax,4  ;get next nibble
  push ax
  and al,0fh
  if REMOVEZEROS
    cmp cl,1
    je @f      ;last nibble
    test al,al
    jnz @f
    cmp putzeros,0
    je __puthexn_next_nibb
@@:
    cmp putzeros,0
    jne @f
    cmp cl,1
    je @f
    mov byte ptr es:[ebp],'0'   ;Put a Zero in front of #
    inc ebp
@@:
    mov putzeros,-1
  endif
  .if al>9
    add al,'a' - 10   ;lowercase
  .else
    add al,'0'
  .endif
;  add al,90h   ;converts with Uppercase
;  daa
;  adc al,40h
;  daa
  mov es:[ebp],al
  inc ebp
__puthexn_next_nibb:
  pop ax
  dec cl
  jnz _puthexn
  ret


;
.data ; D A T A 
;

_do_operand_table label dword
  dd offset _O_NONE
  dd offset _O_SEGR
  dd offset _O_CR
  dd offset _O_DR
  dd offset _O_TR
  dd offset _O_R8
;  dd offset _O_R16
;  dd offset _O_R32
;  dd offset _O_R1632
  dd offset _O_MMX32
;  dd offset _O_MMX64
  dd offset _O_I8
;  dd offset _O_I16
;  dd offset _O_I32
;  dd offset _O_I1632
  dd offset _O_I8EXP
  dd offset _O_1
  dd offset _O_CL
  dd offset _O_RM8
;  dd offset _O_RM16
;  dd offset _O_RM32
;  dd offset _O_RM1632
  dd offset _O_M16
;  dd offset _O_M32
;  dd offset _O_M1632
;  dd offset _O_M64
;  dd offset _O_M80
;  dd offset _O_M
  dd offset _O_ACC8
;  dd offset _O_ACC16
;  dd offset _O_ACC32
;  dd offset _O_ACC1632
  dd offset _O_OFFS16
;  dd offset _O_OFFS32
;  dd offset _O_OFFS1632
  dd offset _O_DX
  dd offset _O_REL8
;  dd offset _O_REL16
;  dd offset _O_REL32
;  dd offset _O_REL1632
  dd offset _O_FAR16
;  dd offset _O_FAR32
;  dd offset _O_FAR1632
  dd offset _O_FPUR
  dd offset _O_ST
  dd offset _O_F32
;  dd offset _O_F64
;  dd offset _O_F80
  dd offset _O_MMXRM64

_put_operand_table label dword
  dd offset P_O_NONE
  dd offset P_O_SEGR
  dd offset P_O_CR
  dd offset P_O_DR
  dd offset P_O_TR
  dd offset P_O_R8
;  dd offset P_O_R16
;  dd offset P_O_R32
;  dd offset P_O_R1632
  dd offset P_O_MMX32
;  dd offset P_O_MMX64
  dd offset P_O_I8
;  dd offset P_O_I16
;  dd offset P_O_I32
;  dd offset P_O_I1632
  dd offset P_O_I8EXP
  dd offset P_O_1
  dd offset P_O_CL
  dd offset P_O_RM8
;  dd offset P_O_RM16
;  dd offset P_O_RM32
;  dd offset P_O_RM1632
  dd offset P_O_M16
;  dd offset P_O_M32
;  dd offset P_O_M1632
;  dd offset P_O_M64
;  dd offset P_O_M80
;  dd offset P_O_M
  dd offset P_O_ACC8
;  dd offset P_O_ACC16
;  dd offset P_O_ACC32
;  dd offset P_O_ACC1632
  dd offset P_O_OFFS16
;  dd offset P_O_OFFS32
;  dd offset P_O_OFFS1632
  dd offset P_O_DX
  dd offset P_O_REL8
;  dd offset P_O_REL16
;  dd offset P_O_REL32
;  dd offset P_O_REL1632
  dd offset P_O_FAR16
;  dd offset P_O_FAR32
;  dd offset P_O_FAR1632
  dd offset P_O_FPUR
  dd offset P_O_ST
  dd offset P_O_F32
;  dd offset P_O_F64
;  dd offset P_O_F80
  dd offset P_O_MMXRM64

;BYTE_PTR db 'byte ptr ',0
;WORD_PTR db 'word ptr ',0
;DWORD_PTR db 'dword ptr ',0
;QWORD_PTR db 'qword ptr ',0
;TWORD_PTR db 'tword ptr ',0
;REAL4_PTR db 'real4 ptr ',0
;REAL8_PTR db 'real8 ptr ',0
;REAL10_PTR db 'real10 ptr ',0
;FAR_PTR db 'far ptr ',0
;???_PTR db '?ptr ',0     ;BUG! What to do here?

;NEW : v0.93 : Needed space after these things
BYTE_PTR db 'bptr ',0
WORD_PTR db 'wptr ',0
DWORD_PTR db 'dptr ',0
QWORD_PTR db 'qptr ',0
TWORD_PTR db 'tptr ',0
REAL4_PTR db 'r4ptr ',0
REAL8_PTR db 'r8ptr ',0
REAL10_PTR db 'r10ptr ',0
FAR_PTR db 'far ',0
???_PTR db '?ptr ',0     ;BUG! What to do here?

;--------------- regs start -----------------------------

regs8 equ $
  db 'al',0,0
  db 'cl',0,0
  db 'dl',0,0
  db 'bl',0,0
  db 'ah',0,0
  db 'ch',0,0
  db 'dh',0,0
  db 'bh',0,0

regs1632 equ $
  db 'eax',0
  db 'ecx',0
  db 'edx',0
  db 'ebx',0
  db 'esp',0
  db 'ebp',0
  db 'esi',0
  db 'edi',0

segregs equ $
  db 'es',0,0
  db 'cs',0,0
  db 'ss',0,0
  db 'ds',0,0
  db 'fs',0,0
  db 'gs',0,0

;--------------- regs end -------------------------------

;------------------
; format
; dw 16-bit mnemonic (default)
; dw 32-bit mnemonic
; ...
; dw 0 ; end of list
mnemonics_special label word
dw M_PUSHA, M_PUSHAD
dw M_POPA, M_POPAD
dw M_PUSHF, M_PUSHFD
dw M_POPF, M_POPFD
dw M_MOVSW, M_MOVSD
dw M_INSW, M_INSD
dw M_OUTSW, M_OUTSD
dw M_CMPSW, M_CMPSD
dw M_SCASW, M_SCASD
dw M_LODSW, M_LODSD
dw M_STOSW, M_STOSD
dw M_IRET, M_IRETD
dw M_CBW, M_CWDE
dw M_CWD, M_CDQ
dw M_JCXZ, M_JECXZ
dw 0                                    ; end of list

;--------------- mnemonics end --------------------------

;--------------- opcodes start --------------------------
; format
; size count desc
; db 1 number of bytes in opcode
; db x opcode-bytes
; db 1 type of 1st argument
; db 1 type of 2nd argument
; db 1 type of 3rd argument
; db 1 opcode-table byte
;       db      1       minimum processor       0 == All processors (8086)
;      1 == 80186
;      2 == 80286
;      3 == 80386
;      4 == 80486
;      5 == 80586 Pentium
;      6 == 80686 PentiumPro
;      7 == 80786 Pentium II
; dw 1 mnemonic index
;
SIZEOF_OPCODE EQU 1+0+1+1+1+1+1+2

P_0 EQU 0
P_1 EQU 1
P_2 EQU 2
P_3 EQU 3
P_4 EQU 4
P_5 EQU 5
P_6 EQU 6
P_7 EQU 7


;--------------- opcodes end ----------------------------
.data?

defsegsize db ?
addrbits db ?
databits db ?

prg_base dd ?                           ; offset to where instructions start
input_off dd ?                          ; ptr to start of instruction
input_sel dw ?
output_off dd ?                         ; ptr to start of output
output_sel dw ?
MR_registers dd ?                       ;pointer to PUSHAD registers
JMP_flags dd ?

seg_over db ?                           ;segment override (SO _...)
seg_flag db ?                           ;segment override flag

_info1 _info <>                         ;operand 1 info
_info2 _info <>                         ;operand 2 info
_info3 _info <>                         ;operand 3 info

_force_pp_siz db ?
_force_pp db ?
_far_ptr db ?

opcode_name dd ?                        ;opcode name

mod_rm db ?                             ;mod(2) reg(3) rm(3)
got_mod_rm db ?
sib db ?
got_sib db ?

oldstk dd ?

opr1 db ?
opr2 db ?
opr3 db ?
oprx db ?
oprc db ?

put_ptr db ?

jmp_typ db ?   ;_TYPE_JMP or _TYPE_Jx or 0(none)

_prefix db ?

if REMOVEZEROS
  putzeros db ?
endif

_plus db ?

end
