;Get byte/word/dword functions
; by : Peter Quiring (sub_death@geocities.com)
;Requires a DPMI host.

.386
.model flat,c
.code
assume fs:flat,gs:flat

include dasm.inc

TRUE equ 1
FALSE equ 0

Testing_Addr db ?
saved_int13 df ?
saved_int14 df ?
seldata dw ?

;===================================================================
;  The following will read/write/cmp data from unknown memory without
;    causing an exception to go to OS.
;  Carry clear = Action performed, data is valid (if any returned)
;  Carry set = Action caused exception, data is invalid
;    Expect: FS:ESI = pointing to location to perform action on
;===================================================================
getbyte proc
  Call Test_location      ; Test location FS:[ESI]
  .If Testing_Addr == TRUE
    mov Testing_Addr,FALSE
    clc
  .Else
    xor al,al
    stc
  .Endif
  ret
getbyte endp

getword proc
  Call Test_location      ; Test location FS:[ESI]
  .If Testing_Addr == TRUE
    mov Testing_Addr,FALSE
    clc
  .Else
    xor ax,ax
    stc
  .Endif
  ret
getword endp

getdword proc
  Call Test_location      ; Test location FS:[ESI]
  .If Testing_Addr == TRUE
    mov Testing_Addr,FALSE
    clc
  .Else
    xor eax,eax
    stc
  .Endif
  ret
getdword endp

chk_location proc uses eax
  Call Test_location      ; Test location FS:[ESI]
  .If Testing_Addr == TRUE
    mov Testing_Addr,FALSE
    clc
  .Else
    stc
  .Endif
  ret
chk_location endp

setbyte proc
  push ax
  Call Test_location      ; Test location FS:[ESI]
  pop ax
  .If Testing_Addr == TRUE
    push offset _bad_   ;just in case we have read access but not write access
    mov fs:[esi],al
    db 8 dup (90h)
    mov Testing_Addr,FALSE
    add esp,4
    clc
  .Else
_bad_:
    stc
  .Endif
  ret
setbyte endp

;
;  This procedure will test the DWORD at address in FS:ESI to see if it's
; a valid location, i.e will not cause a page fault.
;
;  Return       If location is Ok then
;                   Testing_Addr = TRUE
;                                   eax = dword
;               else
;                   Testing_Addr = FALSE
;
;
Test_location proc
  mov Testing_Addr,TRUE
    db 2 dup (90h)
  mov eax,fs:[esi]
    db 8 dup (90h)
Test_Location_End::
  ret
Test_location endp

SetExcVector PROC  Uses Eax
  mov ax,0203h
  int 31h
  ret
SetExcVector ENDP

GetExcVector PROC  Uses Eax
  mov ax,0202h
  int 31h
  ret
GetExcVector ENDP

;Init getbyte/word/dword/etc. to work
getxinit proc
  mov ax,ds
  mov seldata,ax

  mov bl,13
  call GetExcVector
  mov dword ptr saved_int13,edx
  mov word ptr saved_int13+4,cx

  mov edx,offset GeneralProtection_Exception
  mov cx,cs
  call SetExcVector

  mov bl,14
  call GetExcVector
  mov dword ptr saved_int14,edx
  mov word ptr saved_int14+4,cx

  mov edx,offset Page_Fault_Exception
  mov cx,cs
  call SetExcVector
  ret
getxinit endp

getxuninit proc
  mov edx,dword ptr saved_int13
  mov cx,word ptr saved_int13[4]
  mov bl,13
  call SetExcVector
  mov edx,dword ptr saved_int14
  mov cx,word ptr saved_int14[4]
  mov bl,14
  call SetExcVector
  ret
getxuninit endp

_exc struct
  ret_eip  dd ?
  ret_cs   dd ?
  _errcode dd ?
  _eip     dd ?
  _cs      dd ?
  _eflags  dd ?
  _esp     dd ?
  _ss      dd ?
_exc ends

GeneralProtection_Exception proc

  .IF cs:Testing_Addr == TRUE
    push ds
    mov ds,cs:seldata
    mov Testing_Addr,FALSE
    pop ds
    ; skip instruction that caused exc.
    mov dword ptr [esp]._exc._eip,Test_Location_End
    retf
  .ENDIF

  jmp cs:saved_int13

GeneralProtection_Exception endp

Page_Fault_Exception proc

  .IF cs:Testing_Addr == TRUE
    push ds
    mov ds,cs:seldata
    mov Testing_Addr,FALSE
    pop ds
    ; skip instruction that caused exc.
    mov dword ptr [esp]._exc._eip,Test_Location_End
    retf
  .ENDIF

  jmp cs:saved_int14

Page_Fault_Exception endp

end

