; This is just a lame little example that uses Dasm to decode a
; .com-file and output the disassembled instructions to stdout.

; NOTE : Due to bug in MASM v6.13 you must use v6.11 to compile.

include qlib.inc
include process.inc     ;for exit()
include alloc.inc       ;for _maxfree() malloc()
include dasm.inc
include stdio.inc       ;for printf()

extern getxinit:near
extern getxuninit:near

PUTZEROS	EQU	0
TIMEIT          EQU     0
SHOWINFO        EQU     0     ;show extended info in dump

;
; C O D E 
;
.code
main proc
        mov     _bits,0  ;assume 16bits
        mov     eax,_argv
        cmp     _argc,3
        ja      showhelpmsg
        cmp     _argc,3
        jb      @f
        mov     edx,[eax+8]
        cmp     word ptr[edx],'3/'
        jne     @f
        cmp     byte ptr[edx+2],'2'
        jne     @f
        mov     _bits,1  ;32bits
@@:
        cmp     _argc,2
        jb      showhelpmsg

        mov     edx,[eax+4]

        call    _memmax
        mov     buffersize,eax
        push    eax
        call    malloc
        test    eax,eax
        jz      noram
        mov     buffer,eax

	call	_openfilero
        mov     edx,buffer
        mov     ecx,buffersize
	call	_readfile
	mov	infilesize,eax
        mov     eax,buffersize
        cmp     infilesize,eax
	jbe	__filefits
        mov     infilesize,eax
__filefits:
	call	_closefile

IF	TIMEIT
	db	0fh,31h ;rdtsc
	mov	time1l,eax
	mov	time1h,edx
ENDIF

        mov     eax,buffer
        neg     eax
        add     eax,100h   ;virtual 100h program
        mov     prgbase,eax

        call    getxinit

        mov     esi,buffer
mainlop:
        mov     ah,1
        int     16h
        jnz     _end
        mov     ecx,buffer
	add	ecx,infilesize
	cmp	ecx,esi
	jbe	_end
        xor     ebx,ebx
        lea     ecx,fake_regs
        mov     al,_bits     ;16/32bit code
        lea     edi,decodestr
        xor     edx,edx   ;no flags
        mov     ebx,prgbase   ;program Base (virtually 100h)
        call    DecodeOpcode

        mov     _siz,ecx

        lea     edi,decodestr
	xor	al,al
	mov	ecx,-1
        cld
        repne	scasb
	mov	dword ptr [edi-1],00240a0dh	; 0dh,0ah,'$'
        lea     edx,decodestr
	call	_puts
if SHOWINFO
        ;Print MR_... info / JMP info
        .if     MR_Flag
                mov ecx,MR_Address
                xor ebx,ebx
                mov bl,MR_Segment
                shl ebx,2
                add ebx,offset seg_strs
                callp printf,";  MemRef Offset=%x Seg=%s Size=%d Type=%d\n",ecx,ebx,MR_Size,MR_Type
        .endif
        .if     JMP_Flag
                mov eax,JMP_Address
                callp printf,";  JMP Address = %x\n",eax
        .endif
        mov eax,_siz
        callp   printf,";  Bytes = %d\n",eax
        mov ecx,esi
        sub ecx,_siz
        mov bl,[ecx]
        mov bh,[ecx+1]
        mov dl,[ecx+2]
        mov dh,[ecx+3]
        callp  printf,";  Code Sample = %#04x %#04x %#04x %#04x\n",bl,bh,dl,dh
endif
	jmp	mainlop

_end:
        call    getxuninit
        jmp __exit

showhelpmsg:
        lea     edx,_DASM_COPYRIGHT
	call	_puts
	lea	edx,helpstr
	call	_puts

IF	TIMEIT
	db	0fh,31h ;rdtsc
	mov	time2l,eax
	mov	time2h,edx
	sub	eax,time1l
	jnc	_nc
	dec	time2h
_nc:
	mov	diffl,eax
	mov	edx,time2h
	sub	edx,time1h
	mov	diffh,edx

	mov	eax,diffh
	call	_phd
	mov	eax,diffl
	call	_phd
ENDIF

__exit::
        push    dword ptr 0
        call    exit

noram:
        lea     edx,norammsg
        call    _puts
        jmp     __exit

fileio::
        lea     edx,fileiomsg
        call    _puts
        jmp     __exit


main    endp



;
IF	TIMEIT
_phd:
	push	eax
	shr	eax,16
	call	_phw
	pop	eax
_phw:
	push	eax
	shr	eax,8
	call	_phb
	pop	eax
_phb:
	push	eax
	shr	eax,4
	call	_phn
	pop	eax
_phn:
	push	eax
	and	al,0fh
	add	al,90h
	daa
	adc	al,40h
	daa
        int     29h   ;what's this?
	pop	eax
	ret
ENDIF

;
_puts:
	pushad
        mov     ah,9
        int     21h
	popad
	ret


;
; In:
;   EDX -> ASCIIZ filename
; Out:
;   CF=1 - Error opening file
;   CF=0 - File opened succesfully
;    HND - file handle
_openfilero:
	pushad
        xor     cx,cx
        mov     ax,3d00h
        int     21h
        jc      fileio
        mov     hnd,ax
        popad
	ret


;
; In:
;   HND - file handle
;   CF=1 - Error closing file
;   CF=0 - File closed succesfully
_closefile:
	push	ax
        mov     bx,hnd
        mov     ax,3e00h
        int     21h
        jc      fileio
	pop	ax
	ret


;
; In:
;   HND - file handle
;   EDX -> buffer to read to
;   ECX - number of bytes to read
; Out:
;   CF=1 - Error reading file
;     EAX - ?
;   CF=0 - Read went fine
;     EAX - number of bytes read
_readfile:
	pushad
        mov     ax,3f00h
        mov     bx,hnd
        int     21h
        jc      fileio
        movzx   eax,ax
        mov     [esp].callstruct._eax,eax   ;save EAX on stack
	popad
	ret

.data
;
helpstr         db      13,10,'Usage: DasmCOM FILE.COM [/32] [>FILE.ASM]',13,10,10,36
norammsg        db      13,10,'No memory available',13,10,10,36
fileiomsg       db      13,10,'File I/O Error',13,10,10,36

_DASM_COPYRIGHT db DASM_COPYRIGHT

infilesize	dd	?

buffer          dd      ?
buffersize      dd      ?

decodestr       db 80 dup(?)

hnd             dw      ?

fake_regs       label dword
                dd 1    ;EAX
                dd 2    ;ECX
                dd 4    ;EDX
                dd 8    ;EBX
                dd 16   ;ESP
                dd 32   ;EBP
                dd 64   ;ESI
                dd 128  ;EDI

IF	TIMEIT
time1l  dd      ?
time1h	dd	?
time2l	dd	?
time2h	dd	?
diffl	dd	?
diffh	dd	?
ENDIF

seg_strs label byte
  db 'ES:',0
  db 'CS:',0
  db 'SS:',0
  db 'DS:',0
  db 'FS:',0
  db 'GS:',0

_siz dd ?

prgbase dd ?  ;virtual program Base (forced to be 100h)

_bits db ?

;
end

