/********************************************************************
        PopCALC  -- INITIALIZATION/DISPOSABLE CODE
         (c) Copyright 1992-94 by Omega Pint, Inc.
*********************************************************************/

#include "cr.h"


#ifdef K1		/* For PDK-1 users, moves TSR to LIM */
#include "lm.h"
#endif

/** STARTUP DATA are in PCID.C  (discarded in resident mode) **/

extern char loaded_msg[];		 /* Startup messages */
extern char hello_msg[],first_msg[];
extern char hello_atr[],mono_atr[];

extern word init_data_end;	      /* Marks end of init-data */

word scr_buf[80];

/** RESIDENT CODE STACK SPACE **/

#define STK_SZ (100)	  /* Size in words */
word res_stack[STK_SZ+1]; /* Allow allways extra word ! */

extern isr();		/* Interrupt service in CALC.C */
extern tmr_isr();	/* Timer tick service */
extern word hk_list[];  /* This is in CALCID.C for use by isr() function */


/** Display Signon screen **/

one_scr(s,a)
char *s,*a;
{
  int x0,y0,x1,y1;
   x0=crs_x; y0=crs_y;
   vid_atr=7; fil_scr('');
     dspf(s,a);
   x1=crs_x; y1=crs_y+1;
   vid_atr=0x7;
   crs_y=y0+1; dsp_ver(0x20,y1-y0);
   crs_x++; crs_y=y0+1; dsp_ver(0x20,y1-y0);
   crs_x=x0+3;crs_y=y1; dsp_hor(0x20,x1-x0-1);
}
extern char atr_expr,atr_rslt,atr_rad,sep_let;

signon()
{ char *s=hello_atr;
   if (vid_mode==7) 
     {
     s=mono_atr;
     atr_expr=atr_rslt=atr_rad=0x70;
     sep_let=0xb3;
     }
   save_crs(); kil_crs();
   crs_x=5; crs_y=1;
   one_scr(first_msg,s); pckey();
   crs_x=11; crs_y=2;
   one_scr(hello_msg,s);
   crs_x=0; crs_y=24; vid_atr=7;
   dsp_hor(0x20,scr_width);
   restore_crs();
   crs_x=0; crs_y=23;
   mv_crs();
}

/** Must match PC.C values **/

#define RAD2  (0)
#define RAD10 (1)
#define RAD16 (2)
#define WS1   (0)
#define WS2   (1)
#define WS4   (2)

extern char sgn,radix,wsz;
extern dword wmask;
extern char cmd_ln_err[];
extern int y0;

parse_cmd_line()
{ register char *s=cmd_line;
  register c;
  dword tmp;
    up_case(cmd_line);
    while (0 != (c=*s++))
      {
      switch (c)
        {
	case 'D': radix=RAD10; break;
	case 'B': radix=RAD2; break;
	case 'H': radix=RAD16; break;
	case 'C': wsz=WS1; wmask=0xff; break;
	case 'I': wsz=WS2; wmask=0xffff; break;
	case 'L': wsz=WS4; wmask=(dword)-1; break;

	case 'U': sgn=0; break;
	case 'S': sgn=1;
	case ',': ;
	case '/': ;
	case '-': ;
	case  32: break;

	default:  if ((c<='9') & (c>='0'))
		    {
		    s--;
		    s=dec2ul(s,&tmp);
		    if ((tmp!=0) && (tmp<scr_len))
		      y0=((word)tmp)-1;
		    else s=0;
		    }
		  else s=0;

		  if (!s)
		    {
		    s=cmd_ln_err;
		    s[25]=(char)c; dsp(s);
		    exit(1);
		    }
		   
	}
      } 

}

/*** INITIALIZATION ***/

main()
{ 

  parse_cmd_line();

#ifdef DBG
  isr();
#else

  signon();

  if (second_load()) {		/* Check if program already loaded */
	dsp(loaded_msg);	/* If so, display error message */
	return(1);		/* Exit to DOS with errorlevel 1 */
	}

 /* SWITCH TO RESIDENT OPERATION */

  idata_end=&init_data_end;	/* This enables init data disposal. */
  icode_beg=one_scr;		/* This enables init code disposal. */

  stay_resident(res_stack,STK_SZ*2);	 /* Define TSR stack */
  install_hk(hk_list,isr,STK_SZ*2,0x7f); /* Minimal HOT-KEY Support */
  install_tsc(tmr_isr,STK_SZ*2,0x7f);	/* Scheduler for key periodic tick */
#endif

#ifdef K1			/* For PDK-1 users, move TSR to LIM */
   if(is_emsnet())		/* Work around Novell EMSNET buggs  */
	move_to_lim(1,1,MOVE_CODE);
   else
	move_to_lim(1,1,MOVE_BOTH);
#endif

  return(0);				/* Exit code 0=Ok exit */

}
