VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.1#0"; "COMDLG32.OCX"
Begin VB.Form PrintDirectDLLTesting 
   Caption         =   "PrinDirect DLL Testing"
   ClientHeight    =   4845
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   4680
   LinkTopic       =   "Form1"
   ScaleHeight     =   4845
   ScaleWidth      =   4680
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton Command4 
      Caption         =   "Orientation"
      Height          =   495
      Left            =   3240
      TabIndex        =   12
      Top             =   3840
      Width           =   1215
   End
   Begin VB.CommandButton Command3 
      Caption         =   "Set Default printer"
      Height          =   495
      Left            =   3240
      TabIndex        =   11
      Top             =   3240
      Width           =   1215
   End
   Begin VB.Frame Frame2 
      Caption         =   "Formfeed"
      Height          =   1215
      Left            =   240
      TabIndex        =   5
      Top             =   3120
      Width           =   2775
      Begin VB.OptionButton Formfeed 
         Caption         =   "No form feed"
         Height          =   255
         Index           =   1
         Left            =   240
         TabIndex        =   10
         Top             =   600
         Value           =   -1  'True
         Width           =   1815
      End
      Begin VB.OptionButton Formfeed 
         Caption         =   "Chr$(12) "
         Height          =   255
         Index           =   0
         Left            =   240
         TabIndex        =   9
         Top             =   240
         Width           =   1815
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Linefeed"
      Height          =   1215
      Left            =   240
      TabIndex        =   4
      Top             =   1920
      Width           =   2775
      Begin VB.OptionButton Linefeed 
         Caption         =   "No line feed"
         Height          =   255
         Index           =   2
         Left            =   240
         TabIndex        =   8
         Top             =   720
         Value           =   -1  'True
         Width           =   1815
      End
      Begin VB.OptionButton Linefeed 
         Caption         =   "Chr$(13) "
         Height          =   255
         Index           =   1
         Left            =   240
         TabIndex        =   7
         Top             =   480
         Width           =   1815
      End
      Begin VB.OptionButton Linefeed 
         Caption         =   "Chr$(13) + Chr$(10)"
         Height          =   255
         Index           =   0
         Left            =   240
         TabIndex        =   6
         Top             =   240
         Width           =   1815
      End
   End
   Begin VB.CommandButton Command2 
      Caption         =   "&LPrint"
      Height          =   495
      Left            =   3240
      TabIndex        =   3
      Top             =   2640
      Width           =   1215
   End
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   3720
      Top             =   3360
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   327681
   End
   Begin VB.ListBox List1 
      Height          =   1425
      Left            =   240
      TabIndex        =   1
      Top             =   360
      Width           =   4215
   End
   Begin VB.CommandButton Command1 
      Caption         =   "&Print File"
      Height          =   495
      Left            =   3240
      TabIndex        =   0
      Top             =   2040
      Width           =   1215
   End
   Begin VB.Label Label3 
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Portrait"
      Height          =   255
      Left            =   1680
      TabIndex        =   14
      Top             =   4440
      Width           =   2775
   End
   Begin VB.Label Label2 
      Caption         =   "Orientation:"
      Height          =   255
      Left            =   240
      TabIndex        =   13
      Top             =   4440
      Width           =   1215
   End
   Begin VB.Label Label1 
      Caption         =   "Printers:"
      Height          =   255
      Left            =   240
      TabIndex        =   2
      Top             =   120
      Width           =   1215
   End
End
Attribute VB_Name = "PrintDirectDLLTesting"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private Declare Function PrintFile Lib "Prntdrct.dll" (ByVal DeviceName As String, ByVal FileToPrint As String) As Long
Private Declare Function AvailablePrinters Lib "Prntdrct.dll" () As Integer
Private Declare Function PrinterDeviceName Lib "Prntdrct.dll" (Index As Integer) As String
Private Declare Function DefaultPrinter Lib "Prntdrct.dll" () As String
Private Declare Function WinPath Lib "Prntdrct.dll" () As String
Private Declare Function IsWindowsNT Lib "Prntdrct.dll" () As Integer
Private Declare Sub Line_feed Lib "Prntdrct.dll" Alias "Linefeed" (ByVal lfeed As String)
Private Declare Sub Frm_feed Lib "Prntdrct.dll" Alias "Formfeed" (ByVal ffeed As String)
Private Declare Sub LPrint Lib "Prntdrct.dll" (ByVal txt As String)
Private Declare Function LPrintEnd Lib "Prntdrct.dll" (ByVal DeviceName As String) As Long
Private Declare Sub License Lib "Prntdrct.dll" (Password As Long)
'new function added to v.1.23
Private Declare Sub SetDefaultPrinter Lib "Prntdrct.dll" (ByVal pDeviceName As String)
'new function added to v.1.24
Private Declare Sub Orientation Lib "Prntdrct.dll" (newOrientation As Integer, oldOrientation As Integer, ByVal escLandscape As String, ByVal escPortrait As String)
Private Declare Sub SetAutoformfeed Lib "Prntdrct.dll" (setting As Integer)

Private Sub Command1_Click()
    Dim x%
    'set autoformfeed
    SetAutoformfeed -1
    x = PrintFile(List1.List(List1.ListIndex), GetFile())
    If x = 0 Then
        MsgBox "Printed!"
        'Note: Depending on the printer formfeed will not automatically added upon closing the document
        '      for safe operation the last byte in the document should be a formfeed
    Else
        MsgBox "Failed"
        'Note: The value of x holds the error number returned by GetLastError
        '      These errors are listed in the Win32api.inc file starting with %ERROR_
    End If
    'set back autoformfeed
    SetAutoformfeed 0
End Sub

Private Sub Command2_Click()
    Dim x%
    LPrint "Hello, my name is Peter Redei"
    LPrint ""
    LPrint "Above this line should be an empty line"
    LPrint "Now, lets explain what this whole thing is about:"
    LPrint "In Windows the Printer Drivers format the text you send to the printer."
    LPrint "This is not always desirable. For example, you might saved a printout already"
    LPrint "formatted to a particular printer in MSWord and now you want to print the file"
    LPrint "without MSWord. Another good example is printing labels in label printers that"
    LPrint "need no driver since the 'driver' is built into the printer. All you need is"
    LPrint "to send plain text containing simple formatting commands for the printer."
    LPrint ""
    LPrint "PrintDirect allows you to print files (text or binary) directly, bypassing"
    LPrint "the printer driver. It also allows you to use similar command that was very"
    LPrint "handy in the old DOS Basic language 'LPrint'."
    If LPrintEnd(List1.List(List1.ListIndex)) Then
       MsgBox "The printing failed"
    Else
       MsgBox "The printing succeeded"
    End If
End Sub

Private Sub Command3_Click()
    SetDefaultPrinter List1.List(List1.ListIndex)
End Sub

Private Sub Command4_Click()
    Static old%, nw%
    nw = Not old
    'escLandscape passed as a null string,
    'so the DLL will use automatically the defaults:
    'for landscape CHR$(27) +  CHR$(38) + CHR$(108) + CHR$(49) + CHR$(79)
    'for portrait CHR$(27) +  CHR$(38) + CHR$(108) + CHR$(48) + CHR$(79)
    Orientation nw, old, "", ""
    'Note: the purpose of this function is clear, but just in case
    '      You can not set the orientation with the printer setup because
    '      the driver will be bypassed. The only way of setting the printer
    '      is to place the escape code directly to the file that will be printed.
    '      When you print a .prn file it will have the escape sequences, so you
    '      will not need this. When you want to print an unformatted text file
    '      you might need it.
    '      The printer you use might require different escape code than the default
    '      that is PCL code or maybe does not support landscape at all.
    Label3 = IIf(nw = True, "Landscape", "Portrait")
End Sub

Private Sub Form_Load()
    'after registration the first call must be
    'License Password
    GetPrinters
    'PopulatePrinters
End Sub
Private Sub GetPrinters()
    Dim pr As Integer
    Dim i%, defPrinter$
    On Error Resume Next
    pr = AvailablePrinters()
    List1.Clear
    For i = 0 To pr - 1
        List1.AddItem PrinterDeviceName(i)
    Next
    defPrinter$ = DefaultPrinter()
    'defPrinter$ = Left$(defPrinter$, InStr(defPrinter$, ",") - 1)
    'select the default printer as start
    For i = 0 To List1.ListCount - 1
        If List1.List(i) = defPrinter$ Then
            List1.ListIndex = i
            Exit For
        End If
    Next

End Sub
Private Sub PopulatePrinters()
    'this code is alternative VB only solution to the GetPrinters
    'routine that uses the Availableprinters PrintDirect DLL call
    'Note: using the PrintDirect DLL is more reliable
    Dim pr As Printer
    Dim i%
    On Error Resume Next
    List1.Clear
    For Each pr In Printers
        List1.AddItem pr.DeviceName
    Next
    'select the default printer as start
    For i = 0 To List1.ListCount - 1
        If List1.List(i) = Printer.DeviceName Then
            List1.ListIndex = i
            Exit For
        End If
    Next
End Sub
Private Function GetFile() As String
    With CommonDialog1
        .DialogTitle = "Select File to print"
        .filename = ""
        .Flags = cdlOFNFileMustExist Or cdlOFNNoReadOnlyReturn Or cdlOFNHideReadOnly
        .Filter = "Textfiles (*.txt)|*.txt|Printfiles (*.prn)|*.prn|All files (*.*)|*.*|"
        .FilterIndex = 1  'lastfilterindex%
        .ShowOpen
        GetFile = .filename
     End With
End Function

Private Sub Formfeed_Click(Index As Integer)
    Select Case Index
        Case 0
            Frm_feed -1
        Case 1
            Frm_feed 0
    End Select
End Sub

Private Sub Linefeed_Click(Index As Integer)
    Select Case Index
        Case 0
            Line_feed Chr$(13) + Chr$(10)
        Case 1
            Line_feed Chr$(13)
        Case 2
            Line_feed ""
    End Select
End Sub
