'
'  TERM.BAS Example Program
'

$ERROR ALL ON
$LIB ALL OFF

DEFINT A-Z
$INCLUDE "PCL4PB.BI"
$INCLUDE "TIMING.BI"
$INCLUDE "MODEM_IO.BI"
$INCLUDE "TERM_IO.BI"
$INCLUDE "DEFINES.BI"
$INCLUDE "CRC16.BI"
$INCLUDE "CRC32.BI"
$INCLUDE "XYPACKET.BI"
$INCLUDE "XYMODEM.BI"
$INCLUDE "DATETIME.BI"
$INCLUDE "ZDATE.BI"
$INCLUDE "ZMODEM.BI"
$INCLUDE "PROCESS.BI"
$INCLUDE "OPCODES.BI"
$INCLUDE "SI.BI"

$LINK "PCL4PB.OBJ"
$LINK "TERM_IO.PBU"
$LINK "MODEM_IO.PBU"
$LINK "CRC16.PBU"
$LINK "CRC32.PBU"
$LINK "XYPACKET.PBU"
$LINK "XYMODEM.PBU"
$LINK "ARRAYS.PBU"
$LINK "DATETIME.PBU"
$LINK "ZDATE.PBU"
$LINK "ZMODEM.PBU"
$LINK "PROCESS.PBU"
$LINK "PUTGET.PBU"
$LINK "OPCODES.PBU"
$LINK "SI.PBU"

 DECLARE SUB MyExit(BYVAL Port AS INTEGER,Message AS STRING)
 DECLARE SUB SayYesNo(BYVAL Flag AS INTEGER)                                                  

 DIM Buffer(2048+16) AS BYTE
 DIM I AS INTEGER
 DIM L AS INTEGER
 DIM Code AS INTEGER
 DIM Port AS INTEGER
 DIM BaudCode AS INTEGER
 DIM LibVer AS INTEGER
 DIM BufSeg AS WORD
 DIM ARG1 AS STRING
 DIM ARG2 AS STRING
 DIM ARG3 AS STRING
 DIM Parms AS STRING
 DIM LV AS STRING
 DIM AnyKey AS STRING
 ' init
 %False = 0
 %True = NOT %False
 %CTLZ = 26
 CLS
 COLOR 7
 VIEW TEXT (1,1) - (80,24)
 ' get args
 Parms$ = RTRIM$(COMMAND$) + " "
 ARG1$ = "" : ARG2$ = "" : ARG3$ = ""
 ' get 1st arg
 I = INSTR(Parms$," ")
 IF I > 1 THEN
    ARG1$ = LEFT$(Parms$, I - 1)
    ' get 2nd arg
    Parms$ = RIGHT$(Parms$, LEN(Parms$) - I)
    I = INSTR(Parms$," ")
    IF I > 1 THEN
        ARG2$ = LEFT$(Parms$, I - 1)
        ' get 3rd argument
        Parms$ = RIGHT$(Parms$, LEN(Parms$) - I)
        I = INSTR(Parms$," ")
        IF I > 1 THEN
           ARG3$ = LEFT$(Parms$, I - 1)
        END IF
    END IF
 END IF
 '''PRINT "[";ARG1$;"|";ARG2$;"|";ARG3$;"]"
 ' got all 3 args ?
 IF ARG2$ = "" THEN
   PRINT "  Usage: TERM <Port> <BaudRate> {Script}"
   PRINT "Example: TERM 1 9600"
   STOP
 END IF
 BaudCode = -1
 'Get COM port
 Port = VAL(ARG1$) - 1
 'Get baud code
 BaudCode = MatchBaud(ARG2$)
 'Verify good baud rate
 IF BaudCode = -1 THEN
   PRINT "Cannot recognize baud rate "; ARG2$
   END
 END IF
 'Reset port
 CALL InitProcess(Port,ARG2$,BaudCode)
 BufSeg = 1 + VARSEG(Buffer(0)) + (VARPTR(Buffer(0)) \ 16)
 Code = SioRxBuf(Port, BufSeg, %Size2K)
 IF Code < 0 THEN
   PRINT "Error "; Code; " returned from SioRxBuf()"
   Code = SioError(Code)
   END
 END IF
 Code = SioReset(Port, BaudCode)
 CLS
 IF Code < 0 THEN
   PRINT "Error "; Code; " returned from SioReset()"
   Code = SioError(Code)
   END
 END IF

 PRINT "-- TERM 3/26/95 --"
 PRINT " "
 LIBVER = SioInfo(ASC("V"))
 LV$ = LTRIM$(STR$(LIBVER\16)) + "." + LTRIM$(STR$(LIBVER MOD 16))
 PRINT "      Library: ";LV$
 PRINT "TX Interrupts: ";
 CALL SayYesNo(SioInfo(ASC("I")))
 PRINT " Flow Control: ";
 CALL SayYesNo(%RTS.CTS.CONTROL)
 IF %RTS.CTS.CONTROL THEN
   Code = SioFlow(Port,18)
 END IF
 PRINT "   16550 UART: ";
 CALL SayYesNo(SioFIFO(Port,%LEVEL.8))
 PRINT "Seg(RxBuffer): ";HEX$(BufSeg)
 PRINT
 'always set DTR and RTS
 Code = SioDTR(Port, %SET.LINE)
 Code = SioRTS(Port, %SET.LINE)
 'wait for Modem to say its ready
 '(AT.COMMAND.SET, etc. defined in DEFINES.BI)
 IF %AT.COMMAND.SET THEN
   PRINT "  <<Waiting for Modem DSR>>"
   DO
     IF SioDSR(Port) THEN
       EXIT DO
     ELSE
       AnyKey$ = INKEY$
       IF (AnyKey$ <> "") OR SioBrkKey THEN
         CALL MyExit(Port,"Aborted by user")
       END IF
       PRINT ".";
       Code = SioDelay(18)
     END IF
   LOOP
   PRINT "  <<DSR on>>"
 END IF
 'waiting for modem CTS ?
 IF %RTS.CTS.CONTROL THEN
   PRINT "  <<Waiting for Modem CTS>>"
   DO
     IF SioCTS(Port) THEN
       EXIT DO
     ELSE
       AnyKey$ = INKEY$
       IF (AnyKey$ <> "") OR SioBrkKey THEN
         CALL MyExit(Port,"Aborted by user")
       END IF
       PRINT ".";
       Code = SioDelay(18)
     END IF
   LOOP
   PRINT "  <<CTS on>>"
 END IF
 'initialize (Hayes compatible) modem ?
 IF %AT.COMMAND.SET THEN
   PRINT "  <<Initializing modem>>
   Code = ModemSendTo(Port,4,"AT!")
   Code = ModemEcho(Port,10)
   Code = ModemSendTo(Port,4,"AT E1 S7=60 S11=60 V1 X1 Q0 S0=1!")
   IF ModemWaitFor(Port,5*%ONE.SECOND,%True,"OK") THEN
     'modem is ready
      PRINT
      PRINT "  <<MODEM READY>>"
   ELSE
      PRINT
      PRINT "  <<WARNING: Expected OK not received>>"
   END IF
 END IF

 IF %SCRIPTS AND (ARG3$<>"") THEN
   Code = Script(Port,ARG3$,%True)
   IF Code < 0 THEN
      CALL SaySiErr(Code)
   END IF
 END IF

 PRINT "Entering TERMINAL loop..."
 CALL ShowStatus("^Z for Menu")

 DO
   'Look at incoming serial
   Code = SioGetc(Port, 1)
   IF Code = 10 THEN
     PRINT
   ELSEIF Code >= &H20 THEN
     PRINT CHR$(Code);
   END IF
   'Anything to send
   AnyKey$ = INKEY$
   IF AnyKey$ <> "" THEN
     IF AnyKey$ = CHR$(%CTLZ) THEN
       IF Process THEN
         EXIT DO
       END IF
     ELSE
       Code = SioPutc(Port, ASC(AnyKey$))
     END IF
   END IF
 LOOP
 PRINT "User typed ^Z..."
 Code = SioDone(Port)
 END

 SUB MyExit(BYVAL Port AS INTEGER,Message AS STRING)
 DIM Code AS INTEGER
 Code = SioDone(Port)
 PRINT Message
 STOP
 END SUB

 SUB SayYesNo(BYVAL Flag AS INTEGER)                                                  
 IF Flag THEN
   PRINT "YES"
 ELSE
   PRINT "NO"
 END IF
 END SUB
