
; This program demonstrates three methods of accessing absolute addresses.
;  It just writes some characters to the video text mode buffer at B800:0000.

%include "pmode.asm"

_main:
                sti

                mov     edi,[_lomembase]        ; fill all low memory with 0s
                mov     ecx,[_lomemtop]
                sub     ecx,edi
                xor     al,al
                rep     stosb

                call    _getselector            ; allocate a selector
                mov     edx,0B8000h             ; point selector to base of video text buffer
                call    [_setselector]
                mov     es,ax                   ; load ES with selector

                mov     B[es:160*24+2*79],'0'
                                                ; put '0' on text screen at X=79, Y=24
                                                ;  ES points to the text screen

                mov     B[gs:0b8000h+160*24+2*78],'1'
                                                ; put '1' on text screen at X=78, Y=24
                                                ;  GS points, by default, to absolute 0

                mov     eax,0B8000h
                sub     eax,[_code32a]
                mov     B[ds:eax+160*24+2*77],'2'
                                                ; put '2' on text screen at X=77, Y=24

                mov     ax,es                   ; free selector allocated before, you do not
                call    _freeselector           ;  really have to do this before exiting

                mov     es,[_seldata]           ; restore ES to _seldata for exit

                jmp     _exit

                CODEEND

