;*****
; win.asm - 'Win' object
;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                __WIN__ equ 1
                include "pmlib.asd"
                include "error.asi"
                include "heap.asi"
                include "win.asi"



proc            WinNew
                ;in
                ;  eax - number of rows in 'Win'
                ;  ebx - number of columns in 'Win'
                ;  ecx - color scheme
                ;out
                ;  edi - 'Win'
                push    eax
                mov     eax, size win
                call    HeapAlloc
                pop     eax
                call    WinInit
                ret
endp



proc            WinInit
                ;室
                ;  eax - number of rows in 'Win'
                ;  ebx - number of columns in 'Win'
                ;  ecx - color scheme
                ;  edi - 'Win'
                ;out
                ;  nothing
                call    PicInit
                mov     [(win edi).dWinSign], WIN_SIGN
                mov     [(win edi).dVisibleRow], eax
                mov     [(win edi).dVisibleCol], ebx
                mov     [(win edi).dShiftRow], 0
                mov     [(win edi).dShiftCol], 0
                ret
endp



proc            WinDelete
                ;in
                ;  esi - 'Win'
                ;out
                ;  nothing
                mov     eax, [(win esi).dImagePtr]
                call    HeapFree
                mov     eax, esi
                call    HeapFree
                ret
endp



proc            WinSetArea
                ;in
                ;  eax - number of visible rows
                ;  ebx - number of visible columns
                ;  edi - 'Win'
                ;out
                ;  nothing
                mov     [(win edi).dVisibleRow], eax
                mov     [(win edi).dVisibleCol], ebx
                ret
endp



proc            WinShiftArea
                ;in
                ;  eax - row offset of visible area
                ;  ebx - cvolumn offset of visible area
                ;  edi - 'Win'
                ;out
                ;  nothing
                mov     [(win edi).dShiftRow], eax
                mov     [(win edi).dShiftCol], ebx
                ret
endp



dRow            dd      ?
dCol            dd      ?
dSrcDelta       dd      ?
dDstDelta       dd      ?
dRowCount       dd      ?
dColCount       dd      ?

proc            WinToWin
                ;in
                ;  eax - row
                ;  ebx - column
                ;  esi - 'Win'
                ;  edi - 'Win' to copy to
                ;out
                ;  nothing

                ;;save parameters and registers
                push    [(win esi).dShiftRow]
                push    [(win esi).dShiftCol]
                push    [(win esi).dVisibleRow]
                push    [(win esi).dVisibleCol]
                pushad

                ;;check left bound
                and     eax, eax
                @IF_S
                  neg   eax
                  add   [(win esi).dShiftRow], eax
                  sub   [(win esi).dVisibleRow], eax
                  jbe   @@exit
                  xor   eax, eax
                @ENDIF
                and     ebx, ebx
                @IF_S
                  neg   ebx
                  add   [(win esi).dShiftCol], ebx
                  sub   [(win esi).dVisibleCol], ebx
                  jbe   @@exit
                  xor   ebx, ebx
                @ENDIF
                mov     [dRow], eax
                mov     [dCol], ebx

                ;;check right bound
                mov     eax, [(win edi).dTotalRow]
                sub     eax, [dRow]
                jbe     @@exit
                sub     eax, [(win esi).dVisibleRow]
                @IF_B
                  add   [(win esi).dVisibleRow], eax
                @ENDIF
                ;
                mov     eax, [(win edi).dTotalCol]
                sub     eax, [dCol]
                jbe     @@exit
                sub     eax, [(win esi).dVisibleCol]
                @IF_B
                  add   [(win esi).dVisibleCol], eax
                @ENDIF

                ;;setup constants
                mov     eax, [(win esi).dTotalCol]
                sub     eax, [(win esi).dVisibleCol]
                mul     [(win esi).dBytesPerCell]
                mov     [dSrcDelta], eax
                ;
                mov     eax, [(win edi).dTotalCol]
                sub     eax, [(win esi).dVisibleCol]
                mul     [(win edi).dBytesPerCell]
                mov     [dDstDelta], eax
                ;
                mov     eax, [(win esi).dVisibleRow]
                mov     [dRowCount], eax
                mov     eax, [(win esi).dVisibleCol]
                mul     [(win esi).dBytesPerCell]
                mov     [dColCount], eax

                ;;setup pointers
                mov     eax, [(win esi).dTotalCol]
                mul     [(win esi).dShiftRow]
                add     eax, [(win esi).dShiftCol]
                mul     [(win esi).dBytesPerCell]
                mov     esi, [(win esi).dImagePtr]
                add     esi, eax
                ;
                mov     eax, [(win edi).dTotalCol]
                mul     [dRow]
                add     eax, [dCol]
                mul     [(win edi).dBytesPerCell]
                mov     edi, [(win edi).dImagePtr]
                add     edi, eax

                ;;main loop
@@loop:         mov     ecx, [dColCount]
                push    ecx
                shr     ecx, 2
                rep     movsd
                pop     ecx
                and     ecx, 3
                rep     movsb

                add     esi, [dSrcDelta]
                add     edi, [dDstDelta]
                dec     [dRowCount]
                jnz     @@loop

                ;;restore parameters and registers
@@exit:         popad
                pop     [(win esi).dVisibleCol]
                pop     [(win esi).dVisibleRow]
                pop     [(win esi).dShiftCol]
                pop     [(win esi).dShiftRow]

                ret
endp



proc            WinFill
                ;in
                ;  eax - filler
                ;  esi - 'Win'
                ;out
                ;  nothing
                pushad

                cmp     [(win esi).dBytesPerCell], 1
                @IF_E
                  mov   ecx, eax
                  mov   eax, [(win esi).dTotalRow]
                  mul   [(win esi).dTotalCol]
                  xchg  eax, ecx
                  mov   edi, [(win esi).dImagePtr]
                  rep   stosb
                  jmp   @@exit
                @ENDIF

                cmp     [(win esi).dBytesPerCell], 2
                @IF_E
                  mov   ecx, eax
                  mov   eax, [(win esi).dTotalRow]
                  mul   [(win esi).dTotalCol]
                  xchg  eax, ecx
                  mov   edi, [(win esi).dImagePtr]
                  rep   stosw
                  jmp   @@exit
                @ENDIF

                cmp     [(win esi).dBytesPerCell], 3
                @IF_E
                  mov   ecx, eax
                  mov   eax, [(win esi).dTotalRow]
                  mul   [(win esi).dTotalCol]
                  xchg  eax, ecx
                  mov   edi, [(win esi).dImagePtr]
                  shld  ebx, eax, 16
                  @DO
                    mov [edi], ax
                    add edi, 2
                    mov [edi], bl
                    inc edi
                  @DJNZ ecx
                  jmp   @@exit
                @ENDIF

                cmp     [(win esi).dBytesPerCell], 4
                @IF_E
                  mov   ecx, eax
                  mov   eax, [(win esi).dTotalRow]
                  mul   [(win esi).dTotalCol]
                  xchg  eax, ecx
                  mov   edi, [(win esi).dImagePtr]
                  rep   stosd
                  jmp   @@exit
                @ENDIF

@@exit:         popad
                ret
endp



dTotalRow       dd      ?
dTotalCol       dd      ?

proc            WinPicFill
                ;in
                ;  esi - 'Win'
                ;  edi - 'Pic'
                ;out
                ;  nothing
                pushad

                mov     eax, [(win esi).dTotalRow]
                mov     [dTotalRow], eax
                mov     eax, [(win esi).dTotalColByte]
                mov     [dTotalCol], eax
                xchg    esi, edi

                mov     ebx, esi                        ;'Pic'
                mov     esi, [(pic esi).dImagePtr]      ;'Pic' image
                mov     edi, [(win edi).dImagePtr]      ;window image

                mov     ecx, [dTotalRow]
                mov     edx, [(pic ebx).dTotalRow]
                mov     ebp, esi
@@loop1:        push    ecx edx ebp

                mov     ecx, [dTotalCol]
                mov     edx, [(pic ebx).dTotalColByte]
                mov     ebp, esi
                @DO
                  movsb
                  dec   edx
                  @IF_Z
                    mov esi, ebp
                    mov edx, [(pic ebx).dTotalColByte]
                  @ENDIF
                @DJNZ   ecx
                mov     esi, ebp
                add     esi, [(pic ebx).dTotalColByte]

                pop     ebp edx ecx
                dec     edx
                @IF_Z
                  mov   esi, ebp
                  mov   edx, [(pic ebx).dTotalRow]
                @ENDIF
                loop    @@loop1

                popad
                ret
endp

ends            code32
                end
