;*****
; vga.asm - VGA adapter handling.
;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                __VGA__ equ 1
                include "pmlib.asd"
                include "vga.asi"
                include "mouse.asi"
                include "timer.asi"



PALETTE_MASK    equ     3c6h
PALETTE_REG_RD	equ	3c7h
PALETTE_REG_WR	equ	3c8h
PALETTE_DATA	equ	3c9h
INPUT_STATUS_1  equ	3dah
VSYNC_MASK	equ	8



bCardType       db      VGA_NOT_TESTED
bIntCounter     db      0



proc            VgaSetPalette
                ;in
                ;  esi - ptr to buffer with palette
                ;out
                ;  nothing
                pushad
                xor     eax, eax
		mov	dx, PALETTE_REG_WR
		out	dx, al
		mov	dx, PALETTE_DATA
                mov     ecx, 3*256
		cld
		rep 	outsb
                popad
		ret
endp



proc            VgaWaitForVSync
                ;in
                ;  nothing
                ;out
                ;  nothing
                pushad

                cmp     [bCardType], VGA_NOT_TESTED
                @IF_E
                  call  TestRetraceBit
                @ENDIF

                cmp     [bCardType], VGA_W_RETRACE
                @IF_E
                  ;;video card have a retrace bit
                  call  MouseState
                  mov   esi, eax
                  mov   edi, ebx
                  mov   ebp, ecx
@@loop1:          mov   dx, INPUT_STATUS_1
                  in    al, dx
                  and   al, VSYNC_MASK
                  @IF_NZ
                    call  MouseState
                    cmp   esi, eax
                    setne dl
                    cmp   edi, ebx
                    setne dh
                    or    dl, dh
                    cmp   ebp, ecx
                    setne dh
                    or    dl, dh
                    jz    @@loop1
                  @ENDIF
@@loop2:          mov   dx, INPUT_STATUS_1
                  in    al, dx
                  and   al, VSYNC_MASK
                  @IF_Z
                    call  MouseState
                    cmp   esi, eax
                    setne dl
                    cmp   edi, ebx
                    setne dh
                    or    dl, dh
                    cmp   ebp, ecx
                    setne dh
                    or    dl, dh
                    jz    @@loop1
                  @ENDIF
                @ELSE
                  ;;video card does not have a retrace bit
                  call  MouseState
                  mov   esi, eax
                  mov   edi, ebx
                  mov   ebp, ecx
                  call  TimerGetSystemTicks
                  mov   edx, eax
@@loop3:          call  MouseState
                  cmp   esi, eax
                  @IF_E
                    cmp   edi, ebx
                    @IF_E
                      cmp   ebp, ecx
                      @IF_E
                        call  TimerGetSystemTicks
                        cmp   eax, edx
                        jz    @@loop3
                      @ENDIF
                    @ENDIF
                  @ENDIF
                @ENDIF

                popad
		ret
endp



proc            VgaType
                ;in
                ;  nothing
                ;out
                ;  eax - card type
                cmp     [bCardType], VGA_NOT_TESTED
                @IF_E
                  call  TestRetraceBit
                @ENDIF
                xor     eax, eax
                mov     al, [bCardType]
		ret
endp





;;
;                             LOCAL METHODS                                ;
;;



proc            TestRetraceBit
                pushad

                mov   [bCardType], VGA_WO_RETRACE
                lea   eax, [TimerHandler]
                call  TimerSetHandler
                mov   edx, INPUT_STATUS_1
@@loop1:        cmp   [bIntCounter], 2
                @IF_B
                  in  al, dx
                  and al, VSYNC_MASK
                  jz  @@loop1
@@loop2:          cmp   [bIntCounter], 3
                  @IF_B
                    in  al, dx
                    and al, VSYNC_MASK
                    jnz @@loop2
                    mov [bCardType], VGA_W_RETRACE
                  @ENDIF
                @ENDIF
                call  TimerRestore

                popad
                ret
endp



proc            TimerHandler
                inc     [bIntCounter]
		ret
endp

ends            code32
                end
