;*****
; threads.asm - threads handling.
;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                __THREADS__  equ 1
                include "pmlib.asd"
                include "threads.asi"
                include "error.asi"
                include "heap.asi"
                include "list.asi"



dList           dd      0

RUS_MESSAGE     cErrNotEmpty    " ⨢ 楯窨."
ENG_MESSAGE     cErrNotEmpty    "Active threads exists."



proc            ThreadsInit
                ;in
                ;  nothing
                ;out
                ;  nothing
                push    edi
                call    ListNew
                mov     [dList], edi
                pop     edi
                ret
endp



proc            ThreadsRestore
                ;in
                ;  nothing
                ;out
                ;  nothing
                push    esi

                mov     esi, [dList]
                call    ListIsEmpty
                @IF_C
                  lea   esi, [cErrNotEmpty]
                  call  ErrorFatal
                @ENDIF

                call    ListDelete

                pop     esi
                ret
endp



proc            ThreadsUpdate
                ;in
                ;  nothing
                ;out
                ;  nothing
                push    esi

                mov     esi, [dList]
                call    ListFirst
@@loop:         @IF_NC
                  push  esi
                  mov   esi, [(thread eax).dObject]
                  call  [(thread eax).dMethod]
                  pop   esi
                  call  ListNext
                  jmp   short @@loop
                @ENDIF

                pop     esi
                ret
endp



proc            ThreadNew
                ;in
                ;  eax - object update method
                ;  esi - object
                ;out
                ;  edi - 'Thread'
                push    esi

                push    eax
                mov     eax, size thread
                call    HeapAlloc
                mov     [(thread edi).dSign], THREAD_SIGN
                mov     [(thread edi).dObject], esi
                pop     [(thread edi).dMethod]

                mov     esi, [dList]
                call    ListInsertFirst

                pop     esi
                ret
endp



proc            ThreadDelete
                ;in
                ;  esi - 'Thread'
                ;out
                ;  nothing
                push    esi edi

                mov     edi, esi
                mov     esi, [dList]
                call    ListRemove
                mov     eax, edi
                call    HeapFree

                pop     edi esi
                ret
endp

ends            code32
                end
