;*****
; main.asm - windows system test.
;





segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                public  Main
                include "pmlib.asd"
                include "font.asi"
                include "fontmx.asi"
                include "color.asi"
                include "debug.asi"
                include "error.asi"
                include "key.asi"
                include "pcx.asi"
                include "str.asi"
                include "svga.asi"
                include "win.asi"
                include "windows.asi"



@STR            cFmxFileName    "..\..\resource\11x9x1.fmx"
@STR            cGndFileName    "..\..\resource\ground.pcx"
@STR            cCurFileName    "..\..\resource\cursor.pcx"
RUS_MESSAGE     cHelloStr  "ࠢ, !  ४ᥭ!"
ENG_MESSAGE     cHelloStr  "Hello, World! You're beautiful!"



dColorScheme    dd      COLOR32
adPalette       dd      0, 0FFFFFFh
dFont           dd      0
dWin            dd      0
dWindow         dd      0



proc            Main

                ;;create font
                call    InitFont

                ;;initialize video mode
                mov     eax, 480
                mov     ebx, 640
                mov     eax, 384
                mov     ebx, 512
                mov     eax, 600
                mov     ebx, 800
                mov     ecx, [dColorScheme]
                call    SvgaInit

                ;;init windows system
                lea     esi, [cGndFileName]
                call    PcxToPic
                push    edi
                mov     esi, edi
                call    PicToCurrentColorScheme
                lea     esi, [cCurFileName]
                call    PcxToPic
                mov     esi, edi
                call    PicToCurrentColorScheme
                pop     esi
                call    WindowsInit

                ;;ᮧ ஢ 
                call    SvgaGetInfo
                mov     eax, 150
                mov     ebx, 242
                mov     ecx, [dColorScheme]
                call    WinNew
                mov     [dWin], edi
                ;;clear
                mov     eax, 099999999h
                call    ColorTrueToCurrent
                mov     esi, edi
                call    WinFill
                ;;print message
                mov     ebx, -1
                mov     ecx, -1
                lea     edx, [cHelloStr]
                mov     esi, [dFont]
                mov     edi, [dWin]
                call    FontPrintStrz
                ;;ᮧ ᮪஢ 
                call    SvgaGetInfo
                mov     eax, 100
                mov     ebx, 100
                lea     edx, [WindowMoveEventHnd]
                mov     esi, [dWin]
                call    WindowNew
                mov     [dWindow], edi
                ;;show window
                mov     esi, edi
                call    WindowUpdate

                ;;main loop
@@loop:         call    CursorUpdate
                call    KeyNoWait
                cmp     eax, K_ESC
                jne     @@loop

                ;;restore video mode
                call    SvgaRestore

                ret
endp



proc            InitFont
                ;in
                ;  nothing
                ;out
                ;  nothing
                pushad

                ;;create font object
                lea     eax, [cFmxFileName]
                call    FontmxNew
                mov     eax, 2
                mov     ebx, 0
                mov     ecx, [dColorScheme]
                mov     esi, edi
                lea     edi, [adPalette]
                call    FontNew
                mov     [dFont], edi

                popad
                ret
endp

ends            code32
                end
