;****************************************************************************;
; main.asm - timer functions test.                                           ;
;                                                                            ;
;       Plays sample through the speaker.                                    ;
;****************************************************************************;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                public  Main
                include "pmlib.asd"
                include "debug.asi"
                include "error.asi"
                include "host.asi"
                include "timer.asi"



DATA2_PORT      equ     42h
CMD_PORT        equ     43h
CTRL_PORT       equ     61h



wEndFlag        dw      0
cDosOnly        db      "This program requires DOS.", 0



proc            Main

                ;;host check
                call    HostType
                and     al, al
                @IF_NZ
                  lea   esi, [cDosOnly]
                  call  ErrorFatal
                @ENDIF

                cli
                mov     eax, 22000              ;frequency
                call    TimerSetFrequency
                lea     eax, [IntHandler]       ;interrupt handler
                call    TimerSetHandler

                ;;enable sound output
                in      al, CTRL_PORT
                or      al, 3
                out     CTRL_PORT, al
                sti

                ;;main loop
@@loop:         cmp     [wEndFlag], 0
                jz      @@loop

                ;;restore timer state
                cli
                call    TimerRestore

                ;;disable sound output
                in      al, CTRL_PORT
                xor     al, 3
                out     CTRL_PORT, al
                sti

                ret
endp



proc            IntHandler
                pushad

                mov     edi, [dSamplePtr]
                add     [wCounter], 06200h
                adc     edi, 0
                cmp     edi, [dSampleLen]
                @IF_AE
                  mov   [wEndFlag], 1
                  jmp    @@exit
                @ENDIF
                mov     [dSamplePtr], edi
                lea     ebx, [abSample]

                ;;without interpolation
                ;xor     eax, eax
                ;mov     al, [ebx+edi]

                ;;interpolation
                movsx   ax, [bptr (ebx+edi)]
                mov     cx, ax
                inc     edi
                movsx   bx, [bptr (ebx+edi)]
                xchg    ax, bx
                sub     ax, bx
                mov     bx, [wCounter]
                shr     bx, 8
                mul     bx
                sar     ax, 8
                add     ax, cx

                and     eax, 0FFh
                add     al, 080h
                mov     edi, eax
                lea     ebx, [awFreq]
                mov     cx, [ebx+edi*2]

                mov     al, 10110000b
                out     CMD_PORT, al
                mov     al, cl
                out     DATA2_PORT, al
                mov     al, ch
                out     DATA2_PORT, al

@@exit:         popad
                ret
endp            IntHandler



                counter = 70
awFreq          dw      counter
                dw      counter
                dw      counter
                dw      counter
                REPT    63
                counter = counter - 1
                dw      counter
                dw      counter
                dw      counter
                dw      counter
                ENDM

wCounter        dw      0
dSamplePtr      dd      0

abSample:       db      000h,000h,000h,000h,000h,000h,000h,017h
                db      039h,033h,03dh,036h,010h,00ch,02fh,047h
                db      00ch,006h,0ebh,0ebh,00ah,0e1h,000h,000h
                db      0cch,0bah,0d3h,0ffh,0ffh,0f6h,007h,0f6h
                db      026h,032h,038h,04dh,055h,034h,01fh,0f0h
                db      0e7h,0e2h,0c1h,0a2h,083h,08ah,081h,098h
                db      09bh,0cch,00ah,0feh,0e7h,0cch,0c1h,0ceh
                db      0ddh,0d3h,0ddh,000h,00ah,000h,026h,04dh
                db      062h,01eh,0f6h,0c6h,0c4h,0dbh,0f5h,0e5h
                db      0d8h,0eah,0eah,0deh,0dbh,0eah,0cdh,0aeh
                db      0b6h,0cdh,0f9h,0feh,0fdh,0ffh,0feh,0feh
                db      02ah,03bh,031h,03dh,066h,059h,04eh,04fh
                db      070h,059h,034h,020h,047h,04eh,04ah,064h
                db      068h,068h,05dh,03bh,036h,033h,027h,048h
                db      048h,039h,026h,033h,02eh,01fh,033h,01ah
                db      003h,0feh,0eeh,0fdh,0f8h,0cch,0c5h,0c7h
                db      0e6h,0feh,000h,000h,008h,0ffh,010h,01ah
                db      02fh,01ah,00dh,000h,000h,01ch,025h,00bh
                db      0fdh,0e9h,0d8h,0e4h,0d5h,0dbh,0d5h,0c1h
                db      0b5h,0dbh,0f0h,0fdh,0feh,001h,0f0h,001h
                db      01bh,021h,01bh,01bh,010h,00bh,001h,001h
                db      011h,0f4h,0cbh,0c1h,0c5h,0b9h,0c3h,0d1h
                db      0dah,0d0h,0dbh,0dah,0c1h,0d4h,0feh,001h
                db      0f4h,0f9h,020h,011h,003h,003h,022h,02ch
                db      0ffh,0e9h,0e5h,0e3h,0f0h,0efh,0d9h,0b8h
                db      0b0h,0b1h,0b4h,0bah,0c9h,0c6h,0a6h,0a6h
                db      0cah,0d6h,0e3h,0f5h,0efh,007h,017h,021h
                db      031h,03bh,041h,041h,041h,032h,050h,06ch
                db      051h,04ah,04ch,040h,04ah,03dh,03bh,04bh
                db      050h,03bh,030h,030h,023h,017h,027h,013h
                db      017h,017h,007h,020h,00ch,002h,0ffh,0e5h
                db      0d9h,0cfh,0e8h,000h,0ceh,0d5h,0f2h,000h
                db      000h,000h,000h,001h,003h,01eh,02eh,048h
                db      02eh,036h,03dh,02ch,026h,03ch,023h,002h
                db      0f5h,0f3h,0f3h,0edh,0e3h,0d4h,0e3h,0cfh
                db      0e3h,0ffh,00bh,0ffh,0ffh,0feh,00ch,019h
                db      021h,016h,00dh,000h,003h,006h,0f4h,0eeh
                db      0d3h,0bch,0b2h,0aah,0ach,0b6h,0a2h,0b2h
                db      0b2h,0b2h,0a4h,0abh,0bfh,0c2h,0d2h,0dch
                db      0f3h,000h,000h,0ffh,006h,023h,022h,013h
                db      002h,001h,003h,008h,002h,0ffh,0e3h,0e2h
                db      0dah,0d2h,0dah,0dch,0c2h,0cch,0b9h,0d2h
                db      0ddh,0d4h,0e3h,0feh,012h,00dh,028h,034h
                db      040h,048h,03ch,053h,05fh,051h,063h,064h
                db      058h,059h,053h,051h,04bh,04dh,04bh,040h
                db      035h,029h,025h,02fh,009h,01bh,019h,012h
                db      003h,006h,008h,0feh,000h,000h,0e1h,0ddh
                db      0e6h,0f7h,0f3h,0e2h,0d9h,0eeh,002h,008h
                db      00dh,012h,00dh,016h,032h,036h,032h,036h
                db      038h,02ah,025h,021h,025h,012h,0ffh,0f4h
                db      0eeh,0e6h,0e2h,0e2h,0edh,0e6h,0e4h,000h
                db      012h,018h,00eh,00eh,009h,00eh,022h,016h
                db      009h,013h,00bh,009h,001h,0edh,0e3h,0c2h
                db      0a4h,09dh,09eh,08ch,08ch,09dh,0a6h,09eh
                db      0a0h,0aeh,0b0h,0b6h,0bah,0e0h,0edh,0f1h
                db      0fdh,001h,007h,003h,019h,01dh,015h,00eh
                db      00bh,009h,002h,0feh,000h,0e3h,0cah,0e0h
                db      0dah,0d6h,0ddh,0d4h,0d2h,0d8h,0deh,0ddh
                db      0e9h,0feh,00bh,028h,018h,023h,03dh,02eh
                db      027h,037h,054h,053h,049h,051h,053h,053h
                db      043h,043h,054h,047h,049h,04eh,033h,035h
                db      03dh,024h,024h,00bh,014h,00fh,018h,00bh
                db      000h,0fbh,000h,0e6h,0e2h,0d5h,0dch,0dbh
                db      0dfh,0e6h,0ddh,0d5h,0ebh,0f7h,000h,000h
                db      0ffh,019h,02ah,025h,024h,036h,025h,02ch
                db      031h,02ch,019h,021h,010h,00ah,000h,0f2h
                db      0f0h,0f9h,0f2h,0f4h,0fdh,000h,003h,00ch
                db      016h,010h,00ch,015h,00eh,00fh,008h,004h
                db      002h,00eh,002h,000h,0f6h,0d0h,0c1h,0bch
                db      0b7h,09dh,095h,095h,09eh,095h,08ah,0a0h
                db      0ach,0abh,0b1h,0c2h,0dbh,0e4h,0e7h,0eah
                db      000h,0fch,0fdh,000h,00eh,016h,01eh,01fh
                db      00ah,012h,008h,0feh,0f2h,0f0h,0f7h,0f7h
                db      0f1h,0e7h,0eeh,0fdh,0eeh,0fah,0f1h,0feh
                db      018h,025h,022h,035h,033h,032h,026h,01dh
                db      033h,043h,044h,039h,04bh,04bh,03ah,03ah
                db      032h,034h,042h,035h,02ch,026h,03fh,038h
                db      025h,01ah,004h,000h,009h,008h,000h,0ffh
                db      0feh,0f7h,0e5h,0e5h,0deh,0e6h,0deh,0d7h
                db      0e0h,0e4h,0d2h,0ebh,0f8h,0f8h,0fch,009h
                db      01bh,022h,022h,022h,02dh,02eh,030h,036h
                db      032h,011h,01ah,022h,017h,006h,003h,002h
                db      003h,0f7h,0feh,010h,00eh,009h,013h,015h
                db      017h,01bh,015h,013h,00dh,001h,001h,002h
                db      002h,000h,00bh,0e0h,0c2h,0d0h,0cah,0a7h
                db      091h,093h,097h,090h,083h,090h,0a4h,0a6h
                db      0aah,0b9h,0c8h,0d7h,0dfh,0deh,0ebh,0efh
                db      0f6h,0f6h,0ech,008h,022h,021h,016h,01ah
                db      014h,004h,0feh,0fah,0ffh,003h,0feh,0f8h
                db      0feh,002h,00dh,000h,0fch,001h,00fh,017h
                db      027h,035h,03bh,031h,02eh,021h,032h,03bh
                db      038h,050h,03eh,045h,04ch,045h,035h,038h
                db      03bh,038h,027h,017h,01dh,02eh,023h,009h
                db      004h,007h,0fdh,0ffh,000h,0ffh,0fah,0efh
                db      0e8h,0d6h,0e5h,0deh,0e5h,0ddh,0dah,0deh
                db      0ebh,0e5h,0ebh,0f2h,0fch,000h,00bh,016h
                db      01dh,017h,015h,017h,021h,026h,028h,01dh
                db      014h,014h,018h,006h,007h,000h,0feh,0f9h
                db      0f9h,0fch,00eh,015h,00ah,00dh,018h,015h
                db      00fh,016h,009h,001h,005h,0fdh,0f7h,003h
                db      0fdh,0f4h,0c8h,0c7h,0d2h,0c6h,09bh,097h
                db      09ch,08ch,083h,087h,08ah,098h,0a0h,0adh
                db      0bfh,0c9h,0d4h,0e7h,0d7h,0e4h,0f2h,0f1h
                db      0ebh,0f6h,013h,020h,02bh,02bh,01fh,018h
                db      003h,001h,008h,005h,005h,007h,000h,00eh
                db      01bh,013h,00ch,00fh,013h,025h,02ch,03dh
                db      04ah,04eh,02ah,035h,032h,032h,03fh,03fh
                db      044h,03fh,035h,032h,032h,029h,029h,028h
                db      025h,00ah,00bh,014h,021h,00ch,0f9h,0f4h
                db      0fch,0e9h,0efh,0f5h,0fch,0eeh,0dbh,0d4h
                db      0cdh,0d2h,0d4h,0dfh,0dch,0d9h,0e4h,0fbh
                db      0f7h,0efh,0f8h,000h,008h,010h,01fh,01fh
                db      016h,011h,018h,025h,01eh,017h,01bh,011h
                db      009h,011h,013h,00dh,008h,002h,000h,005h
                db      00fh,022h,026h,01dh,016h,01eh,021h,01bh
                db      015h,010h,006h,002h,000h,001h,008h,0ffh
                db      0e8h,0d7h,0d4h,0d3h,0c7h,0b4h,0aah,0a0h
                db      0a1h,093h,09dh,09dh,0a3h,0b4h,0c7h,0c8h
                db      0d3h,0d5h,0dfh,0e7h,0efh,0e9h,0f1h,0f9h
                db      0f8h,00dh,022h,027h,024h,017h,006h,000h
                db      000h,00fh,009h,003h,002h,00bh,018h,016h
                db      018h,011h,014h,01ch,01eh,033h,045h,042h
                db      043h,035h,031h,039h,03ah,039h,042h,049h
                db      03dh,035h,02fh,033h,02ah,024h,020h,01ah
                db      007h,00ah,015h,013h,004h,0f9h,0eeh,0eeh
                db      0e4h,0f0h,0f9h,0feh,0edh,0e1h,0ddh,0d5h
                db      0d7h,0e3h,0e3h,0e6h,0e8h,0fch,004h,000h
                db      0f8h,000h,003h,00dh,012h,01bh,01ah,013h
                db      017h,01fh,020h,019h,01bh,013h,008h,000h
                db      00fh,016h,00dh,003h,000h,000h,007h,00bh
                db      022h,01ch,017h,018h,01ch,020h,020h,01ch
                db      011h,000h,000h,001h,002h,0ffh,0efh,0e2h
                db      0d6h,0c5h,0c8h,0c7h,0b7h,0a1h,090h,094h
                db      092h,092h,096h,09fh,0b2h,0c4h,0cfh,0cch
                db      0d2h,0eeh,0f0h,0f0h,0f1h,0f0h,0f5h,0f9h
                db      00eh,021h,032h,024h,017h,007h,003h,009h
                db      015h,001h,000h,004h,007h,00dh,010h,014h
                db      018h,00ch,010h,021h,02eh,03bh,038h,032h
                db      023h,026h,02bh,034h,02eh,038h,044h,03bh
                db      02eh,02eh,02ah,021h,01ch,00eh,001h,0fdh
                db      000h,000h,004h,000h,0eeh,0d5h,0d2h,0d2h
                db      0e4h,0ech,0ebh,0deh,0d3h,0c9h,0cah,0cdh
                db      0d7h,0dbh,0e6h,0eeh,0f8h,001h,006h,0ffh
                db      000h,004h,015h,016h,017h,011h,019h,01ah
                db      020h,01ch,026h,020h,01bh,00fh,00bh,014h
                db      01dh,00eh,00dh,003h,005h,012h,01ah,024h
                db      026h,023h,023h,023h,020h,029h,01ch,00fh
                db      003h,006h,003h,0fdh,0fch,0ebh,0d8h,0d8h
                db      0c9h,0d1h,0d3h,0bdh,0a1h,092h,08fh,08eh
                db      09dh,094h,0a2h,0bdh,0c9h,0cdh,0d2h,0dah
                db      0f1h,0f9h,0eah,0f1h,0f2h,0fah,000h,018h
                db      02ah,033h,02eh,010h,003h,00eh,007h,00bh
                db      002h,000h,00dh,00eh,00bh,019h,01ah,010h
                db      00fh,019h,026h,033h,03bh,039h,033h,02ah
                db      028h,02dh,034h,038h,03dh,040h,042h,03ah
                db      034h,02dh,022h,015h,005h,0ffh,0fah,0fbh
                db      003h,002h,002h,0eah,0c7h,0c5h,0d3h,0dbh
                db      0e6h,0e8h,0dch,0cdh,0c7h,0cch,0cdh,0dfh
                db      0e4h,0efh,0f6h,0ffh,003h,00ah,000h,0fdh
                db      006h,019h,00fh,00fh,016h,01fh,019h,01ch
                db      024h,025h,020h,016h,00fh,015h,01ah,026h
                db      01ah,015h,00dh,015h,027h,024h,028h,032h
                db      02fh,029h,027h,030h,02dh,016h,019h,015h
                db      011h,006h,000h,0f8h,0e4h,0d1h,0ceh,0d1h
                db      0cfh,0d2h,0c3h,0a0h,086h,08ch,089h,08eh
                db      096h,0a3h,0b8h,0c8h,0c6h,0d8h,0e7h,0f4h
                db      0f5h,0f2h,0ech,0eeh,0fdh,002h,014h,02bh
                db      02fh,023h,019h,008h,010h,00dh,008h,009h
                db      00bh,009h,010h,013h,019h,01ah,014h,012h
                db      019h,026h,02fh,036h,035h,031h,027h,023h
                db      02ah,034h,034h,03eh,03dh,03eh,037h,038h
                db      032h,025h,011h,0fdh,0f8h,0f3h,0f3h,000h
                db      003h,0feh,0e4h,0c8h,0c0h,0c9h,0d7h,0e5h
                db      0dah,0d4h,0c7h,0c6h,0cbh,0d2h,0d8h,0e2h
                db      0eeh,0f7h,0f9h,000h,003h,000h,0ffh,00dh
                db      00ch,013h,015h,016h,01ch,017h,01ch,022h
                db      023h,016h,016h,019h,019h,016h,023h,01ah
                db      013h,014h,019h,024h,027h,028h,034h,028h
                db      028h,02dh,02dh,027h,014h,018h,016h,00dh
                db      005h,000h,0e2h,0c6h,0c2h,0c7h,0c7h,0cch
                db      0d1h,0bah,09dh,084h,081h,083h,088h,093h
                db      0a4h,0aeh,0bfh,0d0h,0dfh,0e7h,0f4h,0f6h
                db      0efh,0efh,0f1h,0fbh,00bh,016h,022h,02bh
                db      022h,019h,018h,010h,00ch,011h,011h,00dh
                db      011h,019h,017h,018h,017h,014h,016h,020h
                db      029h,032h,037h,038h,030h,029h,028h,02ah
                db      031h,036h,035h,038h,03ah,038h,035h,030h
                db      022h,005h,0eeh,0e4h,0e9h,0f1h,0fbh,0f9h
                db      0f9h,0ddh,0c2h,0beh,0ceh,0cfh,0dbh,0d8h
                db      0d7h,0d0h,0cdh,0cch,0cfh,0d8h,0e6h,0efh
                db      000h,000h,000h,009h,007h,000h,008h,00fh
                db      016h,017h,01ah,018h,01eh,022h,022h,01dh
                db      019h,019h,01bh,021h,019h,01fh,01bh,017h
                db      01dh,01bh,025h,029h,026h,030h,034h,035h
                db      031h,02fh,02ch,020h,01dh,014h,010h,00dh
                db      0efh,0cfh,0c9h,0bfh,0cbh,0d2h,0cch,0cdh
                db      0beh,0a2h,08ah,087h,088h,090h,09eh,0abh
                db      0bdh,0cch,0d8h,0e3h,0e7h,0e8h,0f8h,0fbh
                db      0f9h,002h,00ch,010h,010h,018h,025h,02dh
                db      025h,020h,01dh,01eh,020h,023h,021h,020h
                db      027h,022h,020h,026h,024h,022h,01eh,01ch
                db      020h,020h,026h,029h,028h,025h,026h,027h
                db      022h,025h,02ah,02bh,01fh,01eh,01ch,006h
                db      0e2h,0d9h,0dbh,0d8h,0dch,0ebh,0ebh,0e6h
                db      0cfh,0b8h,0afh,0b3h,0b7h,0c7h,0d9h,0deh
                db      0dbh,0ddh,0e5h,0eah,0f0h,0fdh,0feh,0ffh
                db      000h,008h,011h,015h,00bh,00fh,014h,020h
                db      01eh,021h,021h,024h,022h,028h,027h,02ch
                db      030h,030h,02eh,02bh,02fh,030h,02bh,02bh
                db      026h,025h,029h,022h,02ch,02dh,026h,020h
                db      021h,026h,027h,022h,021h,01eh,00ch,0eeh
                db      0deh,0e0h,0e0h,0d6h,0d9h,0d4h,0ceh,0c3h
                db      0a6h,095h,091h,091h,09ah,0ach,0b2h,0b5h
                db      0c5h,0d0h,0d4h,0d7h,0e2h,0f0h,0f5h,0f4h
                db      0fdh,006h,008h,00fh,013h,01dh,021h,01fh
                db      01bh,015h,018h,019h,01fh,021h,01dh,021h
                db      023h,01dh,020h,020h,01bh,01dh,020h,023h
                db      026h,024h,026h,025h,024h,021h,021h,020h
                db      01fh,028h,02bh,022h,01bh,00ah,0f0h,0dch
                db      0d6h,0dbh,0ddh,0e0h,0e3h,0e5h,0dfh,0cah
                db      0b8h,0afh,0b6h,0bbh,0c8h,0d5h,0d9h,0ddh
                db      0dfh,0e2h,0eah,0f0h,0f9h,0feh,000h,004h
                db      009h,00fh,011h,009h,00dh,014h,019h,01bh
                db      019h,01bh,01ch,01fh,022h,023h,026h,023h
                db      028h,028h,023h,02ah,030h,02bh,028h,025h
                db      026h,02bh,02ah,02ch,02fh,028h,01ch,01dh
                db      023h,025h,01eh,01ch,00ah,0f3h,0e0h,0ddh
                db      0ddh,0e0h,0ddh,0deh,0d8h,0cfh,0c7h,0aeh
                db      09dh,09bh,0a0h,0a3h,0ach,0b6h,0c3h,0ceh
                db      0dah,0dfh,0e9h,0ech,0f2h,0f9h,0f9h,0fch
                db      006h,007h,00eh,013h,01bh,023h,023h,021h
                db      01bh,01ah,01ch,01bh,020h,01ch,01dh,020h
                db      020h,022h,023h,022h,023h,025h,027h,028h
                db      027h,028h,029h,028h,024h,022h,020h,020h
                db      023h,029h,023h,012h,0f8h,0e4h,0dbh,0d6h
                db      0d8h,0dch,0dfh,0e2h,0dfh,0d6h,0c8h,0b9h
                db      0b5h,0b6h,0bah,0bbh,0cbh,0d5h,0ddh,0deh
                db      0e5h,0ebh,0efh,0f6h,0f9h,0feh,004h,007h
                db      00dh,013h,00ch,00ah,011h,017h,017h,019h
                db      017h,01eh,020h,023h,022h,029h,024h,027h
                db      027h,029h,024h,02bh,02ah,027h,024h,023h
                db      026h,024h,024h,029h,020h,016h,014h,019h
                db      01fh,01dh,010h,0fbh,0ebh,0e3h,0dfh,0deh
                db      0dfh,0deh,0e4h,0deh,0d3h,0cah,0b9h,0ach
                db      0a9h,0a9h,0adh,0b2h,0bdh,0cbh,0d5h,0e1h
                db      0edh,0eeh,0f0h,0f7h,0fch,0fdh,000h,007h
                db      00fh,011h,014h,01ah,020h,022h,01dh,01ah
                db      01ah,01eh,020h,021h,01fh,01eh,021h,01fh
                db      01eh,021h,020h,022h,021h,024h,024h,024h
                db      027h,029h,026h,021h,01eh,01eh,020h,024h
                db      02ah,026h,008h,0f1h,0e5h,0e4h,0e3h,0e4h
                db      0e5h,0ech,0ech,0edh,0e4h,0d3h,0bch,0b3h
                db      0b3h,0bbh,0bah,0cah,0d9h,0e0h,0e1h,0e5h
                db      0ebh,0eeh,0f7h,0fch,0feh,003h,006h,007h
                db      00ch,00fh,007h,00fh,015h,01bh,017h,017h
                db      01bh,01ch,01ch,01fh,022h,023h,025h,024h
                db      028h,025h,029h,028h,028h,024h,024h,023h
                db      024h,01fh,025h,01ch,013h,017h,01ch,01eh
                db      01bh,008h,0f4h,0e3h,0e5h,0deh,0dbh,0e2h
                db      0e4h,0e4h,0e4h,0dfh,0d8h,0bbh,0a5h,0a0h
                db      0a5h,0aah,0b9h,0c5h,0cbh,0dah,0e4h,0eah
                db      0eeh,0f2h,0f8h,0ffh,000h,004h,007h,00fh
                db      00fh,011h,016h,021h,025h,01bh,016h,012h
                db      018h,019h,01bh,019h,01ch,01ch,01bh,018h
                db      021h,01bh,01ah,01ah,01ah,01eh,020h,021h
                db      023h,023h,020h,01ah,018h,01fh,01fh,022h
                db      01ah,000h,0ebh,0e5h,0e6h,0e6h,0e9h,0ebh
                db      0ech,0f0h,0f2h,0f0h,0ddh,0bah,0b2h,0b1h
                db      0bbh,0c6h,0d4h,0d6h,0e1h,0e1h,0e2h,0e9h
                db      0ech,0edh,0f9h,0ffh,002h,003h,007h,00bh
                db      00eh,00ah,00ah,013h,016h,014h,016h,015h
                db      016h,01dh,01fh,01fh,020h,026h,022h,021h
                db      022h,02ah,02ah,027h,022h,020h,01eh,01fh
                db      01fh,025h,01fh,01ch,015h,017h,01dh,014h
                db      000h,0ech,0e1h,0e1h,0e4h,0eah,0e9h,0e8h
                db      0e3h,0e8h,0e4h,0e1h,0c8h,0b2h,0ach,0b4h
                db      0c6h,0c8h,0cch,0d0h,0dbh,0e9h,0f1h,0f5h
                db      0fah,0feh,004h,009h,009h,00dh,015h,012h
                db      013h,017h,01fh,024h,01eh,015h,017h,01dh
                db      01fh,01fh,021h,01dh,01ch,016h,010h,016h
                db      01dh,01bh,018h,01ch,01ch,01eh,01bh,01ch
                db      018h,015h,015h,018h,016h,016h,016h,00ah
                db      0fah,0eah,0e5h,0efh,0f7h,0f7h,0f7h,0f7h
                db      0f7h,0f7h,0f3h,0e2h,0c7h,0bbh,0c4h,0cdh
                db      0d3h,0dah,0dah,0dfh,0e4h,0ebh,0ech,0f3h
                db      0f5h,0feh,000h,004h,002h,004h,004h,003h
                db      004h,005h,009h,00fh,00ah,009h,007h,009h
                db      009h,00ah,00fh,015h,015h,017h,017h,01ch
                db      020h,022h,01ch,018h,014h,012h,015h,018h
                db      01ch,020h,01eh,018h,016h,016h,00dh,0f8h
                db      0eah,0e4h,0eah,0eeh,0f5h,0f3h,0f3h,0edh
                db      0f6h,0efh,0edh,0deh,0c9h,0bch,0c1h,0c5h
                db      0cch,0cfh,0d0h,0d9h,0e7h,0f6h,0fdh,000h
                db      000h,008h,00ah,00bh,010h,014h,010h,014h
                db      01bh,024h,027h,022h,01bh,017h,017h,01fh
                db      01fh,01fh,018h,017h,015h,00bh,013h,017h
                db      011h,00bh,012h,012h,012h,012h,013h,010h
                db      00ah,011h,015h,018h,011h,00ch,002h,0efh
                db      0e9h,0f1h,0f7h,0fbh,0f6h,0f8h,0fbh,0fdh
                db      0f8h,0efh,0e8h,0d8h,0c4h,0c3h,0c8h,0d3h
                db      0d3h,0d8h,0ddh,0e2h,0e9h,0eeh,0f6h,0fah
                db      000h,000h,004h,009h,006h,006h,009h,001h
                db      004h,009h,009h,006h,008h,004h,003h,004h
                db      008h,009h,011h,016h,017h,017h,01eh,01fh
                db      022h,01dh,018h,017h,018h,01bh,01bh,017h
                db      01fh,01dh,017h,016h,011h,001h,0f3h,0e9h
                db      0e4h,0eah,0efh,0e9h,0eah,0eeh,0f1h,0feh
                db      0fch,0f7h,0e9h,0d6h,0c6h,0c8h,0c8h,0d1h
                db      0d4h,0d9h,0dfh,0efh,0fdh,000h,000h,003h
                db      009h,011h,011h,010h,011h,00eh,011h,016h
                db      01eh,025h,023h,01ch,018h,018h,022h,01eh
                db      01eh,015h,010h,011h,010h,010h,011h,00eh
                db      00eh,00fh,011h,015h,016h,013h,00eh,00fh
                db      010h,011h,014h,00fh,003h,0fch,0f8h,0f6h
                db      0f8h,0f6h,0f6h,0f1h,0f8h,0fdh,000h,0ffh
                db      0fdh,0efh,0dch,0cbh,0cbh,0cdh,0ceh,0d6h
                db      0dah,0dbh,0e5h,0ebh,0f0h,0f8h,0fch,001h
                db      004h,003h,008h,008h,007h,001h,004h,003h
                db      003h,004h,003h,000h,000h,000h,0ffh,000h
                db      003h,007h,00eh,00eh,00fh,012h,012h,010h
                db      00ah,00eh,00eh,010h,012h,014h,016h,020h
                db      01bh,01bh,016h,00fh,000h,0f6h,0f0h,0f0h
                db      0edh,0f6h,0f2h,0f1h,0fch,001h,004h,003h
                db      001h,0fch,0e4h,0d8h,0d6h,0d4h,0d8h,0d8h
                db      0dah,0e5h,0f8h,000h,000h,000h,004h,00eh
                db      019h,011h,00eh,00bh,00bh,00fh,015h,01bh
                db      021h,01bh,011h,00eh,00fh,015h,015h,00fh
                db      009h,007h,00eh,00fh,00eh,00fh,00bh,007h
                db      009h,011h,01dh,019h,013h,013h,015h,013h
                db      013h,013h,00eh,001h,0feh,0fbh,0f5h,0f5h
                db      0f2h,0efh,0f5h,0f9h,0ffh,000h,0f9h,0fdh
                db      0f1h,0e0h,0c9h,0c7h,0c7h,0c7h,0cfh,0d6h
                db      0dah,0e7h,0eeh,0eeh,0f1h,0f9h,000h,003h
                db      007h,00ch,007h,009h,006h,009h,00ch,006h
                db      006h,007h,002h,000h,000h,000h,000h,001h
                db      003h,00ch,00ch,00fh,00fh,00fh,00ch,00fh
                db      00eh,00fh,00fh,00fh,011h,011h,018h,013h
                db      011h,00bh,008h,000h,0fah,0efh,0f4h,0f2h
                db      0f5h,0f4h,0f5h,0fdh,000h,000h,000h,002h
                db      0ffh,0f2h,0e4h,0e4h,0e2h,0e0h,0dbh,0e6h
                db      0f1h,0fdh,000h,001h,001h,008h,00bh,013h
                db      013h,00ch,00ch,00eh,00eh,013h,017h,01ah
                db      01ch,014h,012h,010h,017h,014h,00ch,00bh
                db      007h,00eh,00bh,00bh,00bh,005h,001h,00bh
                db      00ch,00eh,010h,00ch,00eh,00eh,00eh,00ch
                db      009h,005h,0ffh,0fdh,0f7h,0f0h,0f0h,0edh
                db      0f4h,0f9h,0fbh,0fbh,0f9h,0f5h,0f4h,0eeh
                db      0e7h,0dah,0cdh,0ceh,0d2h,0d6h,0dah,0e0h
                db      0e9h,0ech,0f0h,0f7h,0fbh,000h,002h,003h
                db      009h,007h,009h,009h,007h,000h,003h,007h
                db      007h,005h,007h,001h,000h,001h,007h,003h
                db      009h,00dh,010h,00dh,00dh,00eh,013h,012h
                db      013h,012h,010h,010h,012h,018h,018h,00bh
                db      007h,005h,000h,0f9h,0f1h,0f5h,0efh,0efh
                db      0f5h,0fbh,0fdh,0ffh,000h,005h,001h,0ffh
                db      0fbh,0f1h,0ebh,0e8h,0e8h,0e8h,0e8h,0f1h
                db      0fbh,000h,001h,002h,00ah,00ah,011h,016h
                db      010h,010h,012h,011h,011h,012h,01ah,019h
                db      010h,00ch,00ah,00eh,00ah,002h,002h,001h
                db      004h,00ah,001h,000h,000h,000h,004h,008h
                db      00ah,00eh,010h,00eh,012h,011h,00ch,002h
                db      002h,000h,000h,000h,0fah,0f6h,0f6h,0f6h
                db      0fch,0feh,0f6h,0f6h,0f6h,0f4h,0f2h,0e8h
                db      0dbh,0d2h,0d3h,0d7h,0dbh,0dfh,0e2h,0e8h
                db      0efh,0eeh,0f6h,0fah,0feh,000h,001h,001h
                db      008h,008h,002h,000h,001h,000h,003h,00bh
                db      007h,000h,000h,000h,000h,000h,000h,003h
                db      005h,007h,007h,00bh,00dh,015h,015h,018h
                db      015h,011h,018h,017h,015h,015h,00fh,008h
                db      005h,000h,0ffh,0fbh,0f5h,0f1h,0f3h,0f8h
                db      0f9h,0fbh,0fdh,000h,005h,001h,001h,000h
                db      0f9h,0f5h,0f5h,0f1h,0f3h,0f8h,0f5h,0fbh
                db      000h,000h,00dh,00bh,00fh,011h,016h,014h
                db      018h,017h,017h,017h,01bh,01dh,019h,014h
                db      011h,00dh,00fh,00fh,00bh,00bh,005h,007h
                db      003h,000h,0f9h,0fbh,0f9h,0fdh,000h,005h
                db      007h,005h,008h,00bh,001h,001h,000h,000h
                db      000h,0fbh,0fdh,0fdh,0f5h,0f5h,0f8h,0f9h
                db      0fbh,0f3h,0f3h,0f2h,0f5h,0f3h,0e6h,0ddh
                db      0d1h,0d6h,0ddh,0e4h,0e9h,0e9h,0e9h,0f1h
                db      0f3h,0f9h,0fbh,000h,000h,003h,008h,00bh
                db      00bh,00bh,007h,005h,003h,008h,00bh,005h
                db      000h,000h,000h,000h,000h,001h,005h,007h
                db      00bh,007h,00bh,00eh,016h,015h,016h,016h
                db      016h,018h,012h,012h,016h,015h,00bh,000h
                db      000h,000h,0fdh,0f5h,0eeh,0eeh,0f2h,0f5h
                db      0f8h,0fbh,0ffh,000h,000h,001h,000h,0f9h
                db      0f5h,0f2h,0f3h,0f5h,0fdh,0f8h,0f8h,000h
                db      001h,005h,00dh,012h,012h,018h,018h,014h
                db      012h,015h,01ah,021h,01eh,01eh,021h,01bh
                db      018h,014h,00eh,00bh,009h,00dh,005h,000h
                db      0fdh,0f5h,0f5h,0f5h,0fbh,000h,000h,001h
                db      007h,005h,003h,000h,000h,0ffh,0fbh,0feh
                db      0feh,000h,000h,0fch,0fbh,0fbh,0fbh,0f9h
                db      0f4h,0f7h,0f4h,0f7h,0f8h,0f2h,0eah,0e4h
                db      0e6h,0e9h,0f0h,0f2h,0f8h,0f6h,0f8h,0fbh
                db      0fbh,0f9h,000h,000h,002h,007h,00ah,00ah
                db      009h,008h,007h,009h,008h,005h,001h,000h
                db      000h,000h,0feh,000h,000h,000h,001h,001h
                db      001h,002h,005h,008h,008h,00ah,00ch,00ch
                db      00ch,009h,00eh,010h,00ah,005h,001h,000h
                db      000h,0fch,0f8h,0f6h,0f3h,0f3h,0f4h,0f8h
                db      0f8h,0fbh,0feh,001h,002h,000h,0f8h,0f7h
                db      0f2h,0f8h,0fch,0ffh,0feh,0fch,000h,002h
                db      002h,005h,00ch,00ch,00dh,00eh,00ch,00ah
                db      011h,011h,011h,012h,018h,018h,015h,011h
                db      011h,00dh,009h,008h,006h,000h,000h,0fch
                db      0f8h,0f7h,0f8h,0f8h,0fbh,0ffh,000h,001h
                db      001h,000h,000h,0fdh,0fbh,0f8h,0fch,0fch
                db      0ffh,0fdh,0f9h,0f8h,0fbh,0f8h,0f5h,0f0h
                db      0f5h,0f7h,0fbh,0fdh,0f9h,0f1h,0ech,0ech
                db      0f0h,0f6h,0fch,0fch,000h,000h,000h,000h
                db      0ffh,000h,001h,005h,007h,00fh,00fh,009h
                db      00bh,00dh,00bh,008h,004h,004h,001h,000h
                db      000h,000h,000h,001h,000h,000h,0ffh,000h
                db      000h,001h,004h,004h,008h,009h,008h,008h
                db      009h,00dh,00dh,008h,004h,004h,007h,003h
                db      000h,0fdh,0f8h,0f8h,0f9h,0f9h,0f8h,0f9h
                db      000h,000h,004h,004h,000h,0f8h,0f3h,0f5h
                db      0fch,0fdh,0ffh,0ffh,000h,000h,000h,000h
                db      000h,001h,008h,008h,008h,00dh,00dh,00eh
                db      00dh,00eh,011h,015h,015h,012h,011h,008h
                db      008h,008h,004h,000h,000h,0fch,0f8h,0f8h
                db      0f8h,0f9h,0fch,0fch,000h,000h,003h,000h
                db      001h,000h,0fdh,0fdh,0fch,000h,000h,000h
                db      0fch,0fch,0fch,0f8h,0f1h,0f0h,0eeh,0f2h
                db      0f8h,0fdh,0fdh,0fdh,0f5h,0eeh,0eeh,0f2h
                db      0f9h,000h,000h,001h,007h,004h,001h,001h
                db      003h,001h,009h,00fh,010h,010h,00eh,00dh
                db      00dh,00ah,007h,009h,007h,007h,004h,001h
                db      000h,001h,000h,000h,000h,0ffh,000h,000h
                db      000h,003h,004h,003h,004h,003h,000h,004h
                db      004h,003h,003h,003h,000h,000h,000h,0fdh
                db      0fdh,0fch,0f9h,0f7h,0f6h,0f6h,0fch,000h
                db      001h,004h,003h,000h,0f9h,0f5h,0f6h,0fch
                db      0fdh,0fdh,0fdh,000h,000h,000h,000h,000h
                db      000h,001h,003h,009h,00ah,00ah,009h,007h
                db      009h,00dh,010h,011h,010h,00bh,00bh,009h
                db      007h,004h,000h,0ffh,0fdh,0f9h,0f9h,0f9h
                db      0fah,0f9h,0fch,0fdh,000h,000h,000h,000h

dSampleLen      dd      $ - offset abSample


ends            code32



                end

