;****************************************************************************;
; main.asm - pcx loading and saving test.                                    ;
;****************************************************************************;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                public  Main
                include "pmlib.asd"
                include "debug.asi"
                include "error.asi"
                include "color.asi"
                include "win.asi"
                include "pcx.asi"
                include "str.asi"
                include "svga.asi"



@STR            cFileName       "..\..\resource\ground.pcx"
@STR            cOutFileName    "out.pcx"
dPic            dd      0



proc            Main

                ;;initialize video mode
                mov     eax, 600
                mov     ebx, 800
                mov     ecx, COLOR32
                call    SvgaInit

                ;;create 'Pic' object from PCX file
                lea     esi, [cFileName]
                call    PcxToPic
                mov     [dPic], edi
                mov     esi, edi
                call    PicToCurrentColorScheme

                ;;create PCX file from 'Pic' object
                ;lea     esi, [cOutFileName]
                ;call    PcxFromPic

                ;;create and clear win object
                call    SvgaGetInfo
                call    WinNew

                ;;fill win with pic
                mov     esi, edi
                mov     edi, [dPic]
                call    WinPicFill

                ;;copy 'Pic' to 'Win'
                ;mov     esi, [dPic]
                ;mov     eax, [(win edi).dTotalRow]
                ;sub     eax, [(pic esi).dTotalRow]
                ;shr     eax, 1
                ;mov     ebx, [(win edi).dTotalCol]
                ;sub     ebx, [(pic esi).dTotalCol]
                ;shr     ebx, 1
                ;call    PicToPic

                ;;show win
                xor     eax, eax
                xor     ebx, ebx
                call    SvgaWinToScr

                ;;wait for a keypress
                xor     eax, eax
                int     16h

                ;;restore video mode
                call    SvgaRestore

@@exit:         ret
endp

ends            code32
                end
