;****************************************************************************;
; main.asm - parser test.                                                    ;
;                                                                            ;
;       The results are in file "out.log".                                   ;
;****************************************************************************;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                public  Main
                include "pmlib.asd"
                include "debug.asi"
                include "error.asi"
                include "parser.asi"
                include "str.asi"
                include "stream.asi"



@STR            cFileName "m.bat"
@STR            cOutFile  "out.log"
dInpStream      dd      0
dOutStream      dd      0
dParser         dd      0



proc            Main

                mov     ax, 'r'
                lea     esi, [cFileName]
                call    FStreamNew
                mov     [dInpStream], edi

                mov     ax, 'w'
                lea     esi, [cOutFile]
                call    FStreamNew
                mov     [dOutStream], edi

                mov     esi, [dInpStream]
                call    ParserNew
                mov     [dParser], edi

                ;;copy to output stream
@@loop1:        mov     esi, [dParser]
                call    ParserGetToken
                cmp     eax, TOKEN_EOS
                @IF_NE
                  mov   esi, [dOutStream]
                  cmp   eax, TOKEN_EOL
                  @IF_NE
@@loop2:            mov   al, [ebx]
                    call  StreamPutByte
                    inc   ebx
                    loop  @@loop2
                  @ELSE
                    mov   al, 'E'
                    call  StreamPutByte
                    mov   al, 'O'
                    call  StreamPutByte
                    mov   al, 'L'
                    call  StreamPutByte
                  @ENDIF
                  mov   al, 0Dh
                  call  StreamPutByte
                  mov   al, 0Ah
                  call  StreamPutByte
                  jmp   @@loop1
                @ENDIF

                mov     esi, [dOutStream]
                call    FStreamDelete

                mov     esi, [dInpStream]
                call    FStreamDelete

                ret
endp

ends            code32
                end
