;****************************************************************************;
; main.asm - matrix test.                                                    ;
;****************************************************************************;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                public  Main
                include "pmlib.asd"
                include "color.asi"
                include "debug.asi"
                include "gfx.asi"
                include "math.asi"
                include "svga.asi"
                include "vga.asi"
                include "win.asi"



;;poligon description
sPoint1Init     vector  <00, 90, 00>
sPoint2Init     vector  <00, 30, 60>
sPoint3Init     vector  <00,-90, 30>
sPoint4Init     vector  <00,-90,-30>
sPoint5Init     vector  <00, 30,-60>

;;rotation matrix
sMatrix1        mtx     <>

;;poligon after rotation
sPoint1         vector  <>
sPoint2         vector  <>
sPoint3         vector  <>
sPoint4         vector  <>
sPoint5         vector  <>

;;rotated poligon, ready to draw
sPoligon        poligon <55h, 5>
sV5             point   <>
sV4             point   <>
sV3             point   <>
sV2             point   <>
sV1             point   <>

;;win object
dWinHnd         dd      0



proc            Main

                mov     eax, 480
                mov     ebx, 640
                mov     ecx, COLOR8
                call    SvgaInit

                ;;create win object
                call    SvgaGetInfo
                call    WinNew
                mov     [dWinHnd], edi

                ;;fill win object
                xor     eax, eax
                mov     esi, [dWinHnd]
                call    WinFill

                mov     ecx, 360*MATH_DEGREE
@@loop1:        mov     eax, ecx
                lea     esi, [sMatrix1]
                call    MathMtxCreateRotZ
                mov     ebx, esi

                lea     esi, [sPoint1Init]
                lea     edi, [sPoint1]
                call    MathMtxByVector
                lea     esi, [sPoint2Init]
                lea     edi, [sPoint2]
                call    MathMtxByVector
                lea     esi, [sPoint3Init]
                lea     edi, [sPoint3]
                call    MathMtxByVector
                lea     esi, [sPoint4Init]
                lea     edi, [sPoint4]
                call    MathMtxByVector
                lea     esi, [sPoint5Init]
                lea     edi, [sPoint5]
                call    MathMtxByVector

                mov     eax, [sPoint1.dX]
                add     eax, 320
                mov     [sV1.dX], eax
                mov     eax, [sPoint1.dY]
                add     eax, 200
                mov     [sV1.dY], eax
                ;
                mov     eax, [sPoint2.dX]
                add     eax, 320
                mov     [sV2.dX], eax
                mov     eax, [sPoint2.dY]
                add     eax, 200
                mov     [sV2.dY], eax
                ;
                mov     eax, [sPoint3.dX]
                add     eax, 320
                mov     [sV3.dX], eax
                mov     eax, [sPoint3.dY]
                add     eax, 200
                mov     [sV3.dY], eax
                ;
                mov     eax, [sPoint4.dX]
                add     eax, 320
                mov     [sV4.dX], eax
                mov     eax, [sPoint4.dY]
                add     eax, 200
                mov     [sV4.dY], eax
                ;
                mov     eax, [sPoint5.dX]
                add     eax, 320
                mov     [sV5.dX], eax
                mov     eax, [sPoint5.dY]
                add     eax, 200
                mov     [sV5.dY], eax

                xor     eax, eax
                mov     esi, [dWinHnd]
                call    WinFill
                lea     esi, [sPoligon]
                mov     edi, [dWinHnd]
                call    GfxConvexPoligon
                call    VgaWaitForVSync
                xor     eax, eax
                xor     ebx, ebx
                mov     esi, [dWinHnd]
                call    SvgaWinToScr

                dec     ecx
                jns     @@loop1

                xor     eax, eax
                xor     ebx, ebx
                mov     esi, edi
                call    SvgaWinToScr
                call    SvgaRestore

                ret
endp

ends            code32
                end
