;****************************************************************************;
; main.asm - list object test.                                               ;
;                                                                            ;
;       The results are in file "debug.log".                                 ;
;****************************************************************************;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                public  Main
                include "pmlib.asd"
                include "debug.asi"
                include "list.asi"
                include "heap.asi"



cMsg1           db      "Elements list:", 0
cMsg2           db      0Dh, 0Ah, "Elements list after deletion:", 0



proc            Main

                ;;heap dump before start
                call    HeapDump

                ;;create list and insert 6 elements into it
                call    ListNew
                mov     esi, edi
                mov     edi, 60
                call    ListInsertFirst
                mov     edi, 50
                call    ListInsertFirst
                mov     edi, 40
                call    ListInsertFirst
                mov     edi, 30
                call    ListInsertFirst
                mov     edi, 20
                call    ListInsertFirst
                mov     edi, 10
                call    ListInsertFirst

                ;;heap dump
                call    HeapDump

                ;;dump list elements
                push    esi
                lea     esi, [cMsg1]
                call    DebugPrintStr
                pop     esi
                call    ListFirst
@@loop1:        @IF_NC
                  call  DebugPrintEaxDec
                  call  ListNext
                  jmp   @@loop1
                @ENDIF

                ;;delete one element
                mov     edi, 40
                call    ListRemove

                ;;dump list elements after deletion
                push    esi
                lea     esi, [cMsg2]
                call    DebugPrintStr
                pop     esi
                call    ListFirst
@@loop2:        @IF_NC
                  call  DebugPrintEaxDec
                  call  ListNext
                  jmp   @@loop2
                @ENDIF

                ;;destroy list and dump heap structure
                call    ListDelete
                call    HeapDump

                ret
endp

ends            code32
                end
