;****************************************************************************;
; main.asm - host operating system detection.                                ;
;                                                                            ;
;       The results are in file "debug.log".                                 ;
;****************************************************************************;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                public  Main
                include "pmlib.asd"
                include "debug.asi"
                include "host.asi"



abStrDos        db      "Running under DOS.", 0
abStrWin        db      "Running under WINDOWS.", 0



proc            Main

                call    HostType
                movzx   ax, al
                movzx   eax, ax
                push    eax

                and     eax, eax
                @IF_Z
                  lea   esi, [abStrDos]
                @ELSE
                  lea   esi, [abStrWin]
                @ENDIF
                call    DebugPrintStr

                pop     eax
                call    DebugPrintEaxHex

                ret
endp

ends            code32
                end
