;****************************************************************************;
; main.asm - hi-color video mode test.                                       ;
;****************************************************************************;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                public  Main
                include "pmlib.asd"
                include "color.asi"
                include "gfx.asi"
                include "heap.asi"
                include "svga.asi"
                include "vga.asi"
                include "win.asi"

                include "debug.asi"
                include "error.asi"


proc            Main

                ;;set 800*600*64K video mode
                mov     eax, 600
                mov     ebx, 800
                mov     ecx, COLOR16
                call    SvgaInit

                ;;create win object
                mov     eax, 200
                mov     ebx, 256
                mov     ecx, COLOR16
                call    WinNew
                mov     esi, edi

                ;;fill win object
                mov     eax, 0                  ;row counter
@@loop1:        mov     ebx, 0                  ;column counter
                mov     ecx, 0                  ;24-bit color
@@loop2:        pushad
                Color24To16     ecx, edx, esi
                call    GfxSetPoint
                popad
                add     ecx, 010101h
                test    ecx, 0FF000000h
                @IF_NZ
                  xor   ecx, ecx
                @ENDIF
                inc     ebx
                cmp     ebx, 300
                jb      @@loop2
                inc     eax
                cmp     eax, 200
                jb      @@loop1

                ;;show window
                mov     eax, 140
                mov     ebx, 200
                call    SvgaWinToScr

                ;;wait for a keypress
                xor     eax, eax
                int     16h

@@exit:         call    SvgaRestore
                ret
endp

ends            code32
                end
