;****************************************************************************;
; main.asm - heap functions test.                                            ;
;                                                                            ;
;       The results you may see in "debug.log" file. To understand heap dump ;
; read comments to array test.                                               ;
;****************************************************************************;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                public  Main
                include "pmlib.asd"
                include "heap.asi"
                include "lm.asi"



hMemBlock1	dd	0
hMemBlock2	dd	0
dHeapPtr	dd	0



proc            Main

		call	HeapDump

                ;Allocate block 1
		mov	eax, 1000
		call	HeapAlloc
		mov	[hMemBlock1], edi
		call	HeapDump

                ;Allocate block 2
		mov	eax, 1000
		call	HeapAlloc
		mov	[hMemBlock2], edi
		call	HeapDump

                ;Free block 1. There is a hole appear in the free memory pool.
		mov	eax, [hMemBlock1]
		call	HeapFree
		call	HeapDump

                ;Free block 2. The hole is disappear.
		mov	eax, [hMemBlock2]
		call	HeapFree
		call	HeapDump

                ret
endp

ends            code32
                end
