;****************************************************************************;
; main.asm - poligon functions test.                                         ;
;                                                                            ;
;       Test for poligon functions.                                          ;
;****************************************************************************;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                public  Main
                include "pmlib.asd"
                include "color.asi"
                include "debug.asi"
                include "gfx.asi"
                include "math.asi"
                include "svga.asi"
                include "vga.asi"
                include "win.asi"



sPoligon        poligon < 55, 5>
sV5             point   <150, 120>
sV4             point   <250, 220>
sV3             point   <250, 420>
sV2             point   <150, 520>
sV1             point   <050, 320>

sPoligon1       poligon <55h, 3>
                point   <050, 520>
                point   <051, 525>
                point   <052, 520>
                point   <051, 520>

sPoligon2       poligon <  3, 4>
                point   <055, 519>
                point   <064, 511>
                point   <073, 519>
                point   <064, 527>



proc            Main

                ;;initialise video mode
                mov     eax, 480
                mov     ebx, 640
                mov     ecx, COLOR8
                call    SvgaInit

                ;;create and clear win
                mov     eax, 400
                mov     ebx, 640
                mov     ecx, COLOR8
                call    WinNew
                mov     esi, edi
                xor     eax, eax
                call    WinFill

                ;;show main poligon
                lea     esi, [sPoligon]
                call    GfxConvexPoligon
                xor     eax, eax
                xor     ebx, ebx
                mov     esi, edi
                call    SvgaWinToScr
                xor     eax, eax
                int     16h

                ;;show poligon 1 (test for very small poligons)
                lea     esi, [sPoligon1]
                call    GfxConvexPoligon
                xor     eax, eax
                xor     ebx, ebx
                mov     esi, edi
                call    SvgaWinToScr
                xor     eax, eax
                int     16h

                ;;show poligon 2 (test for middle size poligons)
                lea     esi, [sPoligon2]
                call    GfxConvexPoligon
                xor     eax, eax
                xor     ebx, ebx
                mov     esi, edi
                call    SvgaWinToScr

                ;;loop
                mov     edx, 2
@@loop3:        mov     ecx, 61
@@loop1:        xor     eax, eax
                mov     esi, edi
                call    WinFill
                lea     esi, [sPoligon]
                call    GfxConvexPoligon
                lea     esi, [sPoligon1]
                call    GfxConvexPoligon
                lea     esi, [sPoligon2]
                call    GfxConvexPoligon
                call    VgaWaitForVSync
                xor     eax, eax
                xor     ebx, ebx
                mov     esi, edi
                call    SvgaWinToScr
                ;xor     eax, eax
                ;int     16h
                lea     ebx, [sV1]
                inc     [(point ebx).dY]
                inc     [(point ebx).dX]
                lea     ebx, [sV2]
                inc     [(point ebx).dY]
                dec     [(point ebx).dX]
                lea     ebx, [sV3]
                dec     [(point ebx).dX]
                dec     [(point ebx).dX]
                lea     ebx, [sV4]
                dec     [(point ebx).dX]
                dec     [(point ebx).dY]
                lea     ebx, [sV5]
                dec     [(point ebx).dY]
                inc     [(point ebx).dX]
                lea     ebx, [sPoligon]
                ;add     [(poligon ebx).dColor], 1
                loop    @@loop1
                mov     ecx, 61
@@loop2:        xor     eax, eax
                mov     esi, edi
                call    WinFill
                lea     esi, [sPoligon]
                call    GfxConvexPoligon
                lea     esi, [sPoligon1]
                call    GfxConvexPoligon
                lea     esi, [sPoligon2]
                call    GfxConvexPoligon
                call    VgaWaitForVSync
                xor     eax, eax
                xor     ebx, ebx
                mov     esi, edi
                call    SvgaWinToScr
                lea     ebx, [sV1]
                dec     [(point ebx).dY]
                dec     [(point ebx).dX]
                lea     ebx, [sV2]
                dec     [(point ebx).dY]
                inc     [(point ebx).dX]
                lea     ebx, [sV3]
                inc     [(point ebx).dX]
                inc     [(point ebx).dX]
                lea     ebx, [sV4]
                inc     [(point ebx).dX]
                inc     [(point ebx).dY]
                lea     ebx, [sV5]
                inc     [(point ebx).dY]
                dec     [(point ebx).dX]
                loop    @@loop2
                dec     edx
                jnz     @@loop3

                xor     eax, eax
                mov     esi, edi
                call    WinFill
                lea     esi, [sPoligon]
                call    GfxConvexPoligon
                lea     esi, [sPoligon1]
                call    GfxConvexPoligon
                lea     esi, [sPoligon2]
                call    GfxConvexPoligon
                call    VgaWaitForVSync
                xor     eax, eax
                xor     ebx, ebx
                mov     esi, edi
                call    SvgaWinToScr

@@exit:         xor     eax, eax
                int     16h

                call    SvgaRestore


                ret
endp

ends            code32
                end
