;****************************************************************************;
; main.asm - graphics functions test.                                        ;
;                                                                            ;
;       Test for different graphics functions.                               ;
;****************************************************************************;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                public  Main
                include "pmlib.asd"
                include "color.asi"
                include "gfx.asi"
                include "heap.asi"
                include "svga.asi"
                include "vga.asi"
                include "win.asi"



proc            Main

                ;;initialise video mode
                mov     eax, 480
                mov     ebx, 640
                mov     ecx, COLOR8
                call    SvgaInit

                ;;create and clear win object
                mov     eax, 200
                mov     ebx, 300
                mov     ecx, COLOR8
                call    WinNew
                mov     esi, edi
                xor     eax, eax
                mov     eax, 22222222h
                call    WinFill

                mov     ecx, 5
@@loop3:        push    ecx

                mov     ebx, 0
                mov     edx, 100
                mov     ebp, 55h
                mov     ecx, 100
@@loop1:
                xor     eax, eax
                call    WinFill
                mov     eax, 100
                sub     eax, ecx
                call    GfxLine
                call    VgaWaitForVSync

                ;;move win content to video memory
                push    ebx
                mov     eax, 58
                mov     ebx, 58
                call    SvgaWinToScr
                pop     ebx

                sub     ecx, 1
                jns     @@loop1
                inc     ecx
@@loop2:
                xor     eax, eax
                call    WinFill
                mov     eax, 100
                mov     ebx, 100
                sub     ebx, edx
                call    GfxLine
                call    VgaWaitForVSync

                ;;move win content to video memory
                push    ebx
                mov     eax, 58
                mov     ebx, 58
                call    SvgaWinToScr
                pop     ebx

                sub     edx, 1
                jns     @@loop2

                pop     ecx
                loop    @@loop3

                ;;wait for a keypress
                xor     eax, eax
                int     16h

@@exit:         call    SvgaRestore
                ret
endp

ends            code32
                end
