;****************************************************************************;
; main.asm - file functions test.                                            ;
;                                                                            ;
;       Test for different file functions.                                   ;
;****************************************************************************;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                public  Main
                include "pmlib.asd"
                include "debug.asi"
                include "file.asi"
                include "str.asi"



@STR            cFileName       "main.asm"
@STR            cOutFile        "out.log"
dFileHandle     dd      0
dOutFileHandle  dd      0



proc            Main

                ;;open input file
                mov     ax, 'r'
                lea     esi, [cFileName]
                call    FileOpen
                mov     [dFileHandle], esi

                ;;print file size into debug file
                call    FileSize
                call    DebugPrintEaxDec

                ;;open output file
                mov     ax, 'w'
                lea     esi, [cOutFile]
                call    FileOpen
                mov     [dOutFileHandle], esi

                ;;copy to output file
@@loop1:        mov     esi, [dFileHandle]
                call    FileReadByte
                @IF_NC
                  mov   esi, [dOutFileHandle]
                  call  FileWriteByte
                  jmp   @@loop1
                @ENDIF

                ;;close files
                mov     esi, [dFileHandle]
                call    FileClose
                mov     esi, [dOutFileHandle]
                call    FileClose

                ret
endp

ends            code32
                end
