;*****
; main.asm - dialog window test.
;





segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                public  Main
                include "pmlib.asd"
                include "font.asi"
                include "fontmx.asi"
                include "color.asi"
                include "debug.asi"
                include "dialog.asi"
                include "error.asi"
                include "key.asi"
                include "pcx.asi"
                include "str.asi"
                include "svga.asi"
                include "timer.asi"
                include "threads.asi"
                include "win.asi"
                include "windows.asi"



@STR            cFmxFileName    "..\..\resource\10x9x1.fmx"
@STR            cGndFileName    "..\..\resource\ground.pcx"
@STR            cCurFileName    "..\..\resource\cursor.pcx"
RUS_MESSAGE     cHelloStr  "ࠢ, !  ४ᥭ!"
ENG_MESSAGE     cHelloStr  "Hello, World! You're beautiful!"



dColorScheme    dd      COLOR32
aPalette        dd      0FFFFFFh, 0h
dFont           dd      0
dWin            dd      0
dWindow         dd      0
wLastTimeStamp  dw      0



proc            Main

                call    ThreadsInit

                ;;create font
                call    InitFont

                ;;initialize video mode
                mov     eax, 384
                mov     ebx, 512
                mov     eax, 600
                mov     ebx, 800
                mov     eax, 480
                mov     ebx, 640
                mov     ecx, [dColorScheme]
                call    SvgaInit

                ;;init windows system
                lea     esi, [cGndFileName]
                call    PcxToPic
                push    edi
                mov     esi, edi
                call    PicToCurrentColorScheme
                ;;
                lea     esi, [cCurFileName]
                call    PcxToPic
                mov     esi, edi
                call    PicToCurrentColorScheme
                ;;
                pop     esi
                call    WindowsInit

                ;;initialize dialog window
                call    InitDialog

@@loop:         ;;main loop
                call    TimerGetTimeStamp
                sub     ax, [wLastTimeStamp]
                neg     ax
                movzx   eax, ax
                mov     ebx, 84
                mul     ebx
                mov     ebx, 200
                div     ebx
                cmp     eax, 10000
                jb      @@loop
                call    TimerGetTimeStamp
                mov     [wLastTimeStamp], ax
                ;;
                call    CursorUpdate
                call    ThreadsUpdate
                call    KeyNoWait
                cmp     eax, K_ESC
                jne     @@loop

                ;;restore video mode
                call    SvgaRestore

                call    ThreadsRestore

                ret
endp



proc            InitFont
                ;in
                ;  nothing
                ;out
                ;  nothing
                pushad

                ;;create font object
                lea     eax, [cFmxFileName]
                call    FontmxNew
                mov     eax, 2
                mov     ebx, 0
                mov     ecx, [dColorScheme]
                mov     esi, edi
                lea     edi, [aPalette]
                call    FontNew
                mov     [dFont], edi

                popad
                ret
endp



abStrz1         db      'Str 1', 0
abStrz2         db      'Str 2', 0
abStrzOk        db      'Ok', 0
dStr1           dd      0
dStr2           dd      0
dDialog         dd      0
dDlgStr1        dd      0
dDlgStr2        dd      0
dDlgButtonOk    dd      0

proc            InitDialog
                ;in
                ;  nothing
                ;out
                ;  nothing
                pushad

                ;;create string 1
                lea     esi, [abStrz1]
                call    StrNewFromStrz
                mov     [dStr1], edi
                ;;create string 2
                lea     esi, [abStrz2]
                call    StrNewFromStrz
                mov     [dStr2], edi

                ;;create dialog object
                mov     eax, 124
                mov     ebx, 200
                call    DialogNew
                mov     [dDialog], edi
                mov     esi, edi
                ;;create input string 1
                mov     eax, 80
                mov     ebx, [dFont]
                mov     ecx, [dFont]
                mov     edx, [dStr1]
                call    DlgItemInpStrNew
                mov     [dDlgStr1], edi
                mov     [(dlgitem edi).dRow], 10
                mov     [(dlgitem edi).dCol], 10
                ;;create input string 2
                mov     eax, 80
                mov     ebx, [dFont]
                mov     ecx, [dFont]
                mov     edx, [dStr2]
                call    DlgItemInpStrNew
                mov     [dDlgStr2], edi
                mov     [(dlgitem edi).dRow], 40
                mov     [(dlgitem edi).dCol], 10
                ;;create button
                mov     eax, 20
                mov     ebx, 60
                lea     ecx, [abStrzOk]
                mov     edx, [dFont]
                lea     edi, [DummyFunc]
                call    DlgItemButtonNew
                mov     [dDlgButtonOk], edi
                mov     [(dlgitem edi).dRow], 80
                mov     [(dlgitem edi).dCol], ((200-60)/2)

                ;;launch dialog window
                mov     esi, [dDialog]
                call    DialogEval

                popad
                ret
endp



proc            DummyFunc
                ;in
                ;  nothing
                ;out
                ;  nothing
                ret
endp

ends            code32
                end
