;****************************************************************************;
; main.asm - CDF test.                                                       ;
;                                                                            ;
;       This test creates CDF, writes two blocks into it and then performs   ;
; reading.                                                                   ;
;****************************************************************************;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                public  Main
                include "pmlib.asd"
                include "cdf.asi"
                include "str.asi"



@STR            cFileName       "test.cdf"
cStr1           db      "test"
cBuffer         db      20 dup ('****')



proc            Main

                ;;open CDF, if it doesn't exists - create
                mov     ax, 'w'
                lea     esi, [cFileName]
                call    CdfOpen
                mov     esi, edi

                ;;write first block with code 2
                mov     eax, 2
                call    CdfBeginWriteBlock
                  mov   eax, 4
                  lea   edi, [cStr1]
                  call  CdfWriteStr
                call    CdfEndWriteBlock

                ;;write second block with code 2
                mov     eax, 2
                call    CdfBeginWriteBlock
                  mov   eax, 4
                  lea   edi, [cStr1]
                  call  CdfWriteStr
                call    CdfEndWriteBlock

                ;;close CDF
                call    CdfClose

                ;;open CDF
                mov     ax, 'r'
                lea     esi, [cFileName]
                call    CdfOpen
                mov     esi, edi

                ;;read first block
                call    CdfBeginReadBlock
                ;;
                mov     edx, eax        ;block code
                add     dl, '0'
                mov     ah, 2
                int     21h             ;print block code
                call    CrLf
                ;;
                mov     edx, ebx        ;block size
                add     dl, '0'
                mov     ah, 2
                int     21h             ;print block size
                call    CrLf
                ;;
                mov     eax, 4
                lea     edi, [cBuffer]
                call    CdfReadStr      ;read string into buffer
                ;;
                call    CdfEndReadBlock

                ;;close CDF
                call    CdfClose

                ;;print first 8 characters from buffer
                lea     edi, [cBuffer]
                mov     ecx, 8
@@loop1:        mov     dl, [edi]
                inc     edi
                mov     ah, 2
                int     21h
                loop    @@loop1
                call    CrLf

                ret
endp



proc            CrLf
                mov     ah, 2
                mov     dl, 0Dh
                int     21h
                mov     ah, 2
                mov     dl, 0Ah
                int     21h
                ret
endp

ends            code32
                end
