;****************************************************************************;
; main.asm - array test.                                                     ;
;                                                                            ;
;       This test creates and destroys an array object and shows heap changes;
; after each step. Results are in the file "debug.log". Each dump begins with;
; string "Heap dump:" and ends with string "End of dump.". Beetween them     ;
; resides info about free heap blocks. Each block represented by four values:;
; 1-signature, 2-start address, 3-length and 4-address of next heap block.   ;
;****************************************************************************;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                public  Main
                include "pmlib.asd"
                include "array.asi"
                include "debug.asi"
                include "heap.asi"



proc            Main

                ;;dump free heap blocks
                call    HeapDump

                ;;create array with 10 elements with indexes from 1 to 10
                mov     eax, 1
                mov     ebx, 10
                call    ArrayNew

                ;;dump free heap blocks
                call    HeapDump

                ;;destroy array
                call    ArrayDelete

                ;;dump free heap blocks
                call    HeapDump

                ret
endp

ends            code32
                end
