;*****
; template.asm - template for new library modules.
;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                __TEMPLATE__ equ 1
                include "pmlib.asd"
                include "template.asi"
                include "debug.asi"
                include "error.asi"
                include "heap.asi"



DBG_RUS_MESSAGE cErrNotTemplate "ꥪ  'Template'."
DBG_ENG_MESSAGE cErrNotTemplate "Object is not 'Template'."



proc            TemplateNew
                ;in
                ;  nothing
                ;out
                ;  edi - created object
                mov     eax, size template
                call    HeapAlloc
                ret
endp



IF DBG
proc            TemplateCheck
                ;in
                ;  esi - object
                ;out
                ;  nothing
                cmp     [(template esi).dSign], TEMPLATE_SIGN
                @IF_NE
                  lea   esi, [cErrNotTemplate]
                  call  ErrorFatal
                @ENDIF
		ret
endp
ENDIF



proc            TemplateDelete
                ;in
                ;  esi - object
                ;out
                ;  nothing
                IF DBG
                  call  TemplateCheck
                ENDIF
                mov     eax, esi
                call    HeapFree
		ret
endp

ends            code32
                end
