;*****
; strz.asm  -  zero terminated string ('Strz').
;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                __STRZ__ equ 1
                include "pmlib.asd"
                include "strz.asi"



abSymbols       db      "0123456789ABCDEF"



proc            StrzLength
                ;in
                ;  esi - 'Strz' ptr
                ;out
                ;  eax - length
                xor     eax, eax
@@loop:         cmp     [bptr esi+eax], 0
                @IF_NZ
                  inc   eax
                  jmp   @@loop
                @ENDIF
                ret
endp



proc            StrzCopy
                ;in
                ;  esi - ptr to source 'Strz'
                ;  edi - ptr to destination buffer with appropriate size
                ;out
                ;  esi - ptr to end of source 'Strz'
                ;  edi - ptr to end of string in the destination buffer
                push    eax
                cld
@@loop1:        lodsb
                stosb
                and     al, al
                jnz     @@loop1
                pop     eax
                ret
endp



proc            StrzUpper
                ;in
                ;  esi - 'Strz'
                ;out
                ;  nothing
                ;description
                ;  Converts string to upper case with russian letters handling.
                push    esi
@@loop1:        mov     al, [esi]
                cmp     al, 'a'
                jb      @@cont
                cmp     al, 'z'
                ja      @@is_rus_1
                sub     al, 20h
                jmp     @@cont
@@is_rus_1:     cmp     al, ''
                jb      @@cont
                cmp     al, ''
                ja      @@is_rus_2
                sub     al, 20h
                jmp     @@cont
@@is_rus_2:     cmp     al, ''
                jb      @@cont
                cmp     al, ''
                ja      @@is_rus_3
                sub     al, 80
                jmp     @@cont
@@is_rus_3:     cmp     al, ''
                jne     @@is_rus_4
                dec     al
                jmp     @@cont
@@is_rus_4:     cmp     al, ''
                jne     @@cont
                dec     al
@@cont:         mov     [esi], al
                inc     esi
                and     al, al
                jnz     @@loop1
                pop     esi
                ret
endp



proc            StrzHexFromLong
                ;in
                ;  eax - long integer
                ;  edi - ptr to destination buffer (min 10 bytes)
                ;out
                ;  edi - ptr to end of string in the destination buffer
                push    eax ebx ecx
                cld
                mov     ecx, 8
@@loop1:        xor     ebx, ebx
                shld    ebx, eax, 4
                shl     eax, 4
                mov     bl, [ebx+abSymbols]
                mov     [edi], bl
                inc     edi
                loop    @@loop1
                mov     [bptr edi], 'h'
                inc     edi
                mov     [edi], cl
                inc     edi
                pop     ecx ebx eax
                ret
endp



proc            StrzDecFromLong
                ;in
                ;  eax - long signed integer
                ;  edi - ptr to destination buffer (min 11 bytes)
                ;out
                ;  edi - ptr to end of string in the destination buffer
                push    eax ebx ecx edx

                cld
                xor     edx, edx
                push    edx

                ;;check for negative value
                and     eax, eax
                @IF_S
                  neg   eax
                  mov   ecx, '-'
                @ELSE
                  mov   ecx, 0
                @ENDIF

                ;;put digits to stack
                mov     ebx, 10
@@loop1:        div     ebx
                add     dl, '0'
                push    edx
                xor     edx, edx
                and     eax, eax
                jnz     @@loop1

                ;;put sign to stack
                cmp     ecx, '-'
                @IF_E
                  push  ecx
                @ENDIF

                ;;copy from stack to 'Strz'
@@loop2:        pop     eax
                stosb
                and     al, al
                jnz     @@loop2

                pop     edx ecx ebx eax
                ret
endp



proc            StrzDecToLong
                ;in
                ;  esi - 'Str' with decimal number
                ;out
                ;  eax - number
                push    ebx ecx edx esi

                ;;skip leading spaces
@@loop1:        cmp     [bptr esi], ' '
                @IF_E
                  inc   esi
                  jmp   @@loop1
                @ENDIF

                ;;main loop
                xor     eax, eax
                xor     ebx, ebx
                mov     ecx, 10
@@loop2:        mov     bl, [esi]
                and     bl, bl
                @IF_NZ
                  inc   esi
                  sub   bl, '0'
                  mul   ecx
                  add   eax, ebx
                  jmp   @@loop2
                @ENDIF

                pop     esi edx ecx ebx
                ret
endp

ends            code32
                end
