;*****
; stream.asm - 'Stream' object.
;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                __STREAM__ equ 1
                include "pmlib.asd"
                include "stream.asi"
                include "debug.asi"
                include "error.asi"
                include "file.asi"
                include "heap.asi"



STREAM_SIGN   equ     'Strm'



struc           stream          ;stream
  dSign         dd  STREAM_SIGN ;signature for run-time checks
  dPreviewFlag  dd      0       ;
  dByte         dd      0       ;
  fnGetByte     dd      0       ;
  fnPutByte     dd      0       ;
ends



DBG_RUS_MESSAGE cErrNotStream "ꥪ  'Stream'."
DBG_ENG_MESSAGE cErrNotStream "Object is not 'Stream'."



IF DBG
proc            StreamCheck
                ;in
                ;  esi - 'Stream'
                ;out
                ;  nothing
                cmp     [(stream esi).dSign], STREAM_SIGN
                @IF_NE
                  lea   esi, [cErrNotStream]
                  call  ErrorFatal
                @ENDIF
		ret
endp
ENDIF



proc            StreamPreviewByte
                ;in
                ;  esi - 'Stream'
                ;out
                ;  CN: al - byte from stream
                ;  CY: error, no data left
                IF DBG
                  call  StreamCheck
                ENDIF

                cmp     [(stream esi).dPreviewFlag], 1
                @IF_NE
                  call  [(stream esi).fnGetByte]
                  jc    @@exit
                  mov   [(stream esi).dByte], eax
                  mov   [(stream esi).dPreviewFlag], 1
                @ELSE
                  mov   eax, [(stream esi).dByte]
                @ENDIF

@@exit:         ret
endp



proc            StreamGetByte
                ;in
                ;  esi - 'Stream'
                ;out
                ;  CN: al - byte from stream
                ;  CY: error, no data left
                IF DBG
                  call  StreamCheck
                ENDIF

                cmp     [(stream esi).dPreviewFlag], 1
                @IF_NE
                  call  [(stream esi).fnGetByte]
                @ELSE
                  mov   eax, [(stream esi).dByte]
                  mov   [(stream esi).dPreviewFlag], 0
                @ENDIF

@@exit:         ret
endp



proc            StreamPutByte
                ;in
                ;   al - byte
                ;  esi - 'Stream'
                ;out
                ;  nothing
                IF DBG
                  call  StreamCheck
                ENDIF
                call    [(stream esi).fnPutByte]
                ret
endp





;;
;                              File Stream                                 ;
;;

struc           fstream stream
  dFileHandle   dd      0       ;file handle
ends



proc            FStreamNew
                ;in
                ;  ax='r'  - open for read
                ;  ax='w'  - open for write
                ;  ax='rw' - open for read and write
                ;  esi     - ptr to file name
                ;out
                ;  edi - 'Stream'
                push    esi
                call    FileOpen

                mov     eax, size fstream
                call    HeapAlloc

                mov     [(fstream edi).dSign], STREAM_SIGN
                lea     eax, [FStreamGetByte]
                mov     [(fstream edi).fnGetByte], eax
                lea     eax, [FStreamPutByte]
                mov     [(fstream edi).fnPutByte], eax
                mov     [(fstream edi).dFileHandle], esi

                pop     esi
                ret
endp



proc            FStreamDelete
                ;in
                ;  esi - 'Stream'
                ;out
                ;  nothing
                IF DBG
                  call  StreamCheck
                ENDIF

                push    esi
                mov     esi, [(fstream esi).dFileHandle]
                call    FileClose

                pop     eax
                call    HeapFree

		ret
endp



proc            FStreamGetByte
                ;in
                ;  esi - 'Stream'
                ;out
                ;  al - byte
                push    esi
                IF DBG
                  call  StreamCheck
                ENDIF

                mov     esi, [(fstream esi).dFileHandle]
                call    FileReadByte

                pop     esi
		ret
endp



proc            FStreamPutByte
                ;in
                ;  al  - byte
                ;  esi - 'Stream'
                ;out
                ;  nothing
                push    esi
                IF DBG
                  call  StreamCheck
                ENDIF

                mov     esi, [(fstream esi).dFileHandle]
                call    FileWriteByte

                pop     esi
		ret
endp

ends            code32
                end
