;*****
; str.asm  -  string object ('Str').
;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                __STR__ equ 1
                include "pmlib.asd"
                include "str.asi"
                include "debug.asi"
                include "error.asi"
                include "heap.asi"
                include "strz.asi"



abStrzBuffer    db      16 dup (?)

DBG_RUS_MESSAGE cErrNotStr "ꥪ  'Str'."
DBG_ENG_MESSAGE cErrNotStr "Object is not 'Str'."



proc            StrNewFromSize
                ;in
                ;  eax - size
                ;out
                ;  edi - 'Str'.
                push    eax
                call    HeapAlloc
                push    edi
                mov     eax, size str
                call    HeapAlloc
                mov     [(str edi).dSign], STR_SIGN
                pop     [(str edi).dDataPtr]
                pop     [(str edi).dLength]
                ret
endp



proc            StrNewFromStr
                ;in
                ;  esi - 'Str'
                ;out
                ;  edi - 'Str'.
                push    ecx esi
                IF DBG
                  call  StrCheck
                ENDIF
                mov     eax, [(str esi).dLength]
                call    StrNewFromSize
                push    edi
                mov     ecx, [(str esi).dLength]
                mov     esi, [(str esi).dDataPtr]
                mov     edi, [(str edi).dDataPtr]
                rep     movsb
                pop     edi
                pop     esi ecx
                ret
endp



proc            StrNewFromSubStr
                ;in
                ;  eax - starting position
                ;  ebx - ending position
                ;  esi - 'Str'
                ;out
                ;  edi - 'Str'.
                push    ebx ecx esi
                IF DBG
                  call  StrCheck
                ENDIF

                mov     ecx, [(str esi).dLength]
                mov     esi, [(str esi).dDataPtr]
                add     esi, eax
                inc     ebx
                @MIN    ecx, ebx
                sub     ecx, eax

                mov     eax, ecx
                call    StrNewFromSize

                push    edi
                mov     edi, [(str edi).dDataPtr]
                cld
                rep     movsb
                pop     edi

                pop     esi ecx ebx
                ret
endp



proc            StrNewFromStrz
                ;in
                ;  esi - 'Strz'
                ;out
                ;  edi - 'Str'.
                push    edx
                call    StrzLength
                call    StrNewFromSize
                mov     edx, [(str edi).dDataPtr]
@@loop:         mov     al, [esi]
                and     al, al
                @IF_NZ
                  mov   [edx], al
                  inc   edx
                  inc   esi
                  jmp   @@loop
                @ENDIF
                pop     edx
                ret
endp



proc            StrNewFromLong
                ;in
                ;  eax - long integer
                ;out
                ;  edi - 'Str'.
                push    esi
                lea     edi, [abStrzBuffer]
                call    StrzDecFromLong
                lea     esi, [abStrzBuffer]
                call    StrNewFromStrz
                pop     esi
                ret
endp



proc            StrNewFromToken
                ;in
                ;  eax - token type (not used)
                ;  ebx - ptr to string
                ;  ecx - size of string
                ;out
                ;  edi - 'Str'.
                push    eax ebx

                mov     eax, ecx
                call    HeapAlloc
                push    edi

                push    ecx
                @DO
                  mov   al, [ebx]
                  inc   ebx
                  mov   [edi], al
                  inc   edi
                @DJNZ   ecx
                pop     ecx

                mov     eax, size str
                call    HeapAlloc
                mov     [(str edi).dSign], STR_SIGN
                pop     [(str edi).dDataPtr]
                mov     [(str edi).dLength], ecx

                pop     ebx eax
                ret
endp



IF DBG
proc            StrCheck
                ;in
                ;  esi - 'Str'.
                ;out
                ;  nothing
                cmp     [(str esi).dSign], STR_SIGN
                @IF_NE
                  lea   esi, [cErrNotStr]
                  call  ErrorFatal
                @ENDIF
                ret
endp
ENDIF



proc            StrDelete
                ;in
                ;  esi - 'Str'.
                ;out
                ;  nothing
                IF DBG
                  call  StrCheck
                ENDIF
                mov     eax, [(str esi).dDataPtr]
                call    HeapFree
                mov     eax, esi
                call    HeapFree
                ret
endp



proc            StrIsEmpty
                ;in
                ;  esi - 'Str'.
                ;out
                ;  CY: not empty
                ;  CN: empty
                push    ecx esi
                IF DBG
                  call  StrCheck
                ENDIF
                mov     ecx, [(str esi).dLength]
                mov     esi, [(str esi).dDataPtr]
@@loop:         sub     ecx, 1
                @IF_NC
                  cmp   [bptr esi], ' '
                  @IF_NE
                    clc
                    jmp @@exit
                  @ENDIF
                  inc   esi
                  jmp   @@loop
                @ENDIF
@@exit:         cmc
                pop     esi ecx
                ret
endp



proc            StrGetLength
                ;in
                ;  esi - 'Str'.
                ;out
                ;  eax - string length
                IF DBG
                  call  StrCheck
                ENDIF
                mov     eax, [(str esi).dLength]
                ret
endp



proc            StrFill
                ;in
                ;   al - fill character.
                ;  esi - 'Str'.
                ;out
                ;  nothing
                push    ecx edi
                IF DBG
                  call  StrCheck
                ENDIF
                mov     ecx, [(str esi).dLength]
                mov     edi, [(str esi).dDataPtr]
                rep     stosb
                pop     edi ecx
                ret
endp



proc            StrAt
                ;in
                ;  esi - 'Str' to search into.
                ;  edi - 'Str' to search for.
                ;out
                ;  CN: substring found
                ;    eax - position
                ;  CY: substring not found
                ;    eax - undefined
                push    ebx ecx esi edi

                IF DBG
                  call  StrCheck
                ENDIF
                xchg    esi, edi
                IF DBG
                  call  StrCheck
                ENDIF

                mov     ebx, [(str esi).dLength]
                mov     esi, [(str esi).dDataPtr]
                mov     al, [esi]
                mov     ecx, [(str edi).dLength]
                mov     edi, [(str edi).dDataPtr]
                push    ecx
                cld
@@loop1:        repne   scasb
                @IF_E
                  dec   edi
                  cmp   ecx, ebx
                  @IF_AE
                    push ecx esi edi
                    mov  ecx, ebx
                    repe cmpsb
                    pop  edi esi ecx
                    jne  @@loop1
                  @ENDIF
                @ENDIF
                pop     eax

                @IF_E
                  sub   eax, ecx
                  dec   eax
                @ELSE
                  stc
                @ENDIF

                pop     edi esi ecx ebx
                ret
endp



proc            StrDeleteChars
                ;in
                ;  ebx - starting position (inclusive)
                ;  ecx - ending position (inclusive)
                ;  esi - 'Str'.
                ;out
                ;  nothing
                push    ebx ecx edx edi
                IF DBG
                  call  StrCheck
                ENDIF

                mov     eax, [(str esi).dLength]
                and     eax, eax
                jz      @@exit
                dec     eax
                @MIN    ecx, eax
                cmp     ebx, ecx
                @IF_BE
                  ;;edi - ptr to new string
                  sub   eax, ecx
                  add   eax, ebx
                  call  HeapAlloc
                  push  esi edi

                  ;;edx - number of remaining symbols
                  mov   edx, [(str esi).dLength]
                  sub   edx, ecx
                  dec   edx

                  ;;ecx - number of symbols to delete
                  sub   ecx, ebx
                  inc   ecx

                  ;;copy first part of string
                  mov   esi, [(str esi).dDataPtr]
@@loop1:          and   ebx, ebx
                  @IF_NZ
                    mov al, [esi]
                    inc esi
                    mov [edi], al
                    inc edi
                    dec ebx
                    jmp short @@loop1
                  @ENDIF

                  ;;copy second part of string
                  add   esi, ecx
@@loop2:          and   edx, edx
                  @IF_NZ
                    mov al, [esi]
                    inc esi
                    mov [edi], al
                    inc edi
                    dec edx
                    jmp short @@loop2
                  @ENDIF

                  pop   edi esi
                  mov   eax, [(str esi).dDataPtr]
                  call  HeapFree
                  sub   [(str esi).dLength], ecx
                  mov   [(str esi).dDataPtr], edi
                @ENDIF

@@exit:         pop     edi edx ecx ebx
                ret
endp



proc            StrInsertChar
                ;in
                ;   al - symbol to insert
                ;  ebx - position
                ;  esi - 'Str'.
                ;out
                ;  nothing
                push    ebx ecx edx edi
                IF DBG
                  call  StrCheck
                ENDIF

                cmp     ebx, [(str esi).dLength]
                @IF_BE
                  mov   ecx, eax

                  ;;edi - ptr to new string
                  mov   eax, [(str esi).dLength]
                  inc   eax
                  call  HeapAlloc
                  push  esi edi

                  ;;edx - number of remaining symbols
                  mov   edx, [(str esi).dLength]
                  sub   edx, ebx

                  ;;copy first part of string
                  mov   esi, [(str esi).dDataPtr]
@@loop1:          and   ebx, ebx
                  @IF_NZ
                    mov al, [esi]
                    inc esi
                    mov [edi], al
                    inc edi
                    dec ebx
                    jmp short @@loop1
                  @ENDIF

                  ;;insert symbol
                  mov   [edi], cl
                  inc   edi

                  ;;copy second part of string
@@loop2:          and   edx, edx
                  @IF_NZ
                    mov al, [esi]
                    inc esi
                    mov [edi], al
                    inc edi
                    dec edx
                    jmp short @@loop2
                  @ENDIF

                  pop   edi esi
                  mov   eax, [(str esi).dDataPtr]
                  call  HeapFree
                  inc   [(str esi).dLength]
                  mov   [(str esi).dDataPtr], edi
                @ENDIF

                pop     edi edx ecx ebx
                ret
endp



proc            StrPadL
                ;in
                ;  eax - new string size
                ;  esi - 'Str'.
                ;out
                ;  nothing
                push    ebx ecx edi
                IF DBG
                  call  StrCheck
                ENDIF

                cmp     eax, [(str esi).dLength]
                @IF_A
                  mov   ebx, eax
                  mov   ecx, eax
                  sub   ecx, [(str esi).dLength]

                  ;;edi - ptr to new string
                  call  HeapAlloc
                  push  esi edi

                  ;;copy spaces
                  mov   al, ' '
                  rep   stosb

                  ;;copy string
                  mov   ecx, [(str esi).dLength]
                  mov   esi, [(str esi).dDataPtr]
                  rep   movsb

                  pop   edi esi
                  mov   eax, [(str esi).dDataPtr]
                  call  HeapFree
                  mov   [(str esi).dLength], ebx
                  mov   [(str esi).dDataPtr], edi
                @ENDIF

                pop     edi ecx ebx
                ret
endp



proc            StrPadR
                ;in
                ;  eax - new string size
                ;  esi - 'Str'.
                ;out
                ;  nothing
                push    ebx ecx edx edi
                IF DBG
                  call  StrCheck
                ENDIF

                cmp     eax, [(str esi).dLength]
                @IF_A
                  mov   ebx, eax
                  mov   edx, eax
                  sub   edx, [(str esi).dLength]

                  ;;edi - ptr to new string
                  call  HeapAlloc
                  push  esi edi

                  ;;copy string
                  mov   ecx, [(str esi).dLength]
                  mov   esi, [(str esi).dDataPtr]
                  rep   movsb

                  ;;copy spaces
                  mov   al, ' '
                  mov   ecx, edx
                  rep   stosb

                  pop   edi esi
                  mov   eax, [(str esi).dDataPtr]
                  call  HeapFree
                  mov   [(str esi).dLength], ebx
                  mov   [(str esi).dDataPtr], edi
                @ENDIF

                pop     edi edx ecx ebx
                ret
endp



proc            StrAdd
                ;in
                ;  esi - 'Str'.
                ;  edi - 'Str' to add.
                ;out
                ;  nothing
                push    ebx ecx edx edi
                IF DBG
                  call  StrCheck
                ENDIF

                mov     ebx, [(str edi).dLength]
                mov     edx, [(str edi).dDataPtr]

                ;;edi - ptr to new string
                mov     eax, [(str esi).dLength]
                add     eax, ebx
                call    HeapAlloc
                push    esi edi

                ;;copy first string
                mov     ecx, [(str esi).dLength]
                mov     esi, [(str esi).dDataPtr]
                rep     movsb

                ;;copy second string
                mov     ecx, ebx
                mov     esi, edx
                rep     movsb

                pop     edi esi
                mov     eax, [(str esi).dDataPtr]
                call    HeapFree
                add     [(str esi).dLength], ebx
                mov     [(str esi).dDataPtr], edi

                pop     edi edx ecx ebx
                ret
endp



proc            StrDecFromLong
                ;in
                ;  eax - long signed integer
                ;  esi - 'Str'
                ;out
                ;  nothing
                push    eax ebx ecx edx
                IF DBG
                  call  StrCheck
                ENDIF

                ;;put terminal value on stack
                xor     edx, edx
                push    edx

                ;;check for negative value
                and     eax, eax
                @IF_S
                  neg   eax
                  mov   ecx, '-'
                @ELSE
                  mov   ecx, 0
                @ENDIF

                ;;put digits to stack
                mov     ebx, 10
@@loop1:        div     ebx
                add     dl, '0'
                push    edx
                xor     edx, edx
                and     eax, eax
                jnz     @@loop1

                ;;put sign to stack
                cmp     ecx, '-'
                @IF_E
                  push  ecx
                @ENDIF

                ;;copy from stack to 'Str'
                mov     ebx, [(str esi).dLength]
                mov     edx, [(str esi).dDataPtr]
@@loop2:        pop     eax
                and     ebx, ebx
                @IF_NZ
                  mov   [edx], al
                  inc   edx
                  dec   ebx
                @ENDIF
                and     al, al
                jnz     @@loop2

                pop     edx ecx ebx eax
                ret
endp



proc            StrDecToLong
                ;in
                ;  esi - 'Str'
                ;out
                ;  eax - number
                push    ebx ecx edx esi edi
                IF DBG
                  call  StrCheck
                ENDIF

                mov     edi, [(str esi).dLength]
                mov     esi, [(str esi).dDataPtr]

                ;;skip leading spaces
@@loop1:        cmp     [bptr esi], ' '
                @IF_E
                  inc   esi
                  dec   edi
                  jnz   @@loop1
                @ENDIF

                ;;main loop
                xor     eax, eax
                xor     ebx, ebx
                mov     ecx, 10
@@loop2:        and     edi, edi
                @IF_NZ
                  mov   bl, [esi]
                  inc   esi
                  sub   bl, '0'
                  @IF_AE
                    cmp bl, 9
                    @IF_BE
                      mul ecx
                      add eax, ebx
                    @ENDIF
                  @ENDIF
                  dec   edi
                  jmp   @@loop2
                @ENDIF

                pop     edi esi edx ecx ebx
                ret
endp

ends            code32
                end
