;*****
; stack.asm - 'Stack' object.
;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                __STACK__ equ 1
                include "pmlib.asd"
                include "stack.asi"
                include "heap.asi"



struc           element         ;element
  dPrev         dd      0       ;ptr to previous element
  dObject       dd      0       ;stored object
ends

struc           stack           ;stack
  dTop          dd      0       ;ptr to current element
ends



proc            StackNew
                ;in
                ;  nothing
                ;out
                ;  edi - 'Stack'
                mov     eax, size stack
                call    HeapAlloc
                mov     [(stack edi).dTop], edi
                ret
endp



proc            StackDelete
                ;in
                ;  esi - 'Stack'
                ;out
                ;  nothing
@@loop:         mov     eax, [(stack esi).dTop]
                cmp     eax, esi
                @IF_NE
                  call  StackPop
                  jmp   @@loop
                @ENDIF
                mov     eax, esi
                call    HeapFree
                ret
endp



proc            StackPush
                ;in
                ;  eax - object
                ;  esi - 'Stack'
                ;out
                ;  nothing
                push    edi

                push    eax
                mov     eax, size element
                call    HeapAlloc
                mov     eax, [(stack esi).dTop]
                mov     [(element edi).dPrev], eax
                mov     [(stack esi).dTop], edi
                pop     [(element edi).dObject]

                pop     edi
                ret
endp



proc            StackPop
                ;in
                ;  esi - 'Stack'
                ;out
                ;  CN: eax - object.
                ;  CY: error, stack is empty.
                push    edi

                mov     edi, [(stack esi).dTop]
                cmp     edi, esi
                @IF_E
                  stc
                @ELSE
                  mov   eax, [(element edi).dPrev]
                  mov   [(stack esi).dTop], eax
                  mov   eax, edi
                  mov   edi, [(element edi).dObject]
                  call  HeapFree
                  mov   eax, edi
                  clc
                @ENDIF

                pop     edi
                ret
endp



proc            StackWrite
                ;in
                ;  eax - object
                ;  esi - 'Stack'
                ;out
                ;  CY: error, stack is empty.
                push    edi
                mov     edi, [(stack esi).dTop]
                cmp     edi, esi
                @IF_E
                  stc
                @ELSE
                  clc
                  mov   [(element edi).dObject], eax
                @ENDIF
                pop     edi
                ret
endp



proc            StackRead
                ;in
                ;  esi - 'Stack'
                ;out
                ;  CN: eax - object
                ;  CY: error, stack is empty.
                mov     eax, [(stack esi).dTop]
                cmp     eax, esi
                @IF_E
                  stc
                @ELSE
                  clc
                  mov   eax, [(element eax).dObject]
                @ENDIF
                ret
endp

ends            code32
                end
