;*****
; spr.asm - 'Spr' object.
;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                __SPR__ equ 1
                include "pmlib.asd"
                include "spr.asi"
                include "debug.asi"
                include "error.asi"
                include "heap.asi"
                include "pic.asi"



TYPE_TRANSPARENT        equ     0
TYPE_COLOURED_DWORDS    equ     1
TYPE_COLOURED_BYTES     equ     2
TYPE_NEXT_LINE          equ     3
TYPE_END                equ     4



DBG_RUS_MESSAGE cErrNotSpr "ꥪ  'Spr'."
DBG_ENG_MESSAGE cErrNotSpr "Object is not 'Spr'."



adCompareFn     dd      Compare1,   Compare2,   Compare3,   Compare4
adIncrementFn   dd      Increment1, Increment2, Increment3, Increment4



struc           locals
  dTranspColor  dd      0
  dPic          dd      0
  dTmpBufferPtr dd      0
  dTmpBufferSiz dd      0
  dCounter      dd      0
  fnCompare     dd      0
  fnIncrement   dd      0
ends
proc            SprNewFromPic
                ;in
                ;  eax - transparent color
                ;  esi - 'Pic'
                ;out
                ;  edi - created object
                push    ebx ecx edx esi ebp
                sub     esp, size locals
                mov     ebp, esp

                ;;initialize locals
                mov     [(locals ebp).dTranspColor], eax
                mov     [(locals ebp).dPic], esi
                mov     eax, [(pic esi).dBytesPerCell]
                dec     eax
                mov     ebx, [adCompareFn+eax*4]
                mov     [(locals ebp).fnCompare], ebx
                mov     ebx, [adIncrementFn+eax*4]
                mov     [(locals ebp).fnIncrement], ebx

                ;;allocate temporary buffer that is guaranteed to be
                ;;greater than space needed for transformed picture
                mov     eax, [(pic esi).dTotalRow]
                mul     [(pic esi).dTotalColByte]
                shl     eax, 3
                call    HeapAlloc
                mov     [(locals ebp).dTmpBufferPtr], edi
                mov     [(locals ebp).dTmpBufferSiz], 0

                ;;fill temporary buffer and count size of transformed picture
                mov     ebx, [(pic esi).dImagePtr]
                mov     ecx, [(pic esi).dTotalRow]
@@loop1:        push    ecx
                mov     edx, [(pic esi).dTotalColByte]
@@loop2:        call    [(locals ebp).fnCompare]
                mov     [(locals ebp).dCounter], 0
                @IF_E
                  ;;count number of transparent points
@@loop3:          call  [(locals ebp).fnIncrement]
                  sub   edx, [(pic esi).dBytesPerCell]
                  @IF_NZ
                    call [(locals ebp).fnCompare]
                    je  @@loop3
                    mov eax, [(locals ebp).dCounter]
                    or  eax, (TYPE_TRANSPARENT SHL 12)
                    mov [edi], ax
                    add edi, 2
                    add [(locals ebp).dTmpBufferSiz], 2
                  @ENDIF
                @ELSE
                  ;;count number of coloured points
                  push  ebx
@@loop4:          call  [(locals ebp).fnIncrement]
                  sub   edx, [(pic esi).dBytesPerCell]
                  @IF_NZ
                    call [(locals ebp).fnCompare]
                    jne @@loop4
                  @ENDIF
                  pop   ebx
                  mov   eax, [(locals ebp).dCounter]
                  shr   eax, 2
                  @IF_NZ
                    mov ecx, eax
                    or  eax, (TYPE_COLOURED_DWORDS SHL 12)
                    mov [edi], ax
                    add edi, 2
                    add [(locals ebp).dTmpBufferSiz], 2
                    @DO
                      mov eax, [ebx]
                      add ebx, 4
                      mov [edi], eax
                      add edi, 4
                      add [(locals ebp).dTmpBufferSiz], 4
                    @DJNZ ecx
                  @ENDIF
                  mov   eax, [(locals ebp).dCounter]
                  and   eax, 3
                  @IF_NZ
                    mov ecx, eax
                    or  eax, (TYPE_COLOURED_BYTES SHL 12)
                    mov [edi], ax
                    add edi, 2
                    add [(locals ebp).dTmpBufferSiz], 2
                    @DO
                      mov al, [ebx]
                      inc ebx
                      mov [edi], al
                      inc edi
                      inc [(locals ebp).dTmpBufferSiz]
                    @DJNZ ecx
                  @ENDIF
                @ENDIF
                and     edx, edx
                jnz     @@loop2
                mov     [wptr edi], (TYPE_NEXT_LINE SHL 12)
                add     edi, 2
                add     [(locals ebp).dTmpBufferSiz], 2
                pop     ecx
                dec     ecx
                jnz     @@loop1
                mov     [wptr edi], (TYPE_END SHL 12)
                add     [(locals ebp).dTmpBufferSiz], 2

                ;;allocate memory for transformed picture and fill it
                mov     eax, [(locals ebp).dTmpBufferSiz]
                call    HeapAlloc
                push    edi
                mov     ecx, [(locals ebp).dTmpBufferSiz]
                mov     esi, [(locals ebp).dTmpBufferPtr]
                mov     eax, [esi]
                rep     movsb

                ;;release temporary buffer
                mov     eax, [(locals ebp).dTmpBufferPtr]
                call    HeapFree

                ;;create 'Spr'
                mov     eax, size spr
                call    HeapAlloc
                mov     esi, [(locals ebp).dPic]
                mov     [(spr edi).dSign], SPR_SIGN
                mov     eax, [(pic esi).dTotalRow]
                mov     [(spr edi).dTotalRow], eax
                mov     eax, [(pic esi).dTotalCol]
                mov     [(spr edi).dTotalCol], eax
                mov     eax, [(pic esi).dTotalColByte]
                mov     [(spr edi).dTotalColByte], eax
                pop     [(spr edi).dImagePtr]

                add     esp, size locals
                pop     ebp esi edx ecx ebx
                ret
endp

proc            Compare1
                mov     al, [ebx]
                cmp     al, [bptr (locals ebp).dTranspColor]
                ret
endp

proc            Compare2
                mov     ax, [ebx]
                cmp     ax, [wptr (locals ebp).dTranspColor]
                ret
endp

proc            Compare3
                movzx   ax, [bptr ebx+2]
                shl     eax, 16
                mov     ax, [ebx]
                cmp     eax, [(locals ebp).dTranspColor]
                ret
endp

proc            Compare4
                mov     eax, [ebx]
                cmp     eax, [(locals ebp).dTranspColor]
                ret
endp

proc            Increment1
                inc     [(locals ebp).dCounter]
                inc     ebx
                ret
endp

proc            Increment2
                add     [(locals ebp).dCounter], 2
                add     ebx, 2
                ret
endp

proc            Increment3
                add     [(locals ebp).dCounter], 3
                add     ebx, 3
                ret
endp

proc            Increment4
                add     [(locals ebp).dCounter], 4
                add     ebx, 4
                ret
endp




IF DBG
proc            SprCheck
                ;in
                ;  esi - 'Spr'
                ;out
                ;  nothing
                cmp     [(spr esi).dSign], SPR_SIGN
                @IF_NE
                  lea   esi, [cErrNotSpr]
                  call  ErrorFatal
                @ENDIF
		ret
endp
ENDIF



proc            SprDelete
                ;in
                ;  esi - 'Spr'
                ;out
                ;  nothing
                IF DBG
                  call  SprCheck
                ENDIF
                mov     eax, esi
                call    HeapFree
		ret
endp



struc           locals
  dTotalColByte dd      0
  dCurrPtr      dd      0
  dPic          dd      0
ends
proc            SprToPic
                ;in
                ;  eax - row
                ;  ebx - col
                ;  esi - 'Spr'
                ;  edi - 'Pic'
                ;out
                ;  nothing
                pushad
                sub     esp, size locals
                mov     ebp, esp

                IF DBG
                  call  SprCheck
                ENDIF

                mov     ecx, [(pic edi).dTotalColByte]
                mov     [(locals ebp).dTotalColByte], ecx

                mul     [(pic edi).dTotalCol]
                add     eax, ebx
                mul     [(pic edi).dBytesPerCell]
                add     eax, [(pic edi).dImagePtr]
                mov     edi, eax
                mov     [(locals ebp).dCurrPtr], edi

                mov     esi, [(spr esi).dImagePtr]
                xor     eax, eax
                xor     ecx, ecx
@@loop1:        mov     ax, [esi]
                add     esi, 2
                mov     cx, ax
                shr     ax, 12
                and     cx, 0FFFh
                cmp     al, TYPE_TRANSPARENT
                @IF_E
                  add   edi, ecx
                  jmp   @@loop1
                @ENDIF
                cmp     al, TYPE_COLOURED_DWORDS
                @IF_E
                  rep   movsd
                  jmp   @@loop1
                @ENDIF
                cmp     al, TYPE_COLOURED_BYTES
                @IF_E
                  rep   movsb
                  jmp   @@loop1
                @ENDIF
                cmp     al, TYPE_NEXT_LINE
                @IF_E
                  mov   edi, [(locals ebp).dCurrPtr]
                  add   edi, [(locals ebp).dTotalColByte]
                  mov   [(locals ebp).dCurrPtr], edi
                  jmp   @@loop1
                @ENDIF

                add     esp, size locals
                popad
                ret
endp

ends            code32
                end
