;*****
; pic.asm - 'Pic' object.
;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                __PIC__ equ 1
                include "pmlib.asd"
                include "pic.asi"
                include "color.asi"
                include "debug.asi"
                include "error.asi"
                include "heap.asi"



DBG_RUS_MESSAGE cErrNotPic      "ꥪ  ਭ  'Pic'."
DBG_ENG_MESSAGE cErrNotPic      "Object is not a 'Pic'."
DBG_RUS_MESSAGE cErrBPC         "ࠧ ᫮ BPC."
DBG_ENG_MESSAGE cErrBPC         "BPC not match."
RUS_MESSAGE     cErrCopy        "  ஢  ."
ENG_MESSAGE     cErrCopy        "Can not copy to another picture."
RUS_MESSAGE     cErrBadColor    "ୠ 梥⮢ 奬."
ENG_MESSAGE     cErrBadColor    "Bad 'Color sheme'."



proc            PicNew
                ;in
                ;  eax - number of rows
                ;  ebx - number of columns
                ;  ecx - color scheme
                ;out
                ;  edi - 'Pic'
                push    eax
                mov     eax, size pic
                call    HeapAlloc
                pop     eax
                call    PicInit
                ret
endp



proc            PicInit
                ;in
                ;  eax - number of rows
                ;  ebx - number of columns
                ;  ecx - color scheme
                ;  edi - 'Pic'
                ;out
                ;  nothing
                pushad

                cmp     ecx, COLOR32
                @IF_A
                  lea   esi, [cErrBadColor]
                  call  ErrorFatal
                @ENDIF

                mov     esi, edi
                mov     edi, [adBytesPerCell+ecx*4]

                ;;initialize 'Pic' parameters
                mov     [(pic esi).dPicSign], PIC_SIGN
                mov     [(pic esi).dTotalRow], eax
                mov     [(pic esi).dTotalCol], ebx
                mov     [(pic esi).dColorScheme], ecx
                mov     [(pic esi).dBytesPerCell], edi
                mov     eax, ebx
                mul     edi
                mov     [(pic esi).dTotalColByte], eax

                ;;allocate memory for image
                mul     [(pic esi).dTotalRow]
                call    HeapAlloc
                mov     [(pic esi).dImagePtr], edi

                popad
                ret
endp



IF DBG
proc            PicCheck
                ;in
                ;  esi - 'Pic'
                ;out
                ;  nothing
                cmp     [(pic esi).dPicSign], PIC_SIGN
                @IF_NE
                  lea   esi, [cErrNotPic]
                  call  ErrorFatal
                @ENDIF
                ret
endp
ENDIF



proc            PicDelete
                ;in
                ;  esi - 'Pic'
                ;out
                ;  nothing
                IF DBG
                  call  PicCheck
                ENDIF
                mov     eax, [(pic esi).dImagePtr]
                call    HeapFree
                mov     eax, esi
                call    HeapFree
                ret
endp



dRow            dd      ?
dCol            dd      ?
dSrcDelta       dd      ?
dDstDelta       dd      ?
dRowCount       dd      ?
dColCount       dd      ?

proc            PicToPic
                ;in
                ;  eax - row
                ;  ebx - column
                ;  esi - 'Pic' to copy
                ;  edi - 'Pic' to copy to
                ;out
                ;  nothing
                ;description
                ;  Copies one 'Pic' to another. Bounds handled correctly.
                push    [(pic esi).dTotalRow]
                push    [(pic esi).dTotalCol]
                pushad

                IF DBG
                  call  PicCheck
                  xchg  esi, edi
                  call  PicCheck
                  xchg  esi, edi
                  mov   edx, [(pic esi).dBytesPerCell]
                  cmp   edx, [(pic edi).dBytesPerCell]
                  @ERROR_NE cErrBPC
                ENDIF

                ;;save registers
                mov     [dRow], eax
                mov     [dCol], ebx

                ;;validate parameters
                mov     eax, [(pic edi).dTotalRow]
                sub     eax, [dRow]
                @IF_B
                  lea   esi, [cErrCopy]
                  call  ErrorFatal
                @ENDIF
                sub     eax, [(pic esi).dTotalRow]
                @IF_B
                  add   [(pic esi).dTotalRow], eax
                @ENDIF
                mov     eax, [(pic edi).dTotalCol]
                sub     eax, [dCol]
                @IF_B
                  lea   esi, [cErrCopy]
                  call  ErrorFatal
                @ENDIF
                sub     eax, [(pic esi).dTotalCol]
                @IF_B
                  add   [(pic esi).dTotalCol], eax
                  neg   eax
                  mul   [(pic esi).dBytesPerCell]
                  mov   [dSrcDelta], eax
                @ELSE
                  mov   [dSrcDelta], 0
                @ENDIF

                ;;setup constants
                mov     eax, [(pic edi).dTotalCol]
                sub     eax, [(pic esi).dTotalCol]
                mul     [(pic esi).dBytesPerCell]
                mov     [dDstDelta], eax
                mov     eax, [(pic esi).dTotalRow]
                mov     [dRowCount], eax
                mov     eax, [(pic esi).dTotalCol]
                mul     [(pic esi).dBytesPerCell]
                mov     [dColCount], eax

                ;;setup pointers
                mov     esi, [(pic esi).dImagePtr]
                mov     eax, [(pic edi).dTotalCol]
                mul     [dRow]
                add     eax, [dCol]
                mul     [(pic edi).dBytesPerCell]
                mov     edi, [(pic edi).dImagePtr]
                add     edi, eax

                ;;main loop
@@loop:         mov     ecx, [dColCount]
                rep movsb
                add     esi, [dSrcDelta]
                add     edi, [dDstDelta]
                dec     [dRowCount]
                jnz     @@loop

                ;;restore registers
@@exit:         popad
                pop     [(pic esi).dTotalCol]
                pop     [(pic esi).dTotalRow]

                ret
endp



struc           locals
  dRow          dd      ?
  dCol          dd      ?
  dRowCount     dd      ?
  dColCount     dd      ?
  dSrcDelta     dd      ?
  dDstDelta     dd      ?
ends
proc            PicFromPic
                ;in
                ;  eax - row
                ;  ebx - column
                ;  esi - 'Pic' to copy to
                ;  edi - 'Pic' to copy from
                ;out
                ;  nothing
                ;description
                ;  Copies part of bigger 'Pic' to smaller.
                ;  Bounds handled correctly.
                pushad
                sub     esp, size locals
                mov     ebp, esp

                IF DBG
                  call  PicCheck
                  xchg  esi, edi
                  call  PicCheck
                  xchg  esi, edi
                ENDIF

                ;;save parameters
                mov     [(locals ebp).dRow], eax
                mov     [(locals ebp).dCol], ebx

                ;;check bounds
                cmp     eax, [(pic edi).dTotalRow]
                jae     @@exit
                cmp     ebx, [(pic edi).dTotalCol]
                jae     @@exit

                ;;calculate number of rows to copy
                add     eax, [(pic esi).dTotalRow]
                sub     eax, [(pic edi).dTotalRow]
                @IF_A
                  neg   eax
                  add   eax, [(pic esi).dTotalRow]
                @ELSE
                  mov   eax, [(pic esi).dTotalRow]
                @ENDIF
                mov     [(locals ebp).dRowCount], eax

                ;;calculate number of columns to copy
                mov     eax, ebx
                add     eax, [(pic esi).dTotalCol]
                sub     eax, [(pic edi).dTotalCol]
                @IF_A
                  neg   eax
                  add   eax, [(pic esi).dTotalCol]
                @ELSE
                  mov   eax, [(pic esi).dTotalCol]
                @ENDIF
                mul     [(pic esi).dBytesPerCell]
                mov     [(locals ebp).dColCount], eax

                ;;setup constants
                mov     eax, [(pic edi).dTotalColByte]
                sub     eax, [(locals ebp).dColCount]
                mov     [(locals ebp).dSrcDelta], eax
                mov     eax, [(pic esi).dTotalColByte]
                sub     eax, [(locals ebp).dColCount]
                mov     [(locals ebp).dDstDelta], eax

                ;;setup pointers
                mov     eax, [(locals ebp).dRow]
                mul     [(pic edi).dTotalCol]
                add     eax, [(locals ebp).dCol]
                mul     [(pic edi).dBytesPerCell]
                mov     edi, [(pic edi).dImagePtr]
                add     edi, eax
                mov     esi, [(pic esi).dImagePtr]
                xchg    esi, edi

                ;;main loop
@@loop:         mov     ecx, [(locals ebp).dColCount]
                rep movsb
                add     esi, [(locals ebp).dSrcDelta]
                add     edi, [(locals ebp).dDstDelta]
                dec     [(locals ebp).dRowCount]
                jnz     @@loop

@@exit:         add     esp, size locals
                popad
                ret
endp



proc            PicClear
                ;in
                ;  eax - fill color
                ;  esi - 'Pic'
                ;out
                ;  nothing
                ;description
                ;  Clears 'Pic' with fill color.
                pushad

                IF DBG
                  call  PicCheck
                ENDIF

                mov     edi, [(pic esi).dImagePtr]

                ;;8 bpp
                cmp     [(pic esi).dBytesPerCell], 1
                @IF_E
                  mov   edx, [(pic esi).dTotalRow]
                  @DO
                    mov ecx, [(pic esi).dTotalCol]
                    rep stosb
                  @DJNZ edx
                  jmp   short @@exit
                @ENDIF

                ;;15 or 16 bpp
                cmp     [(pic esi).dBytesPerCell], 2
                @IF_E
                  mov   edx, [(pic esi).dTotalRow]
                  @DO
                    mov ecx, [(pic esi).dTotalCol]
                    rep stosw
                  @DJNZ edx
                  jmp   short @@exit
                @ENDIF

                ;;24 bpp
                cmp     [(pic esi).dBytesPerCell], 3
                @IF_E
                  mov   edx, [(pic esi).dTotalRow]
                  @DO
                    mov ecx, [(pic esi).dTotalCol]
                    @DO
                      stosw
                      stosb
                    @DJNZ ecx
                  @DJNZ edx
                  jmp   short @@exit
                @ENDIF

                ;;32 bpp
                mov   edx, [(pic esi).dTotalRow]
                @DO
                  mov ecx, [(pic esi).dTotalCol]
                  rep stosd
                @DJNZ edx

@@exit:         popad
                ret
endp



proc            PicToCurrentColorScheme
                ;in
                ;  esi - 'Pic'
                ;out
                ;  nothing
                ;description
                ;  Converts 'Pic' to current color scheme.
                pushad

                IF DBG
                  call  PicCheck
                ENDIF

                ;;get current color scheme, exit if no conversion needed
                mov     ebx, [dColorSchemeCur]
                cmp     ebx, [(pic esi).dColorScheme]
                je      @@exit

                ;;calculate total number of points
                mov     eax, [(pic esi).dTotalRow]
                mul     [(pic esi).dTotalCol]
                mov     ecx, eax

                ;;allocate memory for new image
                mul     [adBytesPerCell+ebx*4]
                call    HeapAlloc

                ;;convert, drop original image and set new parameters
                push    esi
                mov     eax, [(pic esi).dColorScheme]
                mov     edx, [(pic esi).dPalette]
                mov     esi, [(pic esi).dImagePtr]
                call    ColorConvertBlock
                mov     eax, esi
                call    HeapFree
                pop     esi
                mov     eax, [adBytesPerCell+ebx*4]
                mov     [(pic esi).dBytesPerCell], eax
                mul     [(pic esi).dTotalCol]
                mov     [(pic esi).dTotalColByte], eax
                mov     [(pic esi).dColorScheme], ebx
                mov     [(pic esi).dImagePtr], edi

@@exit:         popad
                ret
endp

ends            code32
                end
