;*****
; parser.asm - parse 'Stream' to tokens.
;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                __PARSER__ equ 1
                include "pmlib.asd"
                include "parser.asi"
                include "debug.asi"
                include "error.asi"
                include "heap.asi"
                include "stream.asi"



PARSER_SIGN     equ     'Pars'
MAX_WORD_SIZE   equ     1024



struc           parser          ;'Parser'
  dSign         dd PARSER_SIGN  ;signature for run-time checks
  dStream       dd      0       ;'Stream'
  dPreviewFlag  dd      0       ;
  dTokenType    dd      0       ;
  dWordLength   dd      0       ;length of current word
  dWordBuffer   dd      0       ;buffer for current word
ends



abDelimiters    db      ',.;:[]{}()<>+-*/=\|&!'

DBG_RUS_MESSAGE cErrNotParser "ꥪ  'Parser'."
DBG_ENG_MESSAGE cErrNotParser "Object is not 'Parser'."



proc            ParserNew
                ;in
                ;  esi - 'Stream'
                ;out
                ;  edi - 'Parser'
                mov     eax, MAX_WORD_SIZE
                call    HeapAlloc
                push    edi

                mov     eax, size parser
                call    HeapAlloc
                mov     [(parser edi).dSign], PARSER_SIGN
                mov     [(parser edi).dStream], esi
                mov     [(parser edi).dPreviewFlag], 0
                pop     [(parser edi).dWordBuffer]

                ret
endp



IF DBG
proc            ParserCheck
                ;in
                ;  esi - 'Parser'
                ;out
                ;  nothing
                cmp     [(parser esi).dSign], PARSER_SIGN
                @IF_NE
                  lea   esi, [cErrNotParser]
                  call  ErrorFatal
                @ENDIF
		ret
endp
ENDIF



proc            ParserDelete
                ;in
                ;  esi - 'Parser'
                ;out
                ;  nothing
                IF DBG
                  call  ParserCheck
                ENDIF

                mov     eax, [(parser esi).dWordBuffer]
                call    HeapFree

                mov     eax, esi
                call    HeapFree
		ret
endp



proc            ParserPreviewToken
                ;in
                ;  esi - 'Parser'
                ;out
                ;  eax - token type
                ;  ebx - ptr to token
                ;  ecx - token length
                IF DBG
                  call  ParserCheck
                ENDIF

                cmp     [(parser esi).dPreviewFlag], 1
                @IF_NE
                  call  ParserReadToken
                @ENDIF
                mov     [(parser esi).dPreviewFlag], 1

                mov     eax, [(parser esi).dTokenType]
                mov     ebx, [(parser esi).dWordBuffer]
                mov     ecx, [(parser esi).dWordLength]

		ret
endp



proc            ParserGetToken
                ;in
                ;  esi - 'Parser'
                ;out
                ;  eax - token type
                ;  ebx - ptr to token
                ;  ecx - token length
                IF DBG
                  call  ParserCheck
                ENDIF

                cmp     [(parser esi).dPreviewFlag], 1
                @IF_NE
                  call  ParserReadToken
                @ENDIF
                mov     [(parser esi).dPreviewFlag], 0

                mov     eax, [(parser esi).dTokenType]
                mov     ebx, [(parser esi).dWordBuffer]
                mov     ecx, [(parser esi).dWordLength]

		ret
endp



proc            ParserSkipLine
                ;in
                ;  esi - 'Parser'
                ;out
                ;  nothing
                push    esi edi
                IF DBG
                  call  ParserCheck
                ENDIF

                ;;initialization
                mov     edi, esi
                mov     esi, [(parser edi).dStream]
                mov     [(parser edi).dPreviewFlag], 0

                ;;skip to next line
@@loop1:        call    StreamGetByte
                jc      @@exit
                cmp     al, 0Dh
                jne     @@loop1
                call    StreamPreviewByte
                jc      @@exit
                cmp     al, 0Ah
                @IF_E
                  call  StreamGetByte
                @ENDIF

@@exit:         pop     edi esi
		ret
endp





;;
;                             LOCAL METHODS                                ;
;;



proc            ParserReadToken
                ;in
                ;  esi - 'Parser'
                ;out
                ;  nothing
                push    ebx esi edi

                ;;initialization
                mov     edi, esi
                mov     esi, [(parser edi).dStream]

                ;;skip spaces
@@loop1:        call    StreamGetByte
                @IF_C
                  mov   [(parser edi).dTokenType], TOKEN_EOS
                  jmp   @@exit
                @ENDIF
                call    IsSpace
                jnc     @@loop1

                ;;check for end of line
                cmp     al, 0Dh
                @IF_E
                  mov   [(parser edi).dTokenType], TOKEN_EOL
                  call  StreamPreviewByte
                  cmp   al, 0Ah
                  @IF_E
                    call  StreamGetByte
                  @ENDIF
                  jmp   @@exit
                @ENDIF

                ;;check for delimiter
                call    IsDelimiter
                @IF_NC
                  mov   [(parser edi).dTokenType], TOKEN_DELIM
                  mov   [(parser edi).dWordLength], 1
                  mov   ebx, [(parser edi).dWordBuffer]
                  mov   [ebx], al
                  jmp   @@exit
                @ENDIF

                ;;check for quote
                cmp     al, "'"
                @IF_E
                  mov   [(parser edi).dTokenType], TOKEN_STR
                  mov   [(parser edi).dWordLength], 0
                  mov   ebx, [(parser edi).dWordBuffer]
@@loop2:          call    StreamGetByte
                  jc      @@exit
                  cmp   al, "'"
                  @IF_NE
                    cmp   [(parser edi).dWordLength], MAX_WORD_SIZE
                    @IF_BE
                      inc [(parser edi).dWordLength]
                      mov [ebx], al
                      inc ebx
                    @ENDIF
                    jmp   @@loop2
                  @ENDIF
                  jmp   @@exit
                @ENDIF

                ;;check for double quote
                cmp     al, '"'
                @IF_E
                  mov   [(parser edi).dTokenType], TOKEN_STR
                  mov   [(parser edi).dWordLength], 0
                  mov   ebx, [(parser edi).dWordBuffer]
@@loop3:          call    StreamGetByte
                  jc      @@exit
                  cmp   al, '"'
                  @IF_NE
                    cmp   [(parser edi).dWordLength], MAX_WORD_SIZE
                    @IF_BE
                      inc [(parser edi).dWordLength]
                      mov [ebx], al
                      inc ebx
                    @ENDIF
                    jmp   @@loop3
                  @ENDIF
                  jmp   @@exit
                @ENDIF

                ;;read word
                mov     [(parser edi).dTokenType], TOKEN_WORD
                mov     [(parser edi).dWordLength], 1
                mov     ebx, [(parser edi).dWordBuffer]
                mov     [ebx], al
@@loop4:        call    StreamPreviewByte
                jc      @@exit
                call    IsLetter
                @IF_NC
                  call  StreamGetByte
                  cmp   [(parser edi).dWordLength], MAX_WORD_SIZE
                  @IF_BE
                    inc [(parser edi).dWordLength]
                    inc ebx
                    mov [ebx], al
                  @ENDIF
                  jmp   @@loop4
                @ENDIF

@@exit:         pop     edi esi ebx
		ret
endp



proc            IsSpace
                ;in
                ;  al - character
                ;out
                ;  CN - character is a space
                ;  CY - character is not a space
                cmp     al, ' '
                @IF_E
                  clc
                  jmp   @@exit
                @ENDIF
                cmp     al, 9
                @IF_E
                  clc
                  jmp   @@exit
                @ENDIF
                stc
@@exit:         ret
endp



proc            IsDelimiter
                ;in
                ;  al - character
                ;out
                ;  CN - character is a delimiter
                ;  CY - character is not a delimiter
                push    ecx edi

                mov     ecx, size abDelimiters
                lea     edi, [abDelimiters]
                repne   scasb
                @IF_E
                  clc
                @ELSE
                  stc
                @ENDIF

                pop     edi ecx
                ret
endp



proc            IsLetter
                ;in
                ;  al - character
                ;out
                ;  CN - character is a letter
                ;  CY - character is not a letter
                cmp     al, 0Dh
                @IF_E
                  stc
                  jmp   @@exit
                @ENDIF

                cmp     al, 0Ah
                @IF_E
                  stc
                  jmp   @@exit
                @ENDIF

                call    IsSpace
                @IF_NC
                  stc
                  jmp   @@exit
                @ENDIF

                call    IsDelimiter
                @IF_NC
                  stc
                  jmp   @@exit
                @ENDIF

                clc
@@exit:         ret
endp

ends            code32
                end
