;*****
; mouse.asm - mouse handling.
;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                __MOUSE__ equ 1
                include "pmlib.asd"
                include "mouse.asi"
                include "error.asi"



RUS_MESSAGE     cErrNoMouse     "  ."
ENG_MESSAGE     cErrNoMouse     "Mouse not found."



proc            MouseInit
                ;in
                ;  nothing
                ;out
                ;  eax - number of mouse buttons
                ;description
                ;  Initialises mouse driver.
                push    ebx
                xor     eax, eax
                int     33h
                and     ax, ax
                @IF_Z
                  lea   esi, [cErrNoMouse]
                  call  ErrorFatal
                @ENDIF
                movsx   eax, bx
                pop     ebx
                ret
endp



proc            MouseState
                ;in
                ;  nothing
                ;out
                ;  eax - row
                ;  ebx - column
                ;  ecx - buttons state
                ;description
                ;  Returns mouse state.
                push    edx
                mov     ax, 3
                int     33h
                xchg    ebx, ecx
                movsx   eax, dx
                movsx   ebx, bx
                movsx   ecx, cx
                pop     edx
                ret
endp



proc            MouseLimits
                ;in
                ;  eax - minimal column
                ;  ebx - maximal column
                ;  ecx - minimal row
                ;  edx - maximal row
                ;out
                ;  nothing
                ;description
                ;  Sets mouse cursor limits.
                push    eax ebx
                mov     ax, 8           ;set vertical range
                int     33h
                pop     edx ecx
                mov     ax, 7           ;set horizontal range
                int     33h
                ret
endp



proc            MouseSetPosition
                ;in
                ;  eax - row
                ;  ebx - column
                ;out
                ;  nothing
                ;description
                ;  Sets mouse cursor position.
                pushad
                mov     edx, eax
                mov     ecx, ebx
                mov     ax, 4
                int     33h
                popad
                ret
endp

ends            code32
                end
