;*****
; math.asm - mathematical objects
;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32



                __MATH__ equ 1
                include  "math.asi"



dVar            dd      0
dPiHalf         dd      180*MATH_DEGREE



proc            MathMtxClear
                ;in
                ;  esi - 'Mtx'
                ;out
                ;  nothing
                ;description
                ;  Matrix is filled with zeroes.
                push    ecx edi
                xor     eax, eax
                mov     ecx, (size mtx)/4
                mov     edi, esi
                rep     stosd
                pop     edi ecx
                ret
endp



proc            MathMtxByVector
                ;in
                ;  ebx - 'Mtx'
                ;  esi - 'Vector'
                ;  edi - resulting 'Vector'
                ;out
                ;  nothing
                ;descriptiom
                ;  Multiplies matrix by vector.

                ;;calculate X-component of resulting vector
                fld     [(mtx ebx).qX1]
                fild    [(vector esi).dX]
                fmul
                fld     [(mtx ebx).qX2]
                fild    [(vector esi).dY]
                fmul
                fadd
                fld     [(mtx ebx).qX3]
                fild    [(vector esi).dZ]
                fmul
                fadd
                fld     [(mtx ebx).qX4]
                fadd

                ;;calculate Y-component of resulting vector
                fld     [(mtx ebx).qY1]
                fild    [(vector esi).dX]
                fmul
                fld     [(mtx ebx).qY2]
                fild    [(vector esi).dY]
                fmul
                fadd
                fld     [(mtx ebx).qY3]
                fild    [(vector esi).dZ]
                fmul
                fadd
                fld     [(mtx ebx).qY4]
                fadd

                ;;calculate Z-component of resulting vector
                fld     [(mtx ebx).qZ1]
                fild    [(vector esi).dX]
                fmul
                fld     [(mtx ebx).qZ2]
                fild    [(vector esi).dY]
                fmul
                fadd
                fld     [(mtx ebx).qZ3]
                fild    [(vector esi).dZ]
                fmul
                fadd
                fld     [(mtx ebx).qZ4]
                fadd

                ;;store resulting vector
                fistp   [(vector edi).dZ]
                fistp   [(vector edi).dY]
                fistp   [(vector edi).dX]

                ret
endp



proc            MathMtxCreateRotZ
                ;in
                ;  eax - rotation angle (in degrees)
                ;  esi - empty 'Mtx'
                ;out
                ;  nothing
                ;description
                ;  Creates rotation matrix.

                ;;initialization
                fldpi
                mov     [dVar], eax
                call    MathMtxClear

                ;;get angle value in radians
                fild    [dVar]
                fild    [dPiHalf]
                fdiv
                fmul

                ;;calculate cosine
                fld     st(0)
                fcos
                fst     [(mtx esi).qX1]
                fstp    [(mtx esi).qY2]

                ;;calculate sine
                fsin
                fst     [(mtx esi).qY1]
                fchs
                fstp    [(mtx esi).qX2]

                ;;store 1
                fld1
                fstp    [(mtx esi).qZ3]

                ret
endp

ends            code32
                end
