;*****
; list.asm - double-linked list.
;



segment         code32 public use32 'CODE'
                assume cs:code32, ds:code32

                __LIST__ equ 1
                include "pmlib.asd"
                include "list.asi"
                include "error.asi"
                include "heap.asi"



LIST_SIGN       equ     'List'

struc           element         ;list element
  dPrev         dd      0       ;ptr to previous element
  dNext         dd      0       ;ptr to next element
  dObject       dd      0       ;stored object
ends

struc           head            ;list head (a kind of element)
  dPrev         dd      0       ;ptr to last element (SIC!)
  dNext         dd      0       ;ptr to first element (SIC!)
  dCurrent      dd      0       ;ptr to current element
  dSign         dd  LIST_SIGN   ;signature for run-time checks
ends

DBG_RUS_MESSAGE cErrNotList "ꥪ  'List'."
DBG_ENG_MESSAGE cErrNotList "Object is not 'List'."



proc            ListNew
                ;in
                ;  nothing
                ;out
                ;  edi - 'List'
                mov     eax, size head
                call    HeapAlloc
                mov     [(head edi).dSign], LIST_SIGN
                mov     [(head edi).dCurrent], edi
                mov     [(head edi).dPrev], edi
                mov     [(head edi).dNext], edi
                ret
endp



IF DBG
proc            ListCheck
                ;in
                ;  esi - 'List'
                ;out
                ;  nothing
                cmp     [(head esi).dSign], LIST_SIGN
                @IF_NE
                  lea   esi, [cErrNotList]
                  call  ErrorFatal
                @ENDIF
                ret
endp
ENDIF



proc            ListDelete
                ;in
                ;  esi - 'List'
                ;out
                ;  nothing
                push    edi
                IF DBG
                  call  ListCheck
                ENDIF
                mov     edi, esi
@@loop:         mov     eax, edi
                mov     edi, [(element edi).dNext]
                call    HeapFree
                cmp     esi, edi
                jnz     @@loop
                pop     edi
                ret
endp



proc            ListGetPosition
                ;in
                ;  esi - 'List'
                ;out
                ;  eax - ptr to current element
                IF DBG
                  call  ListCheck
                ENDIF
                mov     eax, [(head esi).dCurrent]
                ret
endp



proc            ListSetPosition
                ;in
                ;  eax - value from previous call of ListGetPosition
                ;  esi - 'List'
                ;out
                ;  nothing
                IF DBG
                  call  ListCheck
                ENDIF
                mov     [(head esi).dCurrent], eax
                ret
endp



proc            ListIsEmpty
                ;in
                ;  esi - 'List'
                ;out
                ;  CN: list is empty
                ;  CY: list is not empty
                IF DBG
                  call  ListCheck
                ENDIF
                mov     eax, [(head esi).dNext]
                cmp     eax, esi
                clc
                @IF_NZ
                  stc
                @ENDIF
                ret
endp



proc            ListInsertFirst
                ;in
                ;  esi - 'List'
                ;  edi - object
                ;out
                ;  nothing
                ;description
                ;  Inserts object into list at first position.
                push    edi
                IF DBG
                  call  ListCheck
                ENDIF

                ;;allocate memory for new element
                push    edi
                mov     eax, size element
                call    HeapAlloc
                pop     [(element edi).dObject]

                ;;insert between head and first element
                mov     eax, [(element esi).dNext]
                mov     [(element esi).dNext], edi
                mov     [(element edi).dPrev], esi
                mov     [(element edi).dNext], eax
                mov     [(element eax).dPrev], edi

                pop     edi
                ret
endp



proc            ListInsertLast
                ;in
                ;  esi - 'List'
                ;  edi - object
                ;out
                ;  nothing
                ;description
                ;  Inserts object into list at last position.
                push    edi
                IF DBG
                  call  ListCheck
                ENDIF

                ;;allocate memory for new element
                push    edi
                mov     eax, size element
                call    HeapAlloc
                pop     [(element edi).dObject]

                ;;insert between head and last element
                mov     eax, [(element esi).dPrev]
                mov     [(element esi).dPrev], edi
                mov     [(element edi).dPrev], eax
                mov     [(element edi).dNext], esi
                mov     [(element eax).dNext], edi

                pop     edi
                ret
endp



proc            ListInsertBefore
                ;in
                ;  esi - 'List'
                ;  edi - object
                ;out
                ;  nothing
                ;description
                ;  Inserts object into list before current element.
                push    esi edi
                IF DBG
                  call  ListCheck
                ENDIF

                ;;allocate memory for new element
                push    edi
                mov     eax, size element
                call    HeapAlloc
                pop     [(element edi).dObject]

                ;;make new element a current
                mov     eax, [(head esi).dCurrent]
                mov     [(head esi).dCurrent], edi
                mov     esi, eax

                ;;insert into list
                mov     eax, [(element esi).dPrev]
                mov     [(element esi).dPrev], edi
                mov     [(element edi).dPrev], eax
                mov     [(element edi).dNext], esi
                mov     [(element eax).dNext], edi

                pop     edi esi
                ret
endp



proc            ListInsertAfter
                ;in
                ;  esi - 'List'
                ;  edi - object
                ;out
                ;  nothing
                ;description
                ;  Inserts object into list after current element.
                push    esi edi
                IF DBG
                  call  ListCheck
                ENDIF

                ;;allocate memory for new element
                push    edi
                mov     eax, size element
                call    HeapAlloc
                pop     [(element edi).dObject]

                ;;make new element a current
                mov     eax, [(head esi).dCurrent]
                mov     [(head esi).dCurrent], edi
                mov     esi, eax

                ;;insert into list
                mov     eax, [(element esi).dNext]
                mov     [(element esi).dNext], edi
                mov     [(element edi).dPrev], esi
                mov     [(element edi).dNext], eax
                mov     [(element eax).dPrev], edi

                pop     edi esi
                ret
endp



proc            ListFirst
                ;in
                ;  esi - 'List'
                ;out
                ;  CN: eax - object
                ;  CY: list is empty
                ;description
                ;  Returns first object from list and skips to second.
                IF DBG
                  call  ListCheck
                ENDIF
                mov     eax, [(head esi).dNext]
                cmp     eax, esi
                @IF_E
                  stc
                @ELSE
                  clc
                  mov   [(head esi).dCurrent], eax
                  mov   eax, [(element eax).dObject]
                @ENDIF
                ret
endp



proc            ListLast
                ;in
                ;  esi - 'List'
                ;out
                ;  CN: eax - object
                ;  CY: list is empty
                ;description
                ;  Returns last object from list and skips to previous.
                IF DBG
                  call  ListCheck
                ENDIF
                mov     eax, [(head esi).dPrev]
                cmp     eax, esi
                @IF_E
                  stc
                @ELSE
                  clc
                  mov   [(head esi).dCurrent], eax
                  mov   eax, [(element eax).dObject]
                @ENDIF
                ret
endp



proc            ListCurrent
                ;in
                ;  esi - 'List'
                ;out
                ;  CN: eax - object
                ;  CY: list is empty
                ;description
                ;  Returns current object from list.
                IF DBG
                  call  ListCheck
                ENDIF
                mov     eax, [(head esi).dCurrent]
                cmp     eax, esi
                @IF_E
                  stc
                @ELSE
                  clc
                  mov   eax, [(element eax).dObject]
                @ENDIF
                ret
endp



proc            ListPrevious
                ;in
                ;  esi - 'List'
                ;out
                ;  CN: eax - object
                ;  CY: list start is encountered
                ;description
                ;  Returns current object from list and skips to previous.
                IF DBG
                  call  ListCheck
                ENDIF
                mov     eax, [(head esi).dCurrent]
                mov     eax, [(element eax).dPrev]
                cmp     eax, esi
                @IF_E
                  stc
                @ELSE
                  clc
                  mov   [(head esi).dCurrent], eax
                  mov   eax, [(element eax).dObject]
                @ENDIF
                ret
endp



proc            ListNext
                ;in
                ;  esi - 'List'
                ;out
                ;  CN: eax - object
                ;  CY: list end is encountered
                ;description
                ;  Returns current object from list and skips to next.
                IF DBG
                  call  ListCheck
                ENDIF
                mov     eax, [(head esi).dCurrent]
                mov     eax, [(element eax).dNext]
                cmp     eax, esi
                @IF_E
                  stc
                @ELSE
                  clc
                  mov   [(head esi).dCurrent], eax
                  mov   eax, [(element eax).dObject]
                @ENDIF
                ret
endp



proc            ListFind
                ;in
                ;  esi - 'List'
                ;  edi - object
                ;out
                ;  CN: object found
                ;  CY: object not found
                ;description
                ;  Sets internal pointer to object.
                pushad
                IF DBG
                  call  ListCheck
                ENDIF

                mov     ebx, edi
                mov     edi, esi

                ;;find element that contains requested object
@@loop:         mov     edi, [(element edi).dNext]
                cmp     edi, esi
                @IF_E
                  stc
                  jmp   @@exit
                @ENDIF
                cmp     [(element edi).dObject], ebx
                jne     @@loop

                ;;make element a current
                mov     [(head esi).dCurrent], edi

@@exit:         popad
                ret
endp



proc            ListRemove
                ;in
                ;  esi - 'List'
                ;  edi - object
                ;out
                ;  CN: object removed
                ;  CY: object not found
                ;description
                ;  Removes object from list.
                pushad
                IF DBG
                  call  ListCheck
                ENDIF

                mov     ebx, edi
                mov     edi, esi

                ;;find element that contains requested object
@@loop:         mov     edi, [(element edi).dNext]
                cmp     edi, esi
                @IF_E
                  stc
                  jmp   @@exit
                @ENDIF
                cmp     [(element edi).dObject], ebx
                jne     @@loop

                ;;if it is a current element than change current
                cmp     edi, [(head esi).dCurrent]
                @IF_E
                  mov   eax, [(element edi).dNext]
                  cmp   eax, esi
                  @IF_E
                    mov eax, [(element edi).dPrev]
                  @ENDIF
                  mov   [(head esi).dCurrent], eax
                @ENDIF

                ;;remove element
                mov     esi, [(element edi).dPrev]
                mov     ebx, [(element edi).dNext]
                mov     [(element esi).dNext], ebx
                mov     [(element ebx).dPrev], esi
                mov     eax, edi
                call    HeapFree

                clc
@@exit:         popad
                ret
endp



proc            ListReplace
                ;in
                ;  eax - object
                ;  esi - 'List'
                ;out
                ;  nothing
                ;description
                ;  Replaces current object.
                push    esi
                IF DBG
                  call  ListCheck
                ENDIF

                mov     esi, [(head esi).dCurrent]
                mov     [(element esi).dObject], eax

                pop     esi
                ret
endp



proc            ListZap
                ;in
                ;  esi - 'List'
                ;out
                ;  nothing
                ;description
                ;  Deletes all list elements.
                push    edi
                IF DBG
                  call  ListCheck
                ENDIF
                mov     edi, [(element esi).dNext]
@@loop:         cmp     esi, edi
                @IF_NE
                  mov   eax, edi
                  mov   edi, [(element edi).dNext]
                  call  HeapFree
                  jmp   @@loop
                @ENDIF
                mov     [(element esi).dPrev], esi
                mov     [(element esi).dNext], esi
                pop     edi
                ret
endp

ends            code32
                end
